/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.actions;

import com.sap.dictionary.tools.tsmodel.dictionary.actions.CopyDbTableWizardPage;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryObjectChecker;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryUtil;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.dictionary.DtDictionaryDevelopmentObjectEnum;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import java.util.HashSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class CopyDbTableWizard
extends Wizard
implements INewWizard {
    private CopyDbTableWizardPage mCopyDbTableWizardPage;
    private DataSourceManager mDataSourceManager = null;
    private String mProjectName = null;
    private ClipboardObject mClipboardObject = null;
    private boolean mIsTable = true;

    public CopyDbTableWizard(DataSourceManager dataSourceManager, ClipboardObject clipboardObject, boolean isTable) {
        this.mDataSourceManager = dataSourceManager;
        this.mClipboardObject = clipboardObject;
        this.mProjectName = dataSourceManager.getDictionaryRoot().getMetamodel().getName();
        this.mIsTable = isTable;
    }

    public void addPages() {
        String title = "";
        title = this.mIsTable ? "Copy Table" : "Copy View";
        this.mCopyDbTableWizardPage = new CopyDbTableWizardPage(title, this.mProjectName, this.mDataSourceManager, this.mClipboardObject, this.mIsTable);
        this.addPage((IWizardPage)this.mCopyDbTableWizardPage);
    }

    public boolean performFinish() {
        String message;
        ClipboardObject[] children = this.mClipboardObject.getChildren();
        String newIndexName = null;
        this.mClipboardObject.setNewName(this.mCopyDbTableWizardPage.getNewTableName());
        if (children.length == 0) {
            return true;
        }
        Table indexes = this.mCopyDbTableWizardPage.getIndexes();
        if (indexes == null) {
            return true;
        }
        if (indexes.getItems().length == 0) {
            return true;
        }
        if (this.mCopyDbTableWizardPage.mCopyIndexes.getSelection()) {
            boolean nameIsSpecified = false;
            int i = 0;
            while (i < indexes.getItemCount()) {
                String indexName = indexes.getItem(i).getText(1);
                if (!DictionaryUtil.stringIsEmpty(indexName)) {
                    nameIsSpecified = true;
                    break;
                }
                ++i;
            }
            if (!nameIsSpecified && !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Copy Indexes", (String)"There are no indexes specified to be copied. Do you want to continue?")) {
                return false;
            }
        }
        if (!DictionaryUtil.stringIsEmpty(message = this.checkIndexes(indexes))) {
            this.mCopyDbTableWizardPage.setErrorMessage(message);
            return false;
        }
        TableItem[] tableItems = indexes.getItems();
        int i = 0;
        while (i < children.length) {
            if (children[i].getType() == DtDictionaryDevelopmentObjectEnum.DTDBINDEX) {
                newIndexName = "";
                int j = 0;
                while (j < tableItems.length) {
                    if (tableItems[j].getText(0).equalsIgnoreCase(children[i].getNewName())) {
                        newIndexName = tableItems[j].getText(1);
                        break;
                    }
                    ++j;
                }
                if (!DictionaryUtil.stringIsEmpty(newIndexName)) {
                    children[i].setNewName(newIndexName);
                } else {
                    children[i].setExcluded(true);
                }
            }
            ++i;
        }
        return true;
    }

    private String checkIndexes(Table indexes) {
        String indexName1;
        int i = 0;
        while (i < indexes.getItemCount() / 2 + 1) {
            indexName1 = indexes.getItem(i).getText(1);
            if (!DictionaryUtil.stringIsEmpty(indexName1)) {
                int j = i + 1;
                while (j < indexes.getItemCount()) {
                    String indexName2 = indexes.getItem(j).getText(1);
                    if (!DictionaryUtil.stringIsEmpty(indexName2) && indexName2.equalsIgnoreCase(indexName1)) {
                        return MessagePool.getMessage((String)"Index name & occurs more than once", (String)indexName1);
                    }
                    ++j;
                }
            }
            ++i;
        }
        HashSet<String> hIndexes = new HashSet<String>();
        int i2 = 0;
        while (i2 < indexes.getItemCount()) {
            indexName1 = indexes.getItem(i2).getText(1);
            if (!DictionaryUtil.stringIsEmpty(indexName1)) {
                hIndexes.add(indexName1);
            }
            ++i2;
        }
        return DictionaryObjectChecker.checkProjectHasIndex(this.mProjectName, hIndexes);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

