/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.perspective.views.projects.generic;

import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.core.ui.views.IViewStateInfo;
import com.sap.ide.ws.perspective.views.state.ViewStateHandler;
import com.sap.ide.ws.text.WsUiTexts;
import com.tssap.dii.component.DCToolbox;
import com.tssap.j2ee.core.filters.ws.DtrDeleteActionFilter;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.perspective.view.j2ee.J2eeViewSelectionConverter;
import com.tssap.selena.model.extension.filter.FilterFactory;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.IMutableFilterSet;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.util.action.IActionFilter;
import com.tssap.util.action.path.ContextDependentPathProvider;
import com.tssap.util.action.path.IPathProvider;
import com.tssap.util.ui.IContext;
import com.tssap.util.ui.IContextProvider;
import com.tssap.util.ui.IDescriptionIndicator;
import com.tssap.util.ui.image.SapImageRegistry;
import com.tssap.util.ui.menu.IMenuFactory;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.ContextMenu;
import com.tssap.util.ui.menu.context.DynamicContextMenu;
import com.tssap.util.ui.menu.context.IContextMenu;
import com.tssap.util.ui.menu.context.IContextMenuPart;
import com.tssap.util.ui.menu.context.MixedContextMenu;
import com.tssap.util.ui.viewer.IViewerContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public abstract class GenericProjectExplorer
extends ViewPart
implements IContextProvider,
IViewStateInfo {
    protected GenericDataModelFilteredTreeViewer viewer;
    private boolean showDCs = false;
    private Action dcSwitchAction;
    private String originalTitle;
    static /* synthetic */ Class class$com$sap$ide$ws$perspective$views$projects$generic$GenericProjectExplorer;

    public final void createPartControl(Composite parent) {
        ViewStateHandler.readViewState(this);
        this.viewer = GenericDataModelFilteredTreeViewer.createFilteredTreeViewer((Composite)parent, (IFilter)this.getFilters());
        if (this.getLabelProvider() != null) {
            this.viewer.getTreeViewer().setLabelProvider(this.getLabelProvider());
        }
        this.viewer.setOptimisticChildrenCheck(true);
        this.viewer.setDissolveReferences(true);
        this.viewer.setSkipReferenceCollections(false);
        this.viewer.setSkipReferences(true);
        ViewerSorter sorter = this.getSorter();
        if (sorter != null) {
            this.viewer.getTreeViewer().setSorter(sorter);
        }
        this.createTopToolbar();
        this.addContextMenu();
        this.originalTitle = this.getTitle();
        J2eeViewSelectionConverter converter = new J2eeViewSelectionConverter((ISelectionProvider)this.viewer.getTreeViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)converter);
        this.updateTitle();
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        ViewStateHandler.storeViewState(this);
    }

    private IMutableFilterSet getFilters() {
        IMutableFilterSet completeFilterSet = FilterFactory.createOrFilterSet();
        completeFilterSet.addFilter((IFilter)this.getProjectFilters(this.showDCs));
        completeFilterSet.addFilter((IFilter)this.getProjectContentFilters());
        if (this.showDCs) {
            completeFilterSet.addFilter(DCToolbox.getDCMetaDataFilter());
        }
        return completeFilterSet;
    }

    private void addContextMenu() {
        MenuFactory menuFactory = new MenuFactory();
        menuFactory.getPathProviderManager().addPathProvider((IPathProvider)new ContextDependentPathProvider(false));
        MixedContextMenu contextMenuPartContainer = new MixedContextMenu();
        DynamicContextMenu dynamicContextMenu = new DynamicContextMenu((IMenuFactory)menuFactory, 1, (IActionFilter)new DtrDeleteActionFilter());
        contextMenuPartContainer.addContextMenuPart((IContextMenuPart)dynamicContextMenu);
        ContextMenu.setContextMenuToStructuredViewer((StructuredViewer)this.viewer.getTreeViewer(), (IContextMenu)contextMenuPartContainer);
        contextMenuPartContainer.addDescriptionIndicator(new IDescriptionIndicator(){

            public void indicateDescription(String descriptionText) {
                GenericProjectExplorer.this.getViewSite().getActionBars().getStatusLineManager().setMessage(descriptionText);
            }
        });
        dynamicContextMenu.registerShortcuts((Control)this.viewer.getTree(), (IWorkbenchPart)this, (IContextProvider)this);
    }

    public IContext getContext() {
        IViewerContext ret = null;
        if (this.viewer != null) {
            ret = this.viewer.getCurrentViewerContext();
        }
        return ret;
    }

    public void createTopToolbar() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        Action refreshAction = new Action(){

            public void run() {
                GenericProjectExplorer.this.viewer.refresh();
            }
        };
        refreshAction.setImageDescriptor(((SapImageRegistry)UIPlugin.getDefault().getImageRegistry()).getImageDescriptor("refresh"));
        refreshAction.setToolTipText(WsCoreUiTexts.getString((String)"WsCore.Labels.General.refresh"));
        toolBarManager.add((IAction)refreshAction);
        Action collapseAllAction = new Action(){

            public void run() {
                GenericProjectExplorer.this.viewer.getTreeViewer().collapseAll();
            }
        };
        collapseAllAction.setImageDescriptor(ImageDescriptor.createFromFile((Class)(class$com$sap$ide$ws$perspective$views$projects$generic$GenericProjectExplorer == null ? (class$com$sap$ide$ws$perspective$views$projects$generic$GenericProjectExplorer = GenericProjectExplorer.class$("com.sap.ide.ws.perspective.views.projects.generic.GenericProjectExplorer")) : class$com$sap$ide$ws$perspective$views$projects$generic$GenericProjectExplorer), (String)"icons/collapseall.gif"));
        collapseAllAction.setToolTipText(WsCoreUiTexts.getString((String)"WsCore.Labels.General.collapseAll"));
        toolBarManager.add((IAction)collapseAllAction);
        IAction[] customActions = this.getTopToolbarCustomActions();
        int i = 0;
        while (i < customActions.length) {
            toolBarManager.add(customActions[i]);
            ++i;
        }
        if (this.isDcProjectRelevant()) {
            String actionText = this.showDCs ? "Show non DC Projects only" : "Show DC Projects only";
            this.dcSwitchAction = new Action(actionText){

                public void run() {
                    GenericProjectExplorer.this.showDCs = !GenericProjectExplorer.this.showDCs;
                    GenericProjectExplorer.this.viewer.setFilter((IFilter)GenericProjectExplorer.this.getFilters());
                    GenericProjectExplorer.this.viewer.getTreeViewer().refresh();
                    GenericProjectExplorer.this.updateTitle();
                    if (GenericProjectExplorer.this.showDCs) {
                        this.setText("Show non DC Projects only");
                    } else {
                        this.setText("Show DC Projects only");
                    }
                }
            };
            this.getViewSite().getActionBars().getMenuManager().add((IAction)this.dcSwitchAction);
        }
    }

    public boolean isInDcMode() {
        return this.showDCs;
    }

    public void switchToDcMode(boolean value) {
        if (this.dcSwitchAction == null) {
            this.showDCs = value;
        } else {
            this.dcSwitchAction.run();
        }
    }

    private void updateTitle() {
        if (this.showDCs) {
            super.setTitle(this.originalTitle + " - " + WsUiTexts.getString((String)"GenericProjectExplorer.dctitle"));
        } else {
            super.setTitle(this.originalTitle);
        }
    }

    protected ViewerSorter getSorter() {
        return null;
    }

    protected abstract boolean isDcProjectRelevant();

    protected abstract IBaseLabelProvider getLabelProvider();

    protected abstract IMutableFilterSet getProjectContentFilters();

    protected abstract IMutableFilterSet getProjectFilters(boolean var1);

    protected abstract IAction[] getTopToolbarCustomActions();

    public abstract String getViewId();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

