/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.perspective.actions.ear;

import com.sap.ide.eclipse.sdm.SDMManager;
import com.sap.ide.ws.core.actions.GenericSingleAction;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.selena.SelenaFileAdapter;
import com.tssap.j2ee.ui.core.deploy.DeployerFactory;
import com.tssap.j2ee.ui.core.deploy.DeploymentException;
import com.tssap.j2ee.ui.core.deploy.IDeployer;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import org.eclipse.core.resources.IFile;

public class EarDeployAction
extends GenericSingleAction {
    private static final String ACTION_NAME = "Deploy";

    public EarDeployAction() {
        super((ICategory)Category.createDisplayableCategory((ICategory)Category.DEFAULT, (String)"Ws.EarDeployAction", (String)ACTION_NAME, (String)"", null), ACTION_NAME);
    }

    public boolean isEnabled(Element element) {
        IDeployer sdmDeployer = DeployerFactory.getSDMDeployer();
        return sdmDeployer.canDeployAsync(SelenaFileAdapter.getFile((Element)element));
    }

    public boolean isAvailable(Element element) {
        boolean availableFlag = true;
        if (!SelenaFileAdapter.isEarFile((Element)element)) {
            WebServiceCorePlugin.logMessage((String)"Deploy action not available - archive not of type EAR !", (String)"isAvailable(Element element)", ((Object)((Object)this)).getClass());
            availableFlag = false;
        }
        if (DeployerFactory.getSDMDeployer() == null) {
            WebServiceCorePlugin.logMessage((String)"Deploy action not available - no sdm deployer found !", (String)"isAvailable(Element element)", ((Object)((Object)this)).getClass());
            availableFlag = false;
        }
        return availableFlag;
    }

    public void run(Element element) {
        IFile file = SelenaFileAdapter.getFile((Element)element);
        SDMManager manager = SDMManager.getInstance();
        try {
            manager.deployArchiveAsync(file, WebServiceCorePlugin.getTracer(((Object)((Object)this)).getClass()));
        }
        catch (DeploymentException e) {
            WebServiceCorePlugin.logError((Throwable)e, ((Object)((Object)this)).getClass());
        }
    }
}

