/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.services;

import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.dcmetadata.model.PublicPartFileOutputProvider;
import com.sap.ide.eclipse.component.provider.actions.dcmetadata.EditEntityAction;
import com.sap.ide.metamodel.core.dc.DevComponentService;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.plugin.MetamodelWebDynproEclipsePlugin;
import com.sap.ide.metamodel.webdynpro.services.TextPool;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.provider.PPOutputProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;

public class ServicesDC {
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String PLUGIN_ID = MetamodelWebDynproEclipsePlugin.getDefault().getDescriptor().getUniqueIdentifier();
    private static final String RENAME_ENTITY_TITLE = mTPool.getText(100);
    public static final int IS_IN_PUBLIC_PART = 0;
    public static final int IS_NOT_IN_PUBLIC_PART = -1;
    public static final int COULD_NOT_CHECKOUT_PUBLIC_PART = 1;
    public static final int NOT_A_DC = 2;
    public static final int NO_PUBLIC_PART = 3;
    public static final int NO_ENTITIES = 4;
    public static final int UNDEFINED_ERROR_OCURRED = 5;
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$dc$DevComponentService;

    public static void informUserPPNotWritable() {
        String message = mTPool.getText(202);
        String[] buttons = new String[]{IDialogConstants.OK_LABEL};
        MessageDialog dialog = ServicesUI.createMessageDialog((String)RENAME_ENTITY_TITLE, (String)message, (String[])buttons, (int)4, null, (int)0);
        dialog.open();
    }

    public static void renameEntities(EntityPair[] entityPairs, MainDevelopmentObject mdo) {
        if (entityPairs == null || mdo == null) {
            return;
        }
        IProject eclipseProject = ServicesEclipse.getEclipseProject((DevelopmentObject)mdo);
        if (!ServicesEclipse.projectHasComponentNature((String)eclipseProject.getName())) {
            return;
        }
        String newName = mdo.getName();
        String newPackage = mdo.getPackage();
        IPPModel.EntityType mdoEntityType = null;
        if (mdo instanceof Component) {
            mdoEntityType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT;
        } else if (mdo instanceof ComponentInterfaceDefinition) {
            mdoEntityType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION;
        } else {
            return;
        }
        String mdoTypeName = mdoEntityType.toString();
        if (mdoEntityType.getSubTyps().length <= 0) {
            return;
        }
        String mdoSubTypeName = mdoEntityType.getSubTyps()[0].toString();
        int i = 0;
        while (i < entityPairs.length) {
            if (!entityPairs[i].isExcluded()) {
                Entity entityToRename = entityPairs[i].getEntity();
                EditEntityAction entityAction = new EditEntityAction();
                PublicPart publicPart = entityPairs[i].getPublicPart();
                IPPModel ppModel = entityAction.getPPModel(eclipseProject, publicPart.getName());
                if (ppModel == null) {
                    ServicesDC.informUserPPNotWritable();
                } else {
                    int contains = ppModel.contains(entityToRename);
                    if (contains >= 0) {
                        ppModel.removeEntity(entityToRename);
                        Entity newEntity = ComponentFactory.createEntity();
                        newEntity.setName(newName);
                        newEntity.setCaption(newName);
                        newEntity.setPackageName(newPackage.replace('.', '/'));
                        newEntity.setType(mdoTypeName);
                        newEntity.setSubType(mdoSubTypeName);
                        if (entityToRename.getDescription().equals(entityToRename.getName())) {
                            newEntity.setDescription(newName);
                        } else {
                            newEntity.setDescription(entityToRename.getDescription());
                        }
                        ppModel.addEntity(newEntity);
                        IFile ppFile = entityAction.getPPFile(eclipseProject, ppModel);
                        PublicPartFileOutputProvider outputProvider = new PublicPartFileOutputProvider(ppFile);
                        try {
                            ppModel.writeModelTo((PPOutputProvider)outputProvider);
                        }
                        catch (Exception e) {
                            MetamodelWebDynproEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$dc$DevComponentService == null ? ServicesDC.class$("com.sap.ide.metamodel.core.dc.DevComponentService") : class$com$sap$ide$metamodel$core$dc$DevComponentService, "renameEntity", "Could not write .pp file", e, false);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public static EntityHandler isMDOInPublicPart(MainDevelopmentObject mdo) {
        if (mdo == null) {
            return new EntityHandler(false, "Invalid method call", 5);
        }
        IProject eclipseProject = ServicesEclipse.getEclipseProject((DevelopmentObject)mdo);
        if (!ServicesEclipse.projectHasComponentNature((String)eclipseProject.getName())) {
            return new EntityHandler(false, "Not a DC Project", 2);
        }
        String mdoName = mdo.getName();
        String mdoPackage = mdo.getPackage();
        IPPModel.EntityType mdoType = null;
        if (mdo instanceof Component) {
            mdoType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT;
        } else if (mdo instanceof ComponentInterfaceDefinition) {
            mdoType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION;
        } else if (mdo instanceof Model) {
            mdoType = IPPModel.EntityType.COMMON_MODEL;
        } else {
            return new EntityHandler(false, "Object is not allowed to be in public part", 5);
        }
        String mdoTypeName = mdoType.toString();
        if (mdoType.getSubTyps().length <= 0) {
            return new EntityHandler(false, "No subtypes available", 5);
        }
        String mdoSubTypeName = mdoType.getSubTyps()[0].toString();
        DevelopmentComponent dc = DevComponentService.getDC((IProject)eclipseProject);
        if (dc == null) {
            return new EntityHandler(false, "DevComponentService.getDC(eclipseProject) failed", 5);
        }
        PublicPart[] publicParts = DevComponentService.getPublicParts((DevelopmentComponent)dc);
        if (publicParts == null || publicParts.length <= 0) {
            return new EntityHandler(false, "No public parts available", 3);
        }
        String message = "";
        int returnCode = 5;
        int i = 0;
        while (i < publicParts.length) {
            List entities = publicParts[i].getEntities();
            if (entities == null || entities.size() <= 0) {
                message = "No entities";
                returnCode = 4;
            } else {
                int j = 0;
                while (j < entities.size()) {
                    Object entityObject = entities.get(j);
                    if (!(entityObject instanceof Entity)) {
                        return new EntityHandler(false, "object is not an entity", 5);
                    }
                    Entity entity = (Entity)entityObject;
                    String entityName = entity.getName();
                    String entityPackage = entity.getPackageName();
                    String entityType = entity.getType();
                    String entitySubType = entity.getSubType();
                    if (entityType.equals(mdoTypeName) && entitySubType.equals(mdoSubTypeName) && entityName.equals(mdoName) && entityPackage.equals(mdoPackage)) {
                        return new EntityHandler(true, entity, "MDO is contained in public part", 0);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (message.equals("")) {
            message = "Not in public part";
        }
        if (returnCode == 0) {
            returnCode = 5;
        }
        return new EntityHandler(false, message, returnCode);
    }

    public static IStatus checkoutPublicParts(EntityPair[] entityPairs, MainDevelopmentObject mdo) {
        IProject eclipseProject = ServicesEclipse.getEclipseProject((DevelopmentObject)mdo);
        String newName = mdo.getName();
        String newPackage = mdo.getPackage();
        IPPModel.EntityType mdoEntityType = null;
        if (mdo instanceof Component) {
            mdoEntityType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT;
        } else if (mdo instanceof ComponentInterfaceDefinition) {
            mdoEntityType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION;
        }
        String mdoTypeName = mdoEntityType.toString();
        String mdoSubTypeName = mdoEntityType.getSubTyps()[0].toString();
        int i = 0;
        while (i < entityPairs.length) {
            if (!entityPairs[i].isExcluded()) {
                Entity entityToRename = entityPairs[i].getEntity();
                EditEntityAction entityAction = new EditEntityAction();
                PublicPart publicPart = entityPairs[i].getPublicPart();
                IPPModel ppModel = entityAction.getPPModel(eclipseProject, publicPart.getName());
                if (ppModel == null) {
                    return new Status(4, PLUGIN_ID, 1, "Could not checkout public part, possibly due to a missing login", null);
                }
            }
            ++i;
        }
        return new Status(0, PLUGIN_ID, 0, "MDO is contained in public part", null);
    }

    public static IStatus checkoutPublicParts(String oldName, String oldPackage, MainDevelopmentObject mdo) {
        if (oldName == null || oldPackage == null || mdo == null) {
            return new Status(4, PLUGIN_ID, 5, "Invalid method call", null);
        }
        IProject eclipseProject = ServicesEclipse.getEclipseProject((DevelopmentObject)mdo);
        if (!ServicesEclipse.projectHasComponentNature((String)eclipseProject.getName())) {
            return new Status(4, PLUGIN_ID, 2, "Not a DC Project", null);
        }
        String newName = mdo.getName();
        String newPackage = mdo.getPackage();
        IPPModel.EntityType mdoEntityType = null;
        if (mdo instanceof Component) {
            mdoEntityType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT;
        } else if (mdo instanceof ComponentInterfaceDefinition) {
            mdoEntityType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION;
        } else {
            return new Status(4, PLUGIN_ID, 5, "Object is not allowed to be in public part", null);
        }
        String mdoTypeName = mdoEntityType.toString();
        if (mdoEntityType.getSubTyps().length <= 0) {
            return new Status(4, PLUGIN_ID, 5, "No subtypes available", null);
        }
        String mdoSubTypeName = mdoEntityType.getSubTyps()[0].toString();
        DevelopmentComponent dc = DevComponentService.getDC((IProject)eclipseProject);
        PublicPart[] publicParts = DevComponentService.getPublicParts((DevelopmentComponent)dc);
        if (publicParts == null || publicParts.length <= 0) {
            return new Status(4, PLUGIN_ID, 3, "No public parts available", null);
        }
        int i = 0;
        while (i < publicParts.length) {
            List entities = publicParts[i].getEntities();
            if (entities != null) {
                int j = 0;
                while (j < entities.size()) {
                    EditEntityAction entityAction;
                    IPPModel ppModel;
                    Object entityObject = entities.get(j);
                    if (!(entityObject instanceof Entity)) {
                        return new Status(4, PLUGIN_ID, 5, "object is not an entity", null);
                    }
                    Entity entity = (Entity)entityObject;
                    String entityName = entity.getName();
                    String entityPackage = entity.getPackageName();
                    String entityTypeName = entity.getType();
                    String entitySubTypeName = entity.getSubType();
                    String entityDescription = entity.getDescription();
                    if (entityTypeName.equals(mdoTypeName) && entitySubTypeName.equals(mdoSubTypeName) && entityName.equals(oldName) && entityPackage.equals(oldPackage) && (ppModel = (entityAction = new EditEntityAction()).getPPModel(eclipseProject, publicParts[i].getName())) == null) {
                        return new Status(4, PLUGIN_ID, 1, "Could not checkout public part, possibly due to a missing login", null);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return new Status(0, PLUGIN_ID, 0, "MDO is contained in public part", null);
    }

    public static EntityPair[] getCorrespondingEntityPairs(String oldName, String oldPackage, MainDevelopmentObject mdo) {
        EntityPair[] EMPTY_ARRAY = new EntityPair[]{};
        ArrayList<EntityPair> entityPairList = new ArrayList<EntityPair>();
        if (oldName == null || oldPackage == null || mdo == null) {
            return EMPTY_ARRAY;
        }
        IProject eclipseProject = ServicesEclipse.getEclipseProject((DevelopmentObject)mdo);
        if (!ServicesEclipse.projectHasComponentNature((String)eclipseProject.getName())) {
            return EMPTY_ARRAY;
        }
        String newName = mdo.getName();
        String newPackage = mdo.getPackage();
        IPPModel.EntityType mdoEntityType = null;
        if (mdo instanceof Component) {
            mdoEntityType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT;
        } else if (mdo instanceof ComponentInterfaceDefinition) {
            mdoEntityType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION;
        } else {
            return EMPTY_ARRAY;
        }
        String mdoTypeName = mdoEntityType.toString();
        if (mdoEntityType.getSubTyps().length <= 0) {
            return EMPTY_ARRAY;
        }
        String mdoSubTypeName = mdoEntityType.getSubTyps()[0].toString();
        DevelopmentComponent dc = DevComponentService.getDC((IProject)eclipseProject);
        PublicPart[] publicParts = DevComponentService.getPublicParts((DevelopmentComponent)dc);
        int i = 0;
        while (i < publicParts.length) {
            List entities = publicParts[i].getEntities();
            if (entities != null) {
                int j = 0;
                while (j < entities.size()) {
                    Object entityObject = entities.get(j);
                    if (!(entityObject instanceof Entity)) {
                        return EMPTY_ARRAY;
                    }
                    Entity entity = (Entity)entityObject;
                    String entityName = entity.getName();
                    String entityPackage = entity.getPackageName();
                    String entityTypeName = entity.getType();
                    String entitySubTypeName = entity.getSubType();
                    String entityDescription = entity.getDescription();
                    if (entityTypeName.equals(mdoTypeName) && entitySubTypeName.equals(mdoSubTypeName) && entityName.equals(oldName) && entityPackage.equals(oldPackage)) {
                        entityPairList.add(new EntityPair(entity, publicParts[i]));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return entityPairList.toArray(new EntityPair[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class EntityHandler {
        private Entity mEntityInPP = null;
        private IStatus mStatus = null;
        private boolean mIsInPublicPart = false;
        private String mStatusMessage = "";
        private String mErrorMessage = "";
        private int mReturCode = -1;
        private Map mEntityPPMap = new HashMap();

        public EntityHandler() {
        }

        public EntityHandler(Entity ppEntityToRename, IStatus entityStatus) {
            this.mEntityInPP = ppEntityToRename;
            this.mStatus = entityStatus;
        }

        public EntityHandler(boolean isInPublicPart, String statusMessage, String errorMessage) {
            this.mIsInPublicPart = isInPublicPart;
            this.mStatusMessage = statusMessage;
            this.mErrorMessage = errorMessage;
        }

        public EntityHandler(boolean isInPublicPart, String statusMessage, int returnCode) {
            this.mIsInPublicPart = isInPublicPart;
            this.mStatusMessage = statusMessage;
            this.mReturCode = returnCode;
        }

        public EntityHandler(boolean isInPublicPart, Entity entityInPP, String statusMessage, int returnCode) {
            this.mIsInPublicPart = isInPublicPart;
            this.mEntityInPP = entityInPP;
            this.mStatusMessage = statusMessage;
            this.mReturCode = returnCode;
        }

        public void addToMap(Entity entity, PublicPart publicPart) {
            this.mEntityPPMap.put(entity, publicPart);
        }

        public Entity getEntity() {
            return this.mEntityInPP;
        }

        public IStatus getStatus() {
            return this.mStatus;
        }

        public boolean isInPublicPart() {
            return this.mIsInPublicPart;
        }

        public String getStatusMessage() {
            return this.mStatusMessage;
        }

        public String getErrorMessage() {
            return this.mErrorMessage;
        }

        public int getReturnCode() {
            return this.mReturCode;
        }
    }

    public static class EntityPair {
        private Entity mEntity;
        private PublicPart mPublicPart;
        private boolean mIsExcluded = false;

        public EntityPair(Entity entity, PublicPart publicPart) {
            this.mEntity = entity;
            this.mPublicPart = publicPart;
        }

        public Entity getEntity() {
            return this.mEntity;
        }

        public PublicPart getPublicPart() {
            return this.mPublicPart;
        }

        public void setExcluded(boolean isExcluded) {
            this.mIsExcluded = isExcluded;
        }

        public boolean isExcluded() {
            return this.mIsExcluded;
        }
    }
}

