/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.services;

import com.sap.ide.generationfwk.eclipse.GenerationFwkPlugin;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class GenerationPathManager {
    public static final String[] getValidAbsoluteSourcePaths(WebDynproRoot webDynproRoot) {
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)webDynproRoot.getMetamodel().getName());
        ArrayList list = manager.getProjectSourcePaths();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String projectName = webDynproRoot.getMetamodel().getName();
        IProject eclipseProject = workspaceRoot.getProject(projectName);
        Vector<String> validSourcePaths = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            String sourceFolder = (String)list.get(i);
            if (GenerationPathManager.isValidAbsoluteSourceFolder(eclipseProject, sourceFolder)) {
                validSourcePaths.add(sourceFolder);
            }
            ++i;
        }
        return validSourcePaths.toArray(new String[0]);
    }

    public static final String[] getValidSourcePaths(IProject eclipseProject) {
        IPackageFragmentRoot[] allSourcePaths = ServicesEclipse.getSourceRoots((IProject)eclipseProject);
        Vector<String> validSourcePaths = new Vector<String>();
        int i = 0;
        while (i < allSourcePaths.length) {
            String sourceFolder = allSourcePaths[i].getPath().makeRelative().toString();
            if (GenerationPathManager.isValidSourceFolder(eclipseProject, sourceFolder)) {
                validSourcePaths.add(sourceFolder);
            }
            ++i;
        }
        return validSourcePaths.toArray(new String[0]);
    }

    public static final IPackageFragmentRoot[] getValidSourceRoots(IProject eclipseProject) {
        IPackageFragmentRoot[] allSourceRoots = ServicesEclipse.getSourceRoots((IProject)eclipseProject);
        Vector<IPackageFragmentRoot> validSourceRoots = new Vector<IPackageFragmentRoot>();
        int i = 0;
        while (i < allSourceRoots.length) {
            String sourceFolder = allSourceRoots[i].getPath().makeRelative().toString();
            if (GenerationPathManager.isValidSourceFolder(eclipseProject, sourceFolder)) {
                validSourceRoots.add(allSourceRoots[i]);
            }
            ++i;
        }
        return validSourceRoots.toArray(new IPackageFragmentRoot[0]);
    }

    public static final boolean isValidSourceFolder(IProject eclipseProject, String sourceFolder) {
        String[] sourcePaths = GenerationPathManager.getGenSourcePaths(eclipseProject);
        int i = 0;
        while (i < sourcePaths.length) {
            if (sourceFolder.startsWith(sourcePaths[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isValidAbsoluteSourceFolder(IProject eclipseProject, String fullPathSourceFolder) {
        String[] sourcePaths = GenerationFwkPlugin.getInstance().getSourcePathInfixes();
        String projectPath = eclipseProject.getLocation().toOSString();
        int i = 0;
        while (i < sourcePaths.length) {
            if (sourcePaths[i].startsWith("/") || sourcePaths[i].startsWith("\\")) {
                sourcePaths[i] = sourcePaths[i].length() >= 1 ? sourcePaths[i].substring(1, sourcePaths[i].length()) : "";
            }
            sourcePaths[i] = projectPath + "\\" + sourcePaths[i];
            if (fullPathSourceFolder.equals(sourcePaths[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final String[] getGenSourcePaths(IProject eclipseProject) {
        String projectName = eclipseProject.getName();
        String[] sourcePaths = GenerationFwkPlugin.getInstance().getSourcePathInfixes();
        int i = 0;
        while (i < sourcePaths.length) {
            String genFolder;
            sourcePaths[i] = genFolder = projectName.concat(sourcePaths[i]);
            ++i;
        }
        return sourcePaths;
    }
}

