/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.repository;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassMethod;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;

public class ModelRepositoryManager {
    public static MMRepositoryObject getRepositioryObject(Model model, boolean includesAllLanguageFiles) {
        Metamodel metamodel = model.getRoot().getMetamodel();
        MMRepositoryObject repositoryObject = new MMRepositoryObject(metamodel, "Model", model.getQualifiedName(), includesAllLanguageFiles);
        repositoryObject.addMDO((MainDevelopmentObject)model);
        return repositoryObject;
    }

    public static MMRepositoryObject getRepositioryObject(ModelClass modelClass, boolean includesAllLanguageFiles) {
        Metamodel metamodel = modelClass.getRoot().getMetamodel();
        MMRepositoryObject repositoryObject = new MMRepositoryObject(metamodel, "Model Class", modelClass.getQualifiedName(), includesAllLanguageFiles);
        repositoryObject.addMDO((MainDevelopmentObject)modelClass);
        return repositoryObject;
    }

    public static MMRepositoryObject getRepositioryObject(ModelRelation modelRelation, boolean includesAllLanguageFiles) {
        return ModelRepositoryManager.getRepositioryObject(modelRelation.getModel(), includesAllLanguageFiles);
    }

    public static MMRepositoryObject getRepositioryObject(ModelRelationRole modelRelationRole, boolean includesAllLanguageFiles) {
        return ModelRepositoryManager.getRepositioryObject(modelRelationRole.getModelRelation().getModel(), includesAllLanguageFiles);
    }

    public static MMRepositoryObject getRepositioryObject(ModelClassProperty modelClassProperty, boolean includesAllLanguageFiles) {
        return ModelRepositoryManager.getRepositioryObject((ModelClass)modelClassProperty.getAppClass(), includesAllLanguageFiles);
    }

    public static MMRepositoryObject getRepositioryObject(ModelClassMethod modelClassMethod, boolean includesAllLanguageFiles) {
        return ModelRepositoryManager.getRepositioryObject((ModelClass)modelClassMethod.getAppClass(), includesAllLanguageFiles);
    }

    public static MMRepositoryObject getRepositioryObject(DevelopmentObject modelEntity, boolean includesAllLanguageFiles) {
        if (modelEntity instanceof Model) {
            return ModelRepositoryManager.getRepositioryObject((Model)modelEntity, includesAllLanguageFiles);
        }
        if (modelEntity instanceof ModelClass) {
            return ModelRepositoryManager.getRepositioryObject((ModelClass)modelEntity, includesAllLanguageFiles);
        }
        if (modelEntity instanceof ModelClassProperty) {
            return ModelRepositoryManager.getRepositioryObject((ModelClassProperty)modelEntity, includesAllLanguageFiles);
        }
        if (modelEntity instanceof ModelClassMethod) {
            return ModelRepositoryManager.getRepositioryObject((ModelClassMethod)modelEntity, includesAllLanguageFiles);
        }
        if (modelEntity instanceof ModelRelation) {
            return ModelRepositoryManager.getRepositioryObject((ModelRelation)modelEntity, includesAllLanguageFiles);
        }
        if (modelEntity instanceof ModelRelationRole) {
            return ModelRepositoryManager.getRepositioryObject((ModelRelationRole)modelEntity, includesAllLanguageFiles);
        }
        throw new UnsupportedOperationException("Model entity type not supported " + modelEntity.getClass().getName());
    }
}

