/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.repository;

import com.sap.ide.metamodel.core.repository.IMMRepositoryObjectProvider;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterface;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.MessagePool;
import com.sap.ide.metamodel.webdynpro.component.NavigationLinks;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.project.ProjectProperties;
import com.sap.ide.metamodel.webdynpro.repository.ApplicationRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ComponentConfigurationControllerDefinitionRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ComponentConfigurationControllerRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ComponentControllerRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ComponentInterfaceControllerDefinitionRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ComponentInterfaceControllerRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ComponentInterfaceDefinitionRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ComponentInterfaceImplementationRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ComponentRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.CustomControllerRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.InterfaceViewRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.MessagePoolRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ModelClassRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ModelRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ProjectPropertiesRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ViewRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.WindowRepositoryManager;

public class MMRepositoryObjectProvider
implements IMMRepositoryObjectProvider {
    private static IMMRepositoryObjectProvider sInstance = new MMRepositoryObjectProvider();

    public static IMMRepositoryObjectProvider getInstance() {
        return sInstance;
    }

    public MMRepositoryObject getRepositoryObject(MainDevelopmentObject mdo, boolean includesAllLanguageFiles) {
        if (mdo == null) {
            return null;
        }
        if (!(mdo.getRoot() instanceof WebDynproRoot)) {
            return null;
        }
        if (mdo instanceof Application) {
            return ApplicationRepositoryManager.getRepositioryObject((Application)mdo, includesAllLanguageFiles);
        }
        if (mdo instanceof ComponentInterfaceDefinition) {
            return ComponentInterfaceDefinitionRepositoryManager.getRepositioryObject((ComponentInterfaceDefinition)mdo, includesAllLanguageFiles);
        }
        if (mdo instanceof ComponentInterfaceImplementation) {
            return ComponentInterfaceImplementationRepositoryManager.getRepositioryObject((ComponentInterfaceImplementation)mdo, includesAllLanguageFiles);
        }
        if (mdo instanceof InterfaceView) {
            return InterfaceViewRepositoryManager.getRepositioryObject((InterfaceView)mdo, includesAllLanguageFiles);
        }
        if (mdo instanceof Component) {
            return ComponentRepositoryManager.getRepositioryObject((Component)mdo, includesAllLanguageFiles);
        }
        if (mdo instanceof MessagePool) {
            return MessagePoolRepositoryManager.getRepositioryObject((MessagePool)mdo, includesAllLanguageFiles);
        }
        if (mdo instanceof Window) {
            return WindowRepositoryManager.getRepositioryObject((Window)mdo, includesAllLanguageFiles);
        }
        if (mdo instanceof NavigationLinks) {
            NavigationLinks navigationLinks = (NavigationLinks)mdo;
            Window window = navigationLinks.getWindow();
            return WindowRepositoryManager.getRepositioryObject(window, includesAllLanguageFiles);
        }
        if (mdo instanceof View) {
            return ViewRepositoryManager.getRepositioryObject((View)mdo, includesAllLanguageFiles);
        }
        if (mdo instanceof Controller) {
            return MMRepositoryObjectProvider.getRepositoryObject((Controller)mdo, includesAllLanguageFiles);
        }
        if (mdo instanceof Model) {
            return ModelRepositoryManager.getRepositioryObject((Model)mdo, includesAllLanguageFiles);
        }
        if (mdo instanceof ModelClass) {
            return ModelClassRepositoryManager.getRepositioryObject((ModelClass)mdo, includesAllLanguageFiles);
        }
        if (mdo instanceof ProjectProperties) {
            return ProjectPropertiesRepositoryManager.getRepositioryObject((ProjectProperties)mdo);
        }
        return null;
    }

    public static MMRepositoryObject getRepositoryObject(Controller controller, boolean includesAllLanguageFiles) {
        ControllerTypeEnum type = controller.getType();
        if (type == ControllerTypeEnum.COMPONENT_INTERFACE) {
            ComponentInterface componentInterface = (ComponentInterface)controller.getParent();
            if (componentInterface instanceof ComponentInterfaceDefinition) {
                return ComponentInterfaceControllerDefinitionRepositoryManager.getRepositioryObject(controller, includesAllLanguageFiles);
            }
            if (componentInterface instanceof ComponentInterfaceImplementation) {
                return ComponentInterfaceControllerRepositoryManager.getRepositioryObject(controller, includesAllLanguageFiles);
            }
        } else if (type == ControllerTypeEnum.COMPONENT_CONFIGURATION) {
            ComponentInterface componentInterface = (ComponentInterface)controller.getParent();
            if (componentInterface instanceof ComponentInterfaceDefinition) {
                return ComponentConfigurationControllerDefinitionRepositoryManager.getRepositioryObject(controller, includesAllLanguageFiles);
            }
            if (componentInterface instanceof ComponentInterfaceImplementation) {
                return ComponentConfigurationControllerRepositoryManager.getRepositioryObject(controller, includesAllLanguageFiles);
            }
        } else {
            if (type == ControllerTypeEnum.INTERFACE_VIEW) {
                return InterfaceViewRepositoryManager.getRepositioryObject(controller, includesAllLanguageFiles);
            }
            if (type == ControllerTypeEnum.COMPONENT) {
                return ComponentControllerRepositoryManager.getRepositioryObject(controller, includesAllLanguageFiles);
            }
            if (type == ControllerTypeEnum.CUSTOM) {
                return CustomControllerRepositoryManager.getRepositioryObject(controller, includesAllLanguageFiles);
            }
            if (type == ControllerTypeEnum.VIEW) {
                return ViewRepositoryManager.getRepositioryObject(controller, includesAllLanguageFiles);
            }
        }
        return null;
    }
}

