/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.repository;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelIterator;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.repository.Utilities;
import org.eclipse.core.runtime.IPath;

public class ComponentRepositoryManager {
    public static MMRepositoryObject getRepositioryObject(Component component, boolean includesAllLanguageFiles) {
        Metamodel metamodel = component.getRoot().getMetamodel();
        MMRepositoryObject repositoryObject = new MMRepositoryObject(metamodel, "Component", component.getQualifiedName(), includesAllLanguageFiles);
        repositoryObject.addMDO((MainDevelopmentObject)component);
        IPath path = Utilities.getDiagramFilePath((MainDevelopmentObject)component);
        if (path != null) {
            repositoryObject.addAdditionalFile(path);
        }
        return repositoryObject;
    }

    public static MMRepositoryObject getCompleteComponent(Component component) {
        Metamodel metamodel = component.getRoot().getMetamodel();
        MMRepositoryObject repositoryObject = new MMRepositoryObject(metamodel, "Component", component.getQualifiedName(), true);
        repositoryObject.addMDO((MainDevelopmentObject)component);
        MetamodelIterator iterator = component.iterator();
        while (iterator.hasNext()) {
            DevelopmentObject developmentObject = iterator.next();
            if (!(developmentObject instanceof MainDevelopmentObject)) continue;
            repositoryObject.addMDO((MainDevelopmentObject)developmentObject);
        }
        return repositoryObject;
    }
}

