/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.plugin;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.common.plugin.CommonRootManager;
import com.sap.ide.metamodel.core.generation.GenerationObjectChangedCache;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.extension.IWebDynproMetamodelExtender;
import com.sap.ide.metamodel.webdynpro.plugin.IWebDynproMetamodelContentProvider;
import com.sap.ide.metamodel.webdynpro.plugin.MetamodelWebDynproEclipsePlugin;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;

public class WebDynproRootManager {
    private static Map mInstanceMap = new HashMap();
    private Set mExtenders = new HashSet();
    private static final String EXTENSION_POINT = "com.sap.ide.metamodel.webdynpro.WebdynproMetamodelExtender";
    private static final String EXTENSION_ELEMENT_EXTENDER = "metamodelExtenderObject";
    private static final String EXTENSION_ATTRIBUTE_RUN = "run";
    WebDynproRoot mWebDynproRoot;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$WebDynproRoot;

    public static synchronized WebDynproRootManager getWebDynproRootManager(Metamodel metamodel) {
        if (metamodel == null) {
            return null;
        }
        Object rootManager = mInstanceMap.get(metamodel);
        if (rootManager == null) {
            WebDynproRootManager webDynproRootManager = (WebDynproRootManager)rootManager;
            String projectName = metamodel.getName();
            if (!ServicesEclipse.projectHasWebDynproNature(projectName)) {
                String message = "Fatal Error: project does not have WebDynpro Nature. projectName = " + projectName;
                MetamodelWebDynproEclipsePlugin.internalError(class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager == null ? (class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager = WebDynproRootManager.class$("com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager")) : class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager, "getWebDynproRootManager", message, null, false);
                return null;
            }
            webDynproRootManager = new WebDynproRootManager(metamodel);
            mInstanceMap.put(metamodel, webDynproRootManager);
            webDynproRootManager.init(metamodel);
            rootManager = webDynproRootManager;
        }
        return (WebDynproRootManager)rootManager;
    }

    static void releaseWebDynproRootManager(Metamodel metamodel) {
        Object rootManager;
        if (metamodel.hasRoot("WebDynpro") && (rootManager = mInstanceMap.get(metamodel)) != null) {
            WebDynproRootManager webDynproRootManager = (WebDynproRootManager)rootManager;
            webDynproRootManager.notifyExtendersDeletion();
        }
        mInstanceMap.remove(metamodel);
    }

    static void metamodelReloaded(Metamodel metamodel) {
        Object rootManager;
        if (metamodel.hasRoot("WebDynpro") && (rootManager = mInstanceMap.get(metamodel)) != null) {
            WebDynproRootManager webDynproRootManager = (WebDynproRootManager)rootManager;
            webDynproRootManager.notifyExtendersReload();
        }
    }

    public static synchronized WebDynproRoot getWebDynproRoot(Metamodel metamodel) {
        WebDynproRootManager webDynproRootManager = WebDynproRootManager.getWebDynproRootManager(metamodel);
        if (webDynproRootManager != null) {
            return webDynproRootManager.getWebDynproRoot();
        }
        return null;
    }

    public WebDynproRoot getWebDynproRoot() {
        return this.mWebDynproRoot;
    }

    private void init(Metamodel metamodel) {
        String contentArchivePath = MetamodelWebDynproEclipsePlugin.getDefault().getContentArchivePath();
        com.sap.ide.metamodel.core.services.ServicesEclipse.addContentArchiveIgnoreSameName((Metamodel)metamodel, (String)contentArchivePath);
        if (!com.sap.ide.metamodel.core.services.ServicesEclipse.isComponentProject((String)metamodel.getName())) {
            String colContentArchivePath = MetamodelWebDynproEclipsePlugin.getDefault().getColContentArchivePath();
            com.sap.ide.metamodel.core.services.ServicesEclipse.addContentArchive((Metamodel)metamodel, (String)colContentArchivePath, (boolean)false);
        }
        WebDynproRootManager.addContentArchives(metamodel);
        this.createExtenders();
        this.notifyExtendersCreation();
    }

    private WebDynproRootManager(Metamodel metamodel) {
        DictionaryRootManager.getDictionaryRoot((Metamodel)metamodel);
        CommonRootManager.getCommonRoot((Metamodel)metamodel);
        try {
            this.mWebDynproRoot = (WebDynproRoot)metamodel.createRoot(class$com$sap$ide$metamodel$webdynpro$WebDynproRoot == null ? (class$com$sap$ide$metamodel$webdynpro$WebDynproRoot = WebDynproRootManager.class$("com.sap.ide.metamodel.webdynpro.WebDynproRoot")) : class$com$sap$ide$metamodel$webdynpro$WebDynproRoot);
            String message = "creating WebDynproRoot. metamodel = " + metamodel.getName() + " " + metamodel.toString();
            MetamodelWebDynproEclipsePlugin.logMessage(message);
        }
        catch (MetamodelException e) {
            String message = "creating WebDynproRoot failed. metamodel.name = " + metamodel.getName();
            MetamodelWebDynproEclipsePlugin.internalError(class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager == null ? (class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager = WebDynproRootManager.class$("com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager")) : class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager, "getWebDynproRoot", message, e, false);
            return;
        }
        this.mWebDynproRoot.enableEventing();
        MetamodelManager metamodelManager = MetamodelManager.getMetamodelManager((String)metamodel.getName());
        GenerationObjectChangedCache generationObjectChangedCache = metamodelManager.getGenerationObjectChangedCache();
        this.mWebDynproRoot.attachGlobalObserver((DevelopmentObjectObserver)generationObjectChangedCache, 8191);
    }

    private static void addContentArchives(Metamodel metamodel) {
        if (com.sap.ide.metamodel.core.services.ServicesEclipse.isComponentProject((String)metamodel.getName())) {
            return;
        }
        IWebDynproMetamodelContentProvider[] providers = MetamodelWebDynproEclipsePlugin.getDefault().getWebDynproMetamodelContentProviders();
        int i = 0;
        while (i < providers.length) {
            IWebDynproMetamodelContentProvider provider = providers[i];
            String contentArchivePath = provider.getContentArchivePath();
            if (contentArchivePath != null && contentArchivePath.length() > 0) {
                com.sap.ide.metamodel.core.services.ServicesEclipse.addContentArchive((Metamodel)metamodel, (String)contentArchivePath, (boolean)true);
            }
            ++i;
        }
    }

    private void createExtenders() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (EXTENSION_ELEMENT_EXTENDER.equals(elements[j].getName())) {
                    try {
                        Object extension = elements[j].createExecutableExtension(EXTENSION_ATTRIBUTE_RUN);
                        if (extension instanceof IWebDynproMetamodelExtender) {
                            this.mExtenders.add(extension);
                            MetamodelWebDynproEclipsePlugin.logMessage("Found and created an extension for Web Dynpro Metamodel: " + extension);
                        } else {
                            MetamodelWebDynproEclipsePlugin.logMessage("Extension object (" + extension + ") does not implement IWebDynproMetamodelExtender. Will be ignored.");
                        }
                    }
                    catch (Throwable t) {
                        MetamodelWebDynproEclipsePlugin.internalError(class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager == null ? WebDynproRootManager.class$("com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager") : class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager, "createExtenders()", t.getMessage(), t, false);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void notifyExtendersCreation() {
        Iterator iter = this.mExtenders.iterator();
        while (iter.hasNext()) {
            IWebDynproMetamodelExtender extender = (IWebDynproMetamodelExtender)iter.next();
            try {
                extender.notifyWebDynproMetamodelCreated(this.mWebDynproRoot);
            }
            catch (Throwable t) {
                MetamodelWebDynproEclipsePlugin.internalError(class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager == null ? WebDynproRootManager.class$("com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager") : class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager, "notifyExtendersCreation()", t.getMessage(), t, false);
            }
        }
    }

    private void notifyExtendersDeletion() {
        Iterator iter = this.mExtenders.iterator();
        while (iter.hasNext()) {
            IWebDynproMetamodelExtender extender = (IWebDynproMetamodelExtender)iter.next();
            try {
                extender.notifyWebDynproMetamodelDeleted(this.mWebDynproRoot);
            }
            catch (Throwable t) {
                MetamodelWebDynproEclipsePlugin.internalError(class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager == null ? WebDynproRootManager.class$("com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager") : class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager, "notifyExtendersDeletion()", t.getMessage(), t, false);
            }
        }
    }

    private void notifyExtendersReload() {
        Iterator iter = this.mExtenders.iterator();
        while (iter.hasNext()) {
            IWebDynproMetamodelExtender extender = (IWebDynproMetamodelExtender)iter.next();
            try {
                extender.notifyWebDynproMetamodelReloaded(this.mWebDynproRoot);
            }
            catch (Throwable t) {
                MetamodelWebDynproEclipsePlugin.internalError(class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager == null ? WebDynproRootManager.class$("com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager") : class$com$sap$ide$metamodel$webdynpro$plugin$WebDynproRootManager, "notifyExtendersReload()", t.getMessage(), t, false);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

