/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.dc;

import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.eclipse.dii.component.IPPEntityService;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.Entity;
import com.sap.tc.logging.Location;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class PPEntitiyService
implements IPPEntityService {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$metamodel$webdynpro$dc$PPEntitiyService == null ? (class$com$sap$ide$metamodel$webdynpro$dc$PPEntitiyService = PPEntitiyService.class$("com.sap.ide.metamodel.webdynpro.dc.PPEntitiyService")) : class$com$sap$ide$metamodel$webdynpro$dc$PPEntitiyService).getName());
    private Metamodel mMetamodel = null;
    private IDCExtendedProject mDcProject = null;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$dc$PPEntitiyService;

    public PPEntitiyService(IDCExtendedProject project, Metamodel metamodel) {
        this.setDcProject(project);
        this.setMetamodel(metamodel);
    }

    public Iterator getEntities(String type) {
        WebDynproRoot lWdRoot = WebDynproRootManager.getWebDynproRoot(this.getMetamodel());
        try {
            ArrayList<Entity> list = new ArrayList<Entity>();
            if (type.equals(IPPModel.EntityType.WEB_DYNPRO_COMPONENT.toString())) {
                Component[] lComponents = lWdRoot.getComponents();
                int i = 0;
                while (i < lComponents.length) {
                    if (!lComponents[i].originatesInArchive()) {
                        list.add(this.createEntity((DevelopmentObject)lComponents[i]));
                    }
                    ++i;
                }
            } else if (type.equals(IPPModel.EntityType.WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION.toString())) {
                ComponentInterfaceDefinition[] lComponentInterfaceDefinitions = lWdRoot.getComponentInterfaceDefinitions();
                int i = 0;
                while (i < lComponentInterfaceDefinitions.length) {
                    if (!lComponentInterfaceDefinitions[i].originatesInArchive()) {
                        list.add(this.createEntity((DevelopmentObject)lComponentInterfaceDefinitions[i]));
                    }
                    ++i;
                }
            } else if (type.equals(IPPModel.EntityType.COMMON_MODEL.toString())) {
                Model[] lModels = lWdRoot.getModels();
                int i = 0;
                while (i < lModels.length) {
                    if (!lModels[i].originatesInArchive()) {
                        list.add(this.createEntity((DevelopmentObject)lModels[i]));
                    }
                    ++i;
                }
            }
            return ((AbstractList)list).iterator();
        }
        catch (LoadException e) {
            TRACE_LOCATION.catching((Throwable)e);
            return null;
        }
    }

    private Entity createEntity(DevelopmentObject developmentObject) {
        Entity lEntity = ComponentFactory.createEntity();
        String lObjectName = developmentObject.getName();
        String lObjectPackage = "";
        if (developmentObject.isMDO()) {
            lObjectPackage = ((MainDevelopmentObject)developmentObject).getPackage();
            lObjectPackage = lObjectPackage.replace('.', '/');
        }
        IPPModel.EntityType lEntityType = null;
        if (developmentObject instanceof Component) {
            lEntityType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT;
        } else if (developmentObject instanceof ComponentInterfaceDefinition) {
            lEntityType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION;
        } else if (developmentObject instanceof Model) {
            lEntityType = IPPModel.EntityType.COMMON_MODEL;
        }
        String lType = lEntityType.toString();
        String lSubType = lEntityType.getSubTyps()[0].toString();
        lEntity.setName(lObjectName);
        lEntity.setCaption(lObjectName);
        lEntity.setDescription(lObjectName);
        lEntity.setPackageName(lObjectPackage);
        lEntity.setType(lType);
        lEntity.setSubType(lSubType);
        return lEntity;
    }

    public String[] getTypes() {
        WebDynproRoot lWdRoot = WebDynproRootManager.getWebDynproRoot(this.getMetamodel());
        try {
            Model[] lModels;
            ComponentInterfaceDefinition[] lComponentInterfaceDefinitions;
            Vector<String> lTypesVector = new Vector<String>();
            Component[] lComponents = lWdRoot.getComponents();
            if (lComponents.length > 0) {
                int i = 0;
                while (i < lComponents.length) {
                    if (!lComponents[i].originatesInArchive()) {
                        lTypesVector.add(IPPModel.EntityType.WEB_DYNPRO_COMPONENT.toString());
                        break;
                    }
                    ++i;
                }
            }
            if ((lComponentInterfaceDefinitions = lWdRoot.getComponentInterfaceDefinitions()).length > 0) {
                int i = 0;
                while (i < lComponentInterfaceDefinitions.length) {
                    if (!lComponentInterfaceDefinitions[i].originatesInArchive()) {
                        lTypesVector.add(IPPModel.EntityType.WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION.toString());
                        break;
                    }
                    ++i;
                }
            }
            if ((lModels = lWdRoot.getModels()).length > 0) {
                int i = 0;
                while (i < lModels.length) {
                    if (!lModels[i].originatesInArchive()) {
                        lTypesVector.add(IPPModel.EntityType.COMMON_MODEL.toString());
                        break;
                    }
                    ++i;
                }
            }
            return lTypesVector.toArray(new String[0]);
        }
        catch (LoadException e) {
            TRACE_LOCATION.catching((Throwable)e);
            return null;
        }
    }

    private IDCExtendedProject getDcProject() {
        return this.mDcProject;
    }

    private Metamodel getMetamodel() {
        return this.mMetamodel;
    }

    private void setDcProject(IDCExtendedProject project) {
        this.mDcProject = project;
    }

    private void setMetamodel(Metamodel metamodel) {
        this.mMetamodel = metamodel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

