/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.userstore;

import com.sap.engine.interfaces.security.userstore.spi.UserContextSpi;
import com.sap.engine.interfaces.security.userstore.spi.UserInfoSpi;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.lib.security.Principal;
import com.sap.security.api.AttributeList;
import com.sap.security.api.IGroupFactory;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserAccountFactory;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.PrincipalNotAccessibleException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.server.userstore.UserstoreException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class UserInfoUME
implements UserInfoSpi {
    private String uniqueId = null;
    private UserContextSpi userContext = null;
    private static Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$server$userstore$UserInfoUME == null ? (class$com$sap$security$core$server$userstore$UserInfoUME = UserInfoUME.class$("com.sap.security.core.server.userstore.UserInfoUME")) : class$com$sap$security$core$server$userstore$UserInfoUME));
    private static Category myCat = Category.getCategory((Category)LoggingHelper.SYS_SECURITY, (String)"UserStoreUME");
    static /* synthetic */ Class class$com$sap$security$core$server$userstore$UserInfoUME;

    UserInfoUME(UserContextSpi userContext, String uniqueId) {
        String method = "UserInfoUME(UserContextSpi,String)";
        try {
            try {
                this.userContext = userContext;
                this.uniqueId = uniqueId;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.security.Principal engineGetPrincipal() throws UserstoreException {
        Principal principal;
        String method = "engineGetPrincipal()";
        try {
            try {
                myLoc.entering(method);
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                AttributeList attributeList = new AttributeList();
                attributeList.addAttribute("com.sap.security.core.usermanagement", "j_user");
                IUserAccount account = accountFactory.getUserAccount(this.uniqueId, attributeList);
                myLoc.debugT(method, "Getting user name from IUserAccount object: " + account.getUniqueID());
                String userName = account.getLogonUid();
                myLoc.debugT(method, "Creating principal object for user " + userName);
                principal = new Principal(userName);
                Object var8_12 = null;
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0005", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (PrincipalNotAccessibleException pnaex) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0005", new Object[]{this.uniqueId}, pnaex);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return principal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String engineGetName() throws UserstoreException {
        String string;
        String method = "engineGetName()";
        try {
            try {
                myLoc.entering(method);
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                AttributeList attributeList = new AttributeList();
                attributeList.addAttribute("com.sap.security.core.usermanagement", "j_user");
                IUserAccount account = accountFactory.getUserAccount(this.uniqueId, attributeList);
                myLoc.debugT(method, "Getting user name from IUserAccount object: " + account.getUniqueID());
                string = account.getLogonUid();
                Object var7_11 = null;
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0005", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (PrincipalNotAccessibleException pnaex) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0005", new Object[]{this.uniqueId}, pnaex);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509Certificate[] engineGetCertificates() throws UserstoreException {
        X509Certificate[] x509CertificateArray;
        String method = "engineGetCertificates()";
        try {
            try {
                X509Certificate[] result;
                myLoc.entering(method);
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                IUserAccount account = accountFactory.getUserAccount(this.uniqueId);
                myLoc.debugT(method, "Reading certificates of IUserAccount object: \n" + account);
                x509CertificateArray = result = account.getCertificates();
                Object var7_11 = null;
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0021", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (CertificateException ce) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0021", new Object[]{this.uniqueId}, ce);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return x509CertificateArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean engineCheckPassword(char[] password) throws UserstoreException {
        boolean bl;
        block7: {
            boolean bl2;
            block6: {
                String method = "engineCheckPassword(char[])";
                try {
                    try {
                        boolean result;
                        myLoc.entering(method);
                        if (password == null) {
                            bl2 = false;
                            Object var8_6 = null;
                            break block6;
                        }
                        IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                        IUserAccount account = accountFactory.getUserAccount(this.uniqueId);
                        myLoc.debugT(method, "Checking password of IUserAccount object: " + account.getUniqueID());
                        bl = result = account.checkPassword(new String(password));
                        break block7;
                    }
                    catch (UMException ume) {
                        UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0014", new Object[]{this.uniqueId}, ume);
                        LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                        myLoc.throwing(method, (Throwable)use);
                        throw use;
                    }
                    catch (RuntimeException rte) {
                        myLoc.throwing(method, (Throwable)rte);
                        throw rte;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    myLoc.exiting();
                    throw throwable;
                }
            }
            myLoc.exiting();
            return bl2;
        }
        Object var8_7 = null;
        myLoc.exiting();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineGetParentGroups() throws UserstoreException {
        Iterator iterator;
        String method = "engineGetParentGroups()";
        try {
            try {
                myLoc.entering(method);
                IUserFactory userFactory = UMFactory.getUserFactory();
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                IUserAccount account = accountFactory.getUserAccount(this.uniqueId);
                Vector<String> parentGroups = new Vector<String>();
                myLoc.debugT(method, "Searching for IUser: " + account.getLogonUid());
                AttributeList attributeList = new AttributeList();
                attributeList.addAttribute("com.sap.security.core.usermanagement", "uniquename");
                IUser user = userFactory.getUser(account.getAssignedUserID(), attributeList);
                myLoc.debugT(method, "Getting parent groups");
                Iterator groupIDs = user.getParentGroups(false);
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                while (true) {
                    if (!groupIDs.hasNext()) {
                        iterator = ((AbstractList)parentGroups).iterator();
                        Object var12_16 = null;
                        break;
                    }
                    parentGroups.add(groupFactory.getGroup((String)groupIDs.next()).getUniqueName());
                }
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0062", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (PrincipalNotAccessibleException pnaex) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0062", new Object[]{this.uniqueId}, pnaex);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object engineReadUserProperty(int userProperty) throws UserstoreException {
        Date date;
        String method = "engineReadUserProperty(int)";
        try {
            try {
                myLoc.entering(method);
                myLoc.debugT(method, "Checking whether reading is supported on property >" + userProperty + "<");
                if (!this.userContext.engineIsUserPropertySupported(userProperty, 1)) {
                    UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0016", new Object[]{new Integer(userProperty).toString()});
                    LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                    myLoc.throwing(method, (Throwable)use);
                    myLoc.exiting();
                    throw use;
                }
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                IUserAccount account = accountFactory.getUserAccount(this.uniqueId);
                Comparable<Date> result = null;
                switch (userProperty) {
                    case 11: {
                        myLoc.debugT(method, "Reading force to change password flag of IUserAccount " + account.getLogonUid());
                        if (account.isPasswordChangeRequired()) {
                            result = new Long(0L);
                            break;
                        }
                        result = new Long(Long.MAX_VALUE);
                        break;
                    }
                    case 10: {
                        myLoc.debugT(method, "Reading last password changed date of IUserAccount " + account.getLogonUid());
                        result = account.getLastPasswordChangedDate();
                        break;
                    }
                    case 1: {
                        myLoc.debugT(method, "Reading creation date of IUserAccount " + account.getLogonUid());
                        result = account.created();
                        break;
                    }
                    case 2: {
                        myLoc.debugT(method, "Reading last modification date of IUserAccount " + account.getLogonUid());
                        result = account.lastModified();
                        break;
                    }
                    case 4: {
                        myLoc.debugT(method, "Reading last failed logon date of IUserAccount " + account.getLogonUid());
                        result = account.getLastFailedLogonDate();
                        break;
                    }
                    case 6: {
                        myLoc.debugT(method, "Reading last successful logon date of IUserAccount " + account.getLogonUid());
                        result = account.getLastSuccessfulLogonDate();
                        break;
                    }
                    case 5: {
                        myLoc.debugT(method, "Reading successful logon count of IUserAccount " + account.getLogonUid());
                        result = new Integer(account.getSuccessfulLogonCounts());
                        break;
                    }
                    case 3: {
                        myLoc.debugT(method, "Reading failed logon count of IUserAccount " + account.getLogonUid());
                        result = new Integer(account.getFailedLogonAttempts());
                        break;
                    }
                    case 7: {
                        myLoc.debugT(method, "Reading validity period (from) of IUserAccount " + account.getLogonUid());
                        result = account.getValidFromDate();
                        break;
                    }
                    case 8: {
                        myLoc.debugT(method, "Reading validity period (to) of IUserAccount " + account.getLogonUid());
                        result = account.getValidToDate();
                        break;
                    }
                    case 12: {
                        myLoc.debugT(method, "Reading lock status of IUserAccount " + account.getLogonUid());
                        if (account.isLocked()) {
                            if (account.getLockReason() == 1) {
                                result = new Integer(1);
                                break;
                            }
                            if (account.getLockReason() == 2) {
                                result = new Integer(2);
                                break;
                            }
                            result = new Integer(99);
                            break;
                        }
                        result = new Integer(0);
                        break;
                    }
                }
                date = result;
                Object var8_11 = null;
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0022", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return date;
    }

    public void engineSetCertificates(X509Certificate[] certificates) throws UserstoreException {
        String method = "engineSetCertificates(X509Certificate[])";
        try {
            try {
                myLoc.entering(method);
                IUserAccount account = UMFactory.getUserAccountFactory().getMutableUserAccount(this.uniqueId);
                myLoc.debugT(method, "Setting certificates of IUserAccount " + account.getLogonUid());
                account.setCertificates(certificates);
                account.save();
                account.commit();
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0020", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (CertificateException e) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0020", new Object[]{this.uniqueId}, e);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    public void engineSetPassword(char[] newPassword) throws UserstoreException {
        String method = "engineSetPassword(char[])";
        try {
            try {
                myLoc.entering(method);
                IUserAccount account = UMFactory.getUserAccountFactory().getMutableUserAccount(this.uniqueId);
                myLoc.debugT(method, "Setting new password of IUserAccount: " + this.uniqueId);
                account.setPassword(new String(newPassword));
                account.setPasswordChangeRequired(true);
                account.save();
                account.commit();
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0015", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    public void engineSetPassword(char[] oldPassword, char[] newPassword) throws UserstoreException {
        String method = "engineSetPassword(char[], char[])";
        try {
            try {
                myLoc.entering(method);
                IUserAccount account = UMFactory.getUserAccountFactory().getMutableUserAccount(this.uniqueId);
                myLoc.debugT(method, "Setting new password of IUserAccount: " + this.uniqueId);
                account.setPassword(new String(oldPassword), new String(newPassword));
                account.setPasswordChangeRequired(false);
                account.save();
                account.commit();
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0015", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    public void engineWriteUserProperty(int userProperty, Object value) throws UserstoreException {
        String method = "engineWriteUserProperty(int, Object)";
        try {
            try {
                myLoc.entering(method);
                myLoc.debugT(method, "Checking whether writing is supported on property >" + userProperty + "<");
                if (!this.userContext.engineIsUserPropertySupported(userProperty, 2)) {
                    UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0017", new Object[]{new Integer(userProperty).toString()});
                    LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                    myLoc.throwing(method, (Throwable)use);
                    myLoc.exiting();
                    throw use;
                }
                Object result = null;
                myLoc.debugT(method, "Getting mutable IUserAccount object for user: " + this.uniqueId);
                IUserAccount account = UMFactory.getUserAccountFactory().getMutableUserAccount(this.uniqueId);
                switch (userProperty) {
                    case 11: {
                        myLoc.debugT(method, "Setting force to change password flag of IUserAccount " + account.getLogonUid());
                        if ((Long)value == Long.MAX_VALUE) {
                            account.setPasswordChangeRequired(false);
                            break;
                        }
                        account.setPasswordChangeRequired(true);
                        break;
                    }
                    case 4: {
                        myLoc.debugT(method, "Setting last failed logon date of IUserAccount " + account.getLogonUid());
                        account.setLastFailedLogonDate((Date)value);
                        break;
                    }
                    case 6: {
                        myLoc.debugT(method, "Setting last successful logon date of IUserAccount " + account.getLogonUid());
                        account.setLastSuccessfulLogonDate((Date)value);
                        break;
                    }
                    case 5: {
                        myLoc.debugT(method, "Setting successful logon count of IUserAccount " + account.getLogonUid());
                        account.setSuccessfulLogonCounts(((Integer)value).intValue());
                        break;
                    }
                    case 3: {
                        myLoc.debugT(method, "Setting failed logon count of IUserAccount " + account.getLogonUid());
                        account.setFailedLogonAttempts(((Integer)value).intValue());
                        break;
                    }
                    case 7: {
                        myLoc.debugT(method, "Setting validity period (from) of IUserAccount " + account.getLogonUid());
                        account.setValidFromDate((Date)value);
                        break;
                    }
                    case 8: {
                        myLoc.debugT(method, "Setting validity period (to) of IUserAccount " + account.getLogonUid());
                        account.setValidToDate((Date)value);
                        break;
                    }
                    case 12: {
                        myLoc.debugT(method, "Setting lock status of IUserAccount " + account.getLogonUid());
                        int lockReason = (Integer)value;
                        if (lockReason == 0) {
                            account.setLocked(false, 0);
                            break;
                        }
                        if (lockReason == 1) {
                            account.setLocked(true, 1);
                            break;
                        }
                        if (lockReason != 2) break;
                        account.setLocked(true, 2);
                        break;
                    }
                }
                account.save();
                account.commit();
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0029", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    public void engineWriteUserProperty(Map values) throws UserstoreException {
        String method = "engineWriteUserProperty(int, Object)";
        try {
            try {
                myLoc.entering(method);
                Iterator keys = values.keySet().iterator();
                int userProperty = 0;
                Object value = null;
                Object key = null;
                myLoc.debugT(method, "Getting mutable IUserAccount object for user: " + this.uniqueId);
                IUserAccount account = UMFactory.getUserAccountFactory().getMutableUserAccount(this.uniqueId);
                while (keys.hasNext()) {
                    key = keys.next();
                    userProperty = key;
                    value = values.get(key);
                    myLoc.debugT(method, "Checking whether writing is supported on property >" + userProperty + "<");
                    if (!this.userContext.engineIsUserPropertySupported(userProperty, 2)) {
                        UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0017", new Object[]{new Integer(userProperty).toString()});
                        LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                        myLoc.throwing(method, (Throwable)use);
                        myLoc.exiting();
                        throw use;
                    }
                    Object result = null;
                    switch (userProperty) {
                        case 11: {
                            myLoc.debugT(method, "Setting force to change password flag of IUserAccount " + account.getLogonUid());
                            if ((Long)value == Long.MAX_VALUE) {
                                account.setPasswordChangeRequired(false);
                                break;
                            }
                            account.setPasswordChangeRequired(true);
                            break;
                        }
                        case 4: {
                            myLoc.debugT(method, "Setting last failed logon date of IUserAccount " + account.getLogonUid());
                            account.setLastFailedLogonDate((Date)value);
                            break;
                        }
                        case 6: {
                            myLoc.debugT(method, "Setting last successful logon date of IUserAccount " + account.getLogonUid());
                            account.setLastSuccessfulLogonDate((Date)value);
                            break;
                        }
                        case 5: {
                            myLoc.debugT(method, "Setting successful logon count of IUserAccount " + account.getLogonUid());
                            account.setSuccessfulLogonCounts(((Integer)value).intValue());
                            break;
                        }
                        case 3: {
                            myLoc.debugT(method, "Setting failed logon count of IUserAccount " + account.getLogonUid());
                            account.setFailedLogonAttempts(((Integer)value).intValue());
                            break;
                        }
                        case 7: {
                            myLoc.debugT(method, "Setting validity period (from) of IUserAccount " + account.getLogonUid());
                            account.setValidFromDate((Date)value);
                            break;
                        }
                        case 8: {
                            myLoc.debugT(method, "Setting validity period (to) of IUserAccount " + account.getLogonUid());
                            account.setValidToDate((Date)value);
                            break;
                        }
                        case 12: {
                            myLoc.debugT(method, "Setting lock status of IUserAccount " + account.getLogonUid());
                            int lockReason = value;
                            if (lockReason == 0) {
                                account.setLocked(false, 0);
                                break;
                            }
                            if (lockReason == 1) {
                                account.setLocked(true, 1);
                                break;
                            }
                            if (lockReason != 2) break;
                            account.setLocked(true, 2);
                            break;
                        }
                    }
                }
                account.save();
                account.commit();
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0029", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean engineCheckUserProperty(int userProperty, Object value) throws UserstoreException {
        boolean bl;
        String method = "engineCheckUserProperty(int, Object)";
        try {
            try {
                boolean result;
                myLoc.entering(method);
                myLoc.debugT(method, "Checking whether checking is supported on property >" + userProperty + "<");
                if (!this.userContext.engineIsUserPropertySupported(userProperty, 3)) {
                    UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0018", new Object[]{new Integer(userProperty).toString()});
                    LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                    myLoc.throwing(method, (Throwable)use);
                    myLoc.exiting();
                    throw use;
                }
                bl = result = false;
                Object var7_8 = null;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        String string;
        String method = "toString()";
        try {
            try {
                String result = "User ID:      " + this.engineGetName();
                result = result + "\nParent Groups: ";
                Iterator parents = this.engineGetParentGroups();
                while (true) {
                    if (!parents.hasNext()) {
                        string = result = result + "\n";
                        Object var6_6 = null;
                        break;
                    }
                    result = result + (String)parents.next();
                    if (!parents.hasNext()) continue;
                    result = result + "\n               ";
                }
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

