/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.userstore;

import com.sap.engine.interfaces.security.userstore.context.SearchAttribute;
import com.sap.engine.interfaces.security.userstore.context.SearchFilter;
import com.sap.engine.interfaces.security.userstore.context.SearchResult;
import com.sap.engine.interfaces.security.userstore.listener.UserListener;
import com.sap.engine.interfaces.security.userstore.spi.FilterPassword;
import com.sap.engine.interfaces.security.userstore.spi.FilterUsername;
import com.sap.engine.interfaces.security.userstore.spi.UserContextSpi;
import com.sap.engine.interfaces.security.userstore.spi.UserInfoSpi;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.security.api.AttributeList;
import com.sap.security.api.IRole;
import com.sap.security.api.IRoleFactory;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserAccountFactory;
import com.sap.security.api.IUserAccountSearchFilter;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.IUserMaint;
import com.sap.security.api.NoSuchUserAccountException;
import com.sap.security.api.NoSuchUserException;
import com.sap.security.api.PrincipalNotAccessibleException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.ticket.TicketException;
import com.sap.security.core.persistence.datasource.imp.SuperUser;
import com.sap.security.core.server.userstore.FilterPasswordUME;
import com.sap.security.core.server.userstore.FilterUsernameUME;
import com.sap.security.core.server.userstore.PropertiesParserUME;
import com.sap.security.core.server.userstore.SearchFilterUME;
import com.sap.security.core.server.userstore.UserInfoUME;
import com.sap.security.core.server.userstore.UserSearchResultUME;
import com.sap.security.core.server.userstore.UserstoreException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;

public class UserContextUME
implements UserContextSpi {
    FilterPassword filterPassword = null;
    FilterUsername filterUsername = null;
    private static Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$server$userstore$UserContextUME == null ? (class$com$sap$security$core$server$userstore$UserContextUME = UserContextUME.class$("com.sap.security.core.server.userstore.UserContextUME")) : class$com$sap$security$core$server$userstore$UserContextUME));
    private static Category myCat = Category.getCategory((Category)LoggingHelper.SYS_SECURITY, (String)"UserStoreUME");
    private static final String UME_ADMIN_ROLE_NAME = "Administrator";
    static /* synthetic */ Class class$com$sap$security$core$server$userstore$UserContextUME;
    static /* synthetic */ Class class$com$sap$engine$lib$security$Principal;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineListUsers() throws UserstoreException {
        Iterator iterator;
        String method = "engineListUsers()";
        try {
            try {
                myLoc.entering(method);
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                Vector<String> users = new Vector<String>();
                IUserAccount account = null;
                myLoc.debugT(method, "Constructing IUserAccountSearchFilter");
                IUserAccountSearchFilter sf = accountFactory.getUserAccountSearchFilter();
                sf.setLogonUid("*", 1, false);
                myLoc.debugT(method, "Execute search");
                ISearchResult sr = accountFactory.search(sf);
                myLoc.debugT(method, "Found " + sr.size() + " results");
                myLoc.debugT(method, "Iterate...");
                int added = 0;
                while (true) {
                    if (!sr.hasNext()) {
                        myLoc.debugT(method, "Added " + added + " to result set");
                        iterator = ((AbstractList)users).iterator();
                        Object var10_14 = null;
                        break;
                    }
                    AttributeList attributeList = new AttributeList();
                    attributeList.addAttribute("com.sap.security.core.usermanagement", "j_user");
                    account = accountFactory.getUserAccount((String)sr.next(), attributeList);
                    myLoc.debugT(method, "Add user <" + account.getLogonUid() + "> to result set.");
                    users.add(account.getLogonUid());
                    ++added;
                }
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0006", new Object[0], ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (PrincipalNotAccessibleException pnaex) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0006", new Object[0], pnaex);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineListRootUsers() throws UserstoreException {
        Iterator iterator;
        String method = "engineListRootUsers()";
        try {
            try {
                iterator = ((AbstractList)new Vector()).iterator();
                Object var4_4 = null;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserInfoSpi engineGetUserInfo(String userName) throws UserstoreException {
        UserInfoUME userInfoUME;
        String method = "engineGetUserInfo(String)";
        try {
            try {
                myLoc.entering(method);
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                IUserAccount account = null;
                Object user = null;
                Vector parentGroups = new Vector();
                myLoc.debugT(method, "Searching IUserAccount " + userName);
                account = accountFactory.getUserAccountByLogonId(userName);
                myLoc.debugT(method, "Creating UserInfo object instance");
                userInfoUME = new UserInfoUME(this, account.getUniqueID());
                Object var9_11 = null;
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0005", new Object[]{userName}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return userInfoUME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserInfoSpi engineGetUserInfo(X509Certificate certificate) throws UserstoreException {
        UserInfoUME userInfoUME;
        String method = "engineGetUserInfo(X509Certificate)";
        try {
            try {
                myLoc.entering(method);
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                IUserAccount account = null;
                Object user = null;
                Vector parentGroups = new Vector();
                myLoc.debugT(method, "Searching IUserAccount ");
                account = accountFactory.getUserAccount(certificate);
                myLoc.debugT(method, "Creating UserInfo object instance");
                userInfoUME = new UserInfoUME(this, account.getUniqueID());
                Object var9_15 = null;
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0005", new Object[]{""}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (CertificateException ce) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0005", new Object[]{""}, ce);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)ce);
                myLoc.throwing(method, (Throwable)ce);
                throw use;
            }
            catch (TicketException te) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0005", new Object[]{""}, te);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)te);
                myLoc.throwing(method, (Throwable)te);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return userInfoUME;
    }

    public UserInfoSpi engineCreateUser(String userName) throws UserstoreException {
        String method = "engineCreateUser(String)";
        try {
            try {
                myLoc.entering(method);
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                IUserFactory userFactory = UMFactory.getUserFactory();
                IUserAccount account = null;
                IUserMaint user = null;
                try {
                    myLoc.debugT(method, "Searching for IUserAccount " + userName);
                    if (accountFactory.getUserAccountByLogonId(userName) != null) {
                        UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0001", new Object[]{userName});
                        LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                        myLoc.throwing(method, (Throwable)use);
                        myLoc.exiting();
                        throw use;
                    }
                }
                catch (NoSuchUserAccountException nsae) {
                    // empty catch block
                }
                try {
                    myLoc.debugT(method, "Searching for IUser " + userName);
                    userFactory.getUserByUniqueName(userName);
                    UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0002", new Object[]{userName});
                    LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                    myLoc.throwing(method, (Throwable)use);
                    myLoc.exiting();
                    throw use;
                }
                catch (NoSuchUserException nsue) {
                    myLoc.debugT(method, "Create IUser " + userName);
                    user = userFactory.newUser(userName);
                    user.setLastName(userName);
                    user.commit();
                    myLoc.debugT(method, "Create IUserAccount " + userName);
                    account = accountFactory.newUserAccount(userName, user.getUniqueID());
                    account.save();
                    account.commit();
                    myLoc.debugT(method, "Creating UserInfo object instance");
                    UserInfoUME userInfoUME = new UserInfoUME(this, account.getUniqueID());
                    Object var9_15 = null;
                    myCat.infoT(myLoc, method, "Created new user {0}", new Object[]{userName});
                    myLoc.exiting();
                    return userInfoUME;
                }
            }
            catch (UMException ume) {
                myCat.errorT(myLoc, "Failed to create new user " + userName);
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0003", new Object[]{userName}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                myLoc.exiting();
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            myCat.infoT(myLoc, method, "Created new user {0}", new Object[]{userName});
            myLoc.exiting();
            throw throwable;
        }
    }

    public void engineDeleteUser(String userName) throws UserstoreException {
        String method = "engineDeleteUser(String)";
        try {
            try {
                myLoc.entering(method);
                IUserFactory userFactory = UMFactory.getUserFactory();
                myLoc.debugT(method, "Locate IUser with logonid=" + userName);
                String uniqueIdUser = userFactory.getUserByLogonID(userName).getUniqueID();
                myLoc.debugT(method, "Delete IUser with with uniqueId=" + uniqueIdUser);
                userFactory.deleteUser(uniqueIdUser);
            }
            catch (UMException ume) {
                myCat.errorT(myLoc, "Failed to delete user " + userName);
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0004", new Object[]{userName}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                myLoc.exiting();
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            myCat.infoT(myLoc, method, "Deleted user {0}", new Object[]{userName});
            myLoc.exiting();
            throw throwable;
        }
        myCat.infoT(myLoc, method, "Deleted user {0}", new Object[]{userName});
        myLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FilterUsername engineGetFilterUsername() throws UserstoreException {
        FilterUsername filterUsername;
        block6: {
            FilterUsernameUME filterUsernameUME;
            block5: {
                String method = "engineGetFilterUsername()";
                try {
                    try {
                        myLoc.entering(method);
                        if (this.filterUsername == null) {
                            filterUsernameUME = new FilterUsernameUME();
                            Object var4_5 = null;
                            break block5;
                        }
                        filterUsername = this.filterUsername;
                        break block6;
                    }
                    catch (RuntimeException rte) {
                        myLoc.throwing(method, (Throwable)rte);
                        throw rte;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    myLoc.exiting();
                    throw throwable;
                }
            }
            myLoc.exiting();
            return filterUsernameUME;
        }
        Object var4_6 = null;
        myLoc.exiting();
        return filterUsername;
    }

    public void engineSetFilterUsername(FilterUsername filter) throws UserstoreException {
        String method = "engineSetFilterUsername(FilterUsername)";
        myLoc.entering(method);
        myLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FilterPassword engineGetFilterPassword() throws UserstoreException {
        FilterPassword filterPassword;
        block6: {
            FilterPasswordUME filterPasswordUME;
            block5: {
                String method = "engineGetFilterPassword()";
                try {
                    try {
                        myLoc.entering(method);
                        if (this.filterPassword == null) {
                            filterPasswordUME = new FilterPasswordUME();
                            Object var4_5 = null;
                            break block5;
                        }
                        filterPassword = this.filterPassword;
                        break block6;
                    }
                    catch (RuntimeException rte) {
                        myLoc.throwing(method, (Throwable)rte);
                        throw rte;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    myLoc.exiting();
                    throw throwable;
                }
            }
            myLoc.exiting();
            return filterPasswordUME;
        }
        Object var4_6 = null;
        myLoc.exiting();
        return filterPassword;
    }

    public void engineSetFilterPassword(FilterPassword filter) throws UserstoreException {
        String method = "engineSetFilterPassword(FilterPassword)";
        myLoc.entering(method);
        myLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean engineIsUserPropertySupported(int userProperty, int operation) throws UserstoreException {
        boolean bl;
        block50: {
            boolean bl2;
            block49: {
                boolean bl3;
                block48: {
                    boolean bl4;
                    block47: {
                        boolean bl5;
                        block46: {
                            boolean bl6;
                            block45: {
                                boolean bl7;
                                block44: {
                                    boolean bl8;
                                    block43: {
                                        boolean bl9;
                                        block42: {
                                            boolean bl10;
                                            block41: {
                                                boolean bl11;
                                                block40: {
                                                    boolean bl12;
                                                    block39: {
                                                        boolean bl13;
                                                        block38: {
                                                            boolean bl14;
                                                            block37: {
                                                                boolean bl15;
                                                                block36: {
                                                                    boolean bl16;
                                                                    block35: {
                                                                        boolean bl17;
                                                                        block34: {
                                                                            boolean bl18;
                                                                            block33: {
                                                                                boolean bl19;
                                                                                block32: {
                                                                                    boolean bl20;
                                                                                    block31: {
                                                                                        boolean bl21;
                                                                                        block30: {
                                                                                            boolean bl22;
                                                                                            block29: {
                                                                                                boolean bl23;
                                                                                                block28: {
                                                                                                    String method = "engineIsUserPropertySupported(int, int)";
                                                                                                    try {
                                                                                                        try {
                                                                                                            myLoc.entering(method);
                                                                                                            switch (userProperty) {
                                                                                                                case 1: {
                                                                                                                    if (operation == 1) {
                                                                                                                        bl23 = true;
                                                                                                                        Object var6_28 = null;
                                                                                                                        break block28;
                                                                                                                    }
                                                                                                                    bl22 = false;
                                                                                                                    break block29;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    if (operation == 1) {
                                                                                                                        bl21 = true;
                                                                                                                        break block30;
                                                                                                                    }
                                                                                                                    bl20 = false;
                                                                                                                    break block31;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    if (operation == 1 || operation == 2) {
                                                                                                                        bl19 = true;
                                                                                                                        break block32;
                                                                                                                    }
                                                                                                                    bl18 = false;
                                                                                                                    break block33;
                                                                                                                }
                                                                                                                case 4: {
                                                                                                                    if (operation == 1 || operation == 2) {
                                                                                                                        bl17 = true;
                                                                                                                        break block34;
                                                                                                                    }
                                                                                                                    bl16 = false;
                                                                                                                    break block35;
                                                                                                                }
                                                                                                                case 5: {
                                                                                                                    if (operation == 1 || operation == 2) {
                                                                                                                        bl15 = true;
                                                                                                                        break block36;
                                                                                                                    }
                                                                                                                    bl14 = false;
                                                                                                                    break block37;
                                                                                                                }
                                                                                                                case 6: {
                                                                                                                    if (operation == 1 || operation == 2) {
                                                                                                                        bl13 = true;
                                                                                                                        break block38;
                                                                                                                    }
                                                                                                                    bl12 = false;
                                                                                                                    break block39;
                                                                                                                }
                                                                                                                case 10: {
                                                                                                                    if (operation == 1) {
                                                                                                                        bl11 = true;
                                                                                                                        break block40;
                                                                                                                    }
                                                                                                                    bl10 = false;
                                                                                                                    break block41;
                                                                                                                }
                                                                                                                case 11: {
                                                                                                                    if (operation == 1 || operation == 2) {
                                                                                                                        bl9 = true;
                                                                                                                        break block42;
                                                                                                                    }
                                                                                                                    bl8 = false;
                                                                                                                    break block43;
                                                                                                                }
                                                                                                                case 12: {
                                                                                                                    if (operation == 1 || operation == 2) {
                                                                                                                        bl7 = true;
                                                                                                                        break block44;
                                                                                                                    }
                                                                                                                    bl6 = false;
                                                                                                                    break block45;
                                                                                                                }
                                                                                                                case 7: {
                                                                                                                    if (operation == 1 || operation == 2) {
                                                                                                                        bl5 = true;
                                                                                                                        break block46;
                                                                                                                    }
                                                                                                                    bl4 = false;
                                                                                                                    break block47;
                                                                                                                }
                                                                                                                case 8: {
                                                                                                                    if (operation == 1 || operation == 2) {
                                                                                                                        bl3 = true;
                                                                                                                        break block48;
                                                                                                                    }
                                                                                                                    bl2 = false;
                                                                                                                    break block49;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    bl = false;
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            break block50;
                                                                                                        }
                                                                                                        catch (RuntimeException rte) {
                                                                                                            myLoc.throwing(method, (Throwable)rte);
                                                                                                            throw rte;
                                                                                                        }
                                                                                                    }
                                                                                                    catch (Throwable throwable) {
                                                                                                        Object var6_51 = null;
                                                                                                        myLoc.exiting();
                                                                                                        throw throwable;
                                                                                                    }
                                                                                                }
                                                                                                myLoc.exiting();
                                                                                                return bl23;
                                                                                            }
                                                                                            Object var6_29 = null;
                                                                                            myLoc.exiting();
                                                                                            return bl22;
                                                                                        }
                                                                                        Object var6_30 = null;
                                                                                        myLoc.exiting();
                                                                                        return bl21;
                                                                                    }
                                                                                    Object var6_31 = null;
                                                                                    myLoc.exiting();
                                                                                    return bl20;
                                                                                }
                                                                                Object var6_32 = null;
                                                                                myLoc.exiting();
                                                                                return bl19;
                                                                            }
                                                                            Object var6_33 = null;
                                                                            myLoc.exiting();
                                                                            return bl18;
                                                                        }
                                                                        Object var6_34 = null;
                                                                        myLoc.exiting();
                                                                        return bl17;
                                                                    }
                                                                    Object var6_35 = null;
                                                                    myLoc.exiting();
                                                                    return bl16;
                                                                }
                                                                Object var6_36 = null;
                                                                myLoc.exiting();
                                                                return bl15;
                                                            }
                                                            Object var6_37 = null;
                                                            myLoc.exiting();
                                                            return bl14;
                                                        }
                                                        Object var6_38 = null;
                                                        myLoc.exiting();
                                                        return bl13;
                                                    }
                                                    Object var6_39 = null;
                                                    myLoc.exiting();
                                                    return bl12;
                                                }
                                                Object var6_40 = null;
                                                myLoc.exiting();
                                                return bl11;
                                            }
                                            Object var6_41 = null;
                                            myLoc.exiting();
                                            return bl10;
                                        }
                                        Object var6_42 = null;
                                        myLoc.exiting();
                                        return bl9;
                                    }
                                    Object var6_43 = null;
                                    myLoc.exiting();
                                    return bl8;
                                }
                                Object var6_44 = null;
                                myLoc.exiting();
                                return bl7;
                            }
                            Object var6_45 = null;
                            myLoc.exiting();
                            return bl6;
                        }
                        Object var6_46 = null;
                        myLoc.exiting();
                        return bl5;
                    }
                    Object var6_47 = null;
                    myLoc.exiting();
                    return bl4;
                }
                Object var6_48 = null;
                myLoc.exiting();
                return bl3;
            }
            Object var6_49 = null;
            myLoc.exiting();
            return bl2;
        }
        Object var6_50 = null;
        myLoc.exiting();
        return bl;
    }

    public void engineRegisterListener(UserListener userListener, int modifier) throws UserstoreException {
        String method = "engineRegisterListener(UserListener, int)";
        try {
            try {
                myLoc.entering(method);
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0011", new Object[0]);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            myLoc.exiting();
            throw throwable;
        }
    }

    public void engineUnregisterListener(UserListener userlistener) throws UserstoreException {
        String method = "engineUnregisterListener(UserListener)";
        try {
            try {
                myLoc.entering(method);
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0011", new Object[0]);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            myLoc.exiting();
            throw throwable;
        }
    }

    public boolean engineIsSubjectRetrievalSupported() throws UserstoreException {
        String method = "engineIsSubjectRetrievalSupported()";
        myLoc.entering(method);
        myLoc.exiting();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long engineFillSubject(UserInfoSpi user, Subject subject) throws UserstoreException {
        long l;
        String method = "engineFillSubject(UserInfoSpi, Subject)";
        try {
            try {
                myLoc.entering(method);
                subject.getPrincipals().add(user.engineGetPrincipal());
                myLoc.exiting();
                l = Long.MAX_VALUE;
                Object var7_6 = null;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void engineEmptySubject(Subject subject) throws UserstoreException {
        String method = "engineEmptySubject(Subject)";
        try {
            try {
                myLoc.entering(method);
                Iterator principals = subject.getPrincipals(class$com$sap$engine$lib$security$Principal == null ? (class$com$sap$engine$lib$security$Principal = UserContextUME.class$("com.sap.engine.lib.security.Principal")) : class$com$sap$engine$lib$security$Principal).iterator();
                while (principals.hasNext()) {
                    principals.next();
                    principals.remove();
                }
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                Object var5_6 = null;
                myLoc.exiting();
                return;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    public void enginePropertiesChanged(Properties newProps) throws UserstoreException {
        String method = "enginePropertiesChanged(Properties)";
        try {
            try {
                myLoc.entering(method);
                if (!UMFactory.isInitialized()) {
                    UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0080", new Object[0]);
                    LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                    myLoc.throwing(method, (Throwable)use);
                    throw use;
                }
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                IUserFactory userFactory = UMFactory.getUserFactory();
                IRoleFactory roleFactory = UMFactory.getRoleFactory();
                Vector usersAndGroups = PropertiesParserUME.getUsersAndGroups();
                String[][] users = (String[][])usersAndGroups.elementAt(0);
                myLoc.debugT(method, "Creating missing default users");
                int i = 0;
                i = 0;
                while (i < users.length) {
                    block11: {
                        try {
                            userFactory.getUserByLogonID(users[i][0]);
                            myLoc.debugT(method, "User " + users[i][0] + "already exists");
                        }
                        catch (NoSuchUserAccountException nsue) {
                            UserInfoSpi spi = this.engineCreateUser(users[i][0]);
                            myLoc.debugT(method, "User " + users[i][0] + " created");
                            spi.engineSetPassword(users[i][1].toCharArray());
                            myLoc.debugT(method, "Password for user " + users[i][0] + " set");
                            spi.engineWriteUserProperty(11, (Object)new Long(Long.MAX_VALUE));
                            myLoc.debugT(method, "Password for user " + users[i][0] + " marked productive");
                            if (!Boolean.valueOf(users[i][3]).booleanValue()) break block11;
                            spi.engineWriteUserProperty(12, (Object)new Integer(2));
                            myLoc.debugT(method, "User " + users[i][0] + " locked");
                        }
                    }
                    StringTokenizer roles = new StringTokenizer(users[i][4], ",");
                    String roleName = null;
                    while (roles.hasMoreTokens()) {
                        IUser user;
                        roleName = roles.nextToken().trim();
                        IRole role = roleFactory.getRoleByUniqueName(roleName);
                        if (role.isUserMember((user = userFactory.getUserByLogonID(users[i][0])).getUniqueID(), false)) {
                            myLoc.debugT(method, "User " + users[i][0] + " is already in UME role" + roleName);
                            continue;
                        }
                        roleFactory.addUserToRole(user.getUniqueID(), role.getUniqueID());
                        myLoc.debugT(method, "User " + users[i][0] + " added to UME role" + roleName);
                    }
                    ++i;
                }
                myLoc.debugT(method, "Finished creation of missing default users");
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0008", new Object[0], ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var14_18 = null;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int engineGetLockAfterInvalidAttempts() {
        int n;
        String method = "engineGetLockAfterInvalidAttempts()";
        try {
            try {
                myLoc.entering(method);
                n = UMFactory.getProperties().getNumber("ume.logon.security_policy.lock_after_invalid_attempts", 3);
                Object var4_4 = null;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearchResult engineSearchUsers(SearchFilter filter) throws SecurityException {
        UserSearchResultUME userSearchResultUME;
        String method = "engineSearchUsers(SearchFilter)";
        try {
            try {
                myLoc.entering(method);
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                myLoc.debugT(method, "Constructing IUserAccountSearchFilter");
                IUserAccountSearchFilter sf = accountFactory.getUserAccountSearchFilter();
                Iterator attributes = filter.getSearchAttributes();
                SearchAttribute attribute = null;
                while (true) {
                    if (!attributes.hasNext()) {
                        if (filter.getMaxSearchResultSize() > 0) {
                            sf.setMaxSearchResultSize(filter.getMaxSearchResultSize());
                        }
                        myLoc.debugT(method, "Execute search");
                        ISearchResult sr = accountFactory.search(sf);
                        myLoc.debugT(method, "Creating iterator with results");
                        userSearchResultUME = new UserSearchResultUME(sr);
                        Object var10_12 = null;
                        break;
                    }
                    attribute = (SearchAttribute)attributes.next();
                    if (attribute.getAttributeName().equals("user.name")) {
                        sf.setLogonUid((String)attribute.getAttributeValue(), attribute.getOperator(), false);
                        continue;
                    }
                    if (!attribute.getAttributeName().equals("user.locked")) continue;
                    sf.setLocked(Boolean.valueOf((String)attribute.getAttributeValue()).booleanValue());
                }
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0006", new Object[0], ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return userSearchResultUME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean engineIsInEmergencyMode() {
        boolean bl;
        String method = "engineIsInEmergencyMode()";
        try {
            try {
                myLoc.entering(method);
                bl = SuperUser.SUPERUSER_IS_ACTIVE;
                Object var4_4 = null;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean engineIsEmergencyUser(String userName) {
        boolean bl;
        String method = "engineIsEmergencyUser(String)";
        try {
            try {
                myLoc.entering(method);
                bl = userName.equalsIgnoreCase("SAP*");
                Object var5_5 = null;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String engineGetEmergencyUserName() {
        String string;
        String method = "engineGetEmergencyUserName()";
        try {
            try {
                myLoc.entering(method);
                string = "SAP*";
                Object var4_4 = null;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String engineGetAnonymousUserName() {
        String string;
        String method = "engineGetAnonymousUserName()";
        try {
            try {
                myLoc.entering(method);
                String guestUserString = UMFactory.getProperties().get("ume.login.guest_user.uniqueids");
                if (guestUserString == null || guestUserString.equals("")) {
                    UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0034", new Object[0]);
                    LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                    myLoc.throwing(method, (Throwable)use);
                    throw use;
                }
                string = new StringTokenizer(guestUserString, ",").nextToken();
                Object var5_6 = null;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearchFilter engineGetSearchFilter() {
        SearchFilterUME searchFilterUME;
        String method = "engineGetSearchFilter()";
        try {
            try {
                myLoc.entering(method);
                searchFilterUME = new SearchFilterUME();
                Object var4_4 = null;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return searchFilterUME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void engineRefresh(String userName) {
        String method = "engineRefresh()";
        try {
            try {
                myLoc.entering(method);
                IUserFactory userFactory = UMFactory.getUserFactory();
                userFactory.invalidateCacheEntryByLogonId(userName);
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0025", new Object[]{userName}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                Object var7_6 = null;
                myLoc.exiting();
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

