/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.userstore;

import com.sap.engine.interfaces.security.userstore.spi.GroupContextSpi;
import com.sap.engine.interfaces.security.userstore.spi.GroupInfoSpi;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.security.api.AttributeList;
import com.sap.security.api.IGroup;
import com.sap.security.api.IGroupFactory;
import com.sap.security.api.PrincipalIterator;
import com.sap.security.api.PrincipalNotAccessibleException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.server.userstore.UsersOfGroupResultUME;
import com.sap.security.core.server.userstore.UserstoreException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class GroupInfoUME
implements GroupInfoSpi {
    private GroupContextSpi groupContext = null;
    private String uniqueId = null;
    private static Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$server$userstore$GroupInfoUME == null ? (class$com$sap$security$core$server$userstore$GroupInfoUME = GroupInfoUME.class$("com.sap.security.core.server.userstore.GroupInfoUME")) : class$com$sap$security$core$server$userstore$GroupInfoUME));
    private static Category myCat = Category.getCategory((Category)LoggingHelper.SYS_SECURITY, (String)"UserStoreUME");
    static /* synthetic */ Class class$com$sap$security$core$server$userstore$GroupInfoUME;

    GroupInfoUME(GroupContextSpi context, String uniqueId) {
        String method = "GroupInfoUME(GroupContextUME,String)";
        try {
            try {
                this.groupContext = context;
                this.uniqueId = uniqueId;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String engineGetName() throws UserstoreException {
        String string;
        String method = "engineGetName()";
        try {
            try {
                myLoc.entering(method);
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                AttributeList attributeList = new AttributeList();
                attributeList.addAttribute("com.sap.security.core.usermanagement", "uniquename");
                IGroup group = groupFactory.getGroup(this.uniqueId, attributeList);
                string = group.getUniqueName();
                Object var7_11 = null;
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0053", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (PrincipalNotAccessibleException pnaex) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0053", new Object[]{this.uniqueId}, pnaex);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineGetParentGroups() throws UserstoreException {
        Iterator iterator;
        String method = "engineGetParentGroups()";
        try {
            try {
                myLoc.entering(method);
                Vector<String> groups = new Vector<String>();
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                IGroup group = groupFactory.getGroup(this.uniqueId);
                myLoc.debugT(method, "Getting parent groups of IGroup: " + this.uniqueId);
                String[] groupIds = groupFactory.getParentGroups(this.uniqueId, false);
                int i = 0;
                while (true) {
                    if (i >= groupIds.length) {
                        iterator = ((AbstractList)groups).iterator();
                        Object var11_13 = null;
                        break;
                    }
                    String groupUniqueId = null;
                    try {
                        groupUniqueId = groupIds[i];
                        groups.add(groupFactory.getGroup(groupUniqueId).getUniqueName());
                    }
                    catch (UMException ume) {
                        UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0028", new Object[]{groupIds[i]}, ume);
                        LoggingHelper.logThrowable((int)300, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                    }
                    ++i;
                }
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0061", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineGetChildGroups() throws UserstoreException {
        Iterator iterator;
        String method = "engineGetChildGroups()";
        try {
            try {
                myLoc.entering(method);
                Vector<String> groups = new Vector<String>();
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                IGroup group = groupFactory.getGroup(this.uniqueId);
                myLoc.debugT(method, "Getting child groups of IGroup: " + this.uniqueId);
                String[] groupIds = groupFactory.getChildGroups(this.uniqueId, false);
                int i = 0;
                while (true) {
                    if (i >= groupIds.length) {
                        iterator = ((AbstractList)groups).iterator();
                        Object var11_13 = null;
                        break;
                    }
                    String groupUniqueId = null;
                    try {
                        groupUniqueId = groupIds[i];
                        groups.add(groupFactory.getGroup(groupUniqueId).getUniqueName());
                    }
                    catch (UMException ume) {
                        UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0028", new Object[]{groupIds[i]}, ume);
                        LoggingHelper.logThrowable((int)300, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                    }
                    ++i;
                }
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0060", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineGetUsersInGroup() throws UserstoreException {
        UsersOfGroupResultUME usersOfGroupResultUME;
        String method = "engineGetUsersInGroup()";
        try {
            try {
                myLoc.entering(method);
                Vector users = new Vector();
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                IGroup group = groupFactory.getGroup(this.uniqueId);
                myLoc.debugT(method, "Getting user members of IGroup: " + this.uniqueId);
                PrincipalIterator userIds = new PrincipalIterator(group.getUserMembers(false), PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
                usersOfGroupResultUME = new UsersOfGroupResultUME((Iterator)userIds);
                Object var8_10 = null;
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0063", new Object[]{this.uniqueId}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return usersOfGroupResultUME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        String method = "toString()";
        try {
            try {
                myLoc.entering(method);
                String result = "Group ID:      " + this.engineGetName();
                result = result + "\nUsers:         ";
                Iterator users = this.engineGetUsersInGroup();
                while (users.hasNext()) {
                    result = result + (String)users.next();
                    if (!users.hasNext()) continue;
                    result = result + "\n               ";
                }
                result = result + "\nChild Groups:  ";
                Iterator children = this.engineGetChildGroups();
                while (children.hasNext()) {
                    result = result + (String)children.next();
                    if (!children.hasNext()) continue;
                    result = result + "\n               ";
                }
                result = result + "\nParent Groups: ";
                Iterator parents = this.engineGetParentGroups();
                while (parents.hasNext()) {
                    result = result + (String)parents.next();
                    if (!parents.hasNext()) continue;
                    result = result + "\n               ";
                }
                String string = result = result + "\n";
                Object var8_8 = null;
                myLoc.exiting();
                return string;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            myLoc.exiting();
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

