/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.userstore;

import com.sap.engine.interfaces.security.userstore.context.SearchAttribute;
import com.sap.engine.interfaces.security.userstore.context.SearchFilter;
import com.sap.engine.interfaces.security.userstore.context.SearchResult;
import com.sap.engine.interfaces.security.userstore.listener.GroupListener;
import com.sap.engine.interfaces.security.userstore.spi.GroupContextSpi;
import com.sap.engine.interfaces.security.userstore.spi.GroupInfoSpi;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.security.api.AttributeList;
import com.sap.security.api.IGroup;
import com.sap.security.api.IGroupFactory;
import com.sap.security.api.IGroupSearchFilter;
import com.sap.security.api.IRole;
import com.sap.security.api.IRoleFactory;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserAccountFactory;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.NoSuchGroupException;
import com.sap.security.api.PrincipalNotAccessibleException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.server.secstorefs.SecStoreFS;
import com.sap.security.core.server.userstore.GroupInfoUME;
import com.sap.security.core.server.userstore.GroupSearchResultUME;
import com.sap.security.core.server.userstore.PropertiesParserUME;
import com.sap.security.core.server.userstore.SearchFilterUME;
import com.sap.security.core.server.userstore.UserstoreException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class GroupContextUME
implements GroupContextSpi {
    private static Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$server$userstore$GroupContextUME == null ? (class$com$sap$security$core$server$userstore$GroupContextUME = GroupContextUME.class$("com.sap.security.core.server.userstore.GroupContextUME")) : class$com$sap$security$core$server$userstore$GroupContextUME));
    private static Category myCat = Category.getCategory((Category)LoggingHelper.SYS_SECURITY, (String)"UserStoreUME");
    private static final String UME_ADMIN_ROLE_NAME = "Administrator";
    static /* synthetic */ Class class$com$sap$security$core$server$userstore$GroupContextUME;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineListGroups() throws UserstoreException {
        Iterator iterator;
        String method = "engineListGroups()";
        try {
            try {
                myLoc.entering(method);
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                Vector<String> groups = new Vector<String>();
                IGroup group = null;
                myLoc.debugT(method, "Constructing GroupSearchFilter");
                IGroupSearchFilter sf = groupFactory.getGroupSearchFilter();
                sf.setUniqueName("*", 1, false);
                myLoc.debugT(method, "Executing search");
                ISearchResult sr = groupFactory.searchGroups(sf);
                myLoc.debugT(method, "Found " + sr.size() + " results");
                myLoc.debugT(method, "Iterate...");
                int added = 0;
                while (true) {
                    if (!sr.hasNext()) {
                        myLoc.debugT(method, "Added " + added + " to result set");
                        iterator = ((AbstractList)groups).iterator();
                        Object var10_12 = null;
                        break;
                    }
                    group = groupFactory.getGroup((String)sr.next());
                    groups.add(group.getUniqueName());
                    ++added;
                }
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0054", new Object[0], ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GroupInfoSpi engineGetGroupInfo(String groupName) throws UserstoreException {
        GroupInfoUME groupInfoUME;
        String method = "engineGetGroupInfo(String)";
        try {
            try {
                myLoc.entering(method);
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                IGroup group = null;
                myLoc.debugT(method, "Searching for IGroup " + groupName);
                group = groupFactory.getGroupByUniqueName(groupName);
                myLoc.debugT(method, "Creating GroupInfo object instance");
                groupInfoUME = new GroupInfoUME(this, group.getUniqueID());
                Object var7_9 = null;
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0053", new Object[]{groupName}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return groupInfoUME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GroupInfoSpi engineCreateGroup(String groupName) throws UserstoreException {
        GroupInfoUME groupInfoUME;
        String method = "engineCreateGroup(String)";
        try {
            try {
                myLoc.entering(method);
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                IGroup group = null;
                try {
                    myLoc.debugT(method, "Searching for IGroup " + groupName);
                    if (groupFactory.getGroupByUniqueName(groupName) != null) {
                        UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0050", new Object[]{groupName});
                        LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                        myLoc.throwing(method, (Throwable)use);
                        myLoc.exiting();
                        throw use;
                    }
                }
                catch (NoSuchGroupException nsge) {
                    // empty catch block
                }
                myLoc.debugT(method, "Creating IGroup " + groupName);
                group = groupFactory.newGroup(groupName);
                group.save();
                group.commit();
                myCat.infoT(myLoc, method, "Created new group {0}", new Object[]{groupName});
                myLoc.debugT(method, "Creating GroupInfo object instance");
                groupInfoUME = new GroupInfoUME(this, group.getUniqueID());
                Object var7_11 = null;
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0051", new Object[]{groupName}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return groupInfoUME;
    }

    public void engineDeleteGroup(String groupName) throws UserstoreException {
        String method = "engineDeleteGroup(String)";
        try {
            try {
                myLoc.entering(method);
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                myLoc.debugT(method, "Fetching uniqueID of IGroup " + groupName);
                String uniqueID = groupFactory.getGroupByUniqueName(groupName).getUniqueID();
                myLoc.debugT(method, "Deleting IGroup " + groupName);
                groupFactory.deleteGroup(uniqueID);
                myCat.infoT(myLoc, method, "Deleted group {0}", new Object[]{groupName});
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0052", new Object[]{groupName}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    public void engineAddGroupToParent(String groupName, String parentName) throws UserstoreException {
        String method = "engineAddGroupToParent(String, String)";
        try {
            try {
                myLoc.entering(method);
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                myLoc.debugT(method, "Fetching uniqueID of IGroup " + groupName);
                String uniqueIdGroup = groupFactory.getGroupByUniqueName(groupName).getUniqueID();
                myLoc.debugT(method, "Fetching uniqueID of IGroup " + parentName);
                String uniqueIdParent = groupFactory.getGroupByUniqueName(parentName).getUniqueID();
                myLoc.debugT(method, "Adding IGroup " + groupName + " to IGroup " + parentName);
                String[] currentChildren = groupFactory.getChildGroups(uniqueIdGroup, true);
                int i = 0;
                while (i < currentChildren.length) {
                    if (currentChildren[i].equals(uniqueIdParent)) {
                        UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0059", new Object[]{groupName, parentName});
                        LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                        myLoc.throwing(method, (Throwable)use);
                        myLoc.exiting();
                        throw use;
                    }
                    ++i;
                }
                groupFactory.addGroupToParent(uniqueIdGroup, uniqueIdParent);
                myCat.infoT(myLoc, method, "Added group {0} to parent group {1}", new Object[]{groupName, parentName});
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0058", new Object[]{groupName, parentName}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    public void engineRemoveGroupFromParent(String groupName, String parentName) throws UserstoreException {
        String method = "engineRemoveGroupFromParent(String, String)";
        try {
            try {
                myLoc.entering(method);
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                myLoc.debugT(method, "Fetching uniqueID of IGroup " + groupName);
                String uniqueIdOfGroup = groupFactory.getGroupByUniqueName(groupName).getUniqueID();
                myLoc.debugT(method, "Fetching uniqueID of IGroup " + parentName);
                String uniqueIdOfParent = groupFactory.getGroupByUniqueName(parentName).getUniqueID();
                myLoc.debugT(method, "Removing IGroup " + groupName + " from IGroup " + parentName);
                groupFactory.removeGroupFromParent(uniqueIdOfGroup, uniqueIdOfParent);
                myCat.infoT(myLoc, method, "Removed group {0} from parent {1}", new Object[]{groupName, parentName});
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0065", new Object[]{groupName, parentName}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineGetChildGroups(String groupName) throws UserstoreException {
        Iterator iterator;
        String method = "engineGetChildGroups(String)";
        try {
            try {
                myLoc.entering(method);
                GroupInfoSpi group = this.engineGetGroupInfo(groupName);
                iterator = group.engineGetChildGroups();
                Object var6_6 = null;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineGetParentGroups(String groupName) throws UserstoreException {
        Iterator iterator;
        String method = "engineGetParentGroups(String)";
        try {
            try {
                myLoc.entering(method);
                GroupInfoSpi group = this.engineGetGroupInfo(groupName);
                iterator = group.engineGetParentGroups();
                Object var6_6 = null;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return iterator;
    }

    public void engineAddUserToGroup(String userName, String groupName) throws UserstoreException {
        String method = "engineAddUserToGroup(String, String)";
        try {
            try {
                myLoc.entering(method);
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                myLoc.debugT(method, "Fetching uniqueID of IUser " + userName);
                String uniqueIdUser = accountFactory.getUserAccountByLogonId(userName).getAssignedUser().getUniqueID();
                myLoc.debugT(method, "Fetching uniqueID of IGroup " + groupName);
                String uniqueIdGroup = groupFactory.getGroupByUniqueName(groupName).getUniqueID();
                myLoc.debugT(method, "Adding IUser " + userName + " to IGroup " + groupName);
                groupFactory.addUserToGroup(uniqueIdUser, uniqueIdGroup);
                myCat.infoT(myLoc, method, "Added user {0} to group {1}", new Object[]{userName, groupName});
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0057", new Object[]{userName, groupName}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    public void engineRemoveUserFromGroup(String userName, String groupName) throws UserstoreException {
        String method = "engineRemoveUserFromGroup(String, String)";
        try {
            try {
                myLoc.entering(method);
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                myLoc.debugT(method, "Fetching uniqueID of IGroup " + groupName);
                String uniqueIdOfGroup = groupFactory.getGroupByUniqueName(groupName).getUniqueID();
                myLoc.debugT(method, "Fetching uniqueID of IGroup " + userName);
                String uniqueIdOfUser = accountFactory.getUserAccountByLogonId(userName).getAssignedUser().getUniqueID();
                myLoc.debugT(method, "Removing IGroup " + groupName + " from IGroup " + groupName);
                groupFactory.removeUserFromGroup(uniqueIdOfUser, uniqueIdOfGroup);
                myCat.infoT(myLoc, method, "Removed user {0} from group {1}", new Object[]{userName, groupName});
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0064", new Object[]{userName, groupName}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineGetUsersOfGroup(String groupName) throws UserstoreException {
        Iterator iterator;
        String method = "engineGetUsersOfGroup(String)";
        try {
            try {
                myLoc.entering(method);
                GroupInfoSpi group = this.engineGetGroupInfo(groupName);
                iterator = group.engineGetUsersInGroup();
                Object var6_6 = null;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineGetGroupsOfUser(String userName) throws UserstoreException {
        Iterator iterator;
        String method = "engineGetGroupsOfUsers(String)";
        try {
            try {
                myLoc.entering(method);
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                IUserFactory userFactory = UMFactory.getUserFactory();
                Vector<String> groups = new Vector<String>();
                myLoc.debugT(method, "Searching for IUserAccount " + userName);
                IUserAccount account = accountFactory.getUserAccountByLogonId(userName);
                myLoc.debugT(method, "Getting IUser ");
                AttributeList attributeList = new AttributeList();
                attributeList.addAttribute("com.sap.security.core.usermanagement", "uniquename");
                IUser user = userFactory.getUser(account.getAssignedUserID(), attributeList);
                myLoc.debugT(method, "Getting group memberships");
                Iterator groupIds = user.getParentGroups(false);
                while (true) {
                    if (!groupIds.hasNext()) {
                        iterator = ((AbstractList)groups).iterator();
                        Object var15_19 = null;
                        break;
                    }
                    String groupUniqueId = null;
                    try {
                        groupUniqueId = (String)groupIds.next();
                        groups.add(groupFactory.getGroup(groupUniqueId).getUniqueName());
                    }
                    catch (UMException ume) {
                        UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0028", new Object[]{groupUniqueId}, ume);
                        LoggingHelper.logThrowable((int)300, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                    }
                }
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0062", new Object[]{userName}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (PrincipalNotAccessibleException pnaex) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0062", new Object[]{userName}, pnaex);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return iterator;
    }

    public void enginePropertiesChanged(Properties newProps) throws UserstoreException {
        String method = "enginePropertiesChanged(java.util.Properties)";
        try {
            try {
                myLoc.entering(method);
                if (!UMFactory.isInitialized()) {
                    UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0080", new Object[0]);
                    LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                    myLoc.throwing(method, (Throwable)use);
                    throw use;
                }
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                IUserFactory userFactory = UMFactory.getUserFactory();
                IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                IRoleFactory roleFactory = UMFactory.getRoleFactory();
                Vector usersAndGroups = PropertiesParserUME.getUsersAndGroups();
                String[][] users = (String[][])usersAndGroups.elementAt(0);
                String[][] groups = (String[][])usersAndGroups.elementAt(1);
                myLoc.debugT(method, "Creating missing default groups");
                int i = 0;
                while (i < groups.length) {
                    try {
                        groupFactory.getGroupByUniqueName(groups[i][0]);
                        myLoc.debugT(method, "Group " + groups[i][0] + "already exists");
                    }
                    catch (NoSuchGroupException nsue) {
                        GroupInfoSpi spi = this.engineCreateGroup(groups[i][0]);
                        myLoc.debugT(method, "Group " + groups[i][0] + " created");
                    }
                    StringTokenizer roles = new StringTokenizer(groups[i][1], ",");
                    String roleName = null;
                    while (roles.hasMoreTokens()) {
                        IGroup group;
                        roleName = roles.nextToken().trim();
                        IRole role = roleFactory.getRoleByUniqueName(roleName);
                        if (role.isGroupMember((group = groupFactory.getGroupByUniqueName(groups[i][0])).getUniqueID(), false)) {
                            myLoc.debugT(method, "Group " + groups[i][0] + " is already in UME role" + roleName);
                            continue;
                        }
                        roleFactory.addGroupToRole(group.getUniqueID(), role.getUniqueID());
                        myLoc.debugT(method, "Group " + groups[i][0] + " added to UME role" + roleName);
                    }
                    ++i;
                }
                myLoc.debugT(method, "Adding default users to default groups");
                StringTokenizer usersGroups = null;
                String userGroup = null;
                int i2 = 0;
                while (i2 < users.length) {
                    usersGroups = new StringTokenizer(users[i2][2], ",");
                    while (usersGroups.hasMoreTokens()) {
                        userGroup = usersGroups.nextToken();
                        this.engineAddUserToGroup(users[i2][0], userGroup);
                        myLoc.debugT(method, "User " + users[i2][0] + " added to group " + userGroup);
                    }
                    ++i2;
                }
                try {
                    SecStoreFS secStoreFS = new SecStoreFS();
                    secStoreFS.openExistingStore();
                    Properties props = secStoreFS.getStringPairs();
                    Enumeration keys = ((Hashtable)props).keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        if (!key.startsWith("user/")) continue;
                        try {
                            secStoreFS.deletePair(key);
                        }
                        catch (Exception e) {
                            myLoc.warningT(method, "SecStoreFS entry " + key + " could not be deleted.");
                            LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)e);
                }
                Object var20_26 = null;
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0010", new Object[0], ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var20_27 = null;
            myCat.infoT(myLoc, method, "Changed properties");
            myLoc.exiting();
            throw throwable;
        }
        myCat.infoT(myLoc, method, "Changed properties");
        myLoc.exiting();
    }

    public void registerListener(GroupListener groupListener, int modifier) throws UserstoreException {
        String method = "registerListener(GroupListener, int)";
        try {
            try {
                myLoc.entering(method);
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0011", new Object[0]);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            myLoc.exiting();
            throw throwable;
        }
    }

    public void unregisterListener(GroupListener groupListener) throws UserstoreException {
        String method = "unregisterListener(GroupListener)";
        try {
            try {
                myLoc.entering(method);
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0011", new Object[0]);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            myLoc.exiting();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineListRootGroups() throws UserstoreException {
        Iterator iterator;
        String method = "engineListRootGroups()";
        try {
            try {
                myLoc.entering(method);
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                Vector<String> groups = new Vector<String>();
                IGroup group = null;
                myLoc.debugT(method, "Constructing GroupSearchFilter");
                IGroupSearchFilter sf = groupFactory.getGroupSearchFilter();
                sf.setUniqueName("*", 1, false);
                myLoc.debugT(method, "Execute search");
                ISearchResult sr = groupFactory.searchGroups(sf);
                myLoc.debugT(method, "Found " + sr.size() + " results");
                myLoc.debugT(method, "Iterate...");
                int added = 0;
                String[] parents = null;
                String uniqueId = null;
                while (true) {
                    if (!sr.hasNext()) {
                        myLoc.debugT(method, "Added " + added + " to result set");
                        iterator = ((AbstractList)groups).iterator();
                        Object var12_14 = null;
                        break;
                    }
                    uniqueId = (String)sr.next();
                    group = groupFactory.getGroup(uniqueId);
                    parents = groupFactory.getParentGroups(uniqueId, false);
                    if (parents.length != 0) continue;
                    groups.add(group.getUniqueName());
                    ++added;
                }
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0055", new Object[0], ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                throw use;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearchFilter engineGetSearchFilter() {
        SearchFilterUME searchFilterUME;
        String method = "engineGetSearchFilter()";
        try {
            try {
                myLoc.entering(method);
                searchFilterUME = new SearchFilterUME();
                Object var4_4 = null;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return searchFilterUME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearchResult engineSearchGroups(SearchFilter filter) throws SecurityException {
        GroupSearchResultUME groupSearchResultUME;
        String method = "engineSearchUsers(SearchFilter)";
        boolean searchFilterError = false;
        try {
            try {
                GroupSearchResultUME gsr;
                block14: {
                    myLoc.entering(method);
                    IGroupFactory groupFactory = UMFactory.getGroupFactory();
                    IUserAccountFactory accountFactory = UMFactory.getUserAccountFactory();
                    myLoc.debugT(method, "Constructing IGroupSearchFilter");
                    IGroupSearchFilter sf = groupFactory.getGroupSearchFilter();
                    Iterator attributes = filter.getSearchAttributes();
                    SearchAttribute attribute = null;
                    while (true) {
                        UserstoreException use;
                        if (!attributes.hasNext()) {
                            if (filter.getMaxSearchResultSize() > 0) {
                                sf.setMaxSearchResultSize(filter.getMaxSearchResultSize());
                            }
                            gsr = null;
                            if (!searchFilterError) break;
                            myLoc.debugT(method, "Creating empty result iterator");
                            gsr = new GroupSearchResultUME(null);
                            gsr.setState(0);
                            break block14;
                        }
                        attribute = (SearchAttribute)attributes.next();
                        if (attribute.getAttributeName().equals("group.name")) {
                            sf.setUniqueName((String)attribute.getAttributeValue(), attribute.getOperator(), false);
                            continue;
                        }
                        if (attribute.getAttributeName().equals("group.childgroup")) {
                            try {
                                IGroup group = groupFactory.getGroupByUniqueName((String)attribute.getAttributeValue());
                                sf.setDirectChild(group.getUniqueID(), attribute.getOperator(), false);
                            }
                            catch (UMException ume) {
                                use = new UserstoreException("com.sap.security.core.server.lib_userstore_0053", new Object[]{(String)attribute.getAttributeValue()}, ume);
                                LoggingHelper.logThrowable((int)300, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                                searchFilterError = true;
                            }
                            continue;
                        }
                        if (!attribute.getAttributeName().equals("group.childuser")) continue;
                        try {
                            IUserAccount account = accountFactory.getUserAccountByLogonId((String)attribute.getAttributeValue());
                            sf.setDirectChild(account.getAssignedUserID(), attribute.getOperator(), false);
                        }
                        catch (UMException ume) {
                            use = new UserstoreException("com.sap.security.core.server.lib_userstore_0005", new Object[]{(String)attribute.getAttributeValue()}, ume);
                            LoggingHelper.logThrowable((int)300, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                            searchFilterError = true;
                        }
                    }
                    myLoc.debugT(method, "Execute search");
                    ISearchResult sr = groupFactory.searchGroups(sf);
                    myLoc.debugT(method, "Creating iterator with results");
                    gsr = new GroupSearchResultUME(sr);
                }
                groupSearchResultUME = gsr;
                Object var12_17 = null;
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0006", new Object[0], ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.debugT(method, "Creating empty iterator");
                GroupSearchResultUME groupSearchResultUME2 = new GroupSearchResultUME(null);
                Object var12_18 = null;
                myLoc.exiting();
                return groupSearchResultUME2;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
        return groupSearchResultUME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void engineRefresh(String groupName) {
        String method = "engineRefresh()";
        try {
            try {
                myLoc.entering(method);
                IGroupFactory groupFactory = UMFactory.getGroupFactory();
                groupFactory.invalidateCacheEntryByUniqueName(groupName);
            }
            catch (UMException ume) {
                UserstoreException use = new UserstoreException("com.sap.security.core.server.lib_userstore_0026", new Object[]{groupName}, ume);
                LoggingHelper.logThrowable((int)500, (Category)myCat, (Location)myLoc, (String)method, (Throwable)use);
                myLoc.throwing(method, (Throwable)use);
                Object var6_6 = null;
                myLoc.exiting();
                return;
            }
            catch (RuntimeException rte) {
                myLoc.throwing(method, (Throwable)rte);
                throw rte;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            myLoc.exiting();
            throw throwable;
        }
        myLoc.exiting();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

