/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.util;

import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ISynchronizer;
import com.tssap.selena.java.javacomment.internal.JavaCommentsPlugin;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;

public class CommentApplier
implements ISynchronizer {
    private IDOMCompilationUnit myCU;
    private IDOMType myType;
    public static final String HOME_INTF_TAG = "@ejbHome";
    public static final String REMOTE_INTF_TAG = "@ejbRemote";
    public static final String LOCAL_HOME_INTF_TAG = "@ejbLocalHome";
    public static final String LOCAL_INTF_TAG = "@ejbLocal";
    public static final String PK_CLASS_TAG = "@ejbPrimaryKey";
    public static final String SIMPLE_PK = "@hasSimplePK";
    private static final HashMap PROPERTY_NAME_CONVERTOR = new HashMap();
    private static final Collection VALUES_ARE_TYPES;

    public CommentApplier(IDOMCompilationUnit cu) {
        this.myCU = cu;
        this.myType = CommentApplier.findType(this.myCU);
    }

    public void apply(Map properties) {
        if (properties == null || this.myType == null) {
            return;
        }
        IJavaComment comment = JavaCommentsPlugin.getDefault().getJavaCommentParser();
        comment.setSynchronizer((ISynchronizer)this);
        Iterator it = properties.entrySet().iterator();
        while (it.hasNext()) {
            String tagName;
            Map.Entry next = it.next();
            Object tagValue = next.getValue();
            if (!(tagValue instanceof String) || (tagName = (String)PROPERTY_NAME_CONVERTOR.get(next.getKey())) == null) continue;
            if (VALUES_ARE_TYPES.contains(tagName)) {
                tagValue = "<{" + tagValue + "}>";
            }
            comment.setTag(tagName, (String)tagValue);
        }
        comment.synchronize(true);
    }

    public String doSynchronizeFrom() {
        return this.myType.getComment();
    }

    public void doSynchronizeTo(String content) {
        this.myType.setComment(content);
    }

    private static IDOMType findType(IDOMCompilationUnit cu) {
        IDOMNode node = cu.getFirstChild();
        while (node != null && node.getNodeType() != 4) {
            node = node.getNextNode();
        }
        return (IDOMType)node;
    }

    static {
        PROPERTY_NAME_CONVERTOR.put("home", HOME_INTF_TAG);
        PROPERTY_NAME_CONVERTOR.put("remote", REMOTE_INTF_TAG);
        PROPERTY_NAME_CONVERTOR.put("localHome", LOCAL_HOME_INTF_TAG);
        PROPERTY_NAME_CONVERTOR.put("local", LOCAL_INTF_TAG);
        PROPERTY_NAME_CONVERTOR.put("primaryKey", PK_CLASS_TAG);
        PROPERTY_NAME_CONVERTOR.put("simplePK", SIMPLE_PK);
        VALUES_ARE_TYPES = new HashSet();
        VALUES_ARE_TYPES.add(HOME_INTF_TAG);
        VALUES_ARE_TYPES.add(REMOTE_INTF_TAG);
        VALUES_ARE_TYPES.add(LOCAL_HOME_INTF_TAG);
        VALUES_ARE_TYPES.add(LOCAL_INTF_TAG);
        VALUES_ARE_TYPES.add(PK_CLASS_TAG);
    }
}

