/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.refactor;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EntityBean;
import com.tssap.j2ee.core.utils.refactoring.IOccurrence;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrenceCreator;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrences;
import com.tssap.j2ee.core.utils.refactoring.Refactorer;
import com.tssap.j2ee.internal.core.ejb.AccessibleBean;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EjbProjectImpl;
import com.tssap.j2ee.internal.core.ejb.EnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.ReadOnlyEJB;
import com.tssap.j2ee.internal.core.ejb.refactor.EjbJarResourceOccurrencesImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.RenameEjbClassOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.RenameHomeOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.RenameLocalHomeOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.RenameLocalOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.RenamePKClassOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.RenameRemoteOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;

public class ParticipantRefactorer
extends Refactorer {
    private EnterpriseBean myBean;
    private IntHashMap myRolesToParticipantNewNames = new IntHashMap();
    private String myNewName;

    public ParticipantRefactorer(EnterpriseBean bean, String newName) {
        this.myBean = bean;
        this.myNewName = newName;
        if (newName != null) {
            this.addRefactoringScheme((IMember)bean.getBeanClass(), newName);
            this.myRolesToParticipantNewNames.put(1, (Object)this.getFQN(bean.getBeanClass().getPackageFragment().getElementName(), newName));
        }
    }

    public ParticipantRefactorer(EnterpriseBean bean) {
        this(bean, null);
    }

    public String getNewName() {
        return this.myNewName;
    }

    public void addParticipant(int role, String newName) {
        if (role == 1) {
            return;
        }
        try {
            IType type = ((AccessibleBean)this.myBean).getParticipant(role);
            this.addRefactoringScheme((IMember)type, newName);
            this.myRolesToParticipantNewNames.put(role, (Object)this.getFQN(type.getPackageFragment().getElementName(), newName));
        }
        catch (EJBModelException e) {
            EJBImplPlugin.logError("Exception while accessing participant", e);
        }
    }

    private String getFQN(String packageName, String typeName) {
        if (packageName.length() == 0) {
            return typeName;
        }
        return packageName + '.' + typeName;
    }

    protected void doCreateResourceOccurrences() {
        com.tssap.j2ee.core.descriptor.EnterpriseBean[] beans = AssembledInfoFinder.findAssembledBeans((IEnterpriseBean)this.myBean);
        if (beans != null && beans.length > 0) {
            int i = 0;
            while (i < beans.length) {
                EjbJar ejbJar = EjbJarResourceOccurrencesImpl.getEjbJar((DescriptorEntity)beans[i]);
                IResourceOccurrences occurrences = this.getOccurrences(ejbJar.getFile(), ParticipantRefactorer.getCreator(ejbJar));
                Iterator it = this.myRolesToParticipantNewNames.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry next = it.next();
                    int role = (Integer)next.getKey();
                    String newName = (String)next.getValue();
                    occurrences.addOccurrence(this.createRoleOccurrence(beans[i], ejbJar, role, newName));
                }
                ++i;
            }
        }
        super.doCreateResourceOccurrences();
    }

    private IOccurrence createRoleOccurrence(com.tssap.j2ee.core.descriptor.EnterpriseBean enterpriseBean, EjbJar ejbJar, int role, String newName) {
        switch (role) {
            case 1: {
                return new RenameEjbClassOccurrenceImpl(ejbJar, enterpriseBean, newName);
            }
            case 2: {
                if (enterpriseBean instanceof com.tssap.j2ee.core.descriptor.AccessibleBean) {
                    return new RenameHomeOccurrenceImpl(ejbJar, (com.tssap.j2ee.core.descriptor.AccessibleBean)enterpriseBean, newName);
                }
            }
            case 4: {
                if (enterpriseBean instanceof com.tssap.j2ee.core.descriptor.AccessibleBean) {
                    return new RenameRemoteOccurrenceImpl(ejbJar, (com.tssap.j2ee.core.descriptor.AccessibleBean)enterpriseBean, newName);
                }
            }
            case 8: {
                if (enterpriseBean instanceof com.tssap.j2ee.core.descriptor.AccessibleBean) {
                    return new RenameLocalHomeOccurrenceImpl(ejbJar, (com.tssap.j2ee.core.descriptor.AccessibleBean)enterpriseBean, newName);
                }
            }
            case 16: {
                if (enterpriseBean instanceof com.tssap.j2ee.core.descriptor.AccessibleBean) {
                    return new RenameLocalOccurrenceImpl(ejbJar, (com.tssap.j2ee.core.descriptor.AccessibleBean)enterpriseBean, newName);
                }
            }
            case 32: {
                if (!(enterpriseBean instanceof EntityBean)) break;
                return new RenamePKClassOccurrenceImpl(ejbJar, (EntityBean)enterpriseBean, newName);
            }
        }
        throw new IllegalArgumentException();
    }

    protected void performed() {
        if (this.myNewName != null) {
            ((EjbProjectImpl)this.myBean.getEJBProject()).getDelta().renamed(this.myBean, new ReadOnlyEJB(this.myBean, this.getNewFullQualifiedBeanName()));
        }
    }

    private String getNewFullQualifiedBeanName() {
        String packageName = this.myBean.getBeanClass().getPackageFragment().getElementName();
        if (packageName.length() == 0) {
            return this.myNewName;
        }
        return packageName + '.' + this.myNewName;
    }

    private static final IResourceOccurrenceCreator getCreator(final EjbJar ejbJar) {
        return new IResourceOccurrenceCreator(){

            public IResourceOccurrences createResourceOccurrence(IFile resource) throws IllegalArgumentException {
                if (!ejbJar.getFile().equals((Object)resource)) {
                    throw new IllegalArgumentException("This is not an ejb-jar file");
                }
                return new EjbJarResourceOccurrencesImpl(ejbJar);
            }
        };
    }
}

