/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.refactor;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IQueryMethod;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.Method;
import com.tssap.j2ee.core.ejbjar.Query;
import com.tssap.j2ee.core.utils.refactoring.AbstractChangePerformer;
import com.tssap.j2ee.core.utils.refactoring.IOccurrence;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrenceCreator;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrences;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.EjbProjectImpl;
import com.tssap.j2ee.internal.core.ejb.MethodSig;
import com.tssap.j2ee.internal.core.ejb.ReadOnlyEJBMethod;
import com.tssap.j2ee.internal.core.ejb.refactor.DOMCompilationUnitOccurrences;
import com.tssap.j2ee.internal.core.ejb.refactor.EjbJarResourceOccurrencesImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.SetDeployedMethodSignatureOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.SetDeployedQuerySignatureOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.SignatureChangeOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder;

public class MethodSignatureSetter
extends AbstractChangePerformer {
    private EJBMethod myMethod;
    private MethodSig mySignature;
    private String myNewDDName;
    private EJBMethod myRenamedMethod;
    private Map myRefactoringSchemes = new HashMap();

    public MethodSignatureSetter(EJBMethod method, MethodSig beanClassMethodSignature) {
        Map renameScheme;
        this.myMethod = method;
        this.mySignature = beanClassMethodSignature;
        Map retypeScheme = null;
        String newName = beanClassMethodSignature.getName();
        try {
            renameScheme = method.getRenameScheme(newName);
            String returnType = beanClassMethodSignature.getReturnType();
            if (returnType != null) {
                retypeScheme = method.getReturnTypeScheme(returnType);
            }
            this.myNewDDName = method.getRenamedNameForDD(newName);
            String[] paramSigs = JDTUtils.java2jdt((String[])beanClassMethodSignature.getParameterTypes(), (boolean)false);
            this.myRenamedMethod = new ReadOnlyEJBMethod(method, newName, paramSigs, this.myNewDDName, beanClassMethodSignature.getParameterTypeFQNs());
        }
        catch (EJBModelException e) {
            renameScheme = null;
        }
        if (renameScheme == null || this.myNewDDName == null) {
            this.setFailed();
            return;
        }
        try {
            Iterator it = renameScheme.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry next = it.next();
                IMethod jdtMethod = (IMethod)next.getKey();
                String methodName = (String)next.getValue();
                String returnType = this.getMapValue(retypeScheme, jdtMethod);
                this.addRefactoringScheme(jdtMethod, new MethodSig(methodName, beanClassMethodSignature.getParameterTypes(), beanClassMethodSignature.getParameterNames(), beanClassMethodSignature.getParameterTypeFQNs(), returnType));
            }
        }
        catch (JavaModelException e) {
            EJBImplPlugin.logError("Could not find methods to refactor", e);
            this.setFailed();
        }
    }

    public void addRefactoringScheme(IMethod je, MethodSig signature) throws JavaModelException {
        this.myRefactoringSchemes.put(je, signature);
        IMethod[] relatedMethods = RippleMethodFinder.getRelatedMethods((IMethod)je, (IProgressMonitor)new NullProgressMonitor(), (IWorkingCopy[])new IWorkingCopy[0]);
        int i = 0;
        while (i < relatedMethods.length) {
            this.myRefactoringSchemes.put(relatedMethods[i], signature);
            ++i;
        }
    }

    private String getMapValue(Map map, Object key) {
        return map == null ? null : (String)map.get(key);
    }

    protected void performed() {
        ((EjbProjectImpl)this.myMethod.getEJBProject()).getDelta().renamed(this.myMethod, this.myRenamedMethod);
    }

    public EJBMethod getNewEJBMethod() {
        return this.myRenamedMethod;
    }

    protected void doCreateResourceOccurrences() throws IllegalArgumentException {
        Query[] queries;
        Method[] methods = AssembledInfoFinder.findAssembledMethods((IEJBMethod)this.myMethod);
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                EjbJar ejbJar = EjbJarResourceOccurrencesImpl.getEjbJar((DescriptorEntity)methods[i]);
                IResourceOccurrences occurrences = this.getOccurrences(ejbJar.getFile(), MethodSignatureSetter.getEjbJarOccurrenceCreator(ejbJar));
                occurrences.addOccurrence((IOccurrence)new SetDeployedMethodSignatureOccurrenceImpl(methods[i], ejbJar, this.myNewDDName, this.mySignature.getParameterTypeFQNs()));
                ++i;
            }
        }
        if (this.myMethod instanceof IQueryMethod && (queries = AssembledInfoFinder.findAssembledQueries((IEJBMethod)this.myMethod)) != null) {
            int i = 0;
            while (i < queries.length) {
                EjbJar ejbJar = EjbJarResourceOccurrencesImpl.getEjbJar((DescriptorEntity)queries[i]);
                IResourceOccurrences occurrences = this.getOccurrences(ejbJar.getFile(), MethodSignatureSetter.getEjbJarOccurrenceCreator(ejbJar));
                occurrences.addOccurrence((IOccurrence)new SetDeployedQuerySignatureOccurrenceImpl(queries[i], ejbJar, this.myNewDDName, this.mySignature.getParameterTypeFQNs()));
                ++i;
            }
        }
        Iterator it = this.myRefactoringSchemes.entrySet().iterator();
        while (it.hasNext()) {
            MethodSig signature;
            Map.Entry next = it.next();
            IMethod method = (IMethod)next.getKey();
            if (!this.checkUniqueness(method, signature = (MethodSig)next.getValue())) {
                this.setFailed();
                return;
            }
            if (JavaConventions.validateMethodName((String)signature.getName()).isOK()) continue;
            this.setFailed();
            return;
        }
        Iterator it2 = this.myRefactoringSchemes.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry next = it2.next();
            IMethod key = (IMethod)next.getKey();
            MethodSig signature = (MethodSig)next.getValue();
            this.createOccurrences(key, signature);
            if (!this.failed()) continue;
            return;
        }
    }

    private void createOccurrences(IMethod method, MethodSig signature) {
        if (method.isBinary()) {
            this.setFailed();
            return;
        }
        ICompilationUnit cu = method.getCompilationUnit();
        IFile file = DOMCompilationUnitOccurrences.getResource(cu);
        IResourceOccurrences occurrences = this.getOccurrences(file, MethodSignatureSetter.getDOMCUOccurrenceCreator(cu));
        occurrences.addOccurrence((IOccurrence)new SignatureChangeOccurrenceImpl(file, method, signature));
    }

    private boolean checkUniqueness(IMethod original, MethodSig sig) {
        IMethod[] foundMethods;
        IType type = original.getDeclaringType();
        String[] paramSignatures = JDTUtils.java2jdt((String[])sig.getParameterTypes(), (boolean)false);
        String name = sig.getName();
        if (name == null) {
            name = original.getElementName();
        }
        if ((foundMethods = type.findMethods(type.getMethod(name, paramSignatures))) != null && foundMethods.length > 0) {
            return foundMethods[0].equals(original);
        }
        String[] parameterNames = sig.getParameterNames();
        return new HashSet<String>(Arrays.asList(parameterNames)).size() == parameterNames.length;
    }

    public MethodSig getNewSignature() {
        return this.mySignature;
    }

    private static final IResourceOccurrenceCreator getEjbJarOccurrenceCreator(final EjbJar ejbJar) {
        return new IResourceOccurrenceCreator(){

            public IResourceOccurrences createResourceOccurrence(IFile resource) throws IllegalArgumentException {
                if (!ejbJar.getFile().equals((Object)resource)) {
                    throw new IllegalArgumentException("This is not an ejb-jar file");
                }
                return new EjbJarResourceOccurrencesImpl(ejbJar);
            }
        };
    }

    private static final IResourceOccurrenceCreator getDOMCUOccurrenceCreator(final ICompilationUnit cu) {
        return new IResourceOccurrenceCreator(){

            public IResourceOccurrences createResourceOccurrence(IFile resource) throws IllegalArgumentException {
                return new DOMCompilationUnitOccurrences(cu);
            }
        };
    }
}

