/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.refactor;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IQueryMethod;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.Method;
import com.tssap.j2ee.core.ejbjar.Query;
import com.tssap.j2ee.core.utils.refactoring.IOccurrence;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrenceCreator;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrences;
import com.tssap.j2ee.core.utils.refactoring.Refactorer;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.EjbProjectImpl;
import com.tssap.j2ee.internal.core.ejb.ReadOnlyEJBMethod;
import com.tssap.j2ee.internal.core.ejb.refactor.EjbJarResourceOccurrencesImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.RenameMethodOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.RenameQueryOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;

public class EJBMethodRefactorer
extends Refactorer {
    private String myNewName;
    private String myNewDDName;
    private EJBMethod myMethod;
    private EJBMethod myRenamedMethod;

    public EJBMethodRefactorer(EJBMethod method, String newName) {
        Map renameScheme;
        this.myMethod = method;
        this.myNewName = newName;
        try {
            renameScheme = method.getRenameScheme(newName);
            this.myNewDDName = method.getRenamedNameForDD(newName);
            String[] paramSigs = JDTUtils.java2jdt((String[])method.getParameterTypes(), (boolean)false);
            this.myRenamedMethod = new ReadOnlyEJBMethod(method, newName, paramSigs, this.myNewDDName, method.getParameterTypesForDD());
        }
        catch (EJBModelException e) {
            renameScheme = null;
        }
        if (renameScheme == null || this.myNewDDName == null) {
            this.setFailed();
            return;
        }
        Iterator it = renameScheme.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            IMethod jdtMethod = (IMethod)next.getKey();
            String methodName = (String)next.getValue();
            this.addRefactoringScheme((IMember)jdtMethod, methodName);
        }
    }

    public String getNewName() {
        return this.myNewName;
    }

    public EJBMethod getRenamedMethod() {
        return this.myRenamedMethod;
    }

    protected void doCreateResourceOccurrences() {
        Method[] methods = AssembledInfoFinder.findAssembledMethods((IEJBMethod)this.myMethod);
        if (methods == null) {
            return;
        }
        int i = 0;
        while (i < methods.length) {
            EjbJar ejbJar = EjbJarResourceOccurrencesImpl.getEjbJar((DescriptorEntity)methods[i]);
            IResourceOccurrences occurrences = this.getOccurrences(ejbJar.getFile(), EJBMethodRefactorer.getCreator(ejbJar));
            occurrences.addOccurrence((IOccurrence)new RenameMethodOccurrenceImpl(methods[i], ejbJar, this.myNewDDName));
            ++i;
        }
        if (this.myMethod instanceof IQueryMethod) {
            Query[] queries = AssembledInfoFinder.findAssembledQueries((IEJBMethod)this.myMethod);
            if (queries == null) {
                return;
            }
            int i2 = 0;
            while (i2 < queries.length) {
                EjbJar ejbJar = EjbJarResourceOccurrencesImpl.getEjbJar((DescriptorEntity)queries[i2]);
                IResourceOccurrences occurrences = this.getOccurrences(ejbJar.getFile(), EJBMethodRefactorer.getCreator(ejbJar));
                occurrences.addOccurrence((IOccurrence)new RenameQueryOccurrenceImpl(queries[i2], ejbJar, this.myNewDDName));
                ++i2;
            }
        }
        super.doCreateResourceOccurrences();
    }

    protected void performed() {
        ((EjbProjectImpl)this.myMethod.getEJBProject()).getDelta().renamed(this.myMethod, this.myRenamedMethod);
    }

    private static final IResourceOccurrenceCreator getCreator(final EjbJar ejbJar) {
        return new IResourceOccurrenceCreator(){

            public IResourceOccurrences createResourceOccurrence(IFile resource) throws IllegalArgumentException {
                if (!ejbJar.getFile().equals((Object)resource)) {
                    throw new IllegalArgumentException("This is not an ejb-jar file");
                }
                return new EjbJarResourceOccurrencesImpl(ejbJar);
            }
        };
    }
}

