/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.refactor;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IRelationshipEnd;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.ejbjar.CmpField;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbRelationshipRole;
import com.tssap.j2ee.core.utils.refactoring.IOccurrence;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrenceCreator;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrences;
import com.tssap.j2ee.core.utils.refactoring.Refactorer;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.EjbProjectImpl;
import com.tssap.j2ee.internal.core.ejb.EntityBean;
import com.tssap.j2ee.internal.core.ejb.PersistentField;
import com.tssap.j2ee.internal.core.ejb.refactor.EJBMethodRefactorer;
import com.tssap.j2ee.internal.core.ejb.refactor.EjbJarResourceOccurrencesImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.RenameCMPFieldOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.RenameCMRFieldOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.refactor.RenamePrimaryKeyFieldOccurrenceImpl;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;

public class EJBFieldRefactorer
extends Refactorer {
    private String myNewName;
    private PersistentField myField;
    private EJBMethodRefactorer myGetterRefactorer;
    private EJBMethodRefactorer mySetterRefactorer;
    private PersistentField myRenamedField;

    public EJBFieldRefactorer(PersistentField field, String newName) {
        IMethod setter;
        IField pkField;
        this.myField = field;
        this.myNewName = newName;
        IField jdtField = field.getField();
        if (jdtField != null && jdtField.exists()) {
            this.addRefactoringScheme((IMember)jdtField, newName);
        }
        if ((pkField = field.getFieldInPKClass()) != null && pkField.exists()) {
            this.addRefactoringScheme((IMember)pkField, newName);
        }
        IEntityBean bean = (IEntityBean)field.getParent();
        IMethod getter = field.getGetter();
        if (getter != null) {
            try {
                this.myGetterRefactorer = this.getAccessorBMRefactorings(bean, getter, JDTUtils.getGetterName((String)newName));
            }
            catch (EJBModelException e) {
                this.setFailed();
                return;
            }
        }
        if ((setter = field.getSetter()) != null) {
            try {
                this.mySetterRefactorer = this.getAccessorBMRefactorings(bean, setter, JDTUtils.getSetterName((String)newName));
            }
            catch (EJBModelException e) {
                this.setFailed();
                return;
            }
        }
    }

    private EJBMethodRefactorer getAccessorBMRefactorings(IEntityBean bean, IMethod accessor, String newAccessorName) throws EJBModelException {
        EJBMethod accessorBM = ((EntityBean)bean).getEJBMethodByIMethod(accessor);
        if (accessorBM != null && accessorBM.exists()) {
            return new EJBMethodRefactorer(accessorBM, newAccessorName);
        }
        return null;
    }

    protected void doCreateResourceOccurrences() throws IllegalArgumentException {
        if (this.myGetterRefactorer != null) {
            this.addOccurrencesFromNestedRefactorer(this.myGetterRefactorer);
            if (this.failed()) {
                return;
            }
        }
        if (this.mySetterRefactorer != null) {
            this.addOccurrencesFromNestedRefactorer(this.mySetterRefactorer);
            if (this.failed()) {
                return;
            }
        }
        try {
            if (((IEntityBean)this.myField.getParent()).isCMP()) {
                if (this.myField.isRelationship()) {
                    this.addAssembledCMRFieldOccurrences();
                } else {
                    this.addAssembledCMPFieldOccurrences();
                }
            }
        }
        catch (EJBModelException e) {
            this.setFailed();
            return;
        }
        super.doCreateResourceOccurrences();
    }

    private void addAssembledCMPFieldOccurrences() {
        IEntityBean sourceBean = (IEntityBean)this.myField.getParent();
        boolean shouldRenamePKField = this.myField.isInPrimaryKey() && sourceBean.isSimplePK();
        EnterpriseBean[] beans = AssembledInfoFinder.findAssembledBeans((IEnterpriseBean)sourceBean);
        if (beans == null) {
            return;
        }
        int i = 0;
        while (i < beans.length) {
            com.tssap.j2ee.core.ejbjar.EntityBean bean;
            String persistenceType;
            if (beans[i] instanceof com.tssap.j2ee.core.ejbjar.EntityBean && "Container".equals(persistenceType = (bean = (com.tssap.j2ee.core.ejbjar.EntityBean)beans[i]).getPersistenceType())) {
                EjbJar ejbJar = EjbJarResourceOccurrencesImpl.getEjbJar((DescriptorEntity)bean);
                CmpField cmpField = bean.getCmpField(this.myField.getName());
                if (cmpField != null) {
                    IResourceOccurrences occurrences = this.getOccurrences(ejbJar.getFile(), EJBFieldRefactorer.getCreator(ejbJar));
                    occurrences.addOccurrence((IOccurrence)new RenameCMPFieldOccurrenceImpl(cmpField, ejbJar, this.myNewName));
                    if (shouldRenamePKField && this.myField.getName().equals(bean.getPrimaryKeyField())) {
                        occurrences.addOccurrence((IOccurrence)new RenamePrimaryKeyFieldOccurrenceImpl(bean, ejbJar, this.myNewName));
                    }
                }
            }
            ++i;
        }
    }

    private void addAssembledCMRFieldOccurrences() {
        EjbRelationshipRole[] relations = AssembledInfoFinder.findAssembledRelations((IRelationshipEnd)((IRelationshipEnd)this.myField));
        if (relations == null) {
            return;
        }
        int i = 0;
        while (i < relations.length) {
            EjbJar ejbJar = EjbJarResourceOccurrencesImpl.getEjbJar((DescriptorEntity)relations[i]);
            IResourceOccurrences occurrences = this.getOccurrences(ejbJar.getFile(), EJBFieldRefactorer.getCreator(ejbJar));
            occurrences.addOccurrence((IOccurrence)new RenameCMRFieldOccurrenceImpl(relations[i], ejbJar, this.myNewName));
            ++i;
        }
    }

    private void addOccurrencesFromNestedRefactorer(Refactorer refactorer) {
        refactorer.createResourceOccurrences();
        if (refactorer.failed()) {
            this.setFailed();
            return;
        }
        Map resourceOccurrences = refactorer.getResourceOccurrences();
        Iterator it = resourceOccurrences.entrySet().iterator();
        while (it.hasNext()) {
            IOccurrence[] occs;
            IResourceOccurrences occurrences;
            Map.Entry next = it.next();
            IFile file = (IFile)next.getKey();
            IResourceOccurrences actualOccurrences = this.getOccurrences(file, EJBFieldRefactorer.getCopier(occurrences = (IResourceOccurrences)next.getValue()));
            if (actualOccurrences == occurrences || (occs = occurrences.getAllOccurrences()) == null) continue;
            int i = 0;
            while (i < occs.length) {
                actualOccurrences.addOccurrence(occs[i]);
                ++i;
            }
        }
    }

    protected void performed() {
        if (this.myGetterRefactorer != null) {
            this.myGetterRefactorer.performed();
        }
        if (this.mySetterRefactorer != null) {
            this.mySetterRefactorer.performed();
        }
        this.myRenamedField = this.myField.createReadOnlyImage(this.myNewName);
        ((EjbProjectImpl)this.myField.getEJBProject()).getDelta().renamed(this.myField, this.myRenamedField);
    }

    public PersistentField getRenamedElement() {
        return this.myRenamedField;
    }

    public String getNewName() {
        return this.myNewName;
    }

    private static final IResourceOccurrenceCreator getCreator(final EjbJar ejbJar) {
        return new IResourceOccurrenceCreator(){

            public IResourceOccurrences createResourceOccurrence(IFile resource) throws IllegalArgumentException {
                if (!ejbJar.getFile().equals((Object)resource)) {
                    throw new IllegalArgumentException("This is not an ejb-jar file");
                }
                return new EjbJarResourceOccurrencesImpl(ejbJar);
            }
        };
    }

    private static final IResourceOccurrenceCreator getCopier(final IResourceOccurrences occurrences) {
        return new IResourceOccurrenceCreator(){

            public IResourceOccurrences createResourceOccurrence(IFile resource) throws IllegalArgumentException {
                if (!occurrences.getFile().equals((Object)resource)) {
                    throw new IllegalArgumentException("This is not an ejb-jar file");
                }
                return occurrences;
            }
        };
    }
}

