/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.refactor;

import com.tssap.j2ee.core.utils.refactoring.AbstractResourceOccurrences;
import com.tssap.j2ee.core.utils.refactoring.IOccurrence;
import com.tssap.j2ee.internal.core.ejb.MethodSig;
import com.tssap.j2ee.internal.core.ejb.refactor.ISignatureChangeOccurrence;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.formatter.CodeFormatter;

public class DOMCompilationUnitOccurrences
extends AbstractResourceOccurrences {
    private Map myOccurrences = new HashMap();
    private ICompilationUnit myCU;
    private String myCUSource;
    static /* synthetic */ Class class$com$tssap$j2ee$internal$core$ejb$refactor$ISignatureChangeOccurrence;

    public DOMCompilationUnitOccurrences(ICompilationUnit cu) {
        super(DOMCompilationUnitOccurrences.getResource(cu));
        this.myCU = cu;
    }

    public static IFile getResource(ICompilationUnit cu) {
        if (cu == null) {
            return null;
        }
        if (cu.isWorkingCopy()) {
            cu = (ICompilationUnit)cu.getOriginalElement();
        }
        return (IFile)cu.getResource();
    }

    public void addOccurrence(IOccurrence occurrence) {
        this.preAddOccurrence(occurrence, class$com$tssap$j2ee$internal$core$ejb$refactor$ISignatureChangeOccurrence == null ? (class$com$tssap$j2ee$internal$core$ejb$refactor$ISignatureChangeOccurrence = DOMCompilationUnitOccurrences.class$("com.tssap.j2ee.internal.core.ejb.refactor.ISignatureChangeOccurrence")) : class$com$tssap$j2ee$internal$core$ejb$refactor$ISignatureChangeOccurrence, this.myCU.isWorkingCopy());
        ISignatureChangeOccurrence changeOcc = (ISignatureChangeOccurrence)occurrence;
        IMethod method = changeOcc.getOriginalMethod();
        if (this.myOccurrences.containsKey(method)) {
            throw new IllegalArgumentException("Conflicting occurrence");
        }
        this.myOccurrences.put(method, occurrence);
    }

    public IOccurrence[] getAllOccurrences() {
        return this.myOccurrences.values().toArray(new IOccurrence[this.myOccurrences.size()]);
    }

    public boolean canPerformNaive() {
        if (this.myCU.isWorkingCopy()) {
            return !this.hasPerformed();
        }
        return super.canPerformNaive();
    }

    public boolean canPerform() {
        if (this.myCU.isWorkingCopy()) {
            return this.canPerformNaive();
        }
        return super.canPerform();
    }

    public void perform(IProgressMonitor monitor) throws CoreException {
        IDOMCompilationUnit domCU;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (this.myOccurrences.isEmpty()) {
            monitor.done();
            return;
        }
        this.addImportsFromOccurrences();
        try {
            this.myCUSource = this.myCU.getSource();
            domCU = new DOMFactory().createCompilationUnit(this.myCUSource, this.myCU.getElementName());
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.tssap.j2ee.internal.core.ejb", 0, "Problem parsing compilation unit source", (Throwable)e));
        }
        if (domCU == null) {
            throw new CoreException((IStatus)new Status(4, "com.tssap.j2ee.internal.core.ejb", 0, "Problem parsing compilation unit source", null));
        }
        monitor.beginTask("Processing compilation unit", 2);
        this.perform(domCU, new SubProgressMonitor(monitor, 1));
        String newSource = domCU.getContents();
        String formattedSource = new CodeFormatter((Map)null).format(newSource);
        this.setContents(formattedSource, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private void addImportsFromOccurrences() {
        Iterator it = this.myOccurrences.values().iterator();
        while (it.hasNext()) {
            ISignatureChangeOccurrence next = (ISignatureChangeOccurrence)it.next();
            IMethod method = next.getOriginalMethod();
            this.addImports(method.getDeclaringType(), next.getNewSignature());
        }
    }

    private void addImports(IType type, MethodSig signature) {
        int i = 0;
        while (i < signature.getParameterTypeFQNs().length) {
            String fqn = signature.getParameterTypeFQNs()[i];
            signature.getParameterTypes()[i] = JDTUtils.addImport((IType)type, (String)fqn) ? Signature.getSimpleName((String)fqn) : fqn;
            ++i;
        }
        if (signature.getReturnType() != null && JDTUtils.addImport((IType)type, (String)signature.getReturnType())) {
            signature.setReturnTypeResolved();
        }
    }

    private void perform(IDOMCompilationUnit domCU, SubProgressMonitor subProgressMonitor) throws CoreException {
        Iterator it = this.myOccurrences.values().iterator();
        while (it.hasNext()) {
            ISignatureChangeOccurrence next = (ISignatureChangeOccurrence)it.next();
            IDOMNode domNode = JDTUtils.findNode((IDOMNode)domCU, (IMember)next.getOriginalMethod());
            if (!(domNode instanceof IDOMMethod)) {
                throw new CoreException((IStatus)new Status(4, "com.tssap.j2ee.internal.core.ejb", 0, "Problem parsing compilation unit source", null));
            }
            this.changeSignature((IDOMMethod)domNode, next.getNewSignature());
        }
    }

    private void changeSignature(IDOMMethod domMethod, MethodSig signature) {
        String newName = signature.getName();
        if (newName != null) {
            domMethod.setName(newName);
        }
        domMethod.setParameters(signature.getParameterTypes(), signature.getParameterNames());
        String returnType = signature.getReturnType();
        if (returnType != null) {
            domMethod.setReturnType(returnType);
        }
    }

    public void undo(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (this.myCUSource == null) {
            monitor.done();
            return;
        }
        this.setContents(this.myCUSource, monitor);
    }

    private void setContents(String contents, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Saving compilation unit contents", 3);
        IBuffer buf = this.myCU.getBuffer();
        buf.setContents(contents);
        buf.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), false);
        this.myCU.makeConsistent((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.myCU.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

