/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbMetaInfo;
import com.tssap.j2ee.core.ejb.ISelectMethod;
import com.tssap.j2ee.internal.core.ejb.BodyAndComment;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.EnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.EntityBean;
import com.tssap.j2ee.internal.core.ejb.MethodSig;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class SelectMethod
extends EJBMethod
implements ISelectMethod {
    private static final Collection FINDER_EXCEPTION = Collections.singleton("FinderException");

    public SelectMethod(EntityBean parent, MethodSig signature) {
        super(parent, 16, signature.getName(), signature.getName(), signature.getParameterTypeFQNs());
    }

    public IStatus validate() throws EJBModelException {
        this.assertExists();
        if (!((EntityBean)this.getParent()).isCMP()) {
            throw new EJBModelException(this.newStatus(4, "Select methods may only be declared in a CMP entity bean"));
        }
        MultiStatus result = new MultiStatus(EJBImplPlugin.getPluginId(), 0, "Validation of Select Method", null);
        try {
            int flags = this.getMethod(1).getFlags();
            if (!Flags.isAbstract((int)flags)) {
                result.add(this.newStatus(4, "Select methods must be declared abstract"));
            }
            if (!Flags.isPublic((int)flags)) {
                result.add(this.newStatus(4, "Select methods must be declared public"));
            }
            if (Flags.isFinal((int)flags)) {
                result.add(this.newStatus(4, "Select methods must not be declared final"));
            }
        }
        catch (JavaModelException e) {
            throw new EJBModelException(this.newStatus(4, "Error occurred while accessing the method"));
        }
        return result;
    }

    public IMethod getDeclaration() {
        return this.getMethod(1);
    }

    protected IMethod getDefiningMethod() throws EJBModelException {
        IMethod method = this.getDeclaration();
        if (method != null && method.exists()) {
            return method;
        }
        return null;
    }

    public String getRenamedNameForDD(String beanClassName) {
        return beanClassName;
    }

    public Map getRenameScheme(String beanClassName) throws EJBModelException {
        if (!EjbMetaInfo.isSelectMethodName((String)beanClassName)) {
            String msg = "Invalid method name [" + beanClassName + "]";
            throw new EJBModelException((IStatus)new Status(4, EJBImplPlugin.getPluginId(), 0, msg, null));
        }
        HashMap<IMethod, String> scheme = new HashMap<IMethod, String>(1);
        IMethod method = this.getDeclaration();
        if (method != null && method.exists()) {
            scheme.put(method, beanClassName);
        }
        return scheme;
    }

    public Map getReturnTypeScheme(String beanClassReturnType) throws EJBModelException {
        HashMap<IMethod, String> scheme = new HashMap<IMethod, String>(1);
        IMethod method = this.getDeclaration();
        if (method != null && method.exists()) {
            scheme.put(method, beanClassReturnType);
        }
        return scheme;
    }

    public boolean canSetReturnType(String type) {
        return true;
    }

    public void setReturnType(String type, IProgressMonitor monitor) throws EJBModelException {
        super.setReturnType(type, monitor);
    }

    protected void promote(int role, IType type, String beanClassName, List params, String returnType, List exceptionsType, IProgressMonitor monitor) throws EJBModelException {
        throw new EJBModelException("Cannot promote Select method");
    }

    protected EJBMethod doPasteCopy(EnterpriseBean target, String name, String[] paramTypeFQNs, String[] paramNames, String[] exceptionTypes, String returnType, IntHashMap methodBodiesAndComments) throws EJBModelException {
        target.enterWorkingCopyMode();
        try {
            ((EntityBean)target).createSelectMethod(EjbMetaInfo.getSelectMethodUserName((String)name), paramTypeFQNs, paramNames, returnType, exceptionTypes, null);
            try {
                this.pasteMethodBody(target.getBeanClass(), name, paramTypeFQNs, (BodyAndComment)methodBodiesAndComments.get(1));
            }
            catch (CoreException e) {
                throw new EJBModelException("Exception occurred while pasting method", (Throwable)e);
            }
            Object var10_10 = null;
            target.exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            target.exitWorkingCopyMode();
            throw throwable;
        }
        EJBMethod result = (EJBMethod)target.getEJBMethodByJavaTypes(name, paramTypeFQNs);
        return result;
    }

    protected void pasteMethodCopy(EnterpriseBean target, int role, String beanClassMethodName, String[] paramTypeFQNs, String[] paramNames, String[] exceptionTypes, String returnType, BodyAndComment bodyAndComment) throws CoreException {
        throw new EJBModelException("Should not be called");
    }

    protected Collection getMandatoryExceptionTypes() {
        return FINDER_EXCEPTION;
    }

    protected String getDdpKey() {
        return "SelectMethod";
    }

    protected Object getDdpSource() {
        return this.getDeclaration();
    }

    protected boolean isValidName(String name) {
        return EjbMetaInfo.isSelectMethodName((String)name);
    }
}

