/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.ejb.IRelationshipEnd;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.ejbjar.EjbRelationshipRole;
import com.tssap.j2ee.core.ejbjar.Method;
import com.tssap.j2ee.core.inheritance.InhType;
import com.tssap.j2ee.core.utils.ReadOnlinessValidator;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.EntityBean;
import com.tssap.j2ee.internal.core.ejb.PersistentField;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;

public class RelationshipEnd
extends PersistentField
implements IRelationshipEnd {
    private IType myResolvedType;
    private Integer myCardinality;
    private IEntityBean myRelationshipTarget;
    private static final String COLLECTION_FQN = (class$java$util$Collection == null ? (class$java$util$Collection = RelationshipEnd.class$("java.util.Collection")) : class$java$util$Collection).getName();
    private static final String SET_FQN = (class$java$util$Set == null ? (class$java$util$Set = RelationshipEnd.class$("java.util.Set")) : class$java$util$Set).getName();
    private static final String COLLECTION_NAME = Signature.getSimpleName((String)COLLECTION_FQN);
    private static final String SET_NAME = Signature.getSimpleName((String)SET_FQN);
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;

    protected RelationshipEnd(EntityBean parent, String name) {
        super(parent, name);
    }

    public RelationshipEnd(EntityBean parent, IMethod accessor) {
        super(parent, accessor);
    }

    public int getCardinality() {
        if (this.myCardinality == null) {
            this.myCardinality = new Integer(this.internalGetCardinality());
        }
        return this.myCardinality;
    }

    private int internalGetCardinality() {
        String type = this.getType();
        if (type == null) {
            return 0;
        }
        if (COLLECTION_NAME.equals(type = Signature.getSimpleName((String)type))) {
            return 1;
        }
        if (SET_NAME.equals(type)) {
            return 2;
        }
        return 0;
    }

    public void setCardinality(int cardinality, IProgressMonitor monitor) throws EJBModelException {
        int oldCardinality = this.getCardinality();
        if (oldCardinality == cardinality) {
            return;
        }
        if (cardinality < 0 || cardinality > 2) {
            throw new EJBModelException("Cannot set relation cardinality: illegal cardinality option");
        }
        IType type = this.getResolvedType();
        if (type == null) {
            throw new EJBModelException("Could not set relation cardinality");
        }
        this.validateEdit();
        String typeFQN = type.getFullyQualifiedName();
        if (cardinality == 0) {
            this.unsafeSetType(typeFQN, monitor);
            this.setDdp("@associates", null);
        } else {
            if (oldCardinality == 0) {
                this.setDdp("@associates", typeFQN);
            }
            this.unsafeSetType(this.getReturnTypeByCardinality(cardinality), monitor);
        }
    }

    private String getReturnTypeByCardinality(int cardinality) {
        if (cardinality == 1) {
            return COLLECTION_FQN;
        }
        if (cardinality == 2) {
            return SET_FQN;
        }
        throw new IllegalArgumentException();
    }

    public IEntityBean getRoleSource() {
        return (EntityBean)this.getParent();
    }

    public IPersistentField getCMRField() {
        return this;
    }

    public IEntityBean getRelationshipTarget() {
        if (this.myRelationshipTarget == null) {
            this.myRelationshipTarget = this.internalGetRelationshipTarget();
        }
        return this.myRelationshipTarget;
    }

    private IEntityBean internalGetRelationshipTarget() {
        String targetBeanClass = this.getTargetBeanClassName();
        if (targetBeanClass == null) {
            return null;
        }
        try {
            IEnterpriseBean bean = this.getEJBProject().getEnterpriseBean(targetBeanClass);
            if (bean != null && bean.getKind() == 1 && ((IEntityBean)bean).isCMP()) {
                InhType actualLocalInhType;
                IEntityBean candidate = (IEntityBean)bean;
                IType actualLocal = candidate.getParticipant(16);
                if (actualLocal == null && (actualLocal = ((EntityBean)candidate).findParticipant(16, false)) != null && actualLocal.exists() && ((actualLocalInhType = this.internalGetEJBProject().getInhModel().findType(actualLocal.getFullyQualifiedName())) == null || !actualLocalInhType.derivedFrom(this.internalGetEJBProject().getHierarchyHolder().getBaseName(16)))) {
                    return null;
                }
                if (actualLocal != null && actualLocal.equals(this.getResolvedType())) {
                    return candidate;
                }
            }
        }
        catch (EJBModelException eJBModelException) {
            // empty catch block
        }
        return null;
    }

    private String getTargetBeanClassName() {
        String result = this.getDdpAsString("defaultEjbRelationTargetBeanClass");
        if (result != null) {
            return result;
        }
        String expectedBeanClassName = this.getDdpAsString("defaultEjbRelationTargetEjbName");
        if (expectedBeanClassName != null) {
            IPackageFragment pf = this.getEJB().getBeanClass().getPackageFragment();
            result = pf.isDefaultPackage() ? expectedBeanClassName : pf.getElementName() + '.' + expectedBeanClassName;
            return result;
        }
        IType resolvedLocalIntf = this.getResolvedType();
        if (resolvedLocalIntf == null) {
            return null;
        }
        String expectedLocalIntf = resolvedLocalIntf.getFullyQualifiedName();
        try {
            IEntityBean parentEJB = this.getRoleSource();
            IType parentLocal = parentEJB.getParticipant(16);
            if (parentLocal != null && expectedLocalIntf.equals(parentLocal.getFullyQualifiedName())) {
                return this.getEJB().getBeanClassName();
            }
        }
        catch (EJBModelException e) {
            // empty catch block
        }
        if (!expectedLocalIntf.endsWith("Local")) {
            return null;
        }
        return expectedLocalIntf.substring(0, expectedLocalIntf.length() - "Local".length()) + "Bean";
    }

    public void setRelationshipTarget(IEntityBean target, IProgressMonitor monitor) throws EJBModelException {
        IEntityBean currentTarget = this.getRelationshipTarget();
        if (currentTarget == null && target == null) {
            return;
        }
        if (target == null) {
            throw new EJBModelException("Could not set null relationship target");
        }
        if (currentTarget != null && currentTarget.getBeanClassName().equals(target.getBeanClassName())) {
            return;
        }
        if (!target.isCMP()) {
            throw new EJBModelException("Cannot set relationship target to non-cmp bean");
        }
        IType targetLocal = target.getParticipant(16);
        if (targetLocal == null) {
            throw new EJBModelException("Cannot set relationship to a bean that does not have local structure");
        }
        this.validateEdit();
        IType currentType = this.getResolvedType();
        this.getEJB().enterWorkingCopyMode();
        try {
            if (!targetLocal.equals(currentType)) {
                this.setResolvedType(targetLocal.getFullyQualifiedName(), monitor);
            }
            IType targetBeanClass = target.getBeanClass();
            this.setDdp("defaultEjbRelationTargetBeanClass", targetBeanClass.getFullyQualifiedName());
            Object var8_7 = null;
            this.getEJB().exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.getEJB().exitWorkingCopyMode();
            throw throwable;
        }
    }

    public boolean isInPrimaryKey() {
        return false;
    }

    public void setInPrimaryKey(boolean inPrimaryKey) {
    }

    public boolean canSetType(String type) {
        String actualType = this.getType();
        return type != null && (type.equals(actualType) || JDTUtils.getFQN((IType)this.getEJB().getBeanClass(), (String)type).equals(actualType));
    }

    public void setType(String type, IProgressMonitor monitor) throws EJBModelException {
    }

    boolean merge(PersistentField newState) {
        int newCardinality;
        int oldCardinality;
        IEntityBean newRelationshipTarget;
        IType newResolvedType;
        boolean result = super.merge(newState);
        if (!newState.isRelationship()) {
            EJBImplPlugin.logError("Should not happen: a relation became a non-relation, which should have been treated elsewhere");
            return true;
        }
        RelationshipEnd another = (RelationshipEnd)newState;
        if (this.myResolvedType != null && !this.myResolvedType.equals(newResolvedType = another.getResolvedType())) {
            this.myResolvedType = newResolvedType;
            result = true;
        }
        if (!RelationshipEnd.equalsEx(this.myRelationshipTarget, newRelationshipTarget = another.getRelationshipTarget())) {
            IEntityBean oldRelationshipTarget = this.myRelationshipTarget;
            this.myRelationshipTarget = newRelationshipTarget;
            this.internalGetEJBProject().getSynchronizeTarget().relationTargetChanged((IRelationshipEnd)this, oldRelationshipTarget, newRelationshipTarget);
            result = true;
        }
        if (this.myCardinality != null && (oldCardinality = this.myCardinality.intValue()) != (newCardinality = another.getCardinality())) {
            this.myCardinality = new Integer(newCardinality);
            this.internalGetEJBProject().getSynchronizeTarget().relationCardinalityChanged((IRelationshipEnd)this, oldCardinality, newCardinality);
            result = true;
        }
        return result;
    }

    private static boolean equalsEx(Object one, Object another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return one.equals(another);
    }

    public boolean isRelationship() {
        return true;
    }

    public PersistentField createReadOnlyImage(String name) {
        return new RelationshipEnd(this.getEJB(), name);
    }

    public IStatus validate() throws EJBModelException {
        IStatus result = super.validate();
        if (this.getRelationshipTarget() == null) {
            throw new EJBModelException("Type must be local interface of some other bean");
        }
        return result;
    }

    public IType getResolvedType() {
        if (this.myResolvedType == null) {
            this.myResolvedType = this.internalGetResolvedType();
        }
        return this.myResolvedType;
    }

    private IType internalGetResolvedType() {
        if (this.getGetter() == null || !this.getGetter().getDeclaringType().exists()) {
            return null;
        }
        String typeName = this.getCardinality() != 0 ? this.getDdpAsString("@associates") : this.getType();
        if (typeName == null) {
            return null;
        }
        return JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)typeName);
    }

    private void setResolvedType(String typeFQN, IProgressMonitor monitor) throws EJBModelException {
        if (this.getCardinality() == 0) {
            this.unsafeSetType(typeFQN, monitor);
        } else {
            this.setDdp("@associates", typeFQN);
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    static boolean isCollectionType(String type) {
        String simpleType = Signature.getSimpleName((String)type);
        return COLLECTION_NAME.equals(simpleType) || SET_NAME.equals(simpleType);
    }

    public void createGetter(IProgressMonitor monitor) throws EJBModelException {
        this.primCreateGetter(monitor);
        this.promoteAccessor(16, this.getGetterBM());
    }

    public void createSetter(IProgressMonitor monitor) throws EJBModelException {
        this.primCreateSetter(monitor);
        this.promoteAccessor(16, this.getSetterBM());
    }

    void validateEdit() throws EJBModelException {
        EjbRelationshipRole[] deployedInstances;
        int i;
        Method[] deployedMethods;
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        EJBMethod getter = this.getEJB().getEJBMethodByIMethod(this.getGetter());
        EJBMethod setter = this.getEJB().getEJBMethodByIMethod(this.getSetter());
        if (getter != null) {
            validator.addJavaElements((IMember[])getter.getMethods());
            deployedMethods = AssembledInfoFinder.findAssembledMethods((IEJBMethod)getter);
            if (deployedMethods != null) {
                i = 0;
                while (i < deployedMethods.length) {
                    validator.addResource(deployedMethods[i].getDocument().getFile());
                    ++i;
                }
            }
        }
        if (setter != null) {
            validator.addJavaElements((IMember[])setter.getMethods());
            deployedMethods = AssembledInfoFinder.findAssembledMethods((IEJBMethod)setter);
            if (deployedMethods != null) {
                i = 0;
                while (i < deployedMethods.length) {
                    validator.addResource(deployedMethods[i].getDocument().getFile());
                    ++i;
                }
            }
        }
        if ((deployedInstances = AssembledInfoFinder.findAssembledRelations((IRelationshipEnd)this)) != null) {
            i = 0;
            while (i < deployedInstances.length) {
                validator.addResource(deployedInstances[i].getDocument().getFile());
                ++i;
            }
        }
        if (!validator.canModify()) {
            throw new EJBModelException("Could not modify read-only files");
        }
    }

    protected ReadOnlinessValidator getValidatorOnDelete() {
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        EjbRelationshipRole[] relations = AssembledInfoFinder.findAssembledRelations((IRelationshipEnd)this);
        if (relations == null) {
            return validator;
        }
        int i = 0;
        while (i < relations.length) {
            validator.addResource(relations[i].getDocument().getFile());
            ++i;
        }
        return validator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

