/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.ICopiedEJBElement;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.ejbjar.Method;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.utils.ReadOnlinessValidator;
import com.tssap.j2ee.internal.core.ejb.BusinessMethod;
import com.tssap.j2ee.internal.core.ejb.CopiedPersistentField;
import com.tssap.j2ee.internal.core.ejb.EJBElement;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EntityBean;
import com.tssap.j2ee.internal.core.ejb.refactor.EJBFieldRefactorer;
import com.tssap.j2ee.internal.core.ejb.util.EjbTemplatesSupport;
import com.tssap.j2ee.internal.core.ejb.util.IMemberHolder;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.ejb.util.JDomSupport;
import com.tssap.j2ee.internal.core.ejb.util.JavaCommentParserFactory;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ITag;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.Collection;
import java.util.Enumeration;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class PersistentField
extends EJBElement
implements IPersistentField {
    private IField myField;
    private IMethod myGetter;
    private IMethod mySetter;
    private Boolean myIsInPK;
    private IJavaComment myJavaComment;
    private IField myFieldInPKClass;
    private EJBFieldRefactorer myCachedRefactorer;
    private static final String[] NO_PARAMETERS = ArrayUtils.EMPTY_STRING_ARRAY;
    static final String PRIM_KEY_FIELD_TAG = "@primKeyField";
    static final String JAVA_LANG_OBJECT = (class$java$lang$Object == null ? (class$java$lang$Object = PersistentField.class$("java.lang.Object")) : class$java$lang$Object).getName();
    static final String OBJECT = Signature.getSimpleName((String)JAVA_LANG_OBJECT);
    static /* synthetic */ Class class$java$lang$Object;

    protected PersistentField(EntityBean parent, String name) {
        super(parent);
        this.myField = parent.getBeanClass().getField(name);
        this.mySetter = null;
        this.myGetter = null;
    }

    public PersistentField(EntityBean parent, IMethod accessor) {
        super(parent);
        Assert.isLegal((boolean)accessor.exists());
        IType beanClass = parent.getBeanClass();
        String fieldName = JDTUtils.getFieldNameByAccessor((IMethod)accessor);
        this.myField = beanClass.getField(fieldName);
        if (JDTUtils.isSetter((IMethod)accessor)) {
            this.mySetter = accessor;
            this.myGetter = beanClass.getMethod(JDTUtils.getGetterName((IField)this.myField), NO_PARAMETERS);
        } else if (JDTUtils.isGetter((IMethod)accessor)) {
            this.myGetter = accessor;
            try {
                String fieldType = accessor.getReturnType();
                this.mySetter = beanClass.getMethod(JDTUtils.getSetterName((IField)this.myField), new String[]{fieldType});
            }
            catch (JavaModelException e) {
                Assert.isTrue((boolean)false);
            }
        } else {
            Assert.isLegal((boolean)false);
        }
        this.myFieldInPKClass = this.findFieldInPK(fieldName);
    }

    void removed() {
        if (this.exists((IMember)this.myFieldInPKClass)) {
            this.internalGetEJBProject().runCommandLater((Runnable)new UndoTransparableCommand(){

                public void run() {
                    PersistentField.this.getEJB().enterWorkingCopyMode();
                    try {
                        try {
                            PersistentField.this.deleteMember((IMember)PersistentField.this.getFieldInPKClass(), (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (JavaModelException e) {
                            EJBImplPlugin.logWarning("Could not delete field declared in the primary key class");
                        }
                        PersistentField.this.getEJB().regeneratePK();
                        Object var3_2 = null;
                        PersistentField.this.getEJB().exitWorkingCopyMode();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        PersistentField.this.getEJB().exitWorkingCopyMode();
                        throw throwable;
                    }
                }
            });
        }
    }

    private IField findFieldInPK(String fieldName) {
        IType pkClass = this.getPKClass();
        return pkClass == null ? null : pkClass.getField(fieldName);
    }

    private IType getPKClass() {
        EntityBean parent = this.getEJB();
        try {
            IType pkClass = parent.getParticipant(32);
            if (pkClass != null && pkClass.exists()) {
                return pkClass;
            }
            return null;
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    public boolean isInPrimaryKey() {
        if (this.myIsInPK == null) {
            this.myIsInPK = new Boolean(this.internalIsInPK());
        }
        return this.myIsInPK;
    }

    private boolean internalIsInPK() {
        if (this.getEJB().isSimplePK()) {
            IJavaComment comment = this.getJavaComment();
            if (comment == null) {
                return false;
            }
            return comment.hasTags(PRIM_KEY_FIELD_TAG);
        }
        return this.exists((IMember)this.getFieldInPKClass());
    }

    public boolean canSetInPrimaryKey(boolean inPrimaryKey) {
        if (inPrimaryKey == this.isInPrimaryKey()) {
            return true;
        }
        if (this.getEJB().isSimplePK()) {
            IJavaComment comment = this.getJavaComment();
            if (comment == null) {
                return false;
            }
            if (inPrimaryKey) {
                Collection persistentFields = this.getEJB().getPKFields();
                if (persistentFields.size() != 0) {
                    return false;
                }
                if (!this.canBecomePrimKeyField()) {
                    return false;
                }
            }
        }
        return true;
    }

    public void setInPrimaryKey(boolean inPrimaryKey) throws EJBModelException {
        this.setInPrimaryKey(inPrimaryKey, true);
    }

    public void setInPrimaryKey(boolean inPrimaryKey, boolean updatePKClass) throws EJBModelException {
        if (inPrimaryKey == this.isInPrimaryKey()) {
            return;
        }
        if (this.getEJB().isSimplePK()) {
            IJavaComment comment = this.getJavaComment();
            if (comment == null) {
                return;
            }
            if (inPrimaryKey) {
                Collection persistentFields = this.getEJB().getPKFields();
                if (persistentFields.size() != 0) {
                    return;
                }
                if (!this.validateEdit(this.getDefiningMember())) {
                    return;
                }
                this.getEJB().enterWorkingCopyMode();
                try {
                    comment = this.getJavaComment();
                    comment.addTag(PRIM_KEY_FIELD_TAG, "");
                    comment.synchronize(true);
                    this.myIsInPK = null;
                    this.internalGetEJBProject().getDelta().changed(this);
                    if (updatePKClass) {
                        this.getEJB().replacePrimaryKeyParticipant(this.getType(), false, this.getName(), true);
                    }
                    Object var6_9 = null;
                    this.getEJB().exitWorkingCopyMode();
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    this.getEJB().exitWorkingCopyMode();
                    throw throwable;
                }
            } else {
                if (!this.validateEdit(this.getDefiningMember())) {
                    return;
                }
                this.getEJB().enterWorkingCopyMode();
                try {
                    comment = this.getJavaComment();
                    Enumeration enumeration = comment.getTags(PRIM_KEY_FIELD_TAG);
                    while (enumeration.hasMoreElements()) {
                        ((ITag)enumeration.nextElement()).setValue(null);
                    }
                    comment.synchronize(true);
                    this.myIsInPK = null;
                    this.internalGetEJBProject().getDelta().changed(this);
                    if (updatePKClass) {
                        this.getEJB().replacePrimaryKeyParticipant((class$java$lang$Object == null ? (class$java$lang$Object = PersistentField.class$("java.lang.Object")) : class$java$lang$Object).getName(), false, null, true);
                    }
                    Object var8_12 = null;
                    this.getEJB().exitWorkingCopyMode();
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    this.getEJB().exitWorkingCopyMode();
                    throw throwable;
                }
            }
        } else {
            if (!this.validateEdit((IMember)this.getPKClass())) {
                return;
            }
            if (inPrimaryKey) {
                Assert.isTrue((!this.exists((IMember)this.getFieldInPKClass()) ? 1 : 0) != 0);
                try {
                    this.getEJB().enterWorkingCopyMode();
                    try {
                        IType pk = this.getPKClass();
                        if (pk != null) {
                            EjbTemplatesSupport.createPKField(pk, this.getName(), this.getType(), null);
                            this.getEJB().regeneratePK();
                        }
                        Object var10_15 = null;
                        this.myIsInPK = null;
                        this.internalGetEJBProject().getDelta().changed(this);
                        this.getEJB().exitWorkingCopyMode();
                    }
                    catch (Throwable throwable) {
                        Object var10_16 = null;
                        this.myIsInPK = null;
                        this.internalGetEJBProject().getDelta().changed(this);
                        this.getEJB().exitWorkingCopyMode();
                        throw throwable;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                IField fieldInPK = this.getFieldInPKClass();
                Assert.isTrue((boolean)this.exists((IMember)fieldInPK));
                try {
                    this.getEJB().enterWorkingCopyMode();
                    try {
                        fieldInPK = this.getFieldInPKClass();
                        fieldInPK.delete(true, null);
                        this.getEJB().regeneratePK();
                        Object var12_18 = null;
                        this.myIsInPK = null;
                        this.internalGetEJBProject().getDelta().changed(this);
                        this.getEJB().exitWorkingCopyMode();
                    }
                    catch (Throwable throwable) {
                        Object var12_19 = null;
                        this.myIsInPK = null;
                        this.internalGetEJBProject().getDelta().changed(this);
                        this.getEJB().exitWorkingCopyMode();
                        throw throwable;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean canBecomePrimKeyField() {
        String type = this.getType();
        return this.getEJB().isLegalTypeForSimplePKField(type);
    }

    public IField getField() {
        if (this.exists((IMember)this.myField)) {
            return (IField)this.translateIfWorkingCopyMode((IMember)this.myField);
        }
        return null;
    }

    public IMethod getGetter() {
        return (IMethod)this.translateIfWorkingCopyMode((IMember)this.myGetter);
    }

    public IMethod getSetter() {
        return (IMethod)this.translateIfWorkingCopyMode((IMember)this.mySetter);
    }

    public BusinessMethod getGetterBM() {
        IMethod getter = this.getGetter();
        return (BusinessMethod)this.getEJB().getEJBMethodByIMethod(getter);
    }

    public BusinessMethod getSetterBM() {
        IMethod setter = this.getSetter();
        return (BusinessMethod)this.getEJB().getEJBMethodByIMethod(setter);
    }

    public IField getFieldInPKClass() {
        if (this.exists((IMember)this.myFieldInPKClass)) {
            return (IField)this.translateIfWorkingCopyMode((IMember)this.myFieldInPKClass);
        }
        return null;
    }

    public void createGetter(IProgressMonitor monitor) throws EJBModelException {
        this.primCreateGetter(monitor);
        if (EJBImplPlugin.isPromotingAccessors()) {
            this.promoteAccessor(16, this.getGetterBM());
            this.promoteAccessor(4, this.getGetterBM());
        }
    }

    protected void primCreateGetter(IProgressMonitor monitor) throws EJBModelException {
        if (this.exists((IMember)this.myGetter)) {
            return;
        }
        IType beanClass = this.getEJB().getBeanClass();
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        validator.addJavaElement((IMember)beanClass);
        if (!validator.canModify()) {
            throw this.getEJB().cannotModify();
        }
        if (this.getEJB().isCMP()) {
            try {
                EjbTemplatesSupport.createCMPFieldGetter(beanClass, this.getName(), this.getType(), monitor);
            }
            catch (CoreException e) {
                throw new EJBModelException("Exception occurred while creating accessor", (Throwable)e);
            }
        }
        try {
            EjbTemplatesSupport.createBMPFieldGetter(beanClass, this.getName(), this.getType(), monitor);
        }
        catch (CoreException e) {
            throw new EJBModelException("Exception occurred while creating accessor", (Throwable)e);
        }
    }

    public void createSetter(IProgressMonitor monitor) throws EJBModelException {
        this.primCreateSetter(monitor);
        if (EJBImplPlugin.isPromotingAccessors()) {
            this.promoteAccessor(16, this.getSetterBM());
            this.promoteAccessor(4, this.getSetterBM());
        }
    }

    protected void primCreateSetter(IProgressMonitor monitor) throws EJBModelException {
        if (this.exists((IMember)this.mySetter)) {
            return;
        }
        IType beanClass = this.getEJB().getBeanClass();
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        validator.addJavaElement((IMember)beanClass);
        if (!validator.canModify()) {
            throw this.getEJB().cannotModify();
        }
        if (this.getEJB().isCMP()) {
            try {
                EjbTemplatesSupport.createCMPFieldSetter(beanClass, this.getName(), this.getType(), monitor);
            }
            catch (CoreException e) {
                throw new EJBModelException("Exception occurred while creating accessor", (Throwable)e);
            }
        }
        try {
            EjbTemplatesSupport.createBMPFieldSetter(beanClass, this.getName(), this.getType(), monitor);
        }
        catch (CoreException e) {
            throw new EJBModelException("Exception occurred while creating accessor", (Throwable)e);
        }
    }

    protected IMember translateIfWorkingCopyMode(IMember member) {
        return this.getEJB().translateIfWorkingCopyMode(member);
    }

    public void delete(IProgressMonitor monitor) throws EJBModelException {
        BusinessMethod getterBM;
        this.assertExists();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        Throwable exception = null;
        monitor.beginTask("Deleting field", 4);
        ReadOnlinessValidator validator = this.getValidatorOnDelete();
        if (this.exists((IMember)this.getFieldInPKClass())) {
            validator.addJavaElement((IMember)this.getFieldInPKClass());
        }
        if (this.exists((IMember)this.getField())) {
            validator.addJavaElement((IMember)this.getField());
        }
        if ((getterBM = this.getGetterBM()) != null && getterBM.exists()) {
            validator.addJavaElements((IMember[])getterBM.getMethods());
        } else {
            getterBM = null;
        }
        BusinessMethod setterBM = this.getSetterBM();
        if (setterBM != null && setterBM.exists()) {
            validator.addJavaElements((IMember[])setterBM.getMethods());
        } else {
            setterBM = null;
        }
        if (!validator.canModify()) {
            throw new EJBModelException("Could not modify read-only or binary files");
        }
        boolean wasPKField = this.isInPrimaryKey() && this.getEJB().isSimplePK();
        this.getEJB().enterWorkingCopyMode();
        try {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            try {
                                IField fieldInPK = this.getFieldInPKClass();
                                if (this.exists((IMember)fieldInPK)) {
                                    this.deleteMember((IMember)fieldInPK, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    if (!this.getEJB().isSimplePK()) {
                                        this.getEJB().regeneratePK();
                                    }
                                }
                            }
                            catch (JavaModelException e) {
                                if (exception != null) break block26;
                                exception = e;
                            }
                        }
                        try {
                            this.deleteMember((IMember)this.getField(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        catch (JavaModelException e) {
                            if (exception != null) break block27;
                            exception = e;
                        }
                    }
                    try {
                        if (getterBM != null) {
                            getterBM.delete((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            monitor.worked(1);
                        }
                    }
                    catch (EJBModelException e) {
                        if (exception != null) break block28;
                        exception = e;
                    }
                }
                try {
                    if (setterBM != null) {
                        setterBM.delete((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        monitor.worked(1);
                    }
                }
                catch (EJBModelException e) {
                    if (exception != null) break block29;
                    exception = e;
                }
            }
            if (exception != null) {
                throw new EJBModelException(this.newStatus(4, "There were exceptions while deleting field", (Exception)exception));
            }
            if (wasPKField) {
                this.getEJB().replacePrimaryKeyParticipant((class$java$lang$Object == null ? (class$java$lang$Object = PersistentField.class$("java.lang.Object")) : class$java$lang$Object).getName(), false, null, true);
            }
            Object var9_12 = null;
            this.getEJB().exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.getEJB().exitWorkingCopyMode();
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private void deleteMember(IMember member, IProgressMonitor monitor) throws JavaModelException {
        if (member == null || !member.exists()) {
            monitor.done();
            return;
        }
        member.delete(true, monitor);
    }

    public boolean exists() {
        return this.exists((IMember)this.getField()) || this.exists((IMember)this.getGetter()) || this.exists((IMember)this.getSetter());
    }

    private boolean exists(IMember member) {
        return member != null && member.exists();
    }

    public IStatus validate() throws EJBModelException {
        super.validate();
        if ("primaryKey".equals(this.getName())) {
            throw new EJBModelException("Persistent fields may not be called primaryKey");
        }
        try {
            int flags;
            IField field = this.getField();
            if (field != null && field.exists() && Flags.isTransient((int)(flags = field.getFlags()))) {
                throw new EJBModelException(this.newStatus(4, "Transient fields may not be persistent"));
            }
            if (this.getEJB().isCMP() && this.onlyFieldExists()) {
                throw new EJBModelException("CMP fields should have at least one accessor, not only field");
            }
        }
        catch (JavaModelException e) {
            throw new EJBModelException(this.newStatus(4, "Exception occurred while accessing Java information", (Exception)((Object)e)));
        }
        MultiStatus result = new MultiStatus(EJBImplPlugin.getPluginId(), 0, "Validation of persistent field", null);
        result.add(this.validateFieldType());
        return result;
    }

    private boolean onlyFieldExists() {
        IMethod getter = this.getGetter();
        if (getter != null && getter.exists()) {
            return false;
        }
        IMethod setter = this.getSetter();
        return setter == null || !setter.exists();
    }

    private IStatus validateFieldType() throws EJBModelException {
        String pkFieldType;
        String fieldType = JDTUtils.getFQN((IType)this.getEJB().getBeanClass(), (String)this.getFieldType());
        String getterType = JDTUtils.getFQN((IType)this.getEJB().getBeanClass(), (String)this.getGetterType());
        String setterType = JDTUtils.getFQN((IType)this.getEJB().getBeanClass(), (String)this.getSetterType());
        String overallType = this.getType();
        if (overallType == null) {
            throw new EJBModelException(this.newStatus(4, "No type for persistent field"));
        }
        if (fieldType != null && !overallType.equals(fieldType) || getterType != null && !overallType.equals(getterType) || setterType != null && !overallType.equals(setterType)) {
            return this.newStatus(4, "Type check for persistent field");
        }
        if (this.getFieldInPKClass() != null && this.getFieldInPKClass().exists() && (pkFieldType = this.getPKFieldType()) != null && !overallType.equals(pkFieldType)) {
            return this.newStatus(4, "Type declared in PK differs from the field type");
        }
        return this.newStatus(0, "Type check for persistent field");
    }

    boolean merge(PersistentField newState) {
        this.flushJavaComment();
        boolean result = false;
        if (!PersistentField.eq(this.myField, newState.myField)) {
            result = true;
            this.myField = newState.myField;
        }
        if (!PersistentField.eq(this.myGetter, newState.myGetter)) {
            result = true;
            this.myGetter = newState.myGetter;
        }
        if (!PersistentField.eq(this.mySetter, newState.mySetter)) {
            result = true;
            this.mySetter = newState.mySetter;
        }
        if (!PersistentField.eq(this.myFieldInPKClass, newState.myFieldInPKClass)) {
            result = true;
            this.myFieldInPKClass = newState.myFieldInPKClass;
        }
        if (this.myIsInPK != null && this.myIsInPK.booleanValue() != newState.isInPrimaryKey()) {
            result = true;
            this.myIsInPK = new Boolean(newState.isInPrimaryKey());
            if (((EntityBean)this.getParent()).isSimplePK()) {
                ((EntityBean)this.getParent()).fieldPKStatusChanged(this);
            }
            this.internalGetEJBProject().getSynchronizeTarget().fieldPKStatusChanged((IPersistentField)this);
        }
        return result;
    }

    private static boolean eq(Object one, Object another) {
        if (one == null) {
            return another == null;
        }
        return one.equals(another);
    }

    public String getName() {
        return this.myField.getElementName();
    }

    public IPersistentField setName(String newName, IProgressMonitor monitor) throws EJBModelException {
        EJBFieldRefactorer refactorer;
        this.assertExists();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!(refactorer = this.getRefactorer(newName, true)).canPerform()) {
            this.myCachedRefactorer = null;
            return this;
        }
        try {
            try {
                refactorer.perform(monitor);
                PersistentField persistentField = refactorer.getRenamedElement();
                Object var6_6 = null;
                this.myCachedRefactorer = null;
                return persistentField;
            }
            catch (CoreException e) {
                throw new EJBModelException("Exception occurred while setting name", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.myCachedRefactorer = null;
            throw throwable;
        }
    }

    public PersistentField createReadOnlyImage(String name) {
        return new PersistentField(this.getEJB(), name);
    }

    protected EntityBean getEJB() {
        return (EntityBean)this.getParent();
    }

    public String getType() {
        String returnType = this.getFieldType();
        if (returnType == null) {
            returnType = this.getGetterType();
        }
        if (returnType == null) {
            returnType = this.getSetterType();
        }
        return JDTUtils.getFQN((IType)this.getEJB().getBeanClass(), (String)returnType);
    }

    private String getFieldType() {
        if (this.getField() != null && this.getField().exists()) {
            try {
                return Signature.toString((String)this.getField().getTypeSignature());
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getPKFieldType() {
        if (this.getFieldInPKClass() != null && this.getFieldInPKClass().exists()) {
            try {
                return Signature.toString((String)this.getFieldInPKClass().getTypeSignature());
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getGetterType() {
        if (this.getGetter() != null && this.getGetter().exists()) {
            return JDTUtils.getGetterType((IMethod)this.getGetter());
        }
        return null;
    }

    private String getSetterType() {
        if (this.getSetter() != null && this.getSetter().exists()) {
            return JDTUtils.getSetterType((IMethod)this.getSetter());
        }
        return null;
    }

    public boolean canSetType(String type) {
        if (type == null || type.length() == 0 || "void".equals(type)) {
            return false;
        }
        if (this.isInPrimaryKey() && this.getEJB().isSimplePK()) {
            type = JDTUtils.getFQN((IType)this.getEJB().getBeanClass(), (String)type);
            return this.getEJB().isLegalTypeForSimplePKField(type);
        }
        return true;
    }

    public void setType(String type, IProgressMonitor monitor) throws EJBModelException {
        if (!this.canSetType(type)) {
            throw new EJBModelException("Can't set this type");
        }
        String actualType = this.getType();
        if (type.equals(actualType) || JDTUtils.getFQN((IType)this.getEJB().getBeanClass(), (String)type).equals(actualType)) {
            return;
        }
        IType beanClass = this.getEJB().getBeanClass();
        type = JDTUtils.getFQN((IType)beanClass, (String)type);
        if (this.isInPrimaryKey() && this.getEJB().isSimplePK() && JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)type) == null) {
            throw new EJBModelException("Can't set this type");
        }
        this.unsafeSetType(type, monitor);
    }

    protected void unsafeSetType(String type, IProgressMonitor monitor) throws EJBModelException {
        EntityBean parent;
        boolean inPK = this.isInPrimaryKey();
        boolean ejbIsSimplePK = this.getEJB().isSimplePK();
        boolean pkNeedsRegeneration = false;
        if (inPK && !ejbIsSimplePK) {
            try {
                pkNeedsRegeneration = EntityBean.pkNeedsRegeneration(this.getType(), type);
            }
            catch (JavaModelException e) {
                throw new EJBModelException("Could not determine whether pk regeneration is needed", (Throwable)e);
            }
        }
        BusinessMethod setterBM = this.getSetterBM();
        BusinessMethod getterBM = this.getGetterBM();
        IField field = this.getField();
        IField fieldInPK = this.getFieldInPKClass();
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        if (setterBM != null) {
            validator.addJavaElements((IMember[])setterBM.getMethods());
            Method[] deployedMethods = AssembledInfoFinder.findAssembledMethods((IEJBMethod)setterBM);
            if (deployedMethods != null) {
                int i = 0;
                while (i < deployedMethods.length) {
                    validator.addResource(deployedMethods[i].getDocument().getFile());
                    ++i;
                }
            }
        }
        if (getterBM != null) {
            validator.addJavaElements((IMember[])getterBM.getMethods());
        }
        if (field != null) {
            validator.addJavaElement((IMember)field);
        }
        if (fieldInPK != null) {
            validator.addJavaElement((IMember)fieldInPK);
        }
        if (this.isInPrimaryKey() && this.getEJB().isSimplePK()) {
            parent = this.getEJB();
            validator.addJavaElement((IMember)parent.getBeanClass());
            IEJBMethod[] methods = parent.getEJBMethods();
            int i = 0;
            while (i < methods.length) {
                IEJBMethod method = methods[i];
                if (method.getKind() == 2 || method.getKind() == 4) {
                    validator.addJavaElements((IMember[])method.getMethods());
                }
                ++i;
            }
        }
        if (!validator.canModify()) {
            throw new EJBModelException("Could not modify read-only files");
        }
        if (setterBM != null) {
            setterBM.setParameters(new String[]{type}, null, monitor);
        }
        if (getterBM != null) {
            getterBM.setReturnType(type, monitor);
        }
        try {
            if (this.getField() != null && this.getField().exists()) {
                this.setType(this.getField(), type, monitor);
            }
        }
        catch (JavaModelException e) {
            throw new EJBModelException(this.newStatus(4, "Exception occurred while accessing Java information", (Exception)((Object)e)));
        }
        try {
            if (this.getFieldInPKClass() != null && this.getFieldInPKClass().exists()) {
                this.setType(this.getFieldInPKClass(), type, monitor);
            }
        }
        catch (JavaModelException e) {
            throw new EJBModelException(this.newStatus(4, "Exception occurred while accessing Java information", (Exception)((Object)e)));
        }
        if (inPK) {
            if (ejbIsSimplePK) {
                parent = this.getEJB();
                String typeFQN = JDTUtils.getFQN((IType)parent.getBeanClass(), (String)type);
                parent.replacePrimaryKeyParticipant(typeFQN, false, this.getName(), true);
            } else if (pkNeedsRegeneration) {
                this.getEJB().regeneratePK();
            }
        }
    }

    private void setType(IField field, String typeFQN, IProgressMonitor monitor) throws JavaModelException {
        if (JDTUtils.addImport((IType)field.getDeclaringType(), (String)typeFQN)) {
            typeFQN = Signature.getSimpleName((String)typeFQN);
        }
        JDomSupport.executeOperation((JDomSupport.Operation)PersistentField.getRetypifyOperation(typeFQN), (IMember)field, (IProgressMonitor)monitor);
    }

    private void flushJavaComment() {
        this.myJavaComment = null;
    }

    private IJavaComment getJavaComment() {
        if (this.myJavaComment != null && !this.isInSyncWithWCMode(this.myJavaComment)) {
            this.myJavaComment = null;
        }
        if (this.myJavaComment == null) {
            this.myJavaComment = JavaCommentParserFactory.getJavaComment((IMember)this.getDefiningMember());
        }
        return this.myJavaComment;
    }

    private boolean isInSyncWithWCMode(IJavaComment myJavaComment) {
        ICompilationUnit javaCommentCU = ((IMemberHolder)myJavaComment.getSynchronizer()).getMember().getCompilationUnit();
        if (javaCommentCU == null) {
            return false;
        }
        return this.getEJB().isWorkingCopyMode() == javaCommentCU.isWorkingCopy();
    }

    private IMember getDefiningMember() {
        IField result = this.getField();
        if (result != null && result.exists()) {
            return result;
        }
        result = this.getGetter();
        if (result != null && result.exists()) {
            return result;
        }
        result = this.getSetter();
        if (result != null && result.exists()) {
            return result;
        }
        return null;
    }

    private static JDomSupport.Operation getRetypifyOperation(final String type) {
        return new JDomSupport.Operation(){

            public boolean execute(IMember field, IDOMNode domNode) {
                if (!(domNode instanceof IDOMField)) {
                    throw new RuntimeException("Found jdom node does not correspond to a field");
                }
                ((IDOMField)domNode).setType(type);
                return true;
            }
        };
    }

    private static JDomSupport.Operation getRenameAndRetypifyOperation(final String name, final String type) {
        return new JDomSupport.Operation(){

            public boolean execute(IMember field, IDOMNode domNode) {
                if (!(domNode instanceof IDOMField)) {
                    throw new RuntimeException("Found jdom node does not correspond to a field");
                }
                IDOMField domField = (IDOMField)domNode;
                domField.setType(type);
                domField.setName(name);
                return true;
            }
        };
    }

    public boolean canSetSignature(String name, String type) {
        if (!this.canSetType(type)) {
            return false;
        }
        if (name == null) {
            return false;
        }
        if (this.getName().equals(name)) {
            return true;
        }
        return this.canSetName(name);
    }

    public boolean canSetName(String name) {
        if (name == null || name.length() == 0 || "primaryKey".equals(name)) {
            return false;
        }
        try {
            if (this.getEJB().getField(name) != null) {
                return false;
            }
        }
        catch (EJBModelException e) {
            return false;
        }
        EJBFieldRefactorer refactorer = this.getRefactorer(name);
        if (refactorer.canPerformNaive()) {
            return true;
        }
        this.myCachedRefactorer = null;
        return false;
    }

    private EJBFieldRefactorer getRefactorer(String name, boolean assertName) {
        if (this.myCachedRefactorer == null || assertName && !name.equals(this.myCachedRefactorer.getNewName())) {
            this.myCachedRefactorer = new EJBFieldRefactorer(this, name);
        }
        return this.myCachedRefactorer;
    }

    private EJBFieldRefactorer getRefactorer(String name) {
        return this.getRefactorer(name, false);
    }

    public IPersistentField setSignature(String name, String type, IProgressMonitor monitor) throws EJBModelException {
        BusinessMethod getterBM;
        IProgressMonitor m = monitor == null ? new NullProgressMonitor() : monitor;
        m.beginTask("Setting signature", 4);
        PersistentField result = null;
        MultiStatus status = new MultiStatus("com.tssap.j2ee.internal.core.ejb", 0, "Setting signature", null);
        String typeFQN = JDTUtils.getFQN((IType)this.getEJB().getBeanClass(), (String)type);
        String oldName = this.getName();
        ReadOnlinessValidator validator = this.getValidatorOnDelete();
        if (this.exists((IMember)this.getFieldInPKClass())) {
            validator.addJavaElement((IMember)this.getFieldInPKClass());
        }
        if (this.exists((IMember)this.getField())) {
            validator.addJavaElement((IMember)this.getField());
        }
        if ((getterBM = this.getGetterBM()) != null && getterBM.exists()) {
            validator.addJavaElements((IMember[])getterBM.getMethods());
        } else {
            getterBM = null;
        }
        BusinessMethod setterBM = this.getSetterBM();
        if (setterBM != null && setterBM.exists()) {
            validator.addJavaElements((IMember[])setterBM.getMethods());
        } else {
            setterBM = null;
        }
        if (this.isInPrimaryKey() && this.getEJB().isSimplePK()) {
            EntityBean parent = this.getEJB();
            validator.addJavaElement((IMember)parent.getBeanClass());
            IEJBMethod[] methods = parent.getEJBMethods();
            int i = 0;
            while (i < methods.length) {
                IEJBMethod method = methods[i];
                if (method.getKind() == 2 || method.getKind() == 4) {
                    validator.addJavaElements((IMember[])method.getMethods());
                }
                ++i;
            }
        }
        if (!validator.canModify()) {
            throw new EJBModelException("Could not modify read-only or binary files");
        }
        boolean inPK = this.isInPrimaryKey();
        boolean ejbIsSimplePK = this.getEJB().isSimplePK();
        boolean pkNeedsRegeneration = false;
        if (inPK && !ejbIsSimplePK) {
            try {
                pkNeedsRegeneration = EntityBean.pkNeedsRegeneration(this.getType(), type);
            }
            catch (JavaModelException e) {
                throw new EJBModelException("Could not determine whether pk regeneration is needed", (Throwable)e);
            }
        }
        this.getEJB().enterWorkingCopyMode();
        try {
            IField field = this.getField();
            try {
                this.setSignature(field, name, typeFQN, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (JavaModelException e) {
                status.add(e.getStatus());
            }
            if (status.isOK()) {
                IField fieldInPK = this.getFieldInPKClass();
                try {
                    this.setSignature(fieldInPK, name, typeFQN, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (JavaModelException e) {
                    status.add(e.getStatus());
                }
            }
            if (status.isOK() && getterBM != null) {
                try {
                    getterBM.setSignature(JDTUtils.getGetterName((String)name), ArrayUtils.EMPTY_STRING_ARRAY, ArrayUtils.EMPTY_STRING_ARRAY, typeFQN, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (EJBModelException e) {
                    status.add(e.getStatus());
                }
            }
            if (status.isOK() && setterBM != null) {
                String setterParamName;
                try {
                    setterParamName = setterBM.getParameterNames()[0];
                }
                catch (Exception e) {
                    setterParamName = "arg0";
                }
                try {
                    setterBM.setSignature(JDTUtils.getSetterName((String)name), new String[]{typeFQN}, new String[]{setterParamName}, "void", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (EJBModelException e) {
                    status.add(e.getStatus());
                }
            }
            if (status.isOK() && !oldName.equals(name)) {
                result = this.createReadOnlyImage(name);
                this.internalGetEJBProject().getDelta().renamed(this, result);
            }
            Object var19_26 = null;
            this.getEJB().exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var19_27 = null;
            this.getEJB().exitWorkingCopyMode();
            throw throwable;
        }
        if (!status.isOK()) {
            throw new EJBModelException((IStatus)status);
        }
        if (inPK) {
            if (ejbIsSimplePK) {
                EntityBean parent = this.getEJB();
                parent.replacePrimaryKeyParticipant(typeFQN, false, name, true);
            } else if (pkNeedsRegeneration) {
                this.getEJB().regeneratePK();
            }
        }
        return result;
    }

    private void setSignature(IField field, String name, String type, IProgressMonitor monitor) throws JavaModelException {
        try {
            block6: {
                if (field == null) break block6;
                if (field.exists()) break block7;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        {
            block7: {
                return;
            }
            if (JDTUtils.addImport((IType)field.getDeclaringType(), (String)type)) {
                type = Signature.getSimpleName((String)type);
            }
            JDomSupport.executeOperation((JDomSupport.Operation)PersistentField.getRenameAndRetypifyOperation(name, type), (IMember)field, (IProgressMonitor)monitor);
        }
        Object var6_6 = null;
        monitor.done();
    }

    public boolean isRelationship() {
        return false;
    }

    protected String getDdpKey() {
        return "PersistentField";
    }

    protected Object getDdpSource() {
        try {
            if (this.getEJB().isCMP()) {
                return this.getGetter();
            }
            return this.getField();
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    public String getHandleIdentifier() {
        return this.getEJB().getHandleIdentifier() + '\u0000' + this.getName();
    }

    private boolean validateEdit(IMember[] members) {
        return new ReadOnlinessValidator(members).canModify();
    }

    private boolean validateEdit(IMember member) {
        return this.validateEdit(new IMember[]{member});
    }

    protected ReadOnlinessValidator getValidatorOnDelete() {
        return this.getEJB().getValidatorForDDOnCMPFieldsOrQueriesChange();
    }

    public ICopiedEJBElement cut() throws EJBModelException {
        ReadOnlinessValidator validator = this.getValidatorOnDelete();
        if (!validator.canModify()) {
            throw new EJBModelException("Could not modify read-only files");
        }
        CopiedPersistentField result = new CopiedPersistentField(this, true);
        this.delete(null);
        return result;
    }

    public ICopiedEJBElement copy() throws EJBModelException {
        return new CopiedPersistentField(this, false);
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        if (this.exists((IMember)this.getField()) && this.getField().isBinary()) {
            return false;
        }
        if (this.exists((IMember)this.getFieldInPKClass()) && this.getFieldInPKClass().isBinary()) {
            return false;
        }
        BusinessMethod getterBM = this.getGetterBM();
        if (getterBM != null && !getterBM.internalCanCut()) {
            return false;
        }
        BusinessMethod setterBM = this.getSetterBM();
        return setterBM == null || setterBM.internalCanCut();
    }

    public void promoteAccessors(int role) throws EJBModelException {
        this.promoteAccessor(role, this.getGetterBM());
        this.promoteAccessor(role, this.getSetterBM());
    }

    void promoteAccessor(int role, BusinessMethod accessor) throws EJBModelException {
        if (accessor != null && this.getEJB().getParticipant(role) != null && accessor.canPromote(role)) {
            accessor.promote(role);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

