/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.internal.core.ejb.AccessibleBean;
import com.tssap.j2ee.internal.core.ejb.EjbProjectImpl;
import java.util.HashMap;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class NamingConvention {
    private EjbProjectImpl myProject;
    private static final String[] BEAN_CLASS_SUFFIXES = new String[]{"EJB", "Bean", "Impl"};
    private static final HashMap COMPONENT_SUFFIXES = new HashMap();

    public NamingConvention(EjbProjectImpl project) {
        this.myProject = project;
    }

    public IType findParticipant(AccessibleBean bean, int role) {
        IType beanClass = bean.getBeanClass();
        String beanName = beanClass.getElementName();
        String conventionalName = this.getConventionalParticipantName(beanName, role);
        if (conventionalName == null) {
            return null;
        }
        return this.findType(beanClass.getPackageFragment(), conventionalName);
    }

    public String getConventionalParticipantName(String beanName, int role) {
        if (role == 1) {
            return this.getConventionalBeanClassName(beanName);
        }
        int i = 0;
        while (i < BEAN_CLASS_SUFFIXES.length) {
            String suffix = BEAN_CLASS_SUFFIXES[i];
            if (beanName.endsWith(suffix)) {
                beanName = beanName.substring(0, beanName.length() - suffix.length());
                String participantSuffix = (String)COMPONENT_SUFFIXES.get(new Integer(role));
                if (participantSuffix == null) {
                    return null;
                }
                return beanName + participantSuffix;
            }
            ++i;
        }
        return null;
    }

    private IType findType(IPackageFragment packageFragment, String typeName) {
        if (((IPackageFragmentRoot)packageFragment.getParent()).isArchive()) {
            try {
                return packageFragment.getClassFile(typeName + ".class").getType();
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        return packageFragment.getCompilationUnit(typeName + ".java").getType(typeName);
    }

    public String getConventionalBeanClassName(String beanName) {
        int i = 0;
        while (i < BEAN_CLASS_SUFFIXES.length) {
            String suffix = BEAN_CLASS_SUFFIXES[i];
            if (beanName.endsWith(suffix)) {
                return beanName;
            }
            ++i;
        }
        return beanName + BEAN_CLASS_SUFFIXES[1];
    }

    static {
        COMPONENT_SUFFIXES.put(new Integer(2), "Home");
        COMPONENT_SUFFIXES.put(new Integer(4), "");
        COMPONENT_SUFFIXES.put(new Integer(8), "LocalHome");
        COMPONENT_SUFFIXES.put(new Integer(16), "Local");
        COMPONENT_SUFFIXES.put(new Integer(32), "PK");
    }
}

