/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EjbMetaInfo;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.internal.core.ejb.AbstractEjbMethodCollector;
import com.tssap.j2ee.internal.core.ejb.EJBDelta;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.MessageDrivenBean;
import com.tssap.j2ee.internal.core.ejb.MessageDrivenEjbCreateMethod;
import com.tssap.j2ee.internal.core.ejb.MethodSig;
import com.tssap.j2ee.internal.core.ejb.OnMessageBusinessMethod;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import java.util.HashMap;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class MDBMethodCollector
extends AbstractEjbMethodCollector {
    private IMethod myOnMessage;
    private IMethod myCreate;
    private OnMessageBusinessMethod myOnMessageEJBMethod;
    private MessageDrivenEjbCreateMethod myCreateEJBMethod;
    private boolean myInitialized;
    private static final String ON_MESSAGE_NAME = "onMessage";
    private static final String ON_MESSAGE_PARAM_SIMPLE_TYPE = "Message";
    private static final String ON_MESSAGE_PARAM_PACKAGE = "javax.jms";
    public static final String ON_MESSAGE_PARAM_TYPE = "javax.jms.Message";
    private static final String[] ON_MESSAGE_PARAMS = new String[]{"javax.jms.Message"};
    public static final String[] ON_MESSAGE_SIMPLE_PARAMS = new String[]{"Message"};
    private static final String EJB_CREATE_NAME = EjbMetaInfo.getCreateMethodImplName((String)"");
    private static final MethodSig ON_MESSAGE_SIG = AbstractEjbMethodCollector.createSignature("onMessage", ON_MESSAGE_PARAMS);
    private static final MethodSig EJB_CREATE_SIG = AbstractEjbMethodCollector.createSignature(EJB_CREATE_NAME, ArrayUtils.EMPTY_STRING_ARRAY);

    public MDBMethodCollector(MessageDrivenBean bean) {
        super(bean);
        this.getMethods();
    }

    protected void collectMethods(HashMap result) {
        if (!this.myInitialized) {
            this.initialize();
        }
        if (this.myOnMessageEJBMethod != null) {
            result.put(ON_MESSAGE_SIG, this.myOnMessageEJBMethod);
        }
        if (this.myCreateEJBMethod != null) {
            result.put(EJB_CREATE_SIG, this.myCreateEJBMethod);
        }
    }

    public EJBMethod getMethod(String name, String[] paramTypeFQNs) {
        if (!this.myInitialized) {
            this.initialize();
        }
        if (ON_MESSAGE_NAME.equals(name) && paramTypeFQNs != null && paramTypeFQNs.length == 1 && ON_MESSAGE_PARAM_TYPE.equals(paramTypeFQNs[0])) {
            return this.myOnMessageEJBMethod;
        }
        if (EJB_CREATE_NAME.equals(name) && paramTypeFQNs != null && paramTypeFQNs.length == 0) {
            return this.myCreateEJBMethod;
        }
        return null;
    }

    protected void initialize() {
        IMethod[] methods;
        this.myInitialized = true;
        try {
            methods = this.getDeclaredMethods(this.getBean().getBeanClass());
        }
        catch (JavaModelException e) {
            return;
        }
        this.myOnMessage = this.findOnMessageMethod(methods);
        if (this.myOnMessage != null) {
            this.myOnMessageEJBMethod = new OnMessageBusinessMethod(this.getMDB(), this.myOnMessage, ON_MESSAGE_PARAMS);
        }
        this.myCreate = this.findEjbCreateMethod(methods);
        if (this.myCreate != null) {
            this.myCreateEJBMethod = new MessageDrivenEjbCreateMethod(this.getMDB(), this.myCreate, ArrayUtils.EMPTY_STRING_ARRAY);
        }
    }

    private IMethod findOnMessageMethod(IMethod[] methods) {
        int i = 0;
        while (i < methods.length) {
            String[] params;
            if (methods[i].getElementName().equals(ON_MESSAGE_NAME) && (params = methods[i].getParameterTypes()).length == 1) {
                String param = Signature.toString((String)params[0]);
                if (ON_MESSAGE_PARAM_TYPE.equals(param)) {
                    return methods[i];
                }
                if (ON_MESSAGE_PARAM_SIMPLE_TYPE.equals(param)) {
                    try {
                        String[][] possibleValues = methods[i].getDeclaringType().resolveType(param);
                        if (possibleValues != null && possibleValues.length == 1 && ON_MESSAGE_PARAM_PACKAGE.equals(possibleValues[0][0])) {
                            return methods[i];
                        }
                    }
                    catch (JavaModelException e) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private IMethod findEjbCreateMethod(IMethod[] methods) {
        int i = 0;
        while (i < methods.length) {
            String[] params;
            if (methods[i].getElementName().equals(EJB_CREATE_NAME) && (params = methods[i].getParameterTypes()).length == 0) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public OnMessageBusinessMethod getOnMessage() {
        return this.myOnMessageEJBMethod;
    }

    public MessageDrivenEjbCreateMethod getCreateMethod() {
        return this.myCreateEJBMethod;
    }

    public void refresh(EJBDelta delta) {
        IMethod[] methods;
        try {
            methods = this.getDeclaredMethods(this.getBean().getBeanClass());
        }
        catch (JavaModelException e) {
            methods = JDTUtils.NO_METHODS;
        }
        this.refreshOnMessage(delta, methods);
        this.refreshEjbCreate(delta, methods);
    }

    private void refreshOnMessage(EJBDelta delta, IMethod[] methods) {
        boolean haveOnMessageMethod;
        boolean oldHaveOnMessage = this.myOnMessage != null;
        IMethod oldOnMessage = this.myOnMessage;
        this.myOnMessage = this.findOnMessageMethod(methods);
        boolean bl = haveOnMessageMethod = this.myOnMessage != null;
        if (oldHaveOnMessage && !haveOnMessageMethod) {
            delta.removed(this.myOnMessageEJBMethod);
            this.removedMethod(this.myOnMessageEJBMethod);
            this.myOnMessageEJBMethod = null;
        } else if (!oldHaveOnMessage && haveOnMessageMethod) {
            this.myOnMessageEJBMethod = new OnMessageBusinessMethod(this.getMDB(), this.myOnMessage, ON_MESSAGE_PARAMS);
            delta.added(this.myOnMessageEJBMethod);
            this.addedMethod(this.myOnMessageEJBMethod);
        } else if (oldHaveOnMessage && haveOnMessageMethod && !oldOnMessage.getDeclaringType().equals(this.myOnMessage.getDeclaringType())) {
            this.myOnMessageEJBMethod = new OnMessageBusinessMethod(this.getMDB(), this.myOnMessage, ON_MESSAGE_PARAMS);
            delta.changed(this.myOnMessageEJBMethod);
            this.addedMethod(this.myOnMessageEJBMethod);
        }
    }

    private void refreshEjbCreate(EJBDelta delta, IMethod[] methods) {
        boolean haveEjbCreateMethod;
        boolean oldHaveEjbCreate = this.myCreate != null;
        IMethod oldEjbCreate = this.myCreate;
        this.myCreate = this.findEjbCreateMethod(methods);
        boolean bl = haveEjbCreateMethod = this.myCreate != null;
        if (oldHaveEjbCreate && !haveEjbCreateMethod) {
            delta.removed(this.myCreateEJBMethod);
            this.removedMethod(this.myCreateEJBMethod);
            this.myCreateEJBMethod = null;
        } else if (!oldHaveEjbCreate && haveEjbCreateMethod) {
            this.myCreateEJBMethod = new MessageDrivenEjbCreateMethod(this.getMDB(), this.myCreate, ArrayUtils.EMPTY_STRING_ARRAY);
            delta.added(this.myCreateEJBMethod);
            this.addedMethod(this.myCreateEJBMethod);
        } else if (oldHaveEjbCreate && haveEjbCreateMethod && !oldEjbCreate.getDeclaringType().equals(this.myCreate.getDeclaringType())) {
            this.myCreateEJBMethod = new MessageDrivenEjbCreateMethod(this.getMDB(), this.myCreate, ArrayUtils.EMPTY_STRING_ARRAY);
            delta.changed(this.myCreateEJBMethod);
            this.addedMethod(this.myCreateEJBMethod);
        }
    }

    private MessageDrivenBean getMDB() {
        return (MessageDrivenBean)this.getBean();
    }
}

