/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbMetaInfo;
import com.tssap.j2ee.core.ejb.IHomeMethod;
import com.tssap.j2ee.core.utils.signature.MethodSignature;
import com.tssap.j2ee.internal.core.ejb.AccessibleBean;
import com.tssap.j2ee.internal.core.ejb.BodyAndComment;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.EnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.EntityBean;
import com.tssap.j2ee.internal.core.ejb.FullNameUtil;
import com.tssap.j2ee.internal.core.ejb.MethodSig;
import com.tssap.j2ee.internal.core.ejb.util.EjbTemplatesSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

public class HomeMethod
extends EJBMethod
implements IHomeMethod {
    public HomeMethod(EntityBean parent, MethodSig signature) {
        super(parent, 8, signature.getName(), EjbMetaInfo.getHomeMethodImplUserName((String)signature.getName()), signature.getParameterTypeFQNs());
    }

    public IStatus validate() throws EJBModelException {
        return null;
    }

    public static String getHomeName(IMethod beanClassMethod) {
        if (HomeMethod.isValidBeanClassHomeMethod(beanClassMethod)) {
            return EjbMetaInfo.getHomeMethodImplUserName((String)beanClassMethod.getElementName());
        }
        return null;
    }

    public static String getBeanClassName(IMethod homeMethod) {
        String name = homeMethod.getElementName();
        if (EjbMetaInfo.isCreateMethodName((String)name) || EjbMetaInfo.isFindMethodName((String)name)) {
            return null;
        }
        MethodSignature sig = FullNameUtil.getSignature(homeMethod);
        if (sig == null) {
            return null;
        }
        if (EjbMetaInfo.isVetoedHomeMethodSignature((String)sig.toUnqualifiedFullName())) {
            return null;
        }
        return EjbMetaInfo.getHomeMethodImplName((String)name);
    }

    public static boolean isValidBeanClassHomeMethod(IMethod beanClassMethod) {
        return EjbMetaInfo.isHomeMethodImplName((String)beanClassMethod.getElementName());
    }

    public IMethod getHomeDeclaration() {
        return this.getMethod(2);
    }

    public IMethod getLocalHomeDeclaration() {
        return this.getMethod(8);
    }

    public IMethod getImplementation() {
        return this.getMethod(1);
    }

    protected IMethod getDefiningMethod() throws EJBModelException {
        IMethod method = this.getImplementation();
        if (method != null && method.exists()) {
            return method;
        }
        method = this.getHomeDeclaration();
        if (method != null && method.exists()) {
            return method;
        }
        method = this.getLocalHomeDeclaration();
        if (method != null && method.exists()) {
            return method;
        }
        return null;
    }

    public String getRenamedNameForDD(String beanClassName) {
        String name = EjbMetaInfo.getHomeMethodImplUserName((String)beanClassName);
        return name;
    }

    public Map getRenameScheme(String beanClassName) throws EJBModelException {
        if (!EjbMetaInfo.isHomeMethodImplName((String)beanClassName)) {
            String msg = "Invalid method name [" + beanClassName + "]";
            throw new EJBModelException((IStatus)new Status(4, EJBImplPlugin.getPluginId(), 0, msg, null));
        }
        HashMap<IMethod, String> scheme = new HashMap<IMethod, String>(3);
        IMethod method = this.getImplementation();
        if (method != null && method.exists()) {
            scheme.put(method, beanClassName);
        }
        String name = EjbMetaInfo.getHomeMethodImplUserName((String)beanClassName);
        method = this.getHomeDeclaration();
        if (method != null && method.exists()) {
            scheme.put(method, name);
        }
        if ((method = this.getLocalHomeDeclaration()) != null && method.exists()) {
            scheme.put(method, name);
        }
        return scheme;
    }

    public Map getReturnTypeScheme(String beanClassReturnType) throws EJBModelException {
        HashMap<IMethod, String> scheme = new HashMap<IMethod, String>(3);
        IMethod method = this.getImplementation();
        if (method != null && method.exists()) {
            scheme.put(method, beanClassReturnType);
        }
        if ((method = this.getHomeDeclaration()) != null && method.exists()) {
            scheme.put(method, beanClassReturnType);
        }
        if ((method = this.getLocalHomeDeclaration()) != null && method.exists()) {
            scheme.put(method, beanClassReturnType);
        }
        return scheme;
    }

    protected int getAllowedMethodParticipants() {
        return 11;
    }

    protected void promote(int role, IType type, String beanClassName, List params, String returnType, List exceptionsType, IProgressMonitor monitor) throws EJBModelException {
        String userName = EjbMetaInfo.getHomeMethodImplUserName((String)beanClassName);
        try {
            switch (role) {
                case 1: {
                    EjbTemplatesSupport.createHomeMethodImpl(type, userName, params, returnType, exceptionsType, monitor);
                    break;
                }
                case 8: {
                    EjbTemplatesSupport.createHomeLocalMethod(type, userName, params, returnType, exceptionsType, monitor);
                    break;
                }
                case 2: {
                    EjbTemplatesSupport.createHomeMethod(type, userName, params, returnType, exceptionsType, monitor);
                }
            }
        }
        catch (CoreException e) {
            throw new EJBModelException("Exception occurred while promoting the method", (Throwable)e);
        }
    }

    protected void pasteMethodCopy(EnterpriseBean target, int role, String beanClassMethodName, String[] paramTypeFQNs, String[] paramNames, String[] exceptionTypes, String returnType, BodyAndComment bodyAndComment) throws CoreException {
        String methodName;
        AccessibleBean bean = (AccessibleBean)target;
        IType type = bean.getParticipant(role);
        String userName = EjbMetaInfo.getHomeMethodImplUserName((String)beanClassMethodName);
        List params = EnterpriseBean.asList(paramTypeFQNs, paramNames);
        List exceptionsType = EnterpriseBean.asList(exceptionTypes);
        switch (role) {
            case 1: {
                methodName = beanClassMethodName;
                EjbTemplatesSupport.createHomeMethodImpl(type, userName, params, returnType, exceptionsType, null);
                break;
            }
            case 8: {
                methodName = userName;
                EjbTemplatesSupport.createHomeLocalMethod(type, userName, params, returnType, exceptionsType, null);
                break;
            }
            case 2: {
                methodName = userName;
                EjbTemplatesSupport.createHomeMethod(type, userName, params, returnType, exceptionsType, null);
                break;
            }
            default: {
                return;
            }
        }
        this.pasteMethodBody(type, methodName, paramTypeFQNs, bodyAndComment);
    }

    public boolean canSetReturnType(String type) {
        return true;
    }

    protected String getDdpKey() {
        return "HomeMethod";
    }

    protected void transferDdpsFrom(IMethod m) throws EJBModelException {
        if (m.equals(this.getImplementation())) {
            if (!this.transferDdps(m, this.getHomeDeclaration())) {
                this.transferDdps(m, this.getLocalHomeDeclaration());
            }
        } else if (m.equals(this.getHomeDeclaration()) && this.getImplementation() == null) {
            this.transferDdps(m, this.getLocalHomeDeclaration());
        }
    }

    protected boolean isValidName(String name) {
        return EjbMetaInfo.isHomeMethodImplName((String)name) || EjbMetaInfo.isHomeMethodImplName((String)EjbMetaInfo.getHomeMethodImplName((String)name));
    }
}

