/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejb.IEnterpriseBeanHierarchyListener;
import com.tssap.j2ee.core.ejb.IEnterpriseBeanHierarchyManager;
import com.tssap.j2ee.core.utils.IDispatchedJavaDeltaListener;
import com.tssap.j2ee.internal.core.ejb.EjbProjectImpl;
import com.tssap.j2ee.internal.core.ejb.IEJBDispatchedJavaDeltaListener;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.ejb.util.JavaDeltaDispatcher;
import com.tssap.j2ee.internal.core.ejb.workarounds.IProjectDependencyWorkaroundListener;
import com.tssap.j2ee.internal.core.ejb.workarounds.ProjectDependencyListener;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.JavaModelException;

public class HierarchyManager
implements IEnterpriseBeanHierarchyManager,
IEJBDispatchedJavaDeltaListener,
IProjectDependencyWorkaroundListener {
    private boolean myShouldFire = false;
    private IType myEntityBeanType;
    private IType mySessionBeanType;
    private IType myMessageBeanType;
    private IType myEnterpriseBeanType;
    private EjbProjectImpl myProject;
    private UpdatableTypeHierarchy myUpdatableHierarchy;
    private ArrayList myListeners = new ArrayList();

    public HierarchyManager(EjbProjectImpl project) {
        this.myProject = project;
        this.myUpdatableHierarchy = new UpdatableTypeHierarchy();
        ProjectDependencyListener.getInstance().addWorkaroundListener(project.getProject(), (IProjectDependencyWorkaroundListener)this);
        JavaDeltaDispatcher.getInstance().addDispatchedDeltaListener((IJavaElement)this.myProject.getJavaProject(), (IDispatchedJavaDeltaListener)this);
    }

    public IJavaProject getJavaProject() {
        return this.getEJBProject().getJavaProject();
    }

    public Collection getBeanTypes(int kind) {
        if (!this.myUpdatableHierarchy.exists()) {
            this.createBaseTypes();
            this.myUpdatableHierarchy.initialize(this.myEnterpriseBeanType);
        }
        if (!this.myShouldFire) {
            this.myShouldFire = true;
        }
        ArrayList result = new ArrayList();
        if ((kind & 1) > 0) {
            result.addAll(this.myUpdatableHierarchy.getImplementingClasses(this.myEntityBeanType));
        }
        if ((kind & 2) > 0) {
            result.addAll(this.myUpdatableHierarchy.getImplementingClasses(this.mySessionBeanType));
        }
        if ((kind & 4) > 0) {
            result.addAll(this.myUpdatableHierarchy.getImplementingClasses(this.myMessageBeanType));
        }
        return result;
    }

    public int getKind(IType type) {
        if (this.contains(type, 1)) {
            return 1;
        }
        if (this.contains(type, 2)) {
            return 2;
        }
        if (this.contains(type, 4)) {
            return 4;
        }
        return 0;
    }

    public boolean contains(IType type, int kind) {
        return this.getBeanTypes(kind).contains(type);
    }

    private boolean createBaseTypes() {
        this.myEntityBeanType = JDTUtils.findType((IJavaProject)this.myProject.getJavaProject(), (String)"javax.ejb.EntityBean");
        if (this.myEntityBeanType == null) {
            return false;
        }
        this.mySessionBeanType = JDTUtils.findType((IJavaProject)this.myProject.getJavaProject(), (String)"javax.ejb.SessionBean");
        if (this.mySessionBeanType == null) {
            return false;
        }
        this.myMessageBeanType = JDTUtils.findType((IJavaProject)this.myProject.getJavaProject(), (String)"javax.ejb.MessageDrivenBean");
        if (this.myMessageBeanType == null) {
            return false;
        }
        this.myEnterpriseBeanType = JDTUtils.findType((IJavaProject)this.myProject.getJavaProject(), (String)"javax.ejb.EnterpriseBean");
        return this.myEnterpriseBeanType != null;
    }

    public void elementChanged(IJavaElementDelta delta) {
        if (this.myEnterpriseBeanType == null || this.myEntityBeanType == null || this.mySessionBeanType == null || this.myMessageBeanType == null) {
            this.createBaseTypes();
            this.myUpdatableHierarchy.initialize(this.myEnterpriseBeanType);
        } else if (!(this.myEnterpriseBeanType.exists() && this.myEntityBeanType.exists() && this.mySessionBeanType.exists() && this.myMessageBeanType.exists() && !this.isRemovedJavaxJar(delta))) {
            this.myEnterpriseBeanType = null;
            this.myEntityBeanType = null;
            this.mySessionBeanType = null;
            this.myMessageBeanType = null;
            this.createBaseTypes();
            this.myUpdatableHierarchy.initialize(this.myEnterpriseBeanType);
        }
    }

    void refresh() {
        this.myEnterpriseBeanType = null;
        this.myEntityBeanType = null;
        this.mySessionBeanType = null;
        this.myMessageBeanType = null;
        this.createBaseTypes();
        this.myUpdatableHierarchy.initialize(this.myEnterpriseBeanType);
    }

    private boolean isRemovedJavaxJar(IJavaElementDelta delta) {
        if (delta.getElement().getElementType() != 2) {
            return false;
        }
        IJavaElementDelta[] affectedPFRoots = delta.getAffectedChildren();
        if (affectedPFRoots == null || affectedPFRoots.length == 0) {
            return false;
        }
        IPackageFragmentRoot javaxJarRoot = (IPackageFragmentRoot)this.myEnterpriseBeanType.getPackageFragment().getParent();
        int i = 0;
        while (i < affectedPFRoots.length) {
            if ((affectedPFRoots[i].getFlags() & 0x80) != 0 && javaxJarRoot.equals(affectedPFRoots[i].getElement())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void projectDependencyChanged(IProject project) {
        if (this.myEnterpriseBeanType == null || this.myEntityBeanType == null || this.mySessionBeanType == null || this.myMessageBeanType == null) {
            this.createBaseTypes();
        } else if (!(this.myEnterpriseBeanType.exists() && this.myEntityBeanType.exists() && this.mySessionBeanType.exists() && this.myMessageBeanType.exists())) {
            this.myEnterpriseBeanType = null;
            this.myEntityBeanType = null;
            this.mySessionBeanType = null;
            this.myMessageBeanType = null;
            this.createBaseTypes();
        }
        this.myUpdatableHierarchy.initialize(this.myEnterpriseBeanType);
    }

    public EjbProject getEJBProject() {
        return this.myProject;
    }

    void beanTypesChanged(Collection oldTypes, Collection newTypes) {
        if (!this.myShouldFire) {
            return;
        }
        ArrayList commonTypes = new ArrayList(oldTypes);
        commonTypes.retainAll(newTypes);
        ArrayList addedTypes = new ArrayList(newTypes);
        addedTypes.removeAll(commonTypes);
        ArrayList removedTypes = new ArrayList(oldTypes);
        removedTypes.removeAll(commonTypes);
        if (addedTypes.size() + removedTypes.size() > 0) {
            this.fireBeanTypesChanged(addedTypes, removedTypes);
        }
    }

    private void fireBeanTypesChanged(Collection addedTypes, Collection removedTypes) {
        Iterator it = ((AbstractList)((ArrayList)this.myListeners.clone())).iterator();
        while (it.hasNext()) {
            IEnterpriseBeanHierarchyListener next = (IEnterpriseBeanHierarchyListener)it.next();
            next.beanTypesChanged(addedTypes, removedTypes);
        }
    }

    public void addEnterpriseBeanHierarchyListener(IEnterpriseBeanHierarchyListener listener) {
        this.myListeners.add(listener);
    }

    public void removeEnterpriseBeanHierarchyListener(IEnterpriseBeanHierarchyListener listener) {
        ((AbstractCollection)this.myListeners).remove(listener);
    }

    private class UpdatableTypeHierarchy
    implements ITypeHierarchyChangedListener {
        private ITypeHierarchy myHierarchy;
        private Collection myCachedAllTypes;

        private UpdatableTypeHierarchy() {
        }

        public boolean exists() {
            return this.myHierarchy != null;
        }

        public void initialize(IType base) {
            Collection types = this.getAllTypes();
            this.flushCachedTypes();
            if (this.myHierarchy != null) {
                this.myHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            }
            if (base == null || !base.exists()) {
                this.myHierarchy = null;
            } else {
                try {
                    this.myHierarchy = base.newTypeHierarchy(HierarchyManager.this.getJavaProject(), null);
                    this.myHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
                    JavaDeltaDispatcher.getInstance().reactivate();
                }
                catch (JavaModelException e) {
                    this.myHierarchy = null;
                }
            }
            Collection newTypes = this.getAllTypes();
            HierarchyManager.this.beanTypesChanged(types, newTypes);
        }

        public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
            if (typeHierarchy != this.myHierarchy) {
                return;
            }
            Collection types = this.getAllTypes();
            this.flushCachedTypes();
            if (!this.myHierarchy.exists()) {
                this.deleteHierarchy(types);
            } else {
                try {
                    this.myHierarchy.refresh(null);
                    JavaDeltaDispatcher.getInstance().reactivate();
                    Collection newTypes = this.getAllTypes();
                    HierarchyManager.this.beanTypesChanged(types, newTypes);
                }
                catch (JavaModelException e) {
                    this.deleteHierarchy(types);
                }
            }
        }

        private void flushCachedTypes() {
            this.myCachedAllTypes = null;
        }

        private void deleteHierarchy(Collection oldTypes) {
            if (this.myHierarchy == null) {
                return;
            }
            this.myHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.myHierarchy = null;
            HierarchyManager.this.beanTypesChanged(oldTypes, Collections.EMPTY_SET);
        }

        public Collection getAllTypes() {
            if (this.myHierarchy == null) {
                return Collections.EMPTY_SET;
            }
            if (this.myCachedAllTypes == null) {
                this.myCachedAllTypes = this.getImplementingClasses(this.myHierarchy.getType());
            }
            return this.myCachedAllTypes;
        }

        public Collection getImplementingClasses(IType intface) {
            if (this.myHierarchy == null) {
                return Collections.EMPTY_SET;
            }
            IType[] allSubtypes = this.myHierarchy.getAllSubtypes(intface);
            return this.retainClasses(allSubtypes);
        }

        private Collection retainClasses(IType[] types) {
            ArrayList<IType> result = new ArrayList<IType>(types.length);
            int i = 0;
            while (i < types.length) {
                block5: {
                    try {
                        if (types[i].isInterface()) {
                        }
                    }
                    catch (JavaModelException e) {}
                    break block5;
                    if (JDTUtils.findType((IJavaProject)HierarchyManager.this.getEJBProject().getJavaProject(), (String)types[i].getFullyQualifiedName()) != null) {
                        result.add(types[i]);
                    }
                }
                ++i;
            }
            return result;
        }
    }
}

