/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbMetaInfo;
import com.tssap.j2ee.core.ejb.IFinderMethod;
import com.tssap.j2ee.internal.core.ejb.AccessibleBean;
import com.tssap.j2ee.internal.core.ejb.BodyAndComment;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.EnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.EntityBean;
import com.tssap.j2ee.internal.core.ejb.MethodSig;
import com.tssap.j2ee.internal.core.ejb.util.EjbTemplatesSupport;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

public class FinderMethod
extends EJBMethod
implements IFinderMethod {
    private static final Set MRT = new HashSet();
    private static final Collection FINDER_EXCEPTION;

    public FinderMethod(EntityBean parent, MethodSig signature) throws EJBModelException {
        super(parent, 4, signature.getName(), EjbMetaInfo.getFindMethodName((String)EjbMetaInfo.getFindMethodImplUserName((String)signature.getName())), signature.getParameterTypeFQNs());
    }

    public IStatus validate() throws EJBModelException {
        return null;
    }

    public static String getHomeName(IMethod beanClassMethod) {
        if (FinderMethod.isValidBeanClassFinder(beanClassMethod)) {
            String name = beanClassMethod.getElementName();
            name = EjbMetaInfo.getFindMethodImplUserName((String)name);
            return EjbMetaInfo.getFindMethodName((String)name);
        }
        return null;
    }

    public static String getBeanClassName(IMethod findMethod) {
        String name = findMethod.getElementName();
        if (EjbMetaInfo.isFindMethodName((String)name)) {
            name = EjbMetaInfo.getFindMethodUserName((String)name);
            return EjbMetaInfo.getFindMethodImplName((String)name);
        }
        return null;
    }

    public static boolean isValidBeanClassFinder(IMethod beanClassMethod) {
        return EjbMetaInfo.isFindMethodImplName((String)beanClassMethod.getElementName());
    }

    public IMethod getHomeDeclaration() {
        return this.getMethod(2);
    }

    public IMethod getLocalHomeDeclaration() {
        return this.getMethod(8);
    }

    public IMethod getImplementation() {
        return this.getMethod(1);
    }

    protected IMethod getDefiningMethod() throws EJBModelException {
        IMethod method = this.getImplementation();
        if (method != null && method.exists()) {
            return method;
        }
        method = this.getHomeDeclaration();
        if (method != null && method.exists()) {
            return method;
        }
        method = this.getLocalHomeDeclaration();
        if (method != null && method.exists()) {
            return method;
        }
        return null;
    }

    public String getRenamedNameForDD(String beanClassName) {
        String name = EjbMetaInfo.getFindMethodImplUserName((String)beanClassName);
        return EjbMetaInfo.getFindMethodName((String)name);
    }

    public Map getRenameScheme(String beanClassName) throws EJBModelException {
        if (!EjbMetaInfo.isFindMethodImplName((String)beanClassName)) {
            String msg = "Invalid method name [" + beanClassName + "]";
            throw new EJBModelException((IStatus)new Status(4, EJBImplPlugin.getPluginId(), 0, msg, null));
        }
        HashMap<IMethod, String> scheme = new HashMap<IMethod, String>(3);
        IMethod method = this.getImplementation();
        if (method != null && method.exists()) {
            scheme.put(method, beanClassName);
        }
        String name = EjbMetaInfo.getFindMethodImplUserName((String)beanClassName);
        method = this.getHomeDeclaration();
        if (method != null && method.exists()) {
            scheme.put(method, EjbMetaInfo.getFindMethodName((String)name));
        }
        if ((method = this.getLocalHomeDeclaration()) != null && method.exists()) {
            scheme.put(method, EjbMetaInfo.getFindMethodName((String)name));
        }
        return scheme;
    }

    public Map getReturnTypeScheme(String beanClassReturnType) throws EJBModelException {
        HashMap<IMethod, String> scheme = new HashMap<IMethod, String>(3);
        boolean isCollection = MRT.contains(beanClassReturnType);
        IMethod method = this.getImplementation();
        if (method != null && method.exists()) {
            if (isCollection) {
                scheme.put(method, beanClassReturnType);
            } else {
                IType pkClass = this.getEJB().getParticipant(32);
                if (pkClass != null && pkClass.exists()) {
                    scheme.put(method, pkClass.getFullyQualifiedName());
                } else {
                    throw new EJBModelException("Cannot do that");
                }
            }
        }
        if ((method = this.getHomeDeclaration()) != null && method.exists()) {
            if (isCollection) {
                scheme.put(method, beanClassReturnType);
            } else {
                IType remote = this.getEJB().getParticipant(4);
                if (remote != null && remote.exists()) {
                    scheme.put(method, remote.getFullyQualifiedName());
                } else {
                    throw new EJBModelException("Cannot do that");
                }
            }
        }
        if ((method = this.getLocalHomeDeclaration()) != null && method.exists()) {
            if (isCollection) {
                scheme.put(method, beanClassReturnType);
            } else {
                IType local = this.getEJB().getParticipant(16);
                if (local != null && local.exists()) {
                    scheme.put(method, local.getFullyQualifiedName());
                } else {
                    throw new EJBModelException("Cannot do that");
                }
            }
        }
        return scheme;
    }

    protected String internalGetReturnType() throws EJBModelException {
        IMethod impl = this.getImplementation();
        if (impl != null && impl.exists()) {
            return JDTUtils.getFQN((IType)impl.getDeclaringType(), (String)super.getReturnType(impl));
        }
        String returnTypeCandidate = super.internalGetReturnType();
        if (MRT.contains(returnTypeCandidate)) {
            return returnTypeCandidate;
        }
        EntityBean ejb = this.getEJB();
        IType pkClass = ejb.getParticipant(32);
        if (pkClass == null) {
            return null;
        }
        return pkClass.getFullyQualifiedName();
    }

    private EntityBean getEJB() {
        return (EntityBean)this.getParent();
    }

    public boolean canSetReturnType(String type) {
        if (MRT.contains(type)) {
            return !"ejbFindByPrimaryKey".equals(this.getName());
        }
        try {
            IType local;
            IType remote;
            IType pkClass = this.getEJB().getParticipant(32);
            if (pkClass == null || !pkClass.exists()) {
                return false;
            }
            if (!pkClass.getFullyQualifiedName().equals(type) && !pkClass.getElementName().equals(type)) {
                return false;
            }
            IMethod homeMethod = this.getMethod(2);
            if (homeMethod != null && homeMethod.exists() && ((remote = this.getEJB().getParticipant(4)) == null || !remote.exists())) {
                return false;
            }
            IMethod localhomeMethod = this.getMethod(8);
            if (localhomeMethod != null && localhomeMethod.exists() && ((local = this.getEJB().getParticipant(16)) == null || !local.exists())) {
                return false;
            }
        }
        catch (EJBModelException e) {
            return false;
        }
        return true;
    }

    public void setReturnType(String type, IProgressMonitor monitor) throws EJBModelException {
        type = JDTUtils.getFQN((IType)this.getDefiningMethod().getDeclaringType(), (String)type);
        if (MRT.contains(type)) {
            super.setReturnType(type, monitor);
            return;
        }
        if (!this.validateEdit(this.getMethods(), false)) {
            throw new EJBModelException("Could not modify read-only files");
        }
        monitor = this.getValidProgressMonitor(monitor);
        monitor.beginTask("setReturnType", 3);
        IType pkClass = this.getEJB().getParticipant(32);
        if (pkClass != null && (pkClass.getElementName().equals(type) || pkClass.getFullyQualifiedName().equals(type))) {
            this.getParentBean().enterWorkingCopyMode();
            try {
                IMethod beanClassMethod = this.getMethod(1);
                if (beanClassMethod != null && beanClassMethod.exists()) {
                    EJBMethod.setReturnType(beanClassMethod, type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                IMethod homeMethod = this.getMethod(2);
                if (homeMethod != null && homeMethod.exists()) {
                    IType remote = this.getEJB().getParticipant(4);
                    EJBMethod.setReturnType(homeMethod, remote.getFullyQualifiedName(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                IMethod localhomeMethod = this.getMethod(8);
                if (localhomeMethod != null && localhomeMethod.exists()) {
                    IType local = this.getEJB().getParticipant(16);
                    EJBMethod.setReturnType(localhomeMethod, local.getFullyQualifiedName(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                Object var9_9 = null;
                this.getParentBean().exitWorkingCopyMode();
                return;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.getParentBean().exitWorkingCopyMode();
                throw throwable;
            }
        }
        String msg = "Return type can be either Primary Key class or Collection";
        throw new EJBModelException((IStatus)new Status(4, "com.tssap.j2ee.internal.core.ejb", 0, msg, (Throwable)new UnsupportedOperationException()));
    }

    public boolean canPromote(int role) {
        if (!super.canPromote(role)) {
            return false;
        }
        EntityBean bean = (EntityBean)this.getParent();
        try {
            switch (role) {
                case 1: {
                    return !bean.isCMP();
                }
                case 2: {
                    IType remote = bean.getParticipant(4);
                    return remote != null && remote.exists();
                }
                case 8: {
                    IType local = bean.getParticipant(16);
                    return local != null && local.exists();
                }
            }
        }
        catch (EJBModelException e) {
            return false;
        }
        return true;
    }

    protected int getAllowedMethodParticipants() {
        int result = 10;
        try {
            if (!((EntityBean)this.getParentBean()).isCMP()) {
                result |= 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected void promote(int role, IType type, String beanClassName, List params, String returnType, List exceptionsType, IProgressMonitor monitor) throws EJBModelException {
        String userName = EjbMetaInfo.getFindMethodImplUserName((String)beanClassName);
        boolean multi = MRT.contains(returnType);
        try {
            switch (role) {
                case 1: {
                    EjbTemplatesSupport.createFindMethodImpl(type, userName, params, returnType, exceptionsType, monitor);
                    break;
                }
                case 8: {
                    String local;
                    if (multi) {
                        local = returnType;
                    } else {
                        IType localType = this.getEJB().getParticipant(16);
                        local = localType.getFullyQualifiedName();
                    }
                    EjbTemplatesSupport.createFindLocalMethod(type, userName, params, local, exceptionsType, monitor);
                    break;
                }
                case 2: {
                    String remote;
                    if (multi) {
                        remote = returnType;
                    } else {
                        IType remoteType = this.getEJB().getParticipant(4);
                        remote = remoteType.getFullyQualifiedName();
                    }
                    EjbTemplatesSupport.createFindMethod(type, userName, params, remote, exceptionsType, monitor);
                }
            }
        }
        catch (CoreException e) {
            throw new EJBModelException("Exception occurred while promoting the method", (Throwable)e);
        }
    }

    protected void pasteMethodCopy(EnterpriseBean target, int role, String beanClassMethodName, String[] paramTypeFQNs, String[] paramNames, String[] exceptionTypes, String returnType, BodyAndComment bodyAndComment) throws CoreException {
        String methodName;
        AccessibleBean bean = (AccessibleBean)target;
        IType type = bean.getParticipant(role);
        String userName = EjbMetaInfo.getFindMethodImplUserName((String)beanClassMethodName);
        List params = EnterpriseBean.asList(paramTypeFQNs, paramNames);
        List exceptionsType = EnterpriseBean.asList(exceptionTypes);
        boolean multi = MRT.contains(returnType);
        switch (role) {
            case 1: {
                methodName = beanClassMethodName;
                EjbTemplatesSupport.createFindMethodImpl(type, userName, params, returnType, exceptionsType, null);
                break;
            }
            case 8: {
                String local;
                methodName = EjbMetaInfo.getFindMethodName((String)userName);
                if (multi) {
                    local = returnType;
                } else {
                    IType localType = this.getEJB().getParticipant(16);
                    local = localType.getFullyQualifiedName();
                }
                EjbTemplatesSupport.createFindLocalMethod(type, userName, params, local, exceptionsType, null);
                break;
            }
            case 2: {
                String remote;
                methodName = EjbMetaInfo.getFindMethodName((String)userName);
                if (multi) {
                    remote = returnType;
                } else {
                    IType remoteType = this.getEJB().getParticipant(4);
                    remote = remoteType.getFullyQualifiedName();
                }
                EjbTemplatesSupport.createFindMethod(type, userName, params, remote, exceptionsType, null);
                break;
            }
            default: {
                return;
            }
        }
        this.pasteMethodBody(type, methodName, paramTypeFQNs, bodyAndComment);
    }

    protected Collection getMandatoryExceptionTypes() {
        return FINDER_EXCEPTION;
    }

    public void updatePKReturnType(String pkFQN) throws EJBModelException {
        IMethod impl = this.getImplementation();
        if (impl == null || !impl.exists()) {
            return;
        }
        String returnType = this.getReturnType();
        if (!MRT.contains(returnType)) {
            EJBMethod.setReturnType(impl, pkFQN, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected String getDdpKey() {
        return "FindMethod";
    }

    protected void transferDdpsFrom(IMethod m) throws EJBModelException {
        if (m.equals(this.getImplementation())) {
            if (!this.transferDdps(m, this.getHomeDeclaration())) {
                this.transferDdps(m, this.getLocalHomeDeclaration());
            }
        } else if (m.equals(this.getHomeDeclaration()) && this.getImplementation() == null) {
            this.transferDdps(m, this.getLocalHomeDeclaration());
        }
    }

    public boolean canDelete() {
        if (this.isByPrimaryKeyMethod()) {
            return false;
        }
        return super.canDelete();
    }

    boolean isByPrimaryKeyMethod() {
        return EjbMetaInfo.getFindMethodUserName((String)this.getNameForDD()).equals("byPrimaryKey") && this.getParameterTypes().length == 1;
    }

    protected boolean isValidName(String name) {
        return EjbMetaInfo.isFindMethodName((String)name) || EjbMetaInfo.isFindMethodImplName((String)name);
    }

    static {
        MRT.add("java.util.Collection");
        FINDER_EXCEPTION = Collections.singleton("FinderException");
    }
}

