/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbMetaInfo;
import com.tssap.j2ee.internal.core.ejb.AccessibleBeanMethodCollector;
import com.tssap.j2ee.internal.core.ejb.CreateMethod;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.EntityBean;
import com.tssap.j2ee.internal.core.ejb.FinderMethod;
import com.tssap.j2ee.internal.core.ejb.HomeMethod;
import com.tssap.j2ee.internal.core.ejb.MethodSig;
import com.tssap.j2ee.internal.core.ejb.SelectMethod;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jdt.core.IMethod;

public class EntityBeanMethodCollector
extends AccessibleBeanMethodCollector {
    private AccessibleBeanMethodCollector.SpecificMethodCollector myBeanClassCreateMethodsCollector = new AccessibleBeanMethodCollector.CreateMethodCollector(){

        public String getBeanClassMethodName(IMethod beanClassMethod) {
            if (CreateMethod.isValidBeanClassCreateMethod(beanClassMethod)) {
                return beanClassMethod.getElementName();
            }
            return CreateMethod.getBeanClassNonPostName(beanClassMethod);
        }

        public void addMethodOccurrence(EJBMethod ejbMethod, IMethod jdtMethod, int participantRole) {
            int methodRole = EjbMetaInfo.isPostCreateMethodImplName((String)jdtMethod.getElementName()) ? 64 : 1;
            ejbMethod.setMethod(methodRole, jdtMethod);
        }
    };
    private AccessibleBeanMethodCollector.SpecificMethodCollector myBeanClassFindMethodsCollector = new FindMethodCollector(){

        public String getBeanClassMethodName(IMethod beanClassMethod) {
            if (FinderMethod.isValidBeanClassFinder(beanClassMethod)) {
                return beanClassMethod.getElementName();
            }
            return null;
        }
    };
    private AccessibleBeanMethodCollector.SpecificMethodCollector myInterfaceFindMethodsCollector = new FindMethodCollector(){

        public String getBeanClassMethodName(IMethod interfaceMethod) {
            return FinderMethod.getBeanClassName(interfaceMethod);
        }
    };
    private AccessibleBeanMethodCollector.SpecificMethodCollector myBeanClassHomeMethodsCollector = new HomeMethodCollector(){

        public String getBeanClassMethodName(IMethod beanClassMethod) {
            if (HomeMethod.isValidBeanClassHomeMethod(beanClassMethod)) {
                return beanClassMethod.getElementName();
            }
            return null;
        }
    };
    private AccessibleBeanMethodCollector.SpecificMethodCollector myInterfaceHomeMethodsCollector = new HomeMethodCollector(){

        public String getBeanClassMethodName(IMethod interfaceMethod) {
            return HomeMethod.getBeanClassName(interfaceMethod);
        }
    };
    private AccessibleBeanMethodCollector.SpecificMethodCollector mySelectMethodsCollector = new AccessibleBeanMethodCollector.MethodSettingMethodCollector(){

        public EJBMethod createMethod(MethodSig signature) {
            return new SelectMethod(EntityBeanMethodCollector.this.getEntityBean(), signature);
        }

        public String getBeanClassMethodName(IMethod method) {
            if (EjbMetaInfo.isSelectMethodName((String)method.getElementName())) {
                return method.getElementName();
            }
            return null;
        }
    };

    public EntityBeanMethodCollector(EntityBean bean) {
        super(bean);
    }

    protected void collectMethods(HashMap receiver, IMethod[] beanClassMethods, IMethod[] homeMethods, IMethod[] remoteMethods, IMethod[] localhomeMethods, IMethod[] localMethods) {
        super.collectMethods(receiver, beanClassMethods, homeMethods, remoteMethods, localhomeMethods, localMethods);
        this.collectFindMethods(receiver, beanClassMethods, homeMethods, localhomeMethods);
        this.collectHomeMethods(receiver, beanClassMethods, homeMethods, localhomeMethods);
        this.collectSelectMethods(receiver, beanClassMethods);
    }

    private void collectFindMethods(HashMap receiver, IMethod[] beanClassMethods, IMethod[] homeMethods, IMethod[] localhomeMethods) {
        HashSet failedSignatures = new HashSet();
        try {
            if (!this.getEntityBean().isCMP()) {
                this.collectMethods(receiver, failedSignatures, beanClassMethods, this.myBeanClassFindMethodsCollector, 1);
            }
        }
        catch (EJBModelException e) {
            // empty catch block
        }
        this.collectMethods(receiver, failedSignatures, homeMethods, this.myInterfaceFindMethodsCollector, 2);
        this.collectMethods(receiver, failedSignatures, localhomeMethods, this.myInterfaceFindMethodsCollector, 8);
    }

    private void collectHomeMethods(HashMap receiver, IMethod[] beanClassMethods, IMethod[] homeMethods, IMethod[] localhomeMethods) {
        HashSet failedSignatures = new HashSet();
        this.collectMethods(receiver, failedSignatures, beanClassMethods, this.myBeanClassHomeMethodsCollector, 1);
        this.collectMethods(receiver, failedSignatures, homeMethods, this.myInterfaceHomeMethodsCollector, 2);
        this.collectMethods(receiver, failedSignatures, localhomeMethods, this.myInterfaceHomeMethodsCollector, 8);
    }

    private void collectSelectMethods(HashMap receiver, IMethod[] beanClassMethods) {
        try {
            if (this.getEntityBean().isCMP()) {
                HashSet failedSignatures = new HashSet();
                this.collectMethods(receiver, failedSignatures, beanClassMethods, this.mySelectMethodsCollector, 1);
            }
        }
        catch (EJBModelException eJBModelException) {
            // empty catch block
        }
    }

    private EntityBean getEntityBean() {
        return (EntityBean)this.getBean();
    }

    protected AccessibleBeanMethodCollector.SpecificMethodCollector getBeanClassCreateMethodsCollector() {
        return this.myBeanClassCreateMethodsCollector;
    }

    protected abstract class HomeMethodCollector
    extends AccessibleBeanMethodCollector.MethodSettingMethodCollector {
        protected HomeMethodCollector() {
        }

        public EJBMethod createMethod(MethodSig signature) {
            return new HomeMethod(EntityBeanMethodCollector.this.getEntityBean(), signature);
        }
    }

    protected abstract class FindMethodCollector
    extends AccessibleBeanMethodCollector.MethodSettingMethodCollector {
        protected FindMethodCollector() {
        }

        public EJBMethod createMethod(MethodSig signature) throws EJBModelException {
            return new FinderMethod(EntityBeanMethodCollector.this.getEntityBean(), signature);
        }
    }
}

