/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbMetaInfo;
import com.tssap.j2ee.core.ejb.EnterpriseBeanAcceptor;
import com.tssap.j2ee.core.ejb.ICreateMethod;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IFinderMethod;
import com.tssap.j2ee.core.ejb.IHomeMethod;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.ejb.IRelationshipEnd;
import com.tssap.j2ee.core.ejb.ISelectMethod;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbRelation;
import com.tssap.j2ee.core.ejbjar.EjbRelationshipRole;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.utils.ReadOnlinessValidator;
import com.tssap.j2ee.internal.core.ejb.AbstractEjbMethodCollector;
import com.tssap.j2ee.internal.core.ejb.AccessibleBean;
import com.tssap.j2ee.internal.core.ejb.CreateMethod;
import com.tssap.j2ee.internal.core.ejb.EJBDelta;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EjbProjectImpl;
import com.tssap.j2ee.internal.core.ejb.EnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.EntityBeanMethodCollector;
import com.tssap.j2ee.internal.core.ejb.FinderMethod;
import com.tssap.j2ee.internal.core.ejb.PersistentField;
import com.tssap.j2ee.internal.core.ejb.RelationshipEnd;
import com.tssap.j2ee.internal.core.ejb.WorkingCopyPersistentField;
import com.tssap.j2ee.internal.core.ejb.util.EjbBuilder;
import com.tssap.j2ee.internal.core.ejb.util.EjbTemplatesSupport;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.ejb.util.JavaCommentParserFactory;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ITag;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.codemanipulation.IOverrideMethodQuery;

public class EntityBean
extends AccessibleBean
implements IEntityBean {
    private Boolean myIsCMP;
    private HashMap myPersistentFields = null;
    private Boolean myIsSimplePK;
    private static final Collection RESERVED_TYPE_SIGNATURES = Arrays.asList(Signature.createTypeSignature((String)"EntityContext", (boolean)false), Signature.createTypeSignature((String)"javax.ejb.EntityContext", (boolean)false), Signature.createTypeSignature((String)"javax.ejb.EntityContext", (boolean)true));
    static final String HAS_SIMPLE_PK = "@hasSimplePK";
    private static final String[] EQUALS_PARAMS = new String[]{Signature.createTypeSignature((String)"Object", (boolean)false)};
    private static final String EQUALS_NAME = "equals";
    private static final String HASHCODE_NAME = "hashCode";
    private static final String[] MANDATORY = new String[]{"javax.ejb.EntityBean"};
    private static final String FIELD_TYPE_SIMPLE = "simple";
    private static final String ARRAY_SUFFIX = "[]";
    private static final String FIELD_TYPE_CLASS = "class";
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$tssap$selena$model$elements$Element;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;

    public EntityBean(EjbProjectImpl parent, IType beanClass) {
        super(parent, 1, beanClass);
    }

    public int getSupportedRoles() {
        return 63;
    }

    protected boolean validateParticipant(int role, IType type) {
        if (role == 32) {
            EJBImplPlugin.revisit("Any constraints?");
            return type.exists();
        }
        return super.validateParticipant(role, type);
    }

    protected void primAddParticipant(int role, String participantFQN, boolean acceptExisting, boolean deleteOldParticipant, IType actualParticipant, IType[] supertypes, IProgressMonitor monitor) throws EJBModelException {
        if (role == 32) {
            this.addPrimaryKey(participantFQN, acceptExisting, deleteOldParticipant, actualParticipant, monitor);
        } else {
            super.primAddParticipant(role, participantFQN, acceptExisting, deleteOldParticipant, actualParticipant, supertypes, monitor);
        }
    }

    protected void addPrimaryKey(final String pkFQN, boolean acceptExisting, boolean deleteOldParticipant, IType actualParticipant, IProgressMonitor monitor) throws EJBModelException {
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        validator.addJavaElement((IMember)this.getBeanClass());
        validator.addJavaElement((IMember)this.getParticipant(2));
        validator.addJavaElement((IMember)this.getParticipant(4));
        validator.addJavaElement((IMember)this.getParticipant(8));
        validator.addJavaElement((IMember)this.getParticipant(16));
        if (!validator.canModify()) {
            throw this.cannotModify();
        }
        IType type = JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)pkFQN);
        if (type != null) {
            if (!acceptExisting) {
                throw new EJBModelException(this.newStatus(4, "[" + pkFQN + "] already exists"));
            }
        } else {
            IPackageFragment remotePackage = ((EjbProjectImpl)this.getEJBProject()).getSuitablePackage(pkFQN);
            String remoteInterface = EjbProjectImpl.getTypeName(pkFQN);
            try {
                if (actualParticipant != null) {
                    if (!pkFQN.equals(actualParticipant.getFullyQualifiedName())) {
                        this.copyParticipant(actualParticipant, remotePackage, remoteInterface, deleteOldParticipant, monitor);
                    }
                } else {
                    EjbTemplatesSupport.createPrimaryKey(remotePackage, remoteInterface, monitor);
                }
            }
            catch (CoreException ce) {
                EJBModelException me = new EJBModelException(ce.getStatus());
                throw me;
            }
        }
        UndoTransparableCommand updateByPKCommand = new UndoTransparableCommand(){

            public void run() {
                try {
                    if (EntityBean.this.isCMP() && !EntityBean.this.isSimplePK()) {
                        IType currentPK = EntityBean.this.getParticipant(32);
                        IType typeToRegenerate = currentPK != null && currentPK.getFullyQualifiedName().equals(pkFQN) ? currentPK : JDTUtils.findType((IJavaProject)EntityBean.this.getEJBProject().getJavaProject(), (String)pkFQN);
                        EntityBean.this.regeneratePK(typeToRegenerate);
                    }
                    IEJBMethod[] methods = EntityBean.this.getEJBMethods();
                    int i = 0;
                    while (i < methods.length) {
                        IEJBMethod method = methods[i];
                        try {
                            if (method.getKind() == 2) {
                                ((CreateMethod)method).updatePKReturnType(pkFQN);
                            } else if (method.getKind() == 4) {
                                ((FinderMethod)method).updatePKReturnType(pkFQN);
                            }
                        }
                        catch (EJBModelException e) {
                            EJBImplPlugin.logWarning("Update of PK class failed in method " + method, e);
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    EJBImplPlugin.logWarning("Could not update primary key and related methods", e);
                }
                EntityBean.this.updateByPKMethods(pkFQN);
            }
        };
        this.enterWorkingCopyMode();
        try {
            updateByPKCommand.run();
            Object var13_12 = null;
            this.exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.exitWorkingCopyMode();
            throw throwable;
        }
    }

    protected void participantChangeDetectedAfterExitFromWCM() {
        super.participantChangeDetectedAfterExitFromWCM();
        this.myPersistentFields = null;
        try {
            this.getFields();
        }
        catch (EJBModelException eJBModelException) {
            // empty catch block
        }
    }

    private void updateByPKMethods(String pkFQN) {
        this.enterWorkingCopyMode();
        try {
            IEJBMethod[] methods;
            try {
                methods = this.getEJBMethods();
            }
            catch (EJBModelException e) {
                methods = new IEJBMethod[]{};
            }
            int i = 0;
            while (i < methods.length) {
                block9: {
                    IEJBMethod method = methods[i];
                    try {
                        String[] paramNames;
                        String[] params;
                        if (method.getKind() != 4 && method.getKind() != 2 || !"ejbFindByPrimaryKey".equals(method.getName()) && !"ejbCreateByPrimaryKey".equals(method.getName()) || (params = method.getParameterTypes()) == null || params.length != 1) break block9;
                        try {
                            paramNames = method.getParameterNames();
                        }
                        catch (EJBModelException e) {
                            paramNames = null;
                        }
                        method.setParameters(new String[]{pkFQN}, paramNames, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (EJBModelException e) {
                        EJBImplPlugin.logWarning("Failed to update method parameters", e);
                    }
                }
                ++i;
            }
            Object var9_10 = null;
            this.exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.exitWorkingCopyMode();
            throw throwable;
        }
    }

    protected boolean shouldRenameParticipant(int role) {
        if (role != 32) {
            return super.shouldRenameParticipant(role);
        }
        try {
            if (this.isCMP()) {
                return !this.isSimplePK();
            }
            IType pk = this.getParticipant(32);
            return pk != null && pk.exists() && !pk.isBinary();
        }
        catch (EJBModelException e) {
            return false;
        }
    }

    void fieldPKStatusChanged(PersistentField field) {
        if (!this.isSimplePK()) {
            return;
        }
        this.internalGetEJBProject().runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                EntityBean.this.updatePKForSimplePK();
            }
        });
    }

    private void updatePKForSimplePK() {
        if (!this.isSimplePK()) {
            return;
        }
        Collection pkFields = this.getPKFields();
        try {
            if (pkFields.isEmpty()) {
                IType currentPK = this.getParticipant(32);
                if (currentPK == null || !currentPK.exists() || !EnterpriseBean.equivalentClasses(currentPK.getElementName(), (class$java$lang$Object == null ? (class$java$lang$Object = EntityBean.class$("java.lang.Object")) : class$java$lang$Object).getName())) {
                    this.replacePrimaryKeyParticipant((class$java$lang$Object == null ? (class$java$lang$Object = EntityBean.class$("java.lang.Object")) : class$java$lang$Object).getName(), false, null, true);
                }
                return;
            }
            if (pkFields.size() > 1) {
                EJBImplPlugin.revisit("Invalid state. But not easily reachable");
                return;
            }
            PersistentField pkField = (PersistentField)((Object)pkFields.iterator().next());
            String pkClass = pkField.getType();
            IType currentPK = this.getParticipant(32);
            if (currentPK == null || !currentPK.exists() || !EnterpriseBean.equivalentClasses(currentPK.getElementName(), pkClass)) {
                this.replacePrimaryKeyParticipant(pkClass, false, pkField.getName(), true);
            }
        }
        catch (EJBModelException e) {
            EJBImplPlugin.logWarning("Update PK for Simple PK failed", e);
        }
    }

    protected void participantChanged(IType oldParticipant, IType newParticipant, int role) {
        super.participantChanged(oldParticipant, newParticipant, role);
        if (role == 32 && !EntityBean.exists(oldParticipant) && EntityBean.exists(newParticipant)) {
            this.internalGetEJBProject().getSynchronizeTarget().primKeyClassAdded((IEntityBean)this);
        }
    }

    private static boolean exists(IType type) {
        return type != null && type.exists();
    }

    public ICreateMethod createCreateMethod(String userMethodName, String[] parameterTypes, String[] parameterNames, String[] exceptionTypes, IProgressMonitor monitor) throws EJBModelException {
        IType home = this.getParticipant(2);
        IType localhome = this.getParticipant(8);
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        if (home != null) {
            validator.addJavaElement((IMember)home);
        }
        if (localhome != null) {
            validator.addJavaElement((IMember)localhome);
        }
        validator.addJavaElement((IMember)this.getBeanClass());
        if (!validator.canModify()) {
            throw this.cannotModify();
        }
        IType remote = this.getParticipant(4);
        String remoteInterface = remote == null ? null : remote.getFullyQualifiedName();
        IType local = this.getParticipant(16);
        String localInterface = local == null ? null : local.getFullyQualifiedName();
        IType primaryKey = this.getParticipant(32);
        String primaryKeyClass = primaryKey == null ? null : primaryKey.getFullyQualifiedName();
        parameterTypes = this.qualify(parameterTypes);
        exceptionTypes = this.qualify(exceptionTypes);
        this.enterWorkingCopyMode();
        try {
            try {
                EjbBuilder.createCreateMethodForEntity(this, remoteInterface, localInterface, primaryKeyClass, userMethodName, EnterpriseBean.asList(parameterTypes, parameterNames), EnterpriseBean.asList(exceptionTypes), monitor);
            }
            catch (CoreException ce) {
                EJBModelException me = new EJBModelException(ce.getStatus());
                throw me;
            }
            Object var18_15 = null;
            this.exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var18_16 = null;
            this.exitWorkingCopyMode();
            throw throwable;
        }
        return (CreateMethod)this.getEJBMethodByJavaTypes(EjbMetaInfo.getCreateMethodImplName((String)userMethodName), parameterTypes);
    }

    public IFinderMethod createFindMethod(String userMethodName, String[] parameterTypes, String[] parameterNames, String returnType, String[] exceptionTypes, IProgressMonitor monitor) throws EJBModelException {
        IType home = this.getParticipant(2);
        IType localhome = this.getParticipant(8);
        ReadOnlinessValidator validator = this.getValidatorForDDOnCMPFieldsOrQueriesChange();
        if (home != null) {
            validator.addJavaElement((IMember)home);
        }
        if (localhome != null) {
            validator.addJavaElement((IMember)localhome);
        }
        if (!this.isCMP()) {
            validator.addJavaElement((IMember)this.getBeanClass());
        }
        if (!validator.canModify()) {
            throw this.cannotModify();
        }
        parameterTypes = this.qualify(parameterTypes);
        exceptionTypes = this.qualify(exceptionTypes);
        this.enterWorkingCopyMode();
        try {
            try {
                EjbBuilder.createFindMethod(this, userMethodName, EnterpriseBean.asList(parameterTypes, parameterNames), returnType, this.isCMP(), EnterpriseBean.asList(exceptionTypes), monitor);
            }
            catch (CoreException ce) {
                EJBModelException me = new EJBModelException(ce.getStatus());
                throw me;
            }
            Object var13_10 = null;
            this.exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            this.exitWorkingCopyMode();
            throw throwable;
        }
        return (IFinderMethod)this.getEJBMethodByJavaTypes(EjbMetaInfo.getFindMethodImplName((String)userMethodName), parameterTypes);
    }

    public IHomeMethod createHomeMethod(String userMethodName, String[] parameterTypes, String[] parameterNames, String returnType, String[] exceptionTypes, IProgressMonitor monitor) throws EJBModelException {
        IType home = this.getParticipant(2);
        IType localhome = this.getParticipant(8);
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        if (home != null) {
            validator.addJavaElement((IMember)home);
        }
        if (localhome != null) {
            validator.addJavaElement((IMember)localhome);
        }
        validator.addJavaElement((IMember)this.getBeanClass());
        if (!validator.canModify()) {
            throw this.cannotModify();
        }
        parameterTypes = this.qualify(parameterTypes);
        exceptionTypes = this.qualify(exceptionTypes);
        this.enterWorkingCopyMode();
        try {
            try {
                EjbBuilder.createHomeMethod(this, userMethodName, EnterpriseBean.asList(parameterTypes, parameterNames), returnType, EnterpriseBean.asList(exceptionTypes), monitor);
            }
            catch (CoreException ce) {
                EJBModelException me = new EJBModelException(ce.getStatus());
                throw me;
            }
            Object var13_10 = null;
            this.exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            this.exitWorkingCopyMode();
            throw throwable;
        }
        return (IHomeMethod)this.getEJBMethodByJavaTypes(EjbMetaInfo.getHomeMethodImplName((String)userMethodName), parameterTypes);
    }

    public ISelectMethod createSelectMethod(String userMethodName, String[] parameterTypes, String[] parameterNames, String returnType, String[] exceptionTypes, IProgressMonitor monitor) throws EJBModelException {
        if (!this.isCMP()) {
            String msg = "Select methods should not be generated for BMP entity beans";
            throw new EJBModelException((IStatus)new Status(4, "com.tssap.j2ee.internal.core.ejb", 0, msg, null));
        }
        ReadOnlinessValidator validator = this.getValidatorForDDOnCMPFieldsOrQueriesChange();
        validator.addJavaElement((IMember)this.getBeanClass());
        if (!validator.canModify()) {
            throw this.cannotModify();
        }
        this.enterWorkingCopyMode();
        try {
            try {
                EjbBuilder.createSelectMethod(this, userMethodName, EnterpriseBean.asList(parameterTypes, parameterNames), returnType, EnterpriseBean.asList(exceptionTypes), monitor);
            }
            catch (CoreException ce) {
                EJBModelException me = new EJBModelException(ce.getStatus());
                throw me;
            }
            Object var11_9 = null;
            this.exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.exitWorkingCopyMode();
            throw throwable;
        }
        return (ISelectMethod)this.getEJBMethodByJavaTypes(EjbMetaInfo.getSelectMethodName((String)userMethodName), parameterTypes);
    }

    public IPersistentField createPersistentField(String fieldName, String type, boolean inPK, IProgressMonitor monitor) throws EJBModelException {
        if (!this.isCMP()) {
            throw new EJBModelException("BMP beans cannot have persistent fields");
        }
        PersistentField result = this.primCreatePersistentField(fieldName, type, inPK, monitor);
        if (result == null) {
            return null;
        }
        boolean promoting = EJBImplPlugin.isPromotingAccessors();
        if (promoting) {
            result.promoteAccessors(16);
            result.promoteAccessors(4);
        }
        return result;
    }

    private PersistentField primCreatePersistentField(String fieldName, String type, boolean inPK, IProgressMonitor monitor) throws EJBModelException {
        ReadOnlinessValidator validator = this.getValidatorForDDOnCMPFieldsOrQueriesChange();
        validator.addJavaElement((IMember)this.getBeanClass());
        if (inPK && !this.isSimplePK()) {
            validator.addJavaElement((IMember)this.getParticipant(32));
        }
        if (!validator.canModify()) {
            throw this.cannotModify();
        }
        this.addPersistentFields();
        this.enterWorkingCopyMode();
        try {
            block6: {
                try {
                    EjbBuilder.createPersistentCMPField(this, fieldName, type, monitor);
                    WorkingCopyPersistentField virtualField = new WorkingCopyPersistentField(this, this.getBeanClass().getMethod(JDTUtils.getGetterName((String)fieldName), ArrayUtils.EMPTY_STRING_ARRAY));
                    if (!inPK) break block6;
                    virtualField.setInPrimaryKey(inPK);
                }
                catch (CoreException ce) {
                    EJBModelException me = new EJBModelException(ce.getStatus());
                    throw me;
                }
            }
            Object var10_7 = null;
            this.exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            this.exitWorkingCopyMode();
            throw throwable;
        }
        PersistentField result = (PersistentField)this.getField(fieldName);
        return result;
    }

    public boolean isCMP() throws EJBModelException {
        this.assertExists();
        if (this.myIsCMP == null) {
            try {
                this.myIsCMP = Flags.isAbstract((int)this.getBeanClass().getFlags()) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (JavaModelException e) {
                throw new EJBModelException(this.newStatus(4, "Exception occurred while accessing Java information", (Exception)((Object)e)));
            }
        }
        return this.myIsCMP;
    }

    public void setCMP(final boolean isCMP) throws EJBModelException {
        if (isCMP == this.isCMP()) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    EntityBean.this.internalSetCMP(isCMP);
                }
            }, null);
        }
        catch (CoreException e) {
            throw new EJBModelException(this.newStatus(4, "Exception occurred while setting the property", (Exception)((Object)e)));
        }
    }

    private void internalSetCMP(boolean isCMP) throws CoreException {
        Element element = (Element)this.getBeanClass().getAdapter(class$com$tssap$selena$model$elements$Element == null ? (class$com$tssap$selena$model$elements$Element = EntityBean.class$("com.tssap.selena.model.elements.Element")) : class$com$tssap$selena$model$elements$Element);
        if (element != null) {
            element.setPropertyValue("$abstract", isCMP ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        }
    }

    public IPersistentField[] getFields() throws EJBModelException {
        this.assertExists();
        if (this.myPersistentFields == null) {
            this.addPersistentFields();
        }
        return this.myPersistentFields.values().toArray(new IPersistentField[this.myPersistentFields.size()]);
    }

    public IPersistentField getField(String fieldName) throws EJBModelException {
        this.assertExists();
        if (this.myPersistentFields == null) {
            this.addPersistentFields();
        }
        return (IPersistentField)this.myPersistentFields.get(fieldName);
    }

    public final void dispatch(EnterpriseBeanAcceptor acceptor) {
        acceptor.consider((IEntityBean)this);
    }

    private void addPersistentFields() {
        if (this.myPersistentFields != null) {
            return;
        }
        HashMap rawFields = this.collectRawFields();
        this.myPersistentFields = new HashMap(2 * rawFields.size());
        Iterator it = rawFields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            String nextName = (String)next.getKey();
            PersistentField field = (PersistentField)((Object)next.getValue());
            try {
                field.validate();
                this.myPersistentFields.put(nextName, field);
            }
            catch (EJBModelException e) {
                // empty catch block
            }
        }
    }

    private HashMap collectRawFields() {
        HashMap result = new HashMap();
        try {
            if (this.isCMP()) {
                this.collectFieldsFromAbstractAccessors(result);
            } else {
                this.collectFieldsFromJavaFields(result);
            }
        }
        catch (EJBModelException eJBModelException) {
            // empty catch block
        }
        return result;
    }

    private void collectFieldsFromJavaFields(HashMap result) {
    }

    private void collectFieldsFromAbstractAccessors(HashMap result) {
        IMethod[] methods;
        try {
            methods = this.getMethodCollector().getDeclaredMethods(this.getBeanClass());
        }
        catch (JavaModelException e) {
            return;
        }
        int i = 0;
        while (i < methods.length) {
            block10: {
                IMethod next = methods[i];
                if (JDTUtils.isAccessor((IMethod)next)) {
                    try {
                        int flags = next.getFlags();
                        if (!Flags.isAbstract((int)flags)) {
                        }
                    }
                    catch (JavaModelException e) {}
                    break block10;
                    String fieldName = JDTUtils.getFieldNameByAccessor((IMethod)next);
                    if (!result.containsKey(fieldName)) {
                        PersistentField field = new RelationshipEnd(this, next);
                        try {
                            field.validate();
                        }
                        catch (EJBModelException e) {
                            field = new PersistentField(this, next);
                        }
                        result.put(fieldName, field);
                    }
                }
            }
            ++i;
        }
    }

    protected void refresh(EJBDelta ejbDelta) {
        if (this.myIsCMP != null) {
            boolean isCMP = this.myIsCMP;
            this.myIsCMP = null;
            try {
                boolean newIsCMP = this.isCMP();
                if (isCMP != newIsCMP) {
                    ejbDelta.changed(this);
                    this.persistenceTypeChanged();
                }
            }
            catch (EJBModelException e) {
                e.printStackTrace();
            }
        }
        if (this.myIsSimplePK != null) {
            boolean isSimplePK = this.myIsSimplePK;
            this.myIsSimplePK = null;
            boolean newIsSimplePK = this.isSimplePK();
            if (isSimplePK != newIsSimplePK) {
                ejbDelta.changed(this);
                this.internalGetEJBProject().getSynchronizeTarget().primKeyClassStatusChanged((IEntityBean)this);
            }
        }
        super.refresh(ejbDelta);
        this.refreshFields(ejbDelta);
    }

    private void persistenceTypeChanged() {
        EJBImplPlugin.revisit("Update persistent fields!");
    }

    private void refreshFields(EJBDelta ejbDelta) {
        if (this.myPersistentFields == null) {
            return;
        }
        HashMap rawFields = this.collectRawFields();
        HashMap<String, PersistentField> newState = new HashMap<String, PersistentField>(2 * rawFields.size());
        Iterator it = rawFields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            String nextName = (String)next.getKey();
            PersistentField field = (PersistentField)((Object)next.getValue());
            try {
                field.validate();
                newState.put(nextName, field);
            }
            catch (EJBModelException e) {
                // empty catch block
            }
        }
        Iterator it2 = this.myPersistentFields.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry next = it2.next();
            String key = (String)next.getKey();
            PersistentField oldField = (PersistentField)((Object)next.getValue());
            PersistentField newField = (PersistentField)((Object)newState.get(key));
            if (newField == null) {
                ejbDelta.removed(oldField);
                oldField.removed();
                it2.remove();
                continue;
            }
            if (oldField.isRelationship() && !newField.isRelationship()) {
                ejbDelta.changed(oldField);
                ejbDelta.addFieldUnmadeCMR((RelationshipEnd)oldField);
                this.myPersistentFields.put(key, newField);
                continue;
            }
            if (!oldField.isRelationship() && newField.isRelationship()) {
                ejbDelta.changed(newField);
                ejbDelta.addFieldMadeCMR((RelationshipEnd)newField);
                this.myPersistentFields.put(key, newField);
                continue;
            }
            if (!oldField.merge(newField)) continue;
            ejbDelta.changed(oldField);
        }
        Iterator it3 = newState.entrySet().iterator();
        while (it3.hasNext()) {
            Map.Entry next = it3.next();
            String key = (String)next.getKey();
            if (this.myPersistentFields.containsKey(key)) continue;
            PersistentField addedField = (PersistentField)((Object)next.getValue());
            ejbDelta.added(addedField);
            this.myPersistentFields.put(key, addedField);
        }
    }

    public boolean is1_X() {
        return false;
    }

    public boolean is2_X() {
        return true;
    }

    public void set1_X(boolean is1_X) throws EJBModelException {
        throw new EJBModelException("Setting version is not supported yet");
    }

    public void set2_X(boolean is2_X) throws EJBModelException {
        throw new EJBModelException("Setting version is not supported yet");
    }

    public boolean isSimplePK() {
        if (this.myIsSimplePK == null) {
            this.myIsSimplePK = new Boolean(this.internalIsSimplePK());
        }
        return this.myIsSimplePK;
    }

    private boolean internalIsSimplePK() {
        try {
            if (this.isCMP()) {
                return this.getTag(HAS_SIMPLE_PK) != null;
            }
        }
        catch (EJBModelException eJBModelException) {
            // empty catch block
        }
        return false;
    }

    public boolean canSetSimplePK(boolean isSimplePK) {
        if (isSimplePK == this.isSimplePK()) {
            return true;
        }
        try {
            if (!this.isCMP()) {
                return false;
            }
        }
        catch (EJBModelException e) {
            return false;
        }
        if (!isSimplePK) {
            return true;
        }
        Collection pkFields = this.getPKFields();
        switch (pkFields.size()) {
            case 0: {
                return true;
            }
            case 1: {
                IPersistentField field = (IPersistentField)pkFields.iterator().next();
                String type = field.getType();
                return this.isLegalTypeForSimplePKField(type);
            }
        }
        return false;
    }

    boolean isLegalTypeForSimplePKField(String type) {
        if (type == null) {
            return false;
        }
        try {
            String typeSig = Signature.createTypeSignature((String)type, (boolean)true);
            if (Signature.getArrayCount((String)typeSig) > 0) {
                return false;
            }
            if (EntityBean.isSimpleType(typeSig)) {
                return false;
            }
            IType iType = JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)type);
            if (iType == null) {
                return false;
            }
            return !PersistentField.JAVA_LANG_OBJECT.equals(type) && !PersistentField.OBJECT.equals(type);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    Collection getPKFields() {
        IPersistentField[] fields;
        ArrayList<IPersistentField> result = new ArrayList<IPersistentField>();
        try {
            fields = this.getFields();
        }
        catch (EJBModelException cannotHappen) {
            return result;
        }
        int i = 0;
        while (i < fields.length) {
            if (fields[i].isInPrimaryKey()) {
                result.add(fields[i]);
            }
            ++i;
        }
        return result;
    }

    public void setSimplePK(boolean isSimplePK) throws EJBModelException {
        String pkClassName = this.internalGetEJBProject().getNamingConvention().getConventionalParticipantName(this.getBeanClassName(), 32);
        if (pkClassName == null) {
            pkClassName = this.getBeanClassName() + "PK";
        }
        this.setSimplePK(isSimplePK, pkClassName);
    }

    public void setSimplePK(boolean isSimplePK, String pkFQN) throws EJBModelException {
        IType localhome;
        IType home;
        if (isSimplePK == this.isSimplePK()) {
            return;
        }
        ReadOnlinessValidator validator = this.getValidatorForDDOnCMPFieldsOrQueriesChange();
        validator.addJavaElement((IMember)this.getBeanClass());
        if (!this.isSimplePK()) {
            validator.addJavaElement((IMember)this.getParticipant(32));
        }
        if ((home = this.getParticipant(2)) != null) {
            validator.addJavaElement((IMember)home);
        }
        if ((localhome = this.getParticipant(8)) != null) {
            validator.addJavaElement((IMember)localhome);
        }
        if (!validator.canModify()) {
            throw new EJBModelException("Could not modify read-only files");
        }
        this.enterWorkingCopyMode();
        try {
            this.internalGetEJBProject().getDelta().changed(this);
            if (isSimplePK) {
                Collection pkFields = this.getPKFields();
                if (pkFields.isEmpty()) {
                    Object pkField = null;
                    this.setTagValue(HAS_SIMPLE_PK, "true");
                    this.replacePrimaryKeyParticipant((class$java$lang$Object == null ? (class$java$lang$Object = EntityBean.class$("java.lang.Object")) : class$java$lang$Object).getName(), true, null, true);
                    this.myIsSimplePK = null;
                } else {
                    PersistentField pkField = (PersistentField)((Object)pkFields.iterator().next());
                    pkField.setInPrimaryKey(false, false);
                    this.setTagValue(HAS_SIMPLE_PK, "true");
                    this.myIsSimplePK = null;
                    pkField.setInPrimaryKey(true);
                }
            } else {
                Collection pkFields = this.getPKFields();
                Iterator it = pkFields.iterator();
                while (it.hasNext()) {
                    ((PersistentField)((Object)it.next())).setInPrimaryKey(false, false);
                }
                String pkClassName = pkFQN;
                if (pkClassName == null) {
                    pkClassName = this.internalGetEJBProject().getNamingConvention().getConventionalParticipantName(this.getBeanClassName(), 32);
                }
                if (pkClassName == null) {
                    pkClassName = this.getBeanClassName() + "PK";
                }
                this.replacePrimaryKeyParticipant(pkClassName, false, null, true);
                this.setTagValue(HAS_SIMPLE_PK, null);
                this.myIsSimplePK = null;
                Iterator it2 = pkFields.iterator();
                while (it2.hasNext()) {
                    ((PersistentField)((Object)it2.next())).setInPrimaryKey(true);
                }
            }
            Object var11_13 = null;
            this.exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.exitWorkingCopyMode();
            throw throwable;
        }
    }

    void replacePrimaryKeyParticipant(final String pkClassName, boolean deleteOldType, final String pkFieldName, final boolean setPKFieldName) throws EJBModelException {
        this.removeParticipant(32, deleteOldType, null);
        this.addParticipant(32, pkClassName, true, false, null, null);
        com.tssap.j2ee.core.descriptor.EnterpriseBean[] beans = AssembledInfoFinder.findAssembledBeans((IEnterpriseBean)this);
        if (beans == null) {
            return;
        }
        int i = 0;
        while (i < beans.length) {
            if (beans[i] instanceof com.tssap.j2ee.core.ejbjar.EntityBean) {
                final com.tssap.j2ee.core.ejbjar.EntityBean assembledEntity = (com.tssap.j2ee.core.ejbjar.EntityBean)beans[i];
                beans[i].modify(new Runnable(){

                    public void run() {
                        if (setPKFieldName) {
                            assembledEntity.setPrimaryKeyField(pkFieldName);
                        }
                        assembledEntity.setPrimaryKeyClass(pkClassName);
                    }
                });
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void regeneratePK() {
        block10: {
            block9: {
                this.enterWorkingCopyMode();
                try {
                    try {
                        IType pk;
                        block12: {
                            block11: {
                                pk = this.getParticipant(32);
                                if (pk == null) break block11;
                                if (pk.exists()) break block12;
                            }
                            Object var3_3 = null;
                            this.exitWorkingCopyMode();
                            return;
                        }
                        Assert.isLegal((!this.isSimplePK() ? 1 : 0) != 0);
                        if (pk.isBinary()) {
                            break block9;
                        }
                        this.regeneratePK(pk);
                        break block10;
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        Object var3_6 = null;
                        this.exitWorkingCopyMode();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    this.exitWorkingCopyMode();
                    throw throwable;
                }
            }
            Object var3_4 = null;
            this.exitWorkingCopyMode();
            return;
        }
        Object var3_5 = null;
        this.exitWorkingCopyMode();
    }

    private void regeneratePK(IType pk) throws CoreException {
        IField[] fields = pk.getFields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.length);
        ArrayList<String> fieldTypeConstants = new ArrayList<String>(fields.length);
        int i = 0;
        while (i < fields.length) {
            fieldNames.add(fields[i].getElementName());
            fieldTypeConstants.add(EntityBean.getFieldTypeConstant(fields[i]));
            ++i;
        }
        EntityBean.regenerateEquals(pk, fieldNames, fieldTypeConstants);
        this.regenerateHashCode(pk, fieldNames, fieldTypeConstants);
    }

    private static void regenerateEquals(IType pk, ArrayList fieldNames, ArrayList fieldTypeConstants) {
        try {
            IMethod equals = pk.getMethod(EQUALS_NAME, EQUALS_PARAMS);
            if (equals.exists()) {
                equals.delete(true, null);
            }
            EjbTemplatesSupport.createEquals(pk, fieldNames, fieldTypeConstants, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void regenerateHashCode(IType pk, ArrayList fieldNames, ArrayList fieldTypeConstants) {
        try {
            IMethod hc = pk.getMethod(HASHCODE_NAME, ArrayUtils.EMPTY_STRING_ARRAY);
            if (hc.exists()) {
                hc.delete(true, null);
            }
            EjbTemplatesSupport.createHashCode(pk, fieldNames, fieldTypeConstants, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    static boolean pkNeedsRegeneration(String oldFieldType, String newFieldType) throws JavaModelException {
        boolean newIsArray;
        if (oldFieldType == null || newFieldType == null) {
            return true;
        }
        String oldSig = Signature.createTypeSignature((String)oldFieldType, (boolean)false);
        String newSig = Signature.createTypeSignature((String)newFieldType, (boolean)false);
        boolean oldIsArray = Signature.getArrayCount((String)oldSig) > 0;
        boolean bl = newIsArray = Signature.getArrayCount((String)newSig) > 0;
        if (oldIsArray != newIsArray) {
            return true;
        }
        return EntityBean.isSimpleType(Signature.getElementType((String)oldSig)) != EntityBean.isSimpleType(Signature.getElementType((String)newSig));
    }

    private static String getFieldTypeConstant(IField field) throws JavaModelException {
        String type = field.getTypeSignature();
        boolean isArray = Signature.getArrayCount((String)type) > 0;
        type = Signature.getElementType((String)type);
        String result = EntityBean.isSimpleType(type) ? FIELD_TYPE_SIMPLE : FIELD_TYPE_CLASS;
        if (isArray) {
            result = result + ARRAY_SUFFIX;
        }
        return result;
    }

    static boolean isSimpleType(String typeSig) {
        return typeSig.length() == 1;
    }

    protected String getDdpKey() {
        return "EntityBean";
    }

    public IRelationshipEnd getRelationship(String fieldName) {
        try {
            if (!this.isCMP()) {
                return null;
            }
            IPersistentField field = this.getField(fieldName);
            if (field != null && field.isRelationship()) {
                return (IRelationshipEnd)field;
            }
        }
        catch (EJBModelException eJBModelException) {
            // empty catch block
        }
        return null;
    }

    public IRelationshipEnd[] getRelationships() throws EJBModelException {
        ArrayList<IPersistentField> result = new ArrayList<IPersistentField>();
        if (this.isCMP()) {
            IPersistentField[] fields = this.getFields();
            int i = 0;
            while (i < fields.length) {
                if (fields[i].isRelationship()) {
                    result.add(fields[i]);
                }
                ++i;
            }
        }
        return result.toArray(new IRelationshipEnd[result.size()]);
    }

    public IRelationshipEnd createRelationship(String fieldName, IEntityBean target, int cardinality, IProgressMonitor monitor) throws EJBModelException {
        String fieldType;
        if (!this.isCMP()) {
            throw new EJBModelException("BMP beans cannot have relationships");
        }
        IType targetLocal = target.getParticipant(16);
        if (targetLocal == null) {
            throw new EJBModelException("Cannot create relationship to the bean that does not have local interfaces");
        }
        switch (cardinality) {
            case 0: {
                fieldType = targetLocal.getFullyQualifiedName();
                break;
            }
            case 1: {
                fieldType = (class$java$util$Collection == null ? (class$java$util$Collection = EntityBean.class$("java.util.Collection")) : class$java$util$Collection).getName();
                break;
            }
            case 2: {
                fieldType = (class$java$util$Set == null ? (class$java$util$Set = EntityBean.class$("java.util.Set")) : class$java$util$Set).getName();
                break;
            }
            default: {
                throw new EJBModelException("Illegal cardinality");
            }
        }
        ReadOnlinessValidator validator = this.getValidatorForDDOnCMPFieldsOrQueriesChange();
        validator.addJavaElement((IMember)this.getBeanClass());
        if (!validator.canModify()) {
            throw this.cannotModify();
        }
        this.enterWorkingCopyMode();
        try {
            this.primCreatePersistentField(fieldName, fieldType, false, monitor);
            this.addDdp((IMember)this.getBeanClass().getMethod(JDTUtils.getGetterName((String)fieldName), ArrayUtils.EMPTY_STRING_ARRAY), "PersistentField", "defaultEjbRelationTargetBeanClass", "<{" + target.getBeanClassName() + "}>");
            if (cardinality != 0) {
                this.addDdp((IMember)this.getBeanClass().getMethod(JDTUtils.getGetterName((String)fieldName), ArrayUtils.EMPTY_STRING_ARRAY), "PersistentField", "@associates", "<{" + targetLocal.getFullyQualifiedName() + "}>");
            }
            Object var9_8 = null;
            this.exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.exitWorkingCopyMode();
            throw throwable;
        }
        RelationshipEnd result = (RelationshipEnd)this.getRelationship(fieldName);
        result.promoteAccessors(16);
        return result;
    }

    ReadOnlinessValidator getValidatorForDDOnCMPFieldsOrQueriesChange() {
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        try {
            if (!this.isCMP()) {
                return validator;
            }
        }
        catch (EJBModelException e) {
            return validator;
        }
        com.tssap.j2ee.core.descriptor.EnterpriseBean[] beans = AssembledInfoFinder.findAssembledBeans((IEnterpriseBean)this);
        if (beans == null) {
            return validator;
        }
        int i = 0;
        while (i < beans.length) {
            validator.addResource(beans[i].getDocument().getFile());
            ++i;
        }
        return validator;
    }

    protected AbstractEjbMethodCollector createMethodCollector() {
        return new EntityBeanMethodCollector(this);
    }

    protected String[] getMandatorySuperinterface() {
        return MANDATORY;
    }

    protected IOverrideMethodQuery getOverrideMethodQuery() {
        return new IOverrideMethodQuery(){

            public IMethod[] select(IMethod[] elements, IMethod[] defaultSelected, ITypeHierarchy typeHierarchy) {
                try {
                    if (EntityBean.this.isCMP()) {
                        ArrayList<IMethod> result = new ArrayList<IMethod>();
                        int i = 0;
                        while (i < defaultSelected.length) {
                            if (!JDTUtils.isAccessor((IMethod)defaultSelected[i])) {
                                result.add(defaultSelected[i]);
                            }
                            ++i;
                        }
                        return result.toArray(new IMethod[result.size()]);
                    }
                }
                catch (EJBModelException e) {
                    // empty catch block
                }
                return defaultSelected;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void primRewriteWithEjbJarContents(Object assembledBean, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Rewriting bean with ejb-jar contents", 7);
        try {
            block5: {
                try {
                    super.primRewriteWithEjbJarContents(assembledBean, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                    com.tssap.j2ee.core.ejbjar.EntityBean asmBean = (com.tssap.j2ee.core.ejbjar.EntityBean)assembledBean;
                    this.rewriteParticipant(32, asmBean.getPrimaryKeyClass(), monitor);
                    if (!"Container".equals(asmBean.getPersistenceType())) break block5;
                    this.rewriteCMP(asmBean, monitor);
                }
                catch (CoreException e) {
                    EJBImplPlugin.logWarning("Exception occurred while rewriting bean", e);
                    Object var5_6 = null;
                    monitor.done();
                    return;
                }
            }
            Object var5_5 = null;
            monitor.done();
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
    }

    private void rewriteCMP(com.tssap.j2ee.core.ejbjar.EntityBean asmBean, IProgressMonitor monitor) throws EJBModelException, JavaModelException {
        if (!"2.x".equals(asmBean.getCmpVersion())) {
            EJBImplPlugin.logWarning("CMP version 1.x not currently supported, bean ignored");
            return;
        }
        if (!this.isCMP()) {
            EJBImplPlugin.logWarning("The bean is declared to be CMP, but is found to be BMP");
            return;
        }
        this.updateCMPPrimaryKeyField(asmBean);
        monitor.worked(1);
        this.updateCMRs(asmBean);
        monitor.worked(2);
    }

    private void updateCMPPrimaryKeyField(com.tssap.j2ee.core.ejbjar.EntityBean asmBean) throws EJBModelException {
        boolean isSimplePK = false;
        boolean isUnknown = false;
        PersistentField pkField = null;
        if ((class$java$lang$Object == null ? (class$java$lang$Object = EntityBean.class$("java.lang.Object")) : class$java$lang$Object).getName().equals(asmBean.getPrimaryKeyClass())) {
            isSimplePK = true;
            isUnknown = true;
        } else {
            String pkFieldName = asmBean.getPrimaryKeyField();
            if (pkFieldName != null) {
                pkField = (PersistentField)this.getField(pkFieldName);
                if (pkField == null || !asmBean.getPrimaryKeyClass().equals(pkField.getType())) {
                    EJBImplPlugin.logWarning("Could not find the primary key field or its type is not the PK class");
                    return;
                }
                isSimplePK = true;
            }
        }
        if (!isSimplePK) {
            return;
        }
        this.setTagValue(HAS_SIMPLE_PK, "true");
        this.myIsSimplePK = null;
        IPersistentField[] fields = this.getFields();
        int i = 0;
        while (i < fields.length) {
            PersistentField next = (PersistentField)fields[i];
            if (pkField == null || !((Object)((Object)next)).equals((Object)pkField)) {
                IMethod definingMember = next.getGetter();
                if (definingMember == null) {
                    definingMember = next.getSetter();
                }
                this.setTag((IMember)definingMember, "@primKeyField", null);
            }
            ++i;
        }
        if (isUnknown) {
            this.rewriteParticipant(32, (class$java$lang$Object == null ? (class$java$lang$Object = EntityBean.class$("java.lang.Object")) : class$java$lang$Object).getName(), (IProgressMonitor)new NullProgressMonitor());
        }
        if (pkField != null) {
            IMethod definingMember = pkField.getGetter();
            if (definingMember == null) {
                definingMember = pkField.getSetter();
            }
            this.setTag((IMember)definingMember, "@primKeyField", "");
        }
    }

    private void setTag(IMember member, String tagName, String tagValue) {
        IJavaComment comment = JavaCommentParserFactory.getJavaComment((IMember)member);
        if (comment == null) {
            return;
        }
        Enumeration enumeration = comment.getTags(tagName);
        if (enumeration.hasMoreElements()) {
            ((ITag)enumeration.nextElement()).setValue(tagValue);
        } else if (tagValue != null) {
            comment.addTag(tagName, tagValue);
        }
        comment.synchronize(true);
    }

    private void updateCMRs(com.tssap.j2ee.core.ejbjar.EntityBean asmBean) throws EJBModelException {
        String beanName = asmBean.getName();
        EjbJar ejbJar = (EjbJar)asmBean.getParent();
        EjbRelation[] relations = ejbJar.getEjbRelations();
        if (relations == null) {
            return;
        }
        int i = 0;
        while (i < relations.length) {
            EjbRelation rel = relations[i];
            EjbRelationshipRole role1 = rel.getRole1();
            EjbRelationshipRole role2 = rel.getRole2();
            if (beanName.equals(role1.getSourceEjbName())) {
                this.updateCMRField(role1, role2);
            }
            if (beanName.equals(role2.getSourceEjbName())) {
                this.updateCMRField(role2, role1);
            }
            ++i;
        }
    }

    private void updateCMRField(EjbRelationshipRole role, EjbRelationshipRole theOtherRole) throws EJBModelException {
        String cmrFieldName = role.getCmrFieldName();
        if (cmrFieldName == null) {
            return;
        }
        PersistentField field = (PersistentField)this.getField(cmrFieldName);
        if (field == null) {
            EJBImplPlugin.logWarning("Could not find CMR field " + cmrFieldName);
            return;
        }
        com.tssap.j2ee.core.ejbjar.EntityBean theOtherBean = theOtherRole.getSourceEjb();
        if (theOtherBean == null) {
            EJBImplPlugin.logWarning("Relation leads nowhere");
            return;
        }
        String theOtherBeanClass = theOtherBean.getEjbClass();
        IMethod getter = this.getBeanClass().getMethod(JDTUtils.getGetterName((String)cmrFieldName), ArrayUtils.EMPTY_STRING_ARRAY);
        if (getter == null) {
            EJBImplPlugin.logWarning("The relation does not have the getter");
            return;
        }
        this.addDdp((IMember)getter, "PersistentField", "defaultEjbRelationTargetBeanClass", "<{" + theOtherBeanClass + "}>");
        String theOtherBeanLocal = theOtherBean.getLocalInterface();
        String cmrFieldType = role.getCmrFieldType();
        if (cmrFieldType != null) {
            this.addDdp((IMember)getter, "PersistentField", "@associates", "<{" + theOtherBeanLocal + "}>");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

