/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EnterpriseBeanAcceptor;
import com.tssap.j2ee.core.ejb.ICopiedEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.inheritance.InhType;
import com.tssap.j2ee.core.utils.ReadOnlinessValidator;
import com.tssap.j2ee.core.utils.ddp.DdpRegistry;
import com.tssap.j2ee.internal.core.ejb.AbstractEjbMethodCollector;
import com.tssap.j2ee.internal.core.ejb.EJBDelta;
import com.tssap.j2ee.internal.core.ejb.EJBElement;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.EjbProjectImpl;
import com.tssap.j2ee.internal.core.ejb.ReadOnlyEJB;
import com.tssap.j2ee.internal.core.ejb.refactor.ParticipantRefactorer;
import com.tssap.j2ee.internal.core.ejb.util.IMemberHolder;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.ejb.util.JavaCommentParserFactory;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ITag;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.codemanipulation.IOverrideMethodQuery;

public abstract class EnterpriseBean
extends EJBElement
implements IEnterpriseBean {
    private int myKind;
    private IType myBeanClass;
    private IType myWCBeanClass;
    private IJavaComment myJavaComment;
    private Boolean myCachedExists;
    private int myWorkingCopyModeNestLevel;
    private AbstractEjbMethodCollector myCollector;
    static /* synthetic */ Class class$com$tssap$selena$model$elements$Element;
    static /* synthetic */ Class class$java$lang$Object;

    public EnterpriseBean(EjbProjectImpl parent, int kind, IType beanClass) {
        this(parent, kind, beanClass, true);
    }

    protected EnterpriseBean(EjbProjectImpl parent, int kind, IType beanClass, boolean listenToJDT) {
        super(parent);
        if (listenToJDT) {
            this.addDispatchedDeltaListener(beanClass);
        }
        this.myKind = kind;
        Assert.isLegal((beanClass != null ? 1 : 0) != 0);
        this.myBeanClass = beanClass;
    }

    protected void addDispatchedDeltaListener(IType type) {
        ((EjbProjectImpl)this.getEJBProject()).getDeltaDispatcher().register(this, type);
    }

    protected void removeDispatchedDeltaListener(IType type) {
        ((EjbProjectImpl)this.getEJBProject()).getDeltaDispatcher().unregister(this, type);
    }

    protected void removed() {
    }

    protected void afterRemoved() {
        this.removeDispatchedDeltaListener(this.getBeanClass());
    }

    public int getKind() {
        return this.myKind;
    }

    public IType getBeanClass() {
        if (this.isWorkingCopyMode()) {
            return this.myWCBeanClass == null ? this.myBeanClass : this.myWCBeanClass;
        }
        return this.myBeanClass;
    }

    public String getBeanClassName() {
        return this.myBeanClass.getFullyQualifiedName();
    }

    public boolean canSetBeanClassName(String fqn) {
        if (fqn == null) {
            return false;
        }
        if (fqn.endsWith(".java")) {
            fqn = fqn.substring(0, fqn.length() - ".java".length());
        }
        if (fqn.equals(this.getBeanClassName())) {
            return true;
        }
        if (JDTUtils.findType((IJavaProject)this.getJavaProject(), (String)fqn) != null) {
            return false;
        }
        if (this.getBeanClass().isBinary()) {
            return false;
        }
        String pak = JDTUtils.getPackageName((String)fqn);
        IPackageFragment pf = JDTUtils.findSourcePackage((IJavaProject)this.getJavaProject(), (String)pak);
        if (pf == null) {
            return false;
        }
        String name = JDTUtils.getTypeName((String)fqn);
        String anyUnusedName = JDTUtils.generateDefaultName((IPackageFragment)this.getBeanClass().getPackageFragment(), (String)name);
        ParticipantRefactorer refactorer = new ParticipantRefactorer(this, anyUnusedName);
        return refactorer.canPerform();
    }

    public IEnterpriseBean setBeanClassName(String fqn, IProgressMonitor monitor) throws EJBModelException {
        if (fqn.endsWith(".java")) {
            fqn = fqn.substring(0, fqn.length() - ".java".length());
        }
        if (fqn.equals(this.getBeanClassName())) {
            return this;
        }
        ReadOnlyEJB result = new ReadOnlyEJB(this, fqn);
        this.internalGetEJBProject().getDelta().renamed(this, result);
        String name = JDTUtils.getTypeName((String)fqn);
        IPackageFragment aPackage = ((EjbProjectImpl)this.getEJBProject()).getSuitablePackage(fqn);
        this.renameClass(this.myBeanClass, aPackage, name, monitor);
        return result;
    }

    protected void renameClass(IType actual, IPackageFragment pf, String name, IProgressMonitor monitor) throws EJBModelException {
        String pak = pf.getElementName();
        String actualPak = actual.getPackageFragment().getElementName();
        Entity element = (Entity)actual.getAdapter(class$com$tssap$selena$model$elements$Element == null ? (class$com$tssap$selena$model$elements$Element = EnterpriseBean.class$("com.tssap.selena.model.elements.Element")) : class$com$tssap$selena$model$elements$Element);
        if (!pak.equals(actualPak)) {
            Entity pakEntity = (Entity)JDTUtils.findSourcePackage((IJavaProject)this.getJavaProject(), (String)pak).getAdapter(class$com$tssap$selena$model$elements$Element == null ? (class$com$tssap$selena$model$elements$Element = EnterpriseBean.class$("com.tssap.selena.model.elements.Element")) : class$com$tssap$selena$model$elements$Element);
            Entity cutElement = element.cut();
            cutElement.setPropertyValue("$nametemplate", name);
            pakEntity.paste((Element)cutElement);
            cutElement.setPropertyValue("$nametemplate", null);
        } else {
            element.setPropertyValue("$name", name);
        }
    }

    public final boolean exists() {
        if (this.myCachedExists == null) {
            this.myCachedExists = new Boolean(this.internalExists());
        }
        return this.myCachedExists;
    }

    protected boolean internalExists() {
        EJBImplPlugin.revisit("Consider property @abstractBean");
        if (!this.myBeanClass.exists()) {
            return false;
        }
        return this.internalGetEJBProject().getHierarchyManager().contains(this.myBeanClass, this.getKind());
    }

    public void delete(IProgressMonitor monitor) throws EJBModelException {
        this.assertExists();
        this.deleteRequirements();
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor m) throws CoreException {
                    EnterpriseBean.deleteDeployedBeans(AssembledInfoFinder.findAssembledBeans((IEnterpriseBean)EnterpriseBean.this));
                    JDTUtils.deleteType((IType)EnterpriseBean.this.getBeanClass());
                }
            }, monitor);
        }
        catch (CoreException e) {
            throw new EJBModelException(this.newStatus(4, "There were exceptions while deleting enterprise bean", (Exception)((Object)e)));
        }
    }

    protected void deleteRequirements() throws EJBModelException {
        com.tssap.j2ee.core.descriptor.EnterpriseBean[] assembledBeans = AssembledInfoFinder.findAssembledBeans((IEnterpriseBean)this);
        if (!EnterpriseBean.validateEdit((DescriptorEntity[])assembledBeans)) {
            throw this.cannotModify();
        }
        if (this.getBeanClass().isBinary()) {
            throw this.cannotModify();
        }
    }

    protected static void deleteDeployedBeans(com.tssap.j2ee.core.descriptor.EnterpriseBean[] assembledBeans) {
        if (assembledBeans != null) {
            int i = 0;
            while (i < assembledBeans.length) {
                assembledBeans[i].delete();
                ++i;
            }
        }
    }

    protected static boolean validateEdit(DescriptorEntity[] entities) {
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        if (entities != null) {
            int i = 0;
            while (i < entities.length) {
                validator.addResource(entities[i].getDocument().getFile());
                ++i;
            }
        }
        return validator.canModify();
    }

    public boolean isImported() {
        return !this.getEJBProject().getJavaProject().getElementName().equals(this.getBeanClass().getJavaProject().getElementName());
    }

    protected ITag getTag(String tag) {
        IJavaComment comment = this.getJavaComment();
        if (comment == null) {
            return null;
        }
        Enumeration enumeration = comment.getTags(tag);
        if (enumeration.hasMoreElements()) {
            return (ITag)enumeration.nextElement();
        }
        return null;
    }

    protected String getTagValue(String tagName) {
        ITag tag = this.getTag(tagName);
        if (tag == null) {
            return null;
        }
        return tag.getValue();
    }

    protected void setTagValue(String tagName, String tagValue) {
        IJavaComment comment = this.getJavaComment();
        if (comment == null) {
            return;
        }
        this.internalGetEJBProject().getDelta().changed(this);
        Enumeration enumeration = comment.getTags(tagName);
        if (enumeration.hasMoreElements()) {
            ((ITag)enumeration.nextElement()).setValue(tagValue);
        } else {
            comment.addTag(tagName, tagValue);
        }
        comment.synchronize(true);
    }

    protected IJavaComment getJavaComment() {
        if (this.myJavaComment != null && !this.isInSyncWithWCMode(this.myJavaComment)) {
            this.myJavaComment = null;
        }
        if (this.myJavaComment == null) {
            this.myJavaComment = JavaCommentParserFactory.getJavaComment((IMember)this.getBeanClass());
        }
        return this.myJavaComment;
    }

    private boolean isInSyncWithWCMode(IJavaComment myJavaComment) {
        ICompilationUnit javaCommentCU = ((IMemberHolder)myJavaComment.getSynchronizer()).getMember().getCompilationUnit();
        if (javaCommentCU == null) {
            return false;
        }
        return this.isWorkingCopyMode() == javaCommentCU.isWorkingCopy();
    }

    protected void flushComment() {
        this.myJavaComment = null;
    }

    public IJavaProject getJavaProject() {
        return this.getEJBProject().getJavaProject();
    }

    public void renamed(String newFQN) {
        this.internalGetEJBProject().getDelta().renamed(new ReadOnlyEJB(this, this.getBeanClassName()), new ReadOnlyEJB(this, newFQN));
    }

    protected void refresh(EJBDelta delta) {
        this.getMethodCollector().refresh(delta);
    }

    protected static List asList(String[] types, String[] names) {
        if (types == null) {
            return Collections.EMPTY_LIST;
        }
        if (names != null && types.length != names.length) {
            throw new IllegalArgumentException("Types and names are of unequal length");
        }
        ArrayList<String> result = new ArrayList<String>(types.length);
        int i = 0;
        while (i < types.length) {
            String nextName = names == null ? "arg" + i : names[i];
            result.add(types[i] + " " + nextName);
            ++i;
        }
        return result;
    }

    protected static List asList(String[] types) {
        if (types == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>(types.length);
        int i = 0;
        while (i < types.length) {
            result.add(types[i]);
            ++i;
        }
        return result;
    }

    protected static boolean equivalentClasses(String one, String another) {
        return Signature.getSimpleName((String)one).equals(Signature.getSimpleName((String)another));
    }

    public String getName() {
        return this.getBeanClass().getElementName();
    }

    public boolean isEjbVersion1_X() {
        return false;
    }

    public boolean isEjbVersion2_X() {
        return true;
    }

    protected Object getDdpSource() {
        return this.getBeanClass();
    }

    protected final void enterWorkingCopyMode() {
        Assert.isLegal((this.myWorkingCopyModeNestLevel >= 0 ? 1 : 0) != 0);
        if (this.myWorkingCopyModeNestLevel == 0) {
            this.workingCopyModeEntered();
        }
        ++this.myWorkingCopyModeNestLevel;
    }

    protected final void exitWorkingCopyMode() {
        --this.myWorkingCopyModeNestLevel;
        Assert.isLegal((this.myWorkingCopyModeNestLevel >= 0 ? 1 : 0) != 0);
        if (this.myWorkingCopyModeNestLevel == 0) {
            this.workingCopyModeExited();
        }
    }

    protected void workingCopyModeEntered() {
        this.myJavaComment = null;
        this.myWCBeanClass = this.createWorkingCopyType(this.myBeanClass);
    }

    protected void workingCopyModeExited() {
        this.myJavaComment = null;
        if (this.myWCBeanClass == null) {
            return;
        }
        this.commitWorkingCopyType(this.myWCBeanClass);
        this.myWCBeanClass = null;
    }

    protected IType createWorkingCopyType(IType type) {
        ICompilationUnit cu = type.getCompilationUnit();
        if (cu == null) {
            return null;
        }
        try {
            IWorkingCopy wc = (IWorkingCopy)cu.getWorkingCopy();
            if (wc == null) {
                EJBImplPlugin.logError("Could not create working copy for the compilation unit of type " + type.getFullyQualifiedName());
                return null;
            }
            IJavaElement[] typeEquivalents = wc.findElements((IJavaElement)type);
            if (typeEquivalents == null || typeEquivalents.length != 1) {
                EJBImplPlugin.logError("Could not find type equivalent in working copy for the compilation unit of type " + type.getFullyQualifiedName());
                return null;
            }
            return (IType)typeEquivalents[0];
        }
        catch (JavaModelException e) {
            EJBImplPlugin.logError("Exception occurred while creating working copy for the compilation unit of type " + type.getFullyQualifiedName(), e);
            return null;
        }
    }

    protected void commitWorkingCopyType(IType type) {
        ICompilationUnit wc = type.getCompilationUnit();
        Assert.isLegal((wc != null && wc.isWorkingCopy() ? 1 : 0) != 0);
        try {
            IBuffer wcBuffer = wc.getBuffer();
            if (wcBuffer != null && wcBuffer.hasUnsavedChanges()) {
                wc.commit(false, null);
            }
            wc.destroy();
        }
        catch (JavaModelException e) {
            EJBImplPlugin.logError("Exception occurred while committing working copy for the compilation unit of type " + type.getFullyQualifiedName(), e);
        }
    }

    protected final boolean isWorkingCopyMode() {
        return this.myWorkingCopyModeNestLevel > 0;
    }

    protected IMember translateIfWorkingCopyMode(IMember member) {
        if (member == null || member.isBinary() || !this.isWorkingCopyMode()) {
            return member;
        }
        ICompilationUnit wc = this.findWorkingCopy(member);
        if (wc == null) {
            return null;
        }
        IJavaElement[] counterparts = wc.findElements((IJavaElement)member);
        if (counterparts == null || counterparts.length != 1) {
            EJBImplPlugin.logError("In working copy mode, could not find counterpart for source member " + member.getHandleIdentifier());
            return null;
        }
        return (IMember)counterparts[0];
    }

    protected ICompilationUnit findWorkingCopy(IMember member) {
        if (!member.getCompilationUnit().equals(this.myBeanClass.getCompilationUnit())) {
            throw new IllegalArgumentException();
        }
        return this.myWCBeanClass.getCompilationUnit();
    }

    protected EJBModelException cannotModify() {
        return new EJBModelException("Could not modify read-only files");
    }

    protected void addDdp(IMember member, String key, String modelProperty, String value) {
        IJavaComment comment;
        String tagName = DdpRegistry.getDescriptor((String)key, (String)modelProperty).getAccessorData();
        if (tagName == null || tagName.length() == 0) {
            EJBImplPlugin.logWarning("Could not set ddp, accessor data==null", new NullPointerException());
            return;
        }
        if (tagName.charAt(0) != '@') {
            tagName = '@' + tagName;
        }
        if ((comment = JavaCommentParserFactory.getJavaComment((IMember)member)) == null) {
            return;
        }
        Enumeration enumeration = comment.getTags(tagName);
        if (enumeration.hasMoreElements()) {
            ((ITag)enumeration.nextElement()).setValue(value);
        } else {
            comment.addTag(tagName, value);
        }
        comment.synchronize(true);
    }

    public String getHandleIdentifier() {
        return this.getBeanClassName();
    }

    protected final void resetMethodCollector() {
        if (this.isWorkingCopyMode()) {
            EJBImplPlugin.logWarning("In WCM, trying to reset method collector: may lead to subsequent errors!");
        }
        this.myCollector = null;
    }

    protected AbstractEjbMethodCollector getMethodCollector() {
        if (this.myCollector == null) {
            this.myCollector = this.createMethodCollector();
        }
        return this.myCollector;
    }

    protected abstract AbstractEjbMethodCollector createMethodCollector();

    public final IEJBMethod[] getEJBMethods() throws EJBModelException {
        Collection result = this.getMethodCollector().getMethods();
        return result.toArray(new IEJBMethod[result.size()]);
    }

    public final IEJBMethod getEJBMethodByJavaTypes(String name, String[] parameterTypeFQNs) {
        return this.getMethodCollector().getMethod(name, parameterTypeFQNs);
    }

    public EJBMethod getEJBMethodByIMethod(IMethod method) {
        String name = method.getElementName();
        String[] parameterTypeSignatures = method.getParameterTypes();
        String[] parameterTypeFQNs = EnterpriseBean.qualify(JDTUtils.jdt2java((String[])parameterTypeSignatures), method.getDeclaringType());
        return (EJBMethod)this.getEJBMethodByJavaTypes(name, parameterTypeFQNs);
    }

    protected String[] qualify(String[] types) {
        return EnterpriseBean.qualify(types, this.getBeanClass());
    }

    protected static String[] qualify(String[] types, IType context) {
        if (types == null) {
            return null;
        }
        String[] result = new String[types.length];
        int i = 0;
        while (i < result.length) {
            result[i] = EnterpriseBean.qualify(types[i], context);
            ++i;
        }
        return result;
    }

    protected String qualify(String type) {
        return EnterpriseBean.qualify(type, this.getBeanClass());
    }

    protected static String qualify(String type, IType context) {
        return JDTUtils.getFQN((IType)context, (String)type);
    }

    public boolean canCopy(boolean forPackageCopy) {
        return !this.getBeanClass().isBinary();
    }

    public boolean canCut(boolean forPackageCut) {
        return !this.getBeanClass().isBinary();
    }

    public ICopiedEnterpriseBean copy(boolean forPackageCopy) throws EJBModelException {
        throw new EJBModelException("Cannot copy: not supported");
    }

    public ICopiedEnterpriseBean cut(boolean forPackageCut) throws EJBModelException {
        throw new EJBModelException("Cannot cut: not supported");
    }

    public IType getBeanSuperclass() {
        InhType inhType = this.internalGetEJBProject().getInhModel().findType(this.getBeanClassName());
        if (inhType == null) {
            return null;
        }
        String[] baseNodes = inhType.getBaseNodesAsArray();
        if (baseNodes == null || baseNodes.length == 0) {
            return null;
        }
        String superclass = baseNodes[0];
        try {
            return this.getEJBProject().getJavaProject().findType(superclass);
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public boolean canSetBeanSuperclass(IType type) {
        if (this.getBeanSuperclass().equals(type)) {
            return true;
        }
        if (this.getBeanClass().isBinary()) {
            return false;
        }
        if (type == null) {
            return true;
        }
        try {
            if (!type.exists() || type.isInterface() || type.getDeclaringType() != null) {
                return false;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
        InhType inhSupertype = this.internalGetEJBProject().getInhModel().findType(type.getFullyQualifiedName('.'));
        if (inhSupertype == null) {
            return false;
        }
        return !inhSupertype.derivedFrom(this.getBeanClassName());
    }

    public void setBeanSuperclass(IType type) throws EJBModelException {
        IType effectiveType;
        if (!this.canSetBeanSuperclass(type)) {
            throw new EJBModelException("Cannot set property value");
        }
        try {
            IType object = this.getEJBProject().getJavaProject().findType((class$java$lang$Object == null ? (class$java$lang$Object = EnterpriseBean.class$("java.lang.Object")) : class$java$lang$Object).getName());
            effectiveType = type == null ? object : type;
        }
        catch (JavaModelException e) {
            throw new EJBModelException("Exception occurred while trying to set supertype", (Throwable)e);
        }
        if (this.getBeanSuperclass().equals(effectiveType)) {
            return;
        }
        try {
            IOverrideMethodQuery query = this.getOverrideMethodQuery();
            JDTUtils.setExtendsImplementsClause((IType)this.getBeanClass(), (IType)type, (boolean)true, null, (boolean)false, (boolean)false, (boolean)true, (IOverrideMethodQuery)query);
        }
        catch (CoreException e) {
            if (e instanceof EJBModelException) {
                throw (EJBModelException)((Object)e);
            }
            throw new EJBModelException("Exception occurred while setting superclass", (Throwable)e);
        }
    }

    public IType[] getBeanSuperinterfaces() {
        return EnterpriseBean.getSuperinterfaces(this.internalGetEJBProject(), this.myBeanClass);
    }

    protected static IType[] getSuperinterfaces(EjbProjectImpl project, IType type) {
        int startingIndex;
        boolean isInterface;
        try {
            isInterface = type.isInterface();
        }
        catch (JavaModelException e) {
            return null;
        }
        InhType inhType = project.getInhModel().findType(type.getFullyQualifiedName());
        if (inhType == null) {
            return null;
        }
        inhType.getBaseNodes();
        String[] baseNodes = inhType.getBaseNodesAsArray();
        if (baseNodes == null || baseNodes.length == 0) {
            return null;
        }
        ArrayList<IType> superinterfaces = new ArrayList<IType>();
        int i = startingIndex = isInterface ? 0 : 1;
        while (i < baseNodes.length) {
            String superIntfName = baseNodes[i];
            try {
                IType superIntf = project.getJavaProject().findType(superIntfName);
                if (superIntf != null) {
                    superinterfaces.add(superIntf);
                }
            }
            catch (JavaModelException e) {
                // empty catch block
            }
            ++i;
        }
        return superinterfaces.toArray(new IType[superinterfaces.size()]);
    }

    public boolean canSetBeanSuperinterfaces(IType[] types) {
        try {
            types = this.addMandatoryTypeToArray(types, this.getMandatorySuperinterface());
        }
        catch (JavaModelException e) {
            return false;
        }
        return EnterpriseBean.canSetSuperinterfaces(this.myBeanClass, types, this.getBeanSuperinterfaces());
    }

    protected abstract String[] getMandatorySuperinterface();

    protected IType[] addMandatoryTypeToArray(IType[] types, String[] mandatory) throws JavaModelException {
        ArrayList<IType> result = new ArrayList<IType>();
        if (types != null) {
            result.addAll(Arrays.asList(types));
        }
        int i = 0;
        while (i < mandatory.length) {
            IType next = this.getEJBProject().getJavaProject().findType(mandatory[i]);
            if (next == null) {
                return null;
            }
            if (!result.contains(next)) {
                result.add(next);
            }
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    protected static boolean canSetSuperinterfaces(IType type, IType[] supertypes, IType[] actual) {
        if (EnterpriseBean.equalTypeArrays(supertypes, actual)) {
            return true;
        }
        if (type.isBinary()) {
            return false;
        }
        if (supertypes == null || supertypes.length == 0) {
            return true;
        }
        try {
            int i = 0;
            while (i < supertypes.length) {
                if (!supertypes[i].exists() || !supertypes[i].isInterface() || supertypes[i].getDeclaringType() != null) {
                    return false;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
        return true;
    }

    public void setBeanSuperinterfaces(IType[] supertypes) throws EJBModelException {
        if (!this.canSetBeanSuperinterfaces(supertypes)) {
            throw new EJBModelException("Cannot set property value");
        }
        try {
            supertypes = this.addMandatoryTypeToArray(supertypes, this.getMandatorySuperinterface());
        }
        catch (JavaModelException e) {
            throw new EJBModelException("Cannot set property value", (Throwable)e);
        }
        this.setSuperinterfaces(this.myBeanClass, supertypes);
    }

    protected void setSuperinterfaces(IType type, IType[] supertypes) throws EJBModelException {
        try {
            IOverrideMethodQuery query = this.getOverrideMethodQuery();
            JDTUtils.setExtendsImplementsClause((IType)type, null, (boolean)false, (IType[])supertypes, (boolean)true, (boolean)false, (boolean)true, (IOverrideMethodQuery)query);
        }
        catch (CoreException e) {
            if (e instanceof EJBModelException) {
                throw (EJBModelException)((Object)e);
            }
            throw new EJBModelException("Exception occurred while setting superclass", (Throwable)e);
        }
    }

    private static boolean equalTypeArrays(IType[] proposed, IType[] actual) {
        List<IType> proposedCollected;
        if (proposed == null || actual == null) {
            return false;
        }
        List<IType> actualCollected = Arrays.asList(actual);
        return actualCollected.containsAll(proposedCollected = Arrays.asList(proposed)) && proposedCollected.containsAll(actualCollected);
    }

    protected IOverrideMethodQuery getOverrideMethodQuery() {
        return null;
    }

    public abstract void rewriteWithEjbJarContents(Object var1, IProgressMonitor var2);

    public abstract String setName(String var1, IProgressMonitor var2) throws EJBModelException;

    public abstract boolean canSetName(String var1);

    public abstract void dispatch(EnterpriseBeanAcceptor var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

