/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBDeltaEvent;
import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejb.IEJBDelta;
import com.tssap.j2ee.core.ejb.IEJBDeltaListener;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEJBInterfacesHierarchyHolder;
import com.tssap.j2ee.core.ejb.IEJBSynchronizeListener;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEnterpriseBeanHierarchyListener;
import com.tssap.j2ee.core.ejb.IEnterpriseBeanHierarchyManager;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IMessageDrivenBean;
import com.tssap.j2ee.core.ejb.ISessionBean;
import com.tssap.j2ee.core.inheritance.InhModel;
import com.tssap.j2ee.core.inheritance.InhModelAccess;
import com.tssap.j2ee.core.inheritance.change.InhChangesListener;
import com.tssap.j2ee.core.utils.AbstractJ2eeProject;
import com.tssap.j2ee.internal.core.ejb.CompositeSynchronizeTarget;
import com.tssap.j2ee.internal.core.ejb.EJBDelta;
import com.tssap.j2ee.internal.core.ejb.EJBHierarchyHolder;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.EntityBean;
import com.tssap.j2ee.internal.core.ejb.HierarchyManager;
import com.tssap.j2ee.internal.core.ejb.InhDeltaDispatcher;
import com.tssap.j2ee.internal.core.ejb.MessageDrivenBean;
import com.tssap.j2ee.internal.core.ejb.NamingConvention;
import com.tssap.j2ee.internal.core.ejb.SessionBean;
import com.tssap.j2ee.internal.core.ejb.util.CommentApplier;
import com.tssap.j2ee.internal.core.ejb.util.EjbTemplatesSupport;
import com.tssap.j2ee.internal.core.ejb.util.IDOMPackage;
import com.tssap.j2ee.internal.core.ejb.util.IPackageProcessor;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;
import org.eclipse.jdt.internal.corext.codemanipulation.IOverrideMethodQuery;

public class EjbProjectImpl
extends EjbProject
implements IEJBElement,
IEnterpriseBeanHierarchyListener {
    private HashSet myListeners = new HashSet();
    private HierarchyManager myHierarchyManager;
    private HashMap myBeanTypes2EJBs;
    private EJBDelta myDelta = new EJBDelta(this);
    private NamingConvention myNamingConvention;
    private EJBHierarchyHolder myHierarchyHolder;
    private CompositeSynchronizeTarget mySynchronizeTarget = new CompositeSynchronizeTarget();
    private int myCommandNestLevel = 0;
    private InhModel myModel;
    private InhDeltaDispatcher myInhDeltaDispatcher;
    private static final IPackageProcessor SOURCE_PACKAGE_RETURNER = new IPackageProcessor(){

        public Object processSourcePackage(IPackageFragment fragment) {
            return fragment;
        }

        public Object processBinaryPackage(IPackageFragment fragment) {
            return null;
        }
    };

    protected void setProject(IProject project) {
        super.setProject(project);
        this.myHierarchyManager = new HierarchyManager(this);
        this.myHierarchyManager.addEnterpriseBeanHierarchyListener(this);
        IEJBSynchronizeListener[] synchronizers = EJBImplPlugin.getDefault().getSynchronizeListeners();
        int i = 0;
        while (i < synchronizers.length) {
            IEJBSynchronizeListener next = synchronizers[i];
            this.addSynchronizer(next);
            if (next instanceof IEJBDeltaListener) {
                this.addEJBDeltaListener((IEJBDeltaListener)next);
            }
            ++i;
        }
        this.myModel = InhModelAccess.getModel((String)this.getProject().getName());
        this.myInhDeltaDispatcher = new InhDeltaDispatcher(this);
        this.myModel.addInhChangeListener((InhChangesListener)this.myInhDeltaDispatcher);
    }

    protected void configureProject() throws CoreException {
        if (!this.isJ2eeApiAvailable()) {
            this.addJ2eeLibrary();
        }
        CodePlugin.getInstance().getTemplateEngine();
    }

    public EjbProject getEJBProject() {
        return this;
    }

    public IEJBElement getParent() {
        return this;
    }

    protected void assertExists() throws EJBModelException {
        if (!this.exists()) {
            throw new EJBModelException(this.newStatus(4, "Element does not exist"));
        }
    }

    protected IStatus newStatus(int severity, String msg) {
        return new Status(severity, EJBImplPlugin.getPluginId(), 0, msg, null);
    }

    protected IStatus newStatus(int severity, String msg, Exception exception) {
        return new Status(severity, EJBImplPlugin.getPluginId(), 0, msg, (Throwable)exception);
    }

    public IEnterpriseBean[] getEnterpriseBeans() throws EJBModelException {
        if (this.myBeanTypes2EJBs == null) {
            this.addBeans();
        }
        return this.myBeanTypes2EJBs.values().toArray(new IEnterpriseBean[this.myBeanTypes2EJBs.size()]);
    }

    public IEnterpriseBean getEnterpriseBean(String beanClassFQN) throws EJBModelException {
        IType beanClass;
        if (this.myBeanTypes2EJBs == null) {
            this.addBeans();
        }
        if ((beanClass = JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)beanClassFQN)) == null) {
            return null;
        }
        return (IEnterpriseBean)this.myBeanTypes2EJBs.get(beanClass);
    }

    public IEntityBean createEntityBean(String beanClassFQN, Map properties, IProgressMonitor monitor) throws EJBModelException {
        this.assertExists();
        this.assertNoType(beanClassFQN);
        if (this.myBeanTypes2EJBs == null) {
            this.addBeans();
        }
        IPackageFragment beanClassPackage = this.getSuitablePackage(beanClassFQN);
        String beanClassName = EjbProjectImpl.getTypeName(beanClassFQN);
        boolean isCmp = false;
        Object superclass = properties.get("beanSuperclass");
        if (superclass != null && !(superclass instanceof IType)) {
            throw new EJBModelException("Illegal superclass parameter specified");
        }
        IType superClassAsIType = (IType)superclass;
        Object superintf = properties.get("beanSuperinterfaces");
        if (superintf != null && !(superintf instanceof IType[])) {
            throw new EJBModelException("Illegal superinterfaces parameter specified");
        }
        IType[] superinterfaces = (IType[])superintf;
        if (superinterfaces == null) {
            superinterfaces = JDTUtils.NO_TYPES;
        } else {
            ArrayList<IType> superinterfacesAsArrayList = new ArrayList<IType>();
            int i = 0;
            while (i < superinterfaces.length) {
                if (!"javax.ejb.EntityBean".equals(superinterfaces[i].getFullyQualifiedName())) {
                    superinterfacesAsArrayList.add(superinterfaces[i]);
                }
                ++i;
            }
            superinterfaces = superinterfacesAsArrayList.toArray(new IType[superinterfacesAsArrayList.size()]);
        }
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Creating bean class", 2);
            IDOMPackage domPackage = EjbTemplatesSupport.createEntityBeanClass(beanClassPackage, beanClassName, superClassAsIType, superinterfaces, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            EjbProjectImpl.applyComments(domPackage.getDomCompilationUnit(), properties);
            isCmp = properties.get("CMP") != null;
            EjbProjectImpl.applyCmpSetting(domPackage.getDomCompilationUnit(), isCmp);
            EjbTemplatesSupport.save(domPackage, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            EntityBean ejb = (EntityBean)this.getEnterpriseBean(beanClassFQN);
            this.postprocessCreatedEJB(ejb);
            String ASN_PROP = "defaultAbstractSchemaName";
            String CMP_VERSION_PROP = "defaultCmpVersion";
            String CMP_VERSION_2X = "2.x";
            if (isCmp) {
                if (ejb.canSetDdp("defaultAbstractSchemaName", ejb.getName())) {
                    ejb.setDdp("defaultAbstractSchemaName", ejb.getName());
                }
                if (ejb.canSetDdp("defaultCmpVersion", "2.x")) {
                    ejb.setDdp("defaultCmpVersion", "2.x");
                }
            }
            return ejb;
        }
        catch (CoreException ce) {
            EJBModelException me = new EJBModelException(ce.getStatus());
            throw me;
        }
    }

    public ISessionBean createSessionBean(String beanClassFQN, Map properties, IProgressMonitor monitor) throws EJBModelException {
        this.assertExists();
        this.assertNoType(beanClassFQN);
        if (this.myBeanTypes2EJBs == null) {
            this.addBeans();
        }
        IPackageFragment beanClassPackage = this.getSuitablePackage(beanClassFQN);
        String beanClassName = EjbProjectImpl.getTypeName(beanClassFQN);
        Object superclass = properties.get("beanSuperclass");
        if (superclass != null && !(superclass instanceof IType)) {
            throw new EJBModelException("Illegal superclass parameter specified");
        }
        IType superClassAsIType = (IType)superclass;
        Object superintf = properties.get("beanSuperinterfaces");
        if (superintf != null && !(superintf instanceof IType[])) {
            throw new EJBModelException("Illegal superinterfaces parameter specified");
        }
        IType[] superinterfaces = (IType[])superintf;
        if (superinterfaces == null) {
            superinterfaces = JDTUtils.NO_TYPES;
        } else {
            ArrayList<IType> superinterfacesAsArrayList = new ArrayList<IType>();
            int i = 0;
            while (i < superinterfaces.length) {
                if (!"javax.ejb.EntityBean".equals(superinterfaces[i].getFullyQualifiedName())) {
                    superinterfacesAsArrayList.add(superinterfaces[i]);
                }
                ++i;
            }
            superinterfaces = superinterfacesAsArrayList.toArray(new IType[superinterfacesAsArrayList.size()]);
        }
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Creating bean class", 2);
            IDOMPackage domPackage = EjbTemplatesSupport.createSessionBeanClass(beanClassPackage, beanClassName, superClassAsIType, superinterfaces, false, monitor);
            EjbProjectImpl.applyComments(domPackage.getDomCompilationUnit(), properties);
            EjbTemplatesSupport.save(domPackage, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            SessionBean ejb = (SessionBean)this.getEnterpriseBean(beanClassFQN);
            this.postprocessCreatedEJB(ejb);
            return ejb;
        }
        catch (CoreException ce) {
            EJBModelException me = new EJBModelException(ce.getStatus());
            throw me;
        }
    }

    public IMessageDrivenBean createMessageDrivenBean(String beanClassFQN, Map properties, IProgressMonitor monitor) throws EJBModelException {
        this.assertExists();
        this.assertNoType(beanClassFQN);
        if (this.myBeanTypes2EJBs == null) {
            this.addBeans();
        }
        IPackageFragment beanClassPackage = this.getSuitablePackage(beanClassFQN);
        String beanClassName = EjbProjectImpl.getTypeName(beanClassFQN);
        Object superclass = properties.get("beanSuperclass");
        if (superclass != null && !(superclass instanceof IType)) {
            throw new EJBModelException("Illegal superclass parameter specified");
        }
        IType superClassAsIType = (IType)superclass;
        Object superintf = properties.get("beanSuperinterfaces");
        if (superintf != null && !(superintf instanceof IType[])) {
            throw new EJBModelException("Illegal superinterfaces parameter specified");
        }
        IType[] superinterfaces = (IType[])superintf;
        if (superinterfaces == null) {
            superinterfaces = JDTUtils.NO_TYPES;
        } else {
            ArrayList<IType> superinterfacesAsArrayList = new ArrayList<IType>();
            int i = 0;
            while (i < superinterfaces.length) {
                if (!"javax.ejb.EntityBean".equals(superinterfaces[i].getFullyQualifiedName())) {
                    superinterfacesAsArrayList.add(superinterfaces[i]);
                }
                ++i;
            }
            superinterfaces = superinterfacesAsArrayList.toArray(new IType[superinterfacesAsArrayList.size()]);
        }
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Creating bean class", 2);
            IDOMPackage domPackage = EjbTemplatesSupport.createMessageDrivenBeanClass(beanClassPackage, beanClassName, superClassAsIType, superinterfaces, false, monitor);
            EjbProjectImpl.applyComments(domPackage.getDomCompilationUnit(), properties);
            EjbTemplatesSupport.save(domPackage, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            MessageDrivenBean ejb = (MessageDrivenBean)this.getEnterpriseBean(beanClassFQN);
            this.postprocessCreatedEJB(ejb);
            return ejb;
        }
        catch (CoreException ce) {
            EJBModelException me = new EJBModelException(ce.getStatus());
            throw me;
        }
    }

    private void postprocessCreatedEJB(EnterpriseBean ejb) throws CoreException {
        if (ejb != null) {
            JDTUtils.addUnimplementedMethods((IType)ejb.getBeanClass(), (boolean)false, (boolean)true, (IOverrideMethodQuery)ejb.getOverrideMethodQuery());
        }
    }

    private static void applyComments(IDOMCompilationUnit cu, Map properties) {
        new CommentApplier(cu).apply(properties);
    }

    private static void applyCmpSetting(IDOMCompilationUnit cu, boolean isCMP) {
        String cuName = cu.getName();
        String JAVA_EXT = ".java";
        if (!cuName.endsWith(".java")) {
            throw new IllegalArgumentException("Illegal DOM compilation unit");
        }
        IDOMType type = (IDOMType)cu.getChild(cuName.substring(0, cuName.length() - ".java".length()));
        if (type == null) {
            throw new IllegalArgumentException("Illegal DOM compilation unit");
        }
        if (!isCMP) {
            int flags = type.getFlags();
            type.insertSibling((IDOMNode)new DOMFactory().createImport("import javax.ejb.FinderException;\n"));
            type.setFlags(flags &= 0xFFFFFBFF);
        }
    }

    public void addEJBDeltaListener(IEJBDeltaListener listener) {
        HashSet hashSet = this.myListeners;
        synchronized (hashSet) {
            this.myListeners.add(listener);
        }
    }

    public void removeEJBDeltaListener(IEJBDeltaListener listener) {
        HashSet hashSet = this.myListeners;
        synchronized (hashSet) {
            this.myListeners.remove(listener);
        }
    }

    public boolean exists() {
        return this.getJavaProject() != null && this.getJavaProject().exists();
    }

    public IStatus validate() throws EJBModelException {
        this.assertExists();
        MultiStatus result = new MultiStatus(EJBImplPlugin.getPluginId(), 0, "Project validation", null);
        IEnterpriseBean[] beans = this.getEnterpriseBeans();
        int i = 0;
        while (i < beans.length) {
            result.add(beans[i].validate());
            ++i;
        }
        return result;
    }

    private void addBeans() {
        this.myBeanTypes2EJBs = new HashMap();
        Collection entityBeans = this.myHierarchyManager.getBeanTypes(1);
        Iterator it = entityBeans.iterator();
        while (it.hasNext()) {
            IType next = (IType)it.next();
            EnterpriseBean bean = this.createBean(next, 1);
            if (bean == null) continue;
            this.myBeanTypes2EJBs.put(next, bean);
        }
        Collection sessionBeans = this.myHierarchyManager.getBeanTypes(2);
        Iterator it2 = sessionBeans.iterator();
        while (it2.hasNext()) {
            IType next = (IType)it2.next();
            EnterpriseBean bean = this.createBean(next, 2);
            if (bean == null) continue;
            this.myBeanTypes2EJBs.put(next, bean);
        }
        Collection mdBeans = this.myHierarchyManager.getBeanTypes(4);
        Iterator it3 = mdBeans.iterator();
        while (it3.hasNext()) {
            IType next = (IType)it3.next();
            EnterpriseBean bean = this.createBean(next, 4);
            if (bean == null) continue;
            this.myBeanTypes2EJBs.put(next, bean);
        }
    }

    public void beanTypesChanged(final Collection addedTypes, final Collection removedTypes) {
        this.runCommand(new Runnable(){

            public void run() {
                EJBDelta delta = EjbProjectImpl.this.getDelta();
                Iterator it = removedTypes.iterator();
                while (it.hasNext()) {
                    IType next = (IType)it.next();
                    EnterpriseBean nextBean = (EnterpriseBean)((Object)EjbProjectImpl.this.myBeanTypes2EJBs.remove(next));
                    if (nextBean == null) continue;
                    nextBean.removed();
                    delta.removed(nextBean);
                }
                Iterator it2 = addedTypes.iterator();
                while (it2.hasNext()) {
                    IType next = (IType)it2.next();
                    EnterpriseBean nextBean = EjbProjectImpl.this.createBean(next);
                    if (nextBean == null) continue;
                    EjbProjectImpl.this.myBeanTypes2EJBs.put(next, nextBean);
                    delta.added(nextBean);
                }
            }
        });
    }

    void startProcessingDelta() {
        ++this.myCommandNestLevel;
    }

    public synchronized EJBDelta getDelta() {
        return this.myDelta;
    }

    private EnterpriseBean createBean(IType beanClass) {
        int kind = this.myHierarchyManager.getKind(beanClass);
        if (kind == 0) {
            return null;
        }
        return this.createBean(beanClass, kind);
    }

    EnterpriseBean createBean(IType beanClass, int kind) {
        EnterpriseBean bean;
        switch (kind) {
            case 1: {
                bean = new EntityBean(this, beanClass);
                break;
            }
            case 2: {
                bean = new SessionBean(this, beanClass);
                break;
            }
            case 4: {
                bean = new MessageDrivenBean(this, beanClass);
                break;
            }
            default: {
                return null;
            }
        }
        try {
            bean.validate();
            return bean;
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    public HierarchyManager getHierarchyManager() {
        return this.myHierarchyManager;
    }

    public IEnterpriseBeanHierarchyManager getEnterpriseBeanHierarchyManager() {
        return this.getHierarchyManager();
    }

    synchronized void deltaProcessed(EJBDelta delta) {
        Assert.isLegal((this.myDelta == delta ? 1 : 0) != 0);
        --this.myCommandNestLevel;
        this.update();
    }

    private void primFireDelta(EJBDelta delta) {
        EJBDeltaEvent event = new EJBDeltaEvent((EjbProject)this, (IEJBDelta)delta);
        Iterator it = new HashSet(this.myListeners).iterator();
        while (it.hasNext()) {
            ((IEJBDeltaListener)it.next()).ejbModelChanged(event);
        }
    }

    NamingConvention getNamingConvention() {
        if (this.myNamingConvention == null) {
            this.myNamingConvention = new NamingConvention(this);
        }
        return this.myNamingConvention;
    }

    EJBHierarchyHolder getHierarchyHolder() {
        if (this.myHierarchyHolder == null) {
            this.myHierarchyHolder = new EJBHierarchyHolder(this.getJavaProject());
        }
        return this.myHierarchyHolder;
    }

    public IEJBInterfacesHierarchyHolder getEJBInterfacesHierarchyHolder() {
        return this.getHierarchyHolder();
    }

    private void assertNoType(String typeFQN) throws EJBModelException {
        IType type = JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)typeFQN);
        if (type != null) {
            throw new EJBModelException(this.newStatus(4, "[" + typeFQN + "] already exists"));
        }
    }

    public static String getTypeName(String typeFQN) {
        int lastDotIndex = typeFQN.lastIndexOf(46);
        return lastDotIndex == -1 ? typeFQN : typeFQN.substring(lastDotIndex + 1);
    }

    public IPackageFragment getSuitablePackage(String typeFQN) throws EJBModelException {
        int lastDotIndex = typeFQN.lastIndexOf(46);
        String packageFQN = lastDotIndex == -1 ? "" : typeFQN.substring(0, lastDotIndex);
        IPackageFragment typePackage = (IPackageFragment)JDTUtils.processPackages((IJavaProject)this.getJavaProject(), (String)packageFQN, (IPackageProcessor)SOURCE_PACKAGE_RETURNER);
        if (typePackage == null) {
            IPackageFragment defaultPackage = (IPackageFragment)JDTUtils.processPackages((IJavaProject)this.getJavaProject(), (String)"", (IPackageProcessor)SOURCE_PACKAGE_RETURNER);
            if (defaultPackage == null) {
                throw new EJBModelException(this.newStatus(4, "Package for type [" + typeFQN + "] should exist before type creation"));
            }
            try {
                return ((IPackageFragmentRoot)defaultPackage.getParent()).createPackageFragment(packageFQN, false, null);
            }
            catch (JavaModelException e) {
                throw new EJBModelException("Exception occurred while creating package", (Throwable)e);
            }
        }
        return typePackage;
    }

    public IEJBSynchronizeListener getSynchronizeTarget() {
        return this.mySynchronizeTarget;
    }

    public void addSynchronizer(IEJBSynchronizeListener subTarget) {
        this.mySynchronizeTarget.addSynchronizer(subTarget);
    }

    public void removeSynchronizer(IEJBSynchronizeListener subTarget) {
        this.mySynchronizeTarget.removeSynchronizer(subTarget);
    }

    public void runCommand(Runnable command) {
        this.startProcessingDelta();
        try {
            command.run();
            Object var3_2 = null;
            this.deltaProcessed(this.myDelta);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.deltaProcessed(this.myDelta);
            throw throwable;
        }
    }

    public void runCommandLater(final Runnable command) {
        Object newCommand = command instanceof UndoTransparableCommand ? new UndoTransparableCommand(){

            public void run() {
                EjbProjectImpl.this.runCommand(command);
            }
        } : new Runnable(){

            public void run() {
                EjbProjectImpl.this.runCommand(command);
            }
        };
        ModelAccess.runCommandLater((Runnable)newCommand);
    }

    private void update() {
        if (this.myCommandNestLevel < 0) {
            throw new IllegalStateException();
        }
        if (this.myCommandNestLevel > 0) {
            return;
        }
        if (this.myDelta.isEmpty()) {
            return;
        }
        EJBDelta delta = this.myDelta;
        this.primFireDelta(delta);
    }

    void deltaBecameInvalid(EJBDelta delta) {
        if (this.myDelta == delta) {
            if (this.myCommandNestLevel == 0) {
                EjbProjectImpl ejbProjectImpl = this;
                synchronized (ejbProjectImpl) {
                    this.myDelta = new EJBDelta(this);
                }
            } else {
                System.err.println("Delta accessed before command finished! This can potentially lead to broken update");
            }
        }
    }

    InhDeltaDispatcher getDeltaDispatcher() {
        return this.myInhDeltaDispatcher;
    }

    public InhModel getInhModel() {
        return this.myModel;
    }

    public boolean isAutomaticSynchronizationEnabled() {
        return this.mySynchronizeTarget.isAutomaticSynchronizationEnabled();
    }

    public void setAutomaticSynchronizationEnabled(boolean enabled) {
        this.mySynchronizeTarget.setAutomaticSynchronizationEnabled(enabled);
    }

    public boolean canSetDdp(String name, Object value) {
        return false;
    }

    public Object getDdp(String name) {
        return null;
    }

    public String getDdpAsString(String name) {
        return null;
    }

    public String[] getDdpNames() {
        return null;
    }

    public void setDdp(String name, Object value) {
    }

    public void applyDdp(Object entity, String name) {
    }

    public void applyDdps(Object entity) {
    }

    protected String[] getRequiredLibraries() {
        return new String[]{AbstractJ2eeProject.OUR_EJB_LIB, AbstractJ2eeProject.OUR_JMS_LIB, AbstractJ2eeProject.OUR_JDBC_LIB};
    }

    public void delete(IProgressMonitor monitor) throws EJBModelException {
        throw new EJBModelException("Project deletion is not supported");
    }

    public void refreshHierarchies() {
        this.myHierarchyManager.refresh();
    }
}

