/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.ICopiedEJBElement;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.ejbjar.Method;
import com.tssap.j2ee.core.ejbjar.Query;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.utils.ReadOnlinessValidator;
import com.tssap.j2ee.core.utils.ddp.DdpRegistry;
import com.tssap.j2ee.internal.core.ejb.AccessibleBean;
import com.tssap.j2ee.internal.core.ejb.BodyAndComment;
import com.tssap.j2ee.internal.core.ejb.CopiedEJBMethod;
import com.tssap.j2ee.internal.core.ejb.EJBElement;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.EntityBean;
import com.tssap.j2ee.internal.core.ejb.MethodSig;
import com.tssap.j2ee.internal.core.ejb.ReadOnlyEJBMethod;
import com.tssap.j2ee.internal.core.ejb.refactor.EJBMethodRefactorer;
import com.tssap.j2ee.internal.core.ejb.refactor.MethodSignatureSetter;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.ejb.util.JDomSupport;
import com.tssap.selena.model.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.formatter.CodeFormatter;

public abstract class EJBMethod
extends EJBElement
implements IEJBMethod {
    private int myKind;
    private IntHashMap myRoles2Methods = new IntHashMap();
    private Integer myCachedExistingMethods;
    private String myReturnType;
    private boolean myDeleted;
    private static final String REMOTE_EXCEPTION = "RemoteException";
    private static final String REMOTE_PACKAGE = "java.rmi.";
    private static final String MANDATORY_EXCEPTIONS_PACKAGE = "javax.ejb.";
    private String[] myParameterTypeFQNs;
    private String myName;
    private String myNameForDD;
    private EJBMethodRefactorer myCachedRefactorer;
    private MethodSignatureSetter mySignatureSetter;
    private IMethod myTempDdpSource;

    public EJBMethod(EJBElement parent, int kind, String name, String nameForDD, String[] parameterTypeFQNs) {
        super(parent);
        this.myKind = kind;
        this.myParameterTypeFQNs = parameterTypeFQNs;
        this.myName = name;
        this.myNameForDD = nameForDD;
    }

    public int getKind() {
        return this.myKind;
    }

    public boolean exists() {
        return !this.myDeleted && this.getExistingMethods() > 0;
    }

    void removed() {
        this.myDeleted = true;
    }

    public int getExistingMethods() {
        if (this.myCachedExistingMethods == null) {
            Assert.isLegal((boolean)(this.getParentBean() instanceof AccessibleBean));
            int existingBeanRoles = ((AccessibleBean)this.getParentBean()).getExistingRoles();
            int result = 0;
            Iterator it = this.myRoles2Methods.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry next = it.next();
                int role = (Integer)next.getKey();
                IMethod method = (IMethod)next.getValue();
                if (method == null || !method.exists() || !this.isLegalRole(role, existingBeanRoles)) continue;
                result |= role;
            }
            this.myCachedExistingMethods = new Integer(result);
        }
        return this.myCachedExistingMethods;
    }

    public IMethod getMethod(int role) {
        Assert.isLegal((boolean)(this.getParentBean() instanceof AccessibleBean));
        if (!this.isLegalRole(role, ((AccessibleBean)this.getParentBean()).getExistingRoles())) {
            return null;
        }
        IMethod result = (IMethod)this.myRoles2Methods.get(role);
        if (result == null) {
            return null;
        }
        if (result.exists()) {
            return (IMethod)this.getParentBean().translateIfWorkingCopyMode((IMember)result);
        }
        IType methodType = result.getDeclaringType();
        IType typeCounterpart = (IType)this.getParentBean().translateIfWorkingCopyMode((IMember)methodType);
        return typeCounterpart.getMethod(result.getElementName(), result.getParameterTypes());
    }

    protected EnterpriseBean getParentBean() {
        return (EnterpriseBean)this.getParent();
    }

    public IMethod[] getMethods() {
        Assert.isLegal((boolean)(this.getParentBean() instanceof AccessibleBean));
        int existingBeanRoles = ((AccessibleBean)this.getParentBean()).getExistingRoles();
        ArrayList<IMember> methods = new ArrayList<IMember>();
        Iterator it = this.myRoles2Methods.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            int role = (Integer)next.getKey();
            IMethod method = (IMethod)next.getValue();
            if (method == null || !method.exists() || !this.isLegalRole(role, existingBeanRoles)) continue;
            methods.add(this.getParentBean().translateIfWorkingCopyMode((IMember)method));
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    protected boolean isLegalRole(int role, int existingBeanRoles) {
        return (role & existingBeanRoles) > 0;
    }

    protected void setMethod(int role, IMethod method) {
        this.myRoles2Methods.put(role, (Object)method);
    }

    public boolean canDelete() {
        return !this.isCMPAccessor();
    }

    public void delete(IProgressMonitor monitor) throws EJBModelException {
        this.assertExists();
        monitor = this.getValidProgressMonitor(monitor);
        ArrayList<Status> status = null;
        int existingMethods = this.getExistingMethods();
        monitor.beginTask("Deleting methods", this.myRoles2Methods.size());
        if (!this.validateEdit(this.getMethods(), true)) {
            throw new EJBModelException("Could not modify read-only files");
        }
        this.getParentBean().enterWorkingCopyMode();
        try {
            int role = 1;
            while (role <= existingMethods) {
                if ((role & existingMethods) > 0) {
                    IMethod method = this.getMethod(role);
                    try {
                        method.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (JavaModelException jme) {
                        if (status == null) {
                            status = new ArrayList<Status>();
                        }
                        String msg = "Unable to delete method [" + method.getElementName() + "]";
                        status.add(new Status(4, "com.tssap.j2ee.internal.core.ejb", 0, msg, (Throwable)jme));
                    }
                }
                role <<= 1;
            }
            if (status != null) {
                if (status.size() == 1) {
                    throw new EJBModelException((IStatus)status.get(0));
                }
                String msg = "Unable to delete methods";
                IStatus[] statuses = status.toArray(new IStatus[status.size()]);
                throw new EJBModelException((IStatus)new MultiStatus("com.tssap.j2ee.internal.core.ejb", 0, statuses, msg, null));
            }
            Object var9_9 = null;
            this.getParentBean().exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.getParentBean().exitWorkingCopyMode();
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    boolean merge(EJBMethod newState) {
        boolean result = false;
        if (this.myCachedExistingMethods != null) {
            int oldExistingMethods = this.getExistingMethods();
            this.myCachedExistingMethods = null;
            int newExistingMethods = newState.getExistingMethods();
            if (oldExistingMethods != newExistingMethods) {
                this.internalGetEJBProject().getSynchronizeTarget().methodParticipantsChanged((IEJBMethod)this, oldExistingMethods, newExistingMethods);
                result = true;
            } else {
                int role = 1;
                while (role <= oldExistingMethods) {
                    if ((role & oldExistingMethods) > 0) {
                        IMethod oldMethod = (IMethod)this.myRoles2Methods.get(role);
                        IMethod newMethod = (IMethod)newState.myRoles2Methods.get(role);
                        if (!oldMethod.getDeclaringType().equals(newMethod.getDeclaringType())) {
                            result = true;
                            break;
                        }
                    }
                    role <<= 1;
                }
            }
        }
        this.myRoles2Methods = newState.myRoles2Methods;
        this.getExistingMethods();
        if (this.myReturnType != null) {
            String newReturnType;
            String oldReturnType = this.myReturnType;
            this.myReturnType = null;
            try {
                newReturnType = this.getReturnType();
            }
            catch (EJBModelException e) {
                newReturnType = null;
            }
            if (!oldReturnType.equals(newReturnType)) {
                result = true;
            }
        }
        return result;
    }

    protected abstract IMethod getDefiningMethod() throws EJBModelException;

    public abstract Map getRenameScheme(String var1) throws EJBModelException;

    public abstract Map getReturnTypeScheme(String var1) throws EJBModelException;

    public boolean canSetName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (name.equals(this.getName())) {
            return true;
        }
        if (this.isCMPAccessor()) {
            return false;
        }
        if (this.getRefactorer(name).canPerformNaive()) {
            return true;
        }
        this.myCachedRefactorer = null;
        return false;
    }

    protected boolean isCMPAccessor() {
        try {
            EnterpriseBean bean;
            if (JDTUtils.isAccessor((IMethod)this.getDefiningMethod()) && (bean = this.getParentBean()).getKind() == 1 && ((EntityBean)bean).isCMP()) {
                return ((EntityBean)bean).getField(JDTUtils.getFieldNameByAccessor((IMethod)this.getDefiningMethod())) != null;
            }
            return false;
        }
        catch (EJBModelException e) {
            return true;
        }
    }

    private EJBMethodRefactorer getRefactorer(String name) {
        return this.getRefactorer(name, false);
    }

    private EJBMethodRefactorer getRefactorer(String name, boolean assertName) {
        if (this.myCachedRefactorer == null || assertName && !name.equals(this.myCachedRefactorer.getNewName())) {
            this.myCachedRefactorer = new EJBMethodRefactorer(this, name);
        }
        return this.myCachedRefactorer;
    }

    public IEJBMethod setName(String name, IProgressMonitor monitor) throws EJBModelException {
        if (name == null || name.length() == 0) {
            String msg = "Invalid method name [" + name + "]";
            throw new EJBModelException((IStatus)new Status(4, EJBImplPlugin.getPluginId(), 0, msg, null));
        }
        if (name.equals(this.getName())) {
            return this;
        }
        if (!this.getRefactorer(name, true).canPerform()) {
            this.myCachedRefactorer = null;
            return this;
        }
        monitor = this.getValidProgressMonitor(monitor);
        try {
            try {
                EJBMethodRefactorer refactorer = this.getRefactorer(name);
                refactorer.perform(monitor);
                EJBMethod eJBMethod = refactorer.getRenamedMethod();
                Object var6_7 = null;
                this.myCachedRefactorer = null;
                return eJBMethod;
            }
            catch (CoreException e) {
                throw new EJBModelException("Failed to refactor", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.myCachedRefactorer = null;
            throw throwable;
        }
    }

    public abstract String getRenamedNameForDD(String var1);

    public String[] getParameterTypes() {
        try {
            IMethod definingMethod = this.getDefiningMethod();
            if (definingMethod == null) {
                return null;
            }
            String[] jdtTypes = definingMethod.getParameterTypes();
            String[] types = new String[jdtTypes.length];
            int i = 0;
            while (i < jdtTypes.length) {
                types[i] = Signature.toString((String)jdtTypes[i]);
                ++i;
            }
            return types;
        }
        catch (EJBModelException e) {
            return this.getParameterTypesForDD();
        }
    }

    public final String getName() {
        return this.myName;
    }

    public final String getNameForDD() {
        return this.myNameForDD;
    }

    public String[] getParameterTypesForDD() {
        return this.myParameterTypeFQNs;
    }

    public String[] getParameterNames() throws EJBModelException {
        IMethod method = this.getDefiningMethod();
        if (method == null) {
            return null;
        }
        try {
            return method.getParameterNames();
        }
        catch (JavaModelException jme) {
            String msg = "Unable to retrieve method [" + method.getElementName() + "] parameter names";
            throw new EJBModelException((IStatus)new Status(4, "com.tssap.j2ee.internal.core.ejb", 0, msg, (Throwable)jme));
        }
    }

    private String[] getValidParameterNames(int count, String[] rawNames) {
        String[] names = new String[count];
        if (rawNames == null || rawNames.length == 0) {
            int i = 0;
            while (i < names.length) {
                names[i] = "arg" + i;
                ++i;
            }
            return names;
        }
        HashSet<String> nameSet = new HashSet<String>(count);
        int i = 0;
        while (i < rawNames.length) {
            String name = rawNames[i];
            if (name != null && name.length() > 0) {
                nameSet.add(name);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < names.length) {
            String name;
            if (i2 < rawNames.length && (name = rawNames[i2]) != null && name.length() > 0) {
                names[i2] = name;
            } else {
                name = null;
                int j = i2;
                while (j < Integer.MAX_VALUE) {
                    name = "arg" + j;
                    if (!nameSet.contains(name)) break;
                    ++j;
                }
                names[i2] = name;
            }
            ++i2;
        }
        return names;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParameters(String[] types, String[] names, IProgressMonitor monitor) throws EJBModelException {
        monitor = this.getValidProgressMonitor(monitor);
        IMethod[] methods = this.getMethods();
        if (!this.validateEdit(methods, true)) {
            throw new EJBModelException("Cannot modify read-only files");
        }
        if (types == null) {
            types = ArrayUtils.EMPTY_STRING_ARRAY;
            names = ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            names = this.getValidParameterNames(types.length, names);
        }
        String[] otypes = this.getParameterTypes();
        Object[] onames = this.getParameterNames();
        boolean equivalentTypes = this.equivalentTypes(types, otypes);
        if (equivalentTypes && Arrays.equals(names, onames)) {
            return;
        }
        EJBImplPlugin.revisit("assume false, because for compiled classes this will fail all the same :)");
        String[] newParamSigs = JDTUtils.java2jdt((String[])types, (boolean)false);
        String ddName = this.getNameForDD();
        String[] newParamTypeFQNs = this.getParentBean().qualify(types);
        if (!equivalentTypes) {
            this.internalGetEJBProject().getDelta().renamed(this, new ReadOnlyEJBMethod(this, this.getName(), newParamSigs, ddName, newParamTypeFQNs));
        } else {
            this.internalGetEJBProject().getDelta().changed(this);
        }
        int i = 0;
        this.getParentBean().enterWorkingCopyMode();
        try {
            int j;
            String[] jdtTypes;
            EJBModelException eme2;
            block18: {
                try {
                    methods = this.getMethods();
                    while (i < methods.length) {
                        this.setParameters(methods[i], (String[])newParamTypeFQNs.clone(), names, monitor);
                        ++i;
                    }
                }
                catch (EJBModelException eme2) {
                    if (otypes == null) throw eme2;
                    if (onames == null) {
                        throw eme2;
                    }
                    jdtTypes = new String[types.length];
                    j = 0;
                    break block18;
                }
                Object var18_12 = null;
                this.getParentBean().exitWorkingCopyMode();
                return;
            }
            while (j < jdtTypes.length) {
                jdtTypes[j] = Signature.createTypeSignature((String)types[j], (boolean)false);
                ++j;
            }
            while (true) {
                if (i < 0) {
                    throw eme2;
                }
                try {
                    IMethod method = methods[i];
                    IType parent = method.getDeclaringType();
                    if (parent != null && (method = parent.getMethod(method.getElementName(), jdtTypes)) != null && method.exists()) {
                        this.setParameters(method, otypes, (String[])onames, monitor);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                --i;
            }
        }
        catch (Throwable throwable) {
            Object var18_13 = null;
            this.getParentBean().exitWorkingCopyMode();
            throw throwable;
        }
    }

    private boolean equivalentTypes(String[] one, String[] another) {
        if (one == null || another == null) {
            return false;
        }
        if (one.length != another.length) {
            return false;
        }
        int i = 0;
        while (i < one.length) {
            if (!Signature.getSimpleName((String)one[i]).equals(Signature.getSimpleName((String)another[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void setParameters(IMethod method, final String[] types, final String[] names, IProgressMonitor monitor) throws EJBModelException {
        int i = 0;
        while (i < types.length) {
            String next = types[i];
            if (JDTUtils.addImport((IType)method.getDeclaringType(), (String)next)) {
                types[i] = Signature.getSimpleName((String)next);
            }
            ++i;
        }
        monitor.subTask("Set parameters of method " + method.getElementName());
        try {
            JDomSupport.executeOperation((JDomSupport.Operation)new JDomSupport.Operation(){

                public boolean execute(IMember jdtMember, IDOMNode domNode) {
                    if (!(domNode instanceof IDOMMethod)) {
                        throw new RuntimeException("Found jdom node does not correspond to a method");
                    }
                    ((IDOMMethod)domNode).setParameters(types, names);
                    return true;
                }
            }, (IMember)method, (IProgressMonitor)monitor);
        }
        catch (JavaModelException jme) {
            String msg = "Unable to set method [" + method.getElementName() + "] parameters";
            throw new EJBModelException((IStatus)new Status(4, "com.tssap.j2ee.internal.core.ejb", 0, msg, (Throwable)jme));
        }
    }

    public final String getReturnType() throws EJBModelException {
        if (this.myReturnType == null) {
            this.myReturnType = this.internalGetReturnType();
        }
        return this.myReturnType;
    }

    protected String internalGetReturnType() throws EJBModelException {
        IMethod definingMethod = this.getDefiningMethod();
        if (definingMethod == null) {
            return null;
        }
        String returnType = this.getReturnType(definingMethod);
        return JDTUtils.getFQN((IType)definingMethod.getDeclaringType(), (String)returnType);
    }

    protected String getReturnType(IMethod method) throws EJBModelException {
        try {
            return Signature.toString((String)method.getReturnType());
        }
        catch (JavaModelException jme) {
            String msg = "Unable to retrieve method [" + method.getElementName() + "] return type";
            throw new EJBModelException((IStatus)new Status(4, "com.tssap.j2ee.internal.core.ejb", 0, msg, (Throwable)jme));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setReturnType(String type, IProgressMonitor monitor) throws EJBModelException {
        this.internalGetEJBProject().getDelta().changed(this);
        monitor = this.getValidProgressMonitor(monitor);
        IMethod[] methods = this.getMethods();
        if (!this.validateEdit(methods, false)) {
            throw new EJBModelException("Could not modify read-only files");
        }
        type = JDTUtils.getFQN((IType)this.getDefiningMethod().getDeclaringType(), (String)type);
        String[] types = new String[methods.length];
        int i = 0;
        this.getParentBean().enterWorkingCopyMode();
        try {
            EJBModelException eme2;
            block10: {
                try {
                    methods = this.getMethods();
                    while (i < methods.length) {
                        IMethod method = methods[i];
                        types[i] = this.getReturnType(method);
                        EJBMethod.setReturnType(method, type, monitor);
                        ++i;
                    }
                }
                catch (EJBModelException eme2) {
                    break block10;
                }
                Object var9_8 = null;
                this.getParentBean().exitWorkingCopyMode();
                return;
            }
            while (true) {
                if (i < 0) {
                    throw eme2;
                }
                try {
                    EJBMethod.setReturnType(methods[i], types[i], monitor);
                }
                catch (Exception e) {
                    // empty catch block
                }
                --i;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.getParentBean().exitWorkingCopyMode();
            throw throwable;
        }
    }

    protected static void setReturnType(final IMethod method, final String type, IProgressMonitor monitor) throws EJBModelException {
        monitor.subTask("Set return type of method " + method.getElementName());
        try {
            String returnTypeFQN = JDTUtils.getFQN((IType)method.getDeclaringType(), (String)Signature.toString((String)method.getReturnType()));
            final String simpleType = Signature.getSimpleName((String)type);
            if (returnTypeFQN == null || !returnTypeFQN.equals(type)) {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor m) throws CoreException {
                        boolean success = JDTUtils.addImport((IType)method.getDeclaringType(), (String)type);
                        JDomSupport.executeOperation((JDomSupport.Operation)new JDomSupport.Operation(this, success){
                            private final /* synthetic */ boolean val$success;
                            private final /* synthetic */ 2 this$0;
                            {
                                this.this$0 = this$0;
                                this.val$success = val$success;
                            }

                            public boolean execute(IMember jdtMember, IDOMNode domNode) {
                                if (!(domNode instanceof IDOMMethod)) {
                                    throw new RuntimeException("Found jdom node does not correspond to a method");
                                }
                                ((IDOMMethod)domNode).setReturnType(this.val$success ? 2.access$000(this.this$0) : 2.access$100(this.this$0));
                                return true;
                            }
                        }, (IMember)method, (IProgressMonitor)m);
                    }

                    static /* synthetic */ String access$000(2 x0) {
                        return x0.simpleType;
                    }

                    static /* synthetic */ String access$100(2 x0) {
                        return x0.type;
                    }
                }, monitor);
            }
        }
        catch (CoreException jme) {
            String msg = "Unable to set method [" + method.getElementName() + "] return type";
            throw new EJBModelException((IStatus)new Status(4, "com.tssap.j2ee.internal.core.ejb", 0, msg, (Throwable)jme));
        }
    }

    public String toString() {
        String name = this.getNameForDD();
        return "EJBMethod " + name + ", kind=" + this.getKind() + ", exists in " + this.safegetExistingMethods();
    }

    private String safegetExistingMethods() {
        if (this.myCachedExistingMethods == null) {
            return "<unknown>";
        }
        return Integer.toHexString(this.myCachedExistingMethods);
    }

    public boolean canPromote(int role) {
        IMethod methodForRole = (IMethod)this.myRoles2Methods.get(role);
        if (methodForRole != null) {
            return false;
        }
        if ((this.getAllowedMethodParticipants() & role) == 0) {
            return false;
        }
        return this.typeForRoleExists(role);
    }

    protected boolean typeForRoleExists(int role) {
        try {
            IType type = ((AccessibleBean)this.getParentBean()).getParticipant(role);
            return type != null && type.exists();
        }
        catch (EJBModelException e) {
            return false;
        }
    }

    protected int getAllowedMethodParticipants() {
        return 0;
    }

    public boolean canUnpromote(int role) {
        IMethod methodForRole = (IMethod)this.myRoles2Methods.get(role);
        return methodForRole != null && methodForRole.exists();
    }

    public void promote(int role) throws EJBModelException {
        String[] parameterNames;
        AccessibleBean parent = (AccessibleBean)this.getParent();
        IType type = parent.getParticipant(role);
        if (type == null || !type.exists() || type.isReadOnly()) {
            throw new EJBModelException("Target type does not exist or is read-only");
        }
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        validator.addJavaElement((IMember)type);
        if (!validator.canModify()) {
            throw new EJBModelException("Could not modify read-only files");
        }
        String[] parameterTypes = this.getParameterTypesForDD();
        try {
            parameterNames = this.getParameterNames();
        }
        catch (EJBModelException e) {
            parameterNames = null;
        }
        IMethod m1 = this.getDefiningMethod();
        this.promote(role, type, this.getName(), EnterpriseBean.asList(parameterTypes, parameterNames), this.getReturnType(), EnterpriseBean.asList(this.getExceptionTypes()), null);
        IMethod m2 = this.getDefiningMethod();
        if (m1 != null && !m1.equals(m2)) {
            this.transferDdps(m1, m2);
        }
    }

    protected abstract void promote(int var1, IType var2, String var3, List var4, String var5, List var6, IProgressMonitor var7) throws EJBModelException;

    public void unpromote(int role) throws EJBModelException {
        IMethod methodForRole = (IMethod)this.myRoles2Methods.get(role);
        if (!this.validateEdit(new IMethod[]{methodForRole}, false)) {
            throw new EJBModelException("Could not modify read-only files");
        }
        try {
            this.transferDdpsFrom(methodForRole);
            methodForRole.delete(true, null);
        }
        catch (JavaModelException e) {
            throw new EJBModelException("Java exception occurred while trying to delete method", (Throwable)e);
        }
    }

    protected void transferDdpsFrom(IMethod m) throws EJBModelException {
    }

    protected boolean transferDdps(IMethod m1, IMethod m2) throws EJBModelException {
        if (m2 == null) {
            return false;
        }
        String[] propNames = DdpRegistry.getPropertyNames((String)this.getDdpKey());
        if (propNames == null || propNames.length == 0) {
            return true;
        }
        if (!this.validateEdit(new IMethod[]{m2}, false)) {
            throw new EJBModelException("Could not modify read-only files");
        }
        boolean updateRequired = false;
        this.setDdpSource(m1);
        Object[] propValues = new Object[propNames.length];
        int i = 0;
        while (i < propNames.length) {
            propValues[i] = this.getDdp(propNames[i]);
            if (propValues[i] != null) {
                this.setDdpHelper(propNames[i], null);
                updateRequired = true;
            }
            ++i;
        }
        if (!updateRequired) {
            return true;
        }
        this.setDdpSource(m2);
        int i2 = 0;
        while (i2 < propNames.length) {
            if (propValues[i2] != null) {
                if (this.canSetDdp(propNames[i2], propValues[i2])) {
                    this.setDdpHelper(propNames[i2], propValues[i2]);
                } else {
                    EJBImplPlugin.logWarning("Unable to set ddp [" + propNames[i2] + "] to " + propValues[i2]);
                }
            }
            ++i2;
        }
        this.setDdpSource(null);
        if (updateRequired) {
            this.internalGetEJBProject().getDelta().changed(this);
        }
        return true;
    }

    protected Object getDdpSource() {
        if (this.myTempDdpSource != null) {
            return this.myTempDdpSource;
        }
        try {
            return this.getDefiningMethod();
        }
        catch (EJBModelException eJBModelException) {
            return null;
        }
    }

    protected final IMethod getTempDdpSource() {
        return this.myTempDdpSource;
    }

    protected final void setDdpSource(IMethod source) {
        this.myTempDdpSource = source;
    }

    public String[] getExceptionTypes() throws EJBModelException {
        IMethod method = this.getDefiningMethod();
        if (method == null) {
            return null;
        }
        try {
            String[] exceptionTypes = method.getExceptionTypes();
            ArrayList<String> result = new ArrayList<String>(exceptionTypes.length);
            Collection mandatoryExceptionTypes = this.getMandatoryExceptionTypes();
            int i = 0;
            while (i < exceptionTypes.length) {
                String type = Signature.toString((String)exceptionTypes[i]);
                String simpleType = Signature.getSimpleName((String)type);
                if (!REMOTE_EXCEPTION.equals(simpleType) && !mandatoryExceptionTypes.contains(simpleType)) {
                    result.add(JDTUtils.getFQN((IType)method.getDeclaringType(), (String)type));
                }
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }
        catch (JavaModelException e) {
            throw new EJBModelException("Exception occurred while accessing Java information");
        }
    }

    public void setExceptionTypes(String[] exceptions, IProgressMonitor monitor) throws EJBModelException {
        this.internalGetEJBProject().getDelta().changed(this);
        Collection mandatory = this.getMandatoryExceptionTypes();
        ArrayList<String> exceptionsCollections = new ArrayList<String>(exceptions.length);
        int i = 0;
        while (i < exceptions.length) {
            String simpleType = Signature.getSimpleName((String)exceptions[i]);
            if (!mandatory.contains(simpleType) && !REMOTE_EXCEPTION.equals(simpleType)) {
                exceptionsCollections.add(JDTUtils.getFQN((IType)this.getParentBean().getBeanClass(), (String)exceptions[i]));
            }
            ++i;
        }
        IMethod[] methods = this.getMethods();
        if (!this.validateEdit(methods, false)) {
            throw new EJBModelException("Could not modify read-only files");
        }
        monitor = this.getValidProgressMonitor(monitor);
        monitor.beginTask("Setting exceptions", methods.length);
        this.getParentBean().enterWorkingCopyMode();
        try {
            int i2 = 1;
            int iMax = this.getExistingMethods();
            while (i2 <= iMax) {
                if ((i2 & iMax) != 0) {
                    IMethod method = this.getMethod(i2);
                    IType methodType = method.getDeclaringType();
                    ArrayList<String> exceptionsForRole = new ArrayList<String>(mandatory.size() + exceptions.length + 1);
                    Iterator it = mandatory.iterator();
                    while (it.hasNext()) {
                        String next = (String)it.next();
                        exceptionsForRole.add(this.getTypeNameAddingImport(methodType, MANDATORY_EXCEPTIONS_PACKAGE + next));
                    }
                    if ((i2 & 6) > 0) {
                        exceptionsForRole.add(this.getTypeNameAddingImport(methodType, "java.rmi.RemoteException"));
                    }
                    Iterator it2 = exceptionsCollections.iterator();
                    while (it2.hasNext()) {
                        String nextUserException = (String)it2.next();
                        exceptionsForRole.add(this.getTypeNameAddingImport(methodType, nextUserException));
                    }
                    this.setExceptions(method, exceptionsForRole.toArray(new String[exceptionsForRole.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                i2 <<= 1;
            }
            Object var16_15 = null;
            this.getParentBean().exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            this.getParentBean().exitWorkingCopyMode();
            throw throwable;
        }
    }

    protected void setExceptions(IMethod method, final String[] types, IProgressMonitor monitor) throws EJBModelException {
        monitor.subTask("Set exceptions of method " + method.getElementName());
        try {
            JDomSupport.executeOperation((JDomSupport.Operation)new JDomSupport.Operation(){

                public boolean execute(IMember jdtMember, IDOMNode domNode) {
                    if (!(domNode instanceof IDOMMethod)) {
                        throw new RuntimeException("Found jdom node does not correspond to a method");
                    }
                    ((IDOMMethod)domNode).setExceptions(types);
                    return true;
                }
            }, (IMember)method, (IProgressMonitor)monitor);
        }
        catch (CoreException jme) {
            String msg = "Unable to set method [" + method.getElementName() + "] return type";
            throw new EJBModelException((IStatus)new Status(4, "com.tssap.j2ee.internal.core.ejb", 0, msg, (Throwable)jme));
        }
    }

    private String getTypeNameAddingImport(IType type, String fqn) {
        if (JDTUtils.addImport((IType)type, (String)fqn)) {
            return Signature.getSimpleName((String)fqn);
        }
        return fqn;
    }

    protected Collection getMandatoryExceptionTypes() {
        return Collections.EMPTY_LIST;
    }

    public String getHandleIdentifier() {
        return this.getParentBean().getHandleIdentifier() + '\u0000' + this.getOwnSignature();
    }

    private String getOwnSignature() {
        return Integer.toHexString(this.getKind()) + this.getNameForDD() + this.getParamSignature(this.getParameterTypesForDD());
    }

    private String getParamSignature(String[] paramFQNs) {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        int i = 0;
        while (i < paramFQNs.length) {
            buf.append(paramFQNs[i]);
            if (i < paramFQNs.length - 1) {
                buf.append(',');
            }
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    protected boolean validateEdit(IMethod[] methods, boolean includeDDOccurrences) {
        ReadOnlinessValidator validator = new ReadOnlinessValidator((IMember[])methods);
        if (includeDDOccurrences) {
            Query[] deployedQueries;
            Method[] deployedMethods = AssembledInfoFinder.findAssembledMethods((IEJBMethod)this);
            if (deployedMethods != null) {
                int i = 0;
                while (i < deployedMethods.length) {
                    validator.addResource(deployedMethods[i].getDocument().getFile());
                    ++i;
                }
            }
            if ((this.getKind() == 4 || this.getKind() == 16) && (deployedQueries = AssembledInfoFinder.findAssembledQueries((IEJBMethod)this)) != null) {
                int i = 0;
                while (i < deployedQueries.length) {
                    validator.addResource(deployedQueries[i].getDocument().getFile());
                    ++i;
                }
            }
        }
        return validator.canModify();
    }

    protected abstract boolean isValidName(String var1);

    public boolean canSetSignature(String name, String[] paramTypes, String[] paramNames, String returnType) {
        String actualReturnType;
        if (paramTypes != null && paramNames != null && paramNames.length != paramTypes.length) {
            return false;
        }
        if (this.isCMPAccessor()) {
            return false;
        }
        try {
            actualReturnType = this.getReturnType();
        }
        catch (EJBModelException e) {
            return false;
        }
        if (returnType != null && !returnType.equals(actualReturnType) && !this.canSetReturnType(returnType)) {
            return false;
        }
        if (name != null && !name.equals(this.getName()) && !this.isValidName(name)) {
            return false;
        }
        if ((name == null || name.equals(this.getName())) && (returnType == null || returnType.equals(actualReturnType))) {
            return true;
        }
        MethodSignatureSetter performer = this.getSignatureSetter(this.getMethodSignature(name, paramTypes, paramNames, returnType));
        if (!performer.canPerformNaive()) {
            this.mySignatureSetter = null;
            return false;
        }
        return true;
    }

    public IEJBMethod setSignature(String name, String[] paramTypes, String[] paramNames, String returnType, IProgressMonitor monitor) throws EJBModelException {
        String actualReturnType;
        try {
            actualReturnType = this.getReturnType();
        }
        catch (EJBModelException e) {
            return null;
        }
        String actualName = this.getName();
        if ((name == null || name.equals(actualName)) && (returnType == null || returnType.equals(actualReturnType))) {
            MethodSig newSig = this.getMethodSignature(actualName, paramTypes, paramNames, actualReturnType);
            this.setParameters(paramTypes, paramNames, null);
            return this.getParentBean().getEJBMethodByJavaTypes(newSig.getName(), newSig.getParameterTypeFQNs());
        }
        MethodSignatureSetter performer = this.getSignatureSetter(this.getMethodSignature(name, paramTypes, paramNames, returnType), true);
        if (!performer.canPerform()) {
            this.mySignatureSetter = null;
            return this;
        }
        try {
            try {
                performer.perform(monitor);
                EJBMethod eJBMethod = performer.getNewEJBMethod();
                Object var11_13 = null;
                this.mySignatureSetter = null;
                return eJBMethod;
            }
            catch (CoreException e) {
                throw new EJBModelException("Could not set signature", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.mySignatureSetter = null;
            throw throwable;
        }
    }

    private MethodSignatureSetter getSignatureSetter(MethodSig signature) {
        return this.getSignatureSetter(signature, false);
    }

    private MethodSignatureSetter getSignatureSetter(MethodSig signature, boolean assertName) {
        if (this.mySignatureSetter == null || assertName && !signature.equals(this.mySignatureSetter.getNewSignature())) {
            this.mySignatureSetter = new MethodSignatureSetter(this, signature);
        }
        return this.mySignatureSetter;
    }

    private MethodSig getMethodSignature(String name, String[] paramTypes, String[] paramNames, String returnType) {
        String[] paramTypeFQNs = new String[paramTypes.length];
        IType beanClass = this.getParentBean().getBeanClass();
        int i = 0;
        while (i < paramTypes.length) {
            paramTypeFQNs[i] = JDTUtils.getFQN((IType)beanClass, (String)paramTypes[i]);
            ++i;
        }
        returnType = JDTUtils.getFQN((IType)beanClass, (String)returnType);
        return new MethodSig(name, paramTypes, paramNames, paramTypeFQNs, returnType);
    }

    protected IMethod findMethod(int role, String name, String[] parameterTypeSignatures) {
        try {
            AccessibleBean parent = (AccessibleBean)this.getParent();
            IType participant = parent.getParticipant(role);
            if (participant == null || !participant.exists()) {
                return null;
            }
            IMethod fallBackMethod = participant.getMethod(name, parameterTypeSignatures);
            IMethod[] similarMethods = participant.findMethods(fallBackMethod);
            if (similarMethods == null || similarMethods.length != 1) {
                return fallBackMethod;
            }
            return similarMethods[0];
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    public ICopiedEJBElement cut() throws EJBModelException {
        if (!this.validateEdit(this.getMethods(), true)) {
            throw new EJBModelException("Could not modify read-only files");
        }
        CopiedEJBMethod result = new CopiedEJBMethod(this, true);
        this.delete(null);
        return result;
    }

    public ICopiedEJBElement copy() throws EJBModelException {
        return new CopiedEJBMethod(this, false);
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        if (this.isCMPAccessor()) {
            return false;
        }
        return this.internalCanCut();
    }

    public boolean internalCanCut() {
        int role = 1;
        int roleMax = this.getExistingMethods();
        while (role <= roleMax) {
            IMethod method;
            if ((role & roleMax) != 0 && (method = this.getMethod(role)).isBinary()) {
                return false;
            }
            role <<= 1;
        }
        return true;
    }

    protected final EJBMethod pasteCopy(EnterpriseBean target, String name, String[] paramTypeFQNs, String[] paramNames, String[] exceptionTypes, String returnType, IntHashMap methodBodiesAndComments) throws EJBModelException {
        if (!this.isValidName(name)) {
            throw new EJBModelException("Invalid name");
        }
        if (target.getEJBMethodByJavaTypes(name, paramTypeFQNs) != null) {
            throw new EJBModelException("Duplicate method");
        }
        return this.doPasteCopy(target, name, paramTypeFQNs, paramNames, exceptionTypes, returnType, methodBodiesAndComments);
    }

    protected EJBMethod doPasteCopy(EnterpriseBean target, String name, String[] paramTypeFQNs, String[] paramNames, String[] exceptionTypes, String returnType, IntHashMap methodBodiesAndComments) throws EJBModelException {
        target.enterWorkingCopyMode();
        try {
            Iterator it = methodBodiesAndComments.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry next = it.next();
                int role = (Integer)next.getKey();
                BodyAndComment bodyAndComment = (BodyAndComment)next.getValue();
                try {
                    this.pasteMethodCopy(target, role, name, paramTypeFQNs, paramNames, exceptionTypes, returnType, bodyAndComment);
                }
                catch (CoreException e) {
                    throw new EJBModelException("Exception occurred while pasting method", (Throwable)e);
                }
            }
            Object var14_13 = null;
            target.exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            target.exitWorkingCopyMode();
            throw throwable;
        }
        return (EJBMethod)target.getEJBMethodByJavaTypes(name, paramTypeFQNs);
    }

    protected abstract void pasteMethodCopy(EnterpriseBean var1, int var2, String var3, String[] var4, String[] var5, String[] var6, String var7, BodyAndComment var8) throws CoreException;

    protected final void pasteMethodBody(IType type, String methodName, String[] paramTypeFQNs, BodyAndComment bodyAndComment) throws JavaModelException {
        ICompilationUnit cu = type.getCompilationUnit();
        IBuffer buffer = cu.getBuffer();
        IDOMCompilationUnit domCU = new DOMFactory().createCompilationUnit(buffer.getContents(), cu.getElementName());
        IMethod jdtMethod = JDTUtils.findMethod((IType)type, (String)methodName, (String[])paramTypeFQNs);
        if (jdtMethod == null) {
            throw new IllegalStateException("Method must have already been created");
        }
        IDOMMethod method = (IDOMMethod)JDTUtils.findNode((IDOMNode)domCU, (IMember)jdtMethod);
        if (method == null) {
            throw new IllegalStateException("Method must have already been created");
        }
        if (bodyAndComment.getBody() == null && !jdtMethod.getDeclaringType().isInterface()) {
            int flags = method.getFlags();
            method.setFlags(flags |= 0x400);
        }
        method.setBody(bodyAndComment.getBody());
        method.setComment(bodyAndComment.getComment());
        String newSource = domCU.getContents();
        String formattedSource = new CodeFormatter((Map)null).format(newSource);
        buffer.setContents(formattedSource);
        buffer.save(null, true);
        cu.makeConsistent(null);
        cu.save(null, true);
    }

    public abstract boolean canSetReturnType(String var1);
}

