/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.IEJBSynchronizeListener;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.selena.model.preferences.PreferencesPlugin;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class EJBImplPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.tssap.j2ee.internal.core.ejb";
    private boolean myTracing;
    private boolean myDebuggingDelta;
    private static EJBImplPlugin ourInstance;
    private IEJBSynchronizeListener[] myListeners;
    private static final String SYNCHRONIZERS_EXTENSION_POINT = "ejbSynchronizers";
    private static final String SYNCHRONIZER = "synchronizer";
    private static final String CLASS = "class";
    public static final String PROMOTE_CMP_ACCESSORS_ON_CREATION = "PromoteCMPAccessorsOnCreation";

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public EJBImplPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = UtilsPlugin.getTraceDebugOption((IPluginDescriptor)descriptor);
        this.myDebuggingDelta = UtilsPlugin.getDeltaDebugOption((IPluginDescriptor)descriptor);
    }

    public static EJBImplPlugin getDefault() {
        return ourInstance;
    }

    public void startup() throws CoreException {
        super.startup();
    }

    public void shutdown() throws CoreException {
        super.shutdown();
    }

    public static void revisit() {
    }

    public static void revisit(String msg) {
    }

    public IEJBSynchronizeListener[] getSynchronizeListeners() {
        if (this.myListeners == null) {
            this.myListeners = this.loadSynchronizeListeners();
        }
        return this.myListeners;
    }

    private IEJBSynchronizeListener[] loadSynchronizeListeners() {
        ArrayList<IEJBSynchronizeListener> result = new ArrayList<IEJBSynchronizeListener>();
        IExtensionPoint extensionPoint = this.getDescriptor().getExtensionPoint(SYNCHRONIZERS_EXTENSION_POINT);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] confs = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < confs.length) {
                if (SYNCHRONIZER.equals(confs[j].getName())) {
                    try {
                        result.add((IEJBSynchronizeListener)confs[j].createExecutableExtension(CLASS));
                    }
                    catch (Throwable couldNotInstantiate) {
                        EJBImplPlugin.logError("Could not instantiate synchronize listener", couldNotInstantiate);
                    }
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new IEJBSynchronizeListener[result.size()]);
    }

    public static boolean isPromotingAccessors() {
        return PreferencesPlugin.getPreferenceStore((String)"workspace", null).getBoolean(PROMOTE_CMP_ACCESSORS_ON_CREATION);
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public boolean isDebuggingDelta() {
        return this.myDebuggingDelta;
    }

    public static void logInfo(String text) {
        EJBImplPlugin instance = EJBImplPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        EJBImplPlugin.log(1, text);
    }

    public static void logError(String text) {
        EJBImplPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        EJBImplPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        EJBImplPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        EJBImplPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        EJBImplPlugin instance = EJBImplPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            EJBImplPlugin.log(type, text, new Throwable());
        } else {
            EJBImplPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        EJBImplPlugin instance = EJBImplPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }
}

