/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejb.IEJBDelta;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IRelationshipEnd;
import com.tssap.j2ee.internal.core.ejb.EJBElement;
import com.tssap.j2ee.internal.core.ejb.EjbProjectImpl;
import com.tssap.j2ee.internal.core.ejb.RelationshipEnd;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class EJBDelta
implements IEJBDelta {
    private EjbProjectImpl myProject;
    private Collection myFieldsMadeCMR = new HashSet();
    private Collection myFieldsUnmadeCMR = new HashSet();
    private TreeMap mySignatures2Infos = new TreeMap();
    private RenameMapping myRenameMapping = new RenameMapping();
    private static final int DK_ADDED = 1;
    private static final int DK_REMOVED = 2;
    private static final int DK_CHANGED = 4;
    private static final int DK_TOTALLY_CHANGED = 8;
    public static final char SIGNATURE_DELIMITER = '\u0000';
    public static final char PAST_SIGNATURE_DELIM = '\u0001';

    public EJBDelta(EjbProjectImpl project) {
        this.myProject = project;
    }

    public EjbProject getProject() {
        return this.myProject;
    }

    private void deltaAccessed() {
        this.myProject.deltaBecameInvalid(this);
    }

    public IEJBElement[] getAddedElements() {
        this.deltaAccessed();
        Collection matching = this.matchElements(1);
        Iterator it = matching.iterator();
        while (it.hasNext()) {
            EJBElement next = (EJBElement)((Object)it.next());
            if (!this.myRenameMapping.containsAdded(next)) continue;
            it.remove();
        }
        return matching.toArray(new IEJBElement[matching.size()]);
    }

    public IEJBElement[] getRemovedElements() {
        this.deltaAccessed();
        Collection matching = this.matchElements(2);
        Iterator it = matching.iterator();
        while (it.hasNext()) {
            EJBElement next = (EJBElement)((Object)it.next());
            if (!this.myRenameMapping.containsRemoved(next)) continue;
            it.remove();
        }
        return matching.toArray(new IEJBElement[matching.size()]);
    }

    public IEJBElement[] getChangedElements() {
        this.deltaAccessed();
        Collection matching = this.matchElements(4);
        return matching.toArray(new IEJBElement[matching.size()]);
    }

    public IEJBElement[] getTotallyChangedElements() {
        this.deltaAccessed();
        Collection matching = this.matchElements(8);
        return matching.toArray(new IEJBElement[matching.size()]);
    }

    public IEJBElement[][] getRenamedElements() {
        this.deltaAccessed();
        ArrayList<EJBElement> removedArray = new ArrayList<EJBElement>();
        ArrayList<EJBElement> addedArray = new ArrayList<EJBElement>();
        Iterator it = this.myRenameMapping.myAddedSigToRemovedSig.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            String addedSig = (String)next.getKey();
            String removedSig = (String)next.getValue();
            EJBElement addedElement = this.findElementBySignature(addedSig);
            EJBElement removedElement = this.findElementBySignature(removedSig);
            if (addedElement == null || removedElement == null) continue;
            addedArray.add(addedElement);
            removedArray.add(removedElement);
        }
        IEJBElement[][] result = new IEJBElement[][]{removedArray.toArray(new IEJBElement[removedArray.size()]), addedArray.toArray(new IEJBElement[addedArray.size()])};
        return result;
    }

    private Collection matchElements(int deltaKind) {
        ArrayList<EJBElement> result = new ArrayList<EJBElement>();
        Iterator it = this.mySignatures2Infos.values().iterator();
        while (it.hasNext()) {
            EJBElementInfo info = (EJBElementInfo)it.next();
            if (info.myDeltaKind != deltaKind) continue;
            result.add(info.myElement);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.myFieldsMadeCMR.size() + this.myFieldsUnmadeCMR.size() + this.mySignatures2Infos.size() == 0;
    }

    public IRelationshipEnd[] getFieldsMadeCMR() {
        return this.myFieldsMadeCMR.toArray(new IRelationshipEnd[this.myFieldsMadeCMR.size()]);
    }

    public IRelationshipEnd[] getFieldsCeasedCMR() {
        return this.myFieldsUnmadeCMR.toArray(new IRelationshipEnd[this.myFieldsUnmadeCMR.size()]);
    }

    void changed(EJBElement element) {
        EJBElementInfo info = this.findOrCreate(element);
        if (info != null && info.myDeltaKind == 0) {
            info.myDeltaKind = 4;
        }
    }

    void totallyChanged(EJBElement element) {
        EJBElementInfo info = this.findOrCreate(element);
        if (info != null && (info.myDeltaKind == 0 || info.myDeltaKind == 4)) {
            info.myDeltaKind = 8;
            this.removeAllChildren(element, info.mySignature);
        }
    }

    void added(EJBElement element) {
        EJBElementInfo info = this.findOrCreate(element);
        if (info != null) {
            switch (info.myDeltaKind) {
                case 0: 
                case 4: 
                case 8: {
                    info.myDeltaKind = 1;
                    this.removeAllChildren(element, info.mySignature);
                    break;
                }
                case 2: {
                    info.myDeltaKind = 8;
                }
            }
        }
    }

    void removed(EJBElement element) {
        EJBElementInfo info = this.findOrCreate(element);
        if (info != null) {
            switch (info.myDeltaKind) {
                case 0: 
                case 4: 
                case 8: {
                    info.myDeltaKind = 2;
                    this.removeAllChildren(element, info.mySignature);
                    break;
                }
                case 1: {
                    info.myDeltaKind = 8;
                }
            }
        }
    }

    public void renamed(EJBElement removed, EJBElement added) {
        this.createInfoIfMissing(added);
        this.added(added);
        this.createInfoIfMissing(removed);
        this.removed(removed);
        this.myRenameMapping.addMapping(added, removed);
    }

    private EJBElementInfo createInfoIfMissing(EJBElement element) {
        String signature = element.getHandleIdentifier();
        EJBElementInfo info = (EJBElementInfo)this.mySignatures2Infos.get(signature);
        if (info == null) {
            info = new EJBElementInfo(element, signature);
            this.mySignatures2Infos.put(signature, info);
        }
        return info;
    }

    private EJBElementInfo findOrCreate(EJBElement element) {
        EJBElementInfo parentInfo;
        String signature = element.getHandleIdentifier();
        EJBElementInfo info = (EJBElementInfo)this.mySignatures2Infos.get(signature);
        if (info == null && ((parentInfo = this.findParentInMap(element, signature)) == null || parentInfo.canHaveChildren())) {
            info = new EJBElementInfo(element, signature);
            this.mySignatures2Infos.put(signature, info);
        }
        return info;
    }

    private EJBElement findElementBySignature(String sig) {
        EJBElementInfo info = (EJBElementInfo)this.mySignatures2Infos.get(sig);
        if (info == null) {
            return null;
        }
        return info.myElement;
    }

    private EJBElementInfo findParentInMap(EJBElement element, String signature) {
        IEJBElement parent = element.getParent();
        while (parent instanceof EJBElement) {
            String sig = ((EJBElement)parent).getHandleIdentifier();
            EJBElementInfo info = (EJBElementInfo)this.mySignatures2Infos.get(sig);
            if (info != null) {
                return info;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private void removeAllChildren(EJBElement element, String signature) {
        SortedMap allChildren = this.mySignatures2Infos.subMap(signature + '\u0000', signature + '\u0001');
        Iterator it = allChildren.keySet().iterator();
        while (it.hasNext()) {
            String nextRemovedSig = (String)it.next();
            if (this.myRenameMapping.hasMapping(nextRemovedSig)) continue;
            it.remove();
        }
    }

    public void addFieldUnmadeCMR(RelationshipEnd rel) {
        if (this.myFieldsMadeCMR.contains((Object)rel)) {
            this.myFieldsMadeCMR.remove((Object)rel);
        } else {
            this.myFieldsUnmadeCMR.add(rel);
        }
    }

    public void addFieldMadeCMR(RelationshipEnd rel) {
        if (this.myFieldsUnmadeCMR.contains((Object)rel)) {
            this.myFieldsUnmadeCMR.remove((Object)rel);
        } else {
            this.myFieldsMadeCMR.add(rel);
        }
    }

    private static final class RenameMapping {
        private HashMap myAddedSigToRemovedSig = new HashMap();
        private HashMap myRemovedSigToAddedSig = new HashMap();

        private RenameMapping() {
        }

        public void addMapping(EJBElement added, EJBElement removed) {
            String addedSig = added.getHandleIdentifier();
            String removedSig = removed.getHandleIdentifier();
            this.myAddedSigToRemovedSig.put(addedSig, removedSig);
            this.myRemovedSigToAddedSig.put(removedSig, addedSig);
        }

        public boolean containsAdded(EJBElement added) {
            return this.myAddedSigToRemovedSig.containsKey(added.getHandleIdentifier());
        }

        public boolean containsRemoved(EJBElement removed) {
            return this.myRemovedSigToAddedSig.containsKey(removed.getHandleIdentifier());
        }

        public boolean hasMapping(String sig) {
            return this.myRemovedSigToAddedSig.containsKey(sig) || this.myAddedSigToRemovedSig.containsKey(sig);
        }
    }

    private static final class EJBElementInfo {
        private String mySignature;
        private int myDeltaKind;
        private EJBElement myElement;

        public EJBElementInfo(EJBElement element) {
            this(element, element.getHandleIdentifier());
        }

        public EJBElementInfo(EJBElement element, String signature) {
            this.mySignature = signature;
            this.myElement = element;
        }

        public boolean canHaveChildren() {
            return this.myDeltaKind != 1 && this.myDeltaKind != 2 && this.myDeltaKind != 8;
        }

        public int hashCode() {
            return this.mySignature.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof EJBElementInfo) {
                EJBElementInfo that = (EJBElementInfo)o;
                return this.mySignature.equals(that.mySignature) && this.myDeltaKind == that.myDeltaKind;
            }
            return false;
        }
    }
}

