/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejb.ICopiedEJBElement;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.utils.ReadOnlinessValidator;
import com.tssap.j2ee.internal.core.ejb.BusinessMethod;
import com.tssap.j2ee.internal.core.ejb.CopiedEJBMethod;
import com.tssap.j2ee.internal.core.ejb.EntityBean;
import com.tssap.j2ee.internal.core.ejb.PersistentField;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMField;

public class CopiedPersistentField
implements ICopiedEJBElement,
IPersistentField {
    private boolean myIsCut;
    private PersistentField mySource;
    private String myName;
    private String myType;
    private boolean myInPK;
    private String myFieldContents;
    private CopiedEJBMethod myGetter;
    private CopiedEJBMethod mySetter;

    public CopiedPersistentField(PersistentField source, boolean isCut) throws EJBModelException {
        BusinessMethod setterBM;
        this.mySource = source;
        this.myIsCut = isCut;
        this.myInPK = source.isInPrimaryKey();
        this.myName = source.getName();
        this.myType = source.getType();
        BusinessMethod getterBM = source.getGetterBM();
        if (getterBM != null) {
            this.myGetter = new CopiedEJBMethod(getterBM, isCut);
        }
        if ((setterBM = source.getSetterBM()) != null) {
            this.mySetter = new CopiedEJBMethod(setterBM, isCut);
        }
        this.myFieldContents = this.getContents(this.getField());
    }

    private String getContents(IField field) throws EJBModelException {
        if (field == null || !field.exists()) {
            return null;
        }
        try {
            IDOMField domField = new DOMFactory().createField(field.getSource());
            if (domField == null) {
                throw new EJBModelException("Cannot access method");
            }
            return domField.getContents();
        }
        catch (JavaModelException e) {
            throw new EJBModelException("Cannot access method");
        }
    }

    public boolean canPaste(IEJBElement container) {
        return container instanceof EntityBean && this.canPasteTo((EntityBean)container);
    }

    private boolean canPasteTo(EntityBean bean) {
        try {
            if (bean.isCMP() != this.mySource.getEJB().isCMP()) {
                return false;
            }
            if (bean.isSimplePK() != this.mySource.getEJB().isSimplePK()) {
                return false;
            }
            return !bean.isSimplePK() || bean.getPKFields().isEmpty() || !this.myInPK;
        }
        catch (EJBModelException e) {
            return false;
        }
    }

    public IEJBElement paste(IEJBElement container) throws EJBModelException {
        return this.pasteTo((EntityBean)container);
    }

    private PersistentField pasteTo(EntityBean bean) throws EJBModelException {
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        EnterpriseBean[] assembledBeans = AssembledInfoFinder.findAssembledBeans((IEnterpriseBean)bean);
        int i = 0;
        while (i < assembledBeans.length) {
            validator.addResource(assembledBeans[i].getDocument().getFile());
            ++i;
        }
        if (this.myFieldContents != null) {
            validator.addJavaElement((IMember)bean.getBeanClass());
        }
        if (this.myGetter != null) {
            this.myGetter.addSourceOccurrencesToValidator(bean, validator);
        }
        if (this.mySetter != null) {
            this.mySetter.addSourceOccurrencesToValidator(bean, validator);
        }
        if (this.myInPK && !bean.isSimplePK()) {
            validator.addJavaElement((IMember)bean.getParticipant(32));
        }
        if (!validator.canModify()) {
            throw new EJBModelException("Could not modify read-only files");
        }
        try {
            PersistentField createdField;
            String name = this.getUnusedFieldName(bean);
            try {
                createdField = this.doPaste(bean, name);
            }
            catch (JavaModelException e) {
                throw new EJBModelException("Could not paste field");
            }
            if (this.myIsCut) {
                if (!this.equalFields(this.mySource, createdField)) {
                    this.mySource.internalGetEJBProject().getDelta().renamed(this.mySource, createdField);
                } else {
                    this.mySource.internalGetEJBProject().getDelta().totallyChanged(createdField);
                }
            }
            PersistentField persistentField = createdField;
            Object var9_9 = null;
            this.myIsCut = false;
            return persistentField;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.myIsCut = false;
            throw throwable;
        }
    }

    private PersistentField doPaste(EntityBean bean, String name) throws EJBModelException, JavaModelException {
        if (this.myFieldContents != null) {
            IDOMField field = new DOMFactory().createField(this.myFieldContents);
            field.setName(name);
            IType beanClass = bean.getBeanClass();
            if (JDTUtils.addImport((IType)beanClass, (String)this.myType)) {
                field.setType(Signature.getSimpleName((String)this.myType));
            } else {
                field.setType(this.myType);
            }
            beanClass.createField(field.getContents() + "\n", null, false, null);
        }
        if (this.mySetter != null) {
            this.mySetter.setName(JDTUtils.getSetterName((String)name), null);
            this.mySetter.paste(bean);
        }
        if (this.myGetter != null) {
            this.myGetter.setName(JDTUtils.getGetterName((String)name), null);
            this.myGetter.paste(bean);
        }
        PersistentField result = (PersistentField)bean.getField(name);
        result.setInPrimaryKey(this.myInPK);
        return result;
    }

    private boolean equalFields(PersistentField one, PersistentField another) {
        return one.getHandleIdentifier().equals(another.getHandleIdentifier());
    }

    private String getUnusedFieldName(EntityBean bean) throws EJBModelException {
        int startingNumber;
        int lastChar;
        String result = this.myName;
        if (!this.hasField(bean, result)) {
            return result;
        }
        int lastDigit = lastChar = result.length() - 1;
        while (lastDigit > 0 && Character.isDigit(result.charAt(lastDigit))) {
            --lastDigit;
        }
        ++lastDigit;
        while (lastDigit < lastChar && result.charAt(lastDigit) == '0') {
            ++lastDigit;
        }
        if (lastDigit <= lastChar) {
            String trailingDigits = result.substring(lastDigit);
            try {
                startingNumber = Integer.parseInt(trailingDigits);
                result = result.substring(0, lastDigit);
            }
            catch (NumberFormatException e) {
                startingNumber = 1;
            }
        } else {
            startingNumber = 1;
        }
        int i = startingNumber;
        while (i < Integer.MAX_VALUE) {
            if (!this.hasField(bean, result + i)) {
                return result + i;
            }
            ++i;
        }
        throw new EJBModelException("Could not find unused name: too many fields");
    }

    private boolean hasField(EntityBean bean, String name) throws EJBModelException {
        if (bean.getField(name) != null) {
            return true;
        }
        if (bean.getEJBMethodByJavaTypes(JDTUtils.getGetterName((String)name), ArrayUtils.EMPTY_STRING_ARRAY) != null) {
            return true;
        }
        return bean.getEJBMethodByJavaTypes(JDTUtils.getSetterName((String)name), new String[]{this.myType}) != null;
    }

    public boolean isInPrimaryKey() {
        return this.myInPK;
    }

    public boolean canSetInPrimaryKey(boolean inPrimaryKey) {
        return true;
    }

    public void setInPrimaryKey(boolean inPrimaryKey) throws EJBModelException {
        this.myInPK = inPrimaryKey;
    }

    public IField getField() {
        return this.mySource.getField();
    }

    public IMethod getGetter() {
        return this.mySource.getGetter();
    }

    public IMethod getSetter() {
        return this.mySource.getSetter();
    }

    public IField getFieldInPKClass() {
        return this.mySource.getFieldInPKClass();
    }

    public void delete(IProgressMonitor monitor) throws EJBModelException {
    }

    public String getName() {
        return this.myName;
    }

    public IPersistentField setName(String newName, IProgressMonitor monitor) throws EJBModelException {
        this.myName = newName;
        return null;
    }

    public String getType() {
        return this.myType;
    }

    public boolean canSetType(String type) {
        return true;
    }

    public void setType(String type, IProgressMonitor monitor) throws EJBModelException {
        this.myType = type;
    }

    public boolean canSetSignature(String name, String type) {
        return true;
    }

    public IPersistentField setSignature(String name, String type, IProgressMonitor monitor) throws EJBModelException {
        this.myName = name;
        this.myType = type;
        return null;
    }

    public boolean isRelationship() {
        return this.mySource.isRelationship();
    }

    public EjbProject getEJBProject() {
        return this.mySource.getEJBProject();
    }

    public IEJBElement getParent() {
        return this.mySource.getParent();
    }

    public void createGetter(IProgressMonitor monitor) throws EJBModelException {
    }

    public void createSetter(IProgressMonitor monitor) throws EJBModelException {
    }

    public boolean exists() {
        return true;
    }

    public IStatus validate() throws EJBModelException {
        return null;
    }

    public boolean canCopy() {
        return true;
    }

    public ICopiedEJBElement copy() throws EJBModelException {
        return this;
    }

    public boolean canCut() {
        return this.myIsCut;
    }

    public ICopiedEJBElement cut() throws EJBModelException {
        if (this.myIsCut) {
            return this;
        }
        throw new EJBModelException("Cannot cut copied element");
    }

    public boolean canSetDdp(String name, Object value) {
        return false;
    }

    public void setDdp(String name, Object value) {
    }

    public String[] getDdpNames() {
        return null;
    }

    public Object getDdp(String name) {
        return null;
    }

    public String getDdpAsString(String name) {
        return null;
    }

    public void applyDdp(Object entity, String name) {
    }

    public void applyDdps(Object entity) {
    }
}

