/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbMetaInfo;
import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.ICopiedEJBElement;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.utils.ReadOnlinessValidator;
import com.tssap.j2ee.internal.core.ejb.BodyAndComment;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.EnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.EntityBean;
import com.tssap.j2ee.internal.core.ejb.SessionBean;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMMethod;

public class CopiedEJBMethod
implements ICopiedEJBElement,
IEJBMethod {
    private EJBMethod mySource;
    private boolean myIsCut;
    private String myName;
    private String myNameForDD;
    private String myReturnType;
    private String[] myParameterTypeFQNs;
    private String[] myParameterNames;
    private String[] myExceptionTypes;
    private IntHashMap myMethodBodiesAndComments = new IntHashMap();
    private boolean myHaveSetAnySignaturePart;
    private static final String CREATE_BY_PK_BEAN_CLASS_METHOD_NAME = EjbMetaInfo.getCreateMethodImplName((String)"byPrimaryKey");
    private static final String FIND_BY_PK_BEAN_CLASS_METHOD_NAME = EjbMetaInfo.getFindMethodImplName((String)"byPrimaryKey");

    public CopiedEJBMethod(EJBMethod source, boolean isCut) throws EJBModelException {
        this.mySource = source;
        this.myIsCut = isCut;
        this.myName = source.getName();
        this.myNameForDD = source.getNameForDD();
        this.myParameterTypeFQNs = source.getParameterTypesForDD();
        this.myParameterNames = source.getParameterNames();
        this.myReturnType = source.getReturnType();
        this.myExceptionTypes = source.getExceptionTypes();
        int role = 1;
        int roleMax = source.getExistingMethods();
        while (role <= roleMax) {
            if ((role & roleMax) != 0) {
                IMethod method = source.getMethod(role);
                if (isCut && method.isBinary()) {
                    throw new EJBModelException("Cannot cut binary method");
                }
                this.myMethodBodiesAndComments.put(role, (Object)this.getBodyAndComment(method));
            }
            role <<= 1;
        }
    }

    private BodyAndComment getBodyAndComment(IMethod method) throws EJBModelException {
        boolean noBody = false;
        try {
            IDOMMethod domMethod;
            if (method.getDeclaringType().isInterface() || Flags.isAbstract((int)method.getFlags())) {
                noBody = true;
            }
            if ((domMethod = new DOMFactory().createMethod(method.getSource())) == null) {
                throw new EJBModelException("Cannot access method");
            }
            String body = noBody ? null : domMethod.getBody();
            return new BodyAndComment(body, domMethod.getComment());
        }
        catch (JavaModelException e) {
            throw new EJBModelException("Cannot access method");
        }
    }

    public IEJBElement paste(IEJBElement container) throws EJBModelException {
        return this.pasteTo((EnterpriseBean)container);
    }

    public IEJBMethod pasteTo(EnterpriseBean bean) throws EJBModelException {
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        com.tssap.j2ee.core.descriptor.EnterpriseBean[] assembledBeans = AssembledInfoFinder.findAssembledBeans((IEnterpriseBean)bean);
        int i = 0;
        while (i < assembledBeans.length) {
            validator.addResource(assembledBeans[i].getDocument().getFile());
            ++i;
        }
        this.addSourceOccurrencesToValidator(bean, validator);
        if (!validator.canModify()) {
            throw new EJBModelException("Could not modify read-only files");
        }
        try {
            boolean isByPKMethod;
            boolean bl = isByPKMethod = bean.getKind() == 1 && this.isByPKMethod(this.myName, this.myParameterTypeFQNs);
            if (isByPKMethod) {
                IType targetPK = ((EntityBean)bean).getParticipant(32);
                if (targetPK == null) {
                    throw new EJBModelException("Could not paste byPrimaryKey method: cannot locate primary key class for target bean");
                }
                this.myParameterTypeFQNs = new String[]{targetPK.getFullyQualifiedName()};
            }
            String name = this.getUnusedMethodName(bean);
            EJBMethod createdMethod = this.mySource.pasteCopy(bean, name, this.myParameterTypeFQNs, this.myParameterNames, this.myExceptionTypes, this.myReturnType, this.myMethodBodiesAndComments);
            if (this.myIsCut) {
                if (!CopiedEJBMethod.equalMethods(this.mySource, createdMethod)) {
                    this.mySource.internalGetEJBProject().getDelta().renamed(this.mySource, createdMethod);
                } else {
                    this.mySource.internalGetEJBProject().getDelta().totallyChanged(createdMethod);
                }
            }
            EJBMethod eJBMethod = createdMethod;
            Object var10_9 = null;
            this.myIsCut = false;
            return eJBMethod;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.myIsCut = false;
            throw throwable;
        }
    }

    void addSourceOccurrencesToValidator(EnterpriseBean bean, ReadOnlinessValidator validator) throws EJBModelException {
        if (bean.getKind() == 4) {
            validator.addJavaElement((IMember)bean.getBeanClass());
        } else {
            IAccessibleBean aBean = (IAccessibleBean)bean;
            Iterator it = this.myMethodBodiesAndComments.keySet().iterator();
            while (it.hasNext()) {
                int role = (Integer)it.next();
                if (role == 64) {
                    role = 1;
                }
                validator.addJavaElement((IMember)aBean.getParticipant(role));
            }
        }
    }

    private boolean isByPKMethod(String name, String[] parameterTypes) {
        if (parameterTypes.length != 1) {
            return false;
        }
        return CREATE_BY_PK_BEAN_CLASS_METHOD_NAME.equals(name) || FIND_BY_PK_BEAN_CLASS_METHOD_NAME.equals(name);
    }

    private static boolean equalMethods(EJBMethod one, EJBMethod another) {
        return one.getHandleIdentifier().equals(another.getHandleIdentifier());
    }

    private String getUnusedMethodName(EnterpriseBean bean) throws EJBModelException {
        int startingNumber;
        int lastChar;
        String result = this.myName;
        if (bean.getEJBMethodByJavaTypes(result, this.myParameterTypeFQNs) == null) {
            return result;
        }
        int lastDigit = lastChar = result.length() - 1;
        while (lastDigit > 0 && Character.isDigit(result.charAt(lastDigit))) {
            --lastDigit;
        }
        ++lastDigit;
        while (lastDigit < lastChar && result.charAt(lastDigit) == '0') {
            ++lastDigit;
        }
        if (lastDigit <= lastChar) {
            String trailingDigits = result.substring(lastDigit);
            try {
                startingNumber = Integer.parseInt(trailingDigits);
                result = result.substring(0, lastDigit);
            }
            catch (NumberFormatException e) {
                startingNumber = 1;
            }
        } else {
            startingNumber = 1;
        }
        int i = startingNumber;
        while (i < Integer.MAX_VALUE) {
            if (bean.getEJBMethodByJavaTypes(result + i, this.myParameterTypeFQNs) == null) {
                return result + i;
            }
            ++i;
        }
        throw new EJBModelException("Could not find unused name: too many methods");
    }

    public boolean canPaste(IEJBElement container) {
        return container instanceof EnterpriseBean && this.canPasteTo((EnterpriseBean)container);
    }

    public boolean canPasteTo(IEnterpriseBean bean) {
        int sourceBeanKind = this.mySource.getParentBean().getKind();
        switch (sourceBeanKind) {
            case 4: {
                return this.canPasteMDBMethodTo(bean);
            }
            case 1: {
                return this.canPasteEBMethodTo(bean) && this.checkParticipantsPresent((IAccessibleBean)bean) && this.checkUniqueness(bean);
            }
            case 2: {
                return this.canPasteSBMethodTo(bean) && this.checkParticipantsPresent((IAccessibleBean)bean) && this.checkUniqueness(bean);
            }
        }
        return false;
    }

    private boolean canPasteMDBMethodTo(IEnterpriseBean bean) {
        if (bean.getKind() != 4) {
            return false;
        }
        EJBImplPlugin.revisit("After coalescing methods from up the whole hierarchy, the check below will be invalid");
        try {
            if (bean.getEJBMethodByJavaTypes(this.myName, this.myParameterTypeFQNs) != null) {
                return false;
            }
        }
        catch (EJBModelException e) {
            return false;
        }
        return true;
    }

    private boolean canPasteEBMethodTo(IEnterpriseBean bean) {
        switch (bean.getKind()) {
            case 4: {
                return false;
            }
            case 1: {
                if (this.getKind() == 4 || this.getKind() == 16) {
                    try {
                        return ((IEntityBean)this.mySource.getParent()).isCMP() == ((IEntityBean)bean).isCMP();
                    }
                    catch (EJBModelException e) {
                        return false;
                    }
                }
                return true;
            }
            case 2: {
                return this.mySource.getKind() == 1;
            }
        }
        return false;
    }

    private boolean canPasteSBMethodTo(IEnterpriseBean bean) {
        switch (bean.getKind()) {
            case 4: {
                return false;
            }
            case 2: {
                return this.checkStatelessnessConditions((SessionBean)bean);
            }
            case 1: {
                return this.mySource.getKind() == 1;
            }
        }
        return false;
    }

    private boolean checkStatelessnessConditions(SessionBean bean) {
        if (bean.isStateful()) {
            return true;
        }
        if (this.getKind() != 2) {
            return true;
        }
        String onlyMethodName = EjbMetaInfo.getCreateMethodImplName((String)"");
        if (bean.getEJBMethodByJavaTypes(onlyMethodName, ArrayUtils.EMPTY_STRING_ARRAY) != null) {
            return false;
        }
        return onlyMethodName.equals(this.getName()) && this.getParameterTypes().length == 0;
    }

    private boolean checkParticipantsPresent(IAccessibleBean bean) {
        EJBImplPlugin.revisit("The code in the loop relies on IEJBMethod.R_* being equal to IAccessibleBean.R_*");
        try {
            Iterator it = this.myMethodBodiesAndComments.keySet().iterator();
            while (it.hasNext()) {
                IType participant;
                int requiredParticipant = (Integer)it.next();
                if (requiredParticipant == 64) {
                    requiredParticipant = 1;
                }
                if ((participant = bean.getParticipant(requiredParticipant)) != null && !participant.isBinary()) continue;
                return false;
            }
        }
        catch (EJBModelException beanDoesNotExist) {
            return false;
        }
        return true;
    }

    private boolean checkUniqueness(IEnterpriseBean bean) {
        if (!this.myHaveSetAnySignaturePart) {
            return true;
        }
        try {
            return bean.getEJBMethodByJavaTypes(this.myName, this.myParameterTypeFQNs) == null;
        }
        catch (EJBModelException e) {
            return false;
        }
    }

    public boolean canPromote(int role) {
        return false;
    }

    public boolean canSetName(String name) {
        return true;
    }

    public boolean canSetReturnType(String type) {
        return true;
    }

    public boolean canSetSignature(String name, String[] paramTypes, String[] paramNames, String returnType) {
        return true;
    }

    public boolean canUnpromote(int role) {
        return false;
    }

    public ICopiedEJBElement copy() throws EJBModelException {
        return this;
    }

    public ICopiedEJBElement cut() throws EJBModelException {
        if (this.myIsCut) {
            return this;
        }
        throw new EJBModelException("Cannot cut copied element");
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return this.myIsCut;
    }

    public boolean canDelete() {
        return false;
    }

    public void delete(IProgressMonitor monitor) throws EJBModelException {
    }

    public String[] getExceptionTypes() throws EJBModelException {
        return this.myExceptionTypes;
    }

    public void setExceptionTypes(String[] exceptions, IProgressMonitor monitor) throws EJBModelException {
        this.myExceptionTypes = exceptions;
    }

    public int getExistingMethods() {
        return 0;
    }

    public int getKind() {
        return this.mySource.getKind();
    }

    public IMethod getMethod(int role) throws EJBModelException {
        return null;
    }

    public IMethod[] getMethods() throws EJBModelException {
        return null;
    }

    public String getName() {
        return this.myName;
    }

    public String getNameForDD() {
        return this.myNameForDD;
    }

    public String[] getParameterNames() throws EJBModelException {
        return this.myParameterNames;
    }

    public String[] getParameterTypes() {
        return this.myParameterTypeFQNs;
    }

    public String[] getParameterTypesForDD() {
        return this.myParameterTypeFQNs;
    }

    public String getReturnType() throws EJBModelException {
        return this.myReturnType;
    }

    public void promote(int role) throws EJBModelException {
    }

    public IEJBMethod setName(String name, IProgressMonitor monitor) throws EJBModelException {
        this.myName = name;
        this.myNameForDD = this.mySource.getRenamedNameForDD(name);
        this.myHaveSetAnySignaturePart = true;
        return this;
    }

    public void setParameters(String[] types, String[] names, IProgressMonitor monitor) throws EJBModelException {
        this.myParameterTypeFQNs = types;
        this.myParameterNames = names;
        this.myHaveSetAnySignaturePart = true;
    }

    public void setReturnType(String type, IProgressMonitor monitor) throws EJBModelException {
        if (type == null) {
            return;
        }
        this.myReturnType = type;
        this.myHaveSetAnySignaturePart = true;
    }

    public IEJBMethod setSignature(String name, String[] paramTypes, String[] paramNames, String returnType, IProgressMonitor monitor) throws EJBModelException {
        this.setName(name, null);
        this.setParameters(paramTypes, paramNames, null);
        this.setReturnType(returnType, null);
        return this;
    }

    public void unpromote(int role) throws EJBModelException {
    }

    public boolean exists() {
        return true;
    }

    public EjbProject getEJBProject() {
        return this.mySource.getEJBProject();
    }

    public IEJBElement getParent() {
        return null;
    }

    public IStatus validate() throws EJBModelException {
        return null;
    }

    public boolean canSetDdp(String name, Object value) {
        return false;
    }

    public void setDdp(String name, Object value) {
    }

    public void applyDdp(Object entity, String name) {
    }

    public void applyDdps(Object entity) {
    }

    public Object getDdp(String name) {
        return null;
    }

    public String getDdpAsString(String name) {
        return null;
    }

    public String[] getDdpNames() {
        return null;
    }
}

