/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.utils.clipboard.ClipboardElement;
import com.tssap.j2ee.internal.core.ejb.AccessibleBean;
import com.tssap.j2ee.internal.core.ejb.CopiedEnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.IntSortedMap;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class CopiedAccessibleBean
extends CopiedEnterpriseBean {
    private static final Comparator PARTICIPANT_COMPARATOR = new Comparator(){

        public int compare(Object first, Object second) {
            return -((Comparable)first).compareTo(second);
        }
    };
    private IntSortedMap myRoles2CopiedTypeEntities = new IntSortedMap(PARTICIPANT_COMPARATOR);
    private IntSortedMap myRoles2PastedJDTTypes = new IntSortedMap();
    private IntSortedMap myRoles2OriginalTypeNames = new IntSortedMap(PARTICIPANT_COMPARATOR);
    private int myOriginalExistingRoles;
    private static final IntHashMap ROLES_2_EJBJARMODELMETAINFO_CONSTANTS = new IntHashMap();

    public CopiedAccessibleBean(AccessibleBean source, boolean isCut, boolean forPackage) throws EJBModelException {
        super(source, isCut, forPackage);
        int existingRoles = source.getExistingRoles();
        int i = 32;
        while (i > 1) {
            IType participant;
            if ((i & existingRoles) != 0 && this.shouldCopyParticipant(i, participant = source.getParticipant(i))) {
                this.myRoles2OriginalTypeNames.put(i, participant.getFullyQualifiedName());
                this.myOriginalExistingRoles |= i;
                if (!forPackage) {
                    this.myRoles2CopiedTypeEntities.put(i, this.cutOrCopy(participant));
                }
            }
            i >>= 1;
        }
    }

    protected boolean shouldCopyParticipant(int i, IType participant) {
        if (participant.isBinary()) {
            return false;
        }
        if (this.isForPackage() || this.isCut()) {
            return participant.getPackageFragment().equals(this.getSource().getBeanClass().getPackageFragment());
        }
        return true;
    }

    protected boolean canPasteTypes(Entity packageAsEntity) {
        if (!super.canPasteTypes(packageAsEntity)) {
            return false;
        }
        Iterator it = this.myRoles2CopiedTypeEntities.values().iterator();
        while (it.hasNext()) {
            Entity nextParticipantCopy = (Entity)it.next();
            if (nextParticipantCopy == null || packageAsEntity.canPaste((Element)nextParticipantCopy)) continue;
            return false;
        }
        return true;
    }

    protected Entity pasteTypes(Entity packageAsEntity) {
        Entity result = super.pasteTypes(packageAsEntity);
        if (result == null) {
            return null;
        }
        IType pastedBeanClass = (IType)ElementUtil.getJavaElement((Element)result);
        this.removeImportsToOtherCopiedTypes(pastedBeanClass);
        Iterator it = this.myRoles2CopiedTypeEntities.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            int role = (Integer)next.getKey();
            Entity nextParticipantCopy = (Entity)next.getValue();
            if (nextParticipantCopy == null) continue;
            Element pastedTypeAsEntity = packageAsEntity.paste((Element)nextParticipantCopy);
            IType pastedType = (IType)ElementUtil.getJavaElement((Element)pastedTypeAsEntity);
            this.removeImportsToOtherCopiedTypes(pastedType);
            this.myRoles2PastedJDTTypes.put(role, pastedType);
        }
        return result;
    }

    private void removeImportsToOtherCopiedTypes(IType type) {
        if (type == null || type.isBinary()) {
            return;
        }
        ICompilationUnit cu = type.getCompilationUnit();
        try {
            ICompilationUnit wc = (ICompilationUnit)cu.getWorkingCopy();
            Iterator it = this.myRoles2OriginalTypeNames.values().iterator();
            while (it.hasNext()) {
                String fqn = (String)it.next();
                IImportDeclaration decl = wc.getImport(fqn);
                if (!decl.exists()) continue;
                decl.delete(false, null);
            }
            IBuffer wcBuffer = wc.getBuffer();
            if (wcBuffer != null && wcBuffer.hasUnsavedChanges()) {
                wc.commit(false, null);
            }
            wc.destroy();
        }
        catch (JavaModelException e) {
            EJBImplPlugin.logError("Exception occurred while committing working copy for the compilation unit of type " + type.getFullyQualifiedName(), e);
        }
    }

    protected void postPaste(IType newType) {
        if (newType == null) {
            return;
        }
        final String fqn = newType.getFullyQualifiedName();
        ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                try {
                    IEnterpriseBean bean = CopiedAccessibleBean.this.getEJBProject().getEnterpriseBean(fqn);
                    if (bean instanceof AccessibleBean) {
                        AccessibleBean aBean = (AccessibleBean)bean;
                        Iterator it = CopiedAccessibleBean.this.myRoles2PastedJDTTypes.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry next = it.next();
                            int role = (Integer)next.getKey();
                            IType newParticipant = (IType)next.getValue();
                            if (newParticipant == null) continue;
                            aBean.addParticipant(role, newParticipant.getFullyQualifiedName(), true, null, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                }
                catch (EJBModelException e) {
                    EJBImplPlugin.logWarning("Exception occurred while postprocessing the pasted EJB", e);
                }
            }
        });
    }

    protected void fixupAssembledClipboardEntity(ClipboardElement clipboardEntity, IType newType) {
        super.fixupAssembledClipboardEntity(clipboardEntity, newType);
        Iterator it = this.myRoles2PastedJDTTypes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            int role = (Integer)next.getKey();
            String property = CopiedAccessibleBean.getPropertyForRole(role);
            IType newParticipant = (IType)next.getValue();
            if (newParticipant == null) continue;
            String newFQN = newParticipant.getFullyQualifiedName();
            clipboardEntity.setPropertyValue(property, newFQN);
        }
    }

    private static String getPropertyForRole(int role) {
        return (String)ROLES_2_EJBJARMODELMETAINFO_CONSTANTS.get(role);
    }

    protected IType getNewTypeOnForPackageCopy(IPackageFragment pf) {
        IType result = super.getNewTypeOnForPackageCopy(pf);
        Iterator it = this.myRoles2OriginalTypeNames.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            int role = (Integer)next.getKey();
            String nextTypeName = Signature.getSimpleName((String)((String)next.getValue()));
            this.myRoles2PastedJDTTypes.put(role, this.findPrimaryType(pf, nextTypeName));
        }
        return result;
    }

    static {
        ROLES_2_EJBJARMODELMETAINFO_CONSTANTS.put(2, (Object)"homeInterfaceRef");
        ROLES_2_EJBJARMODELMETAINFO_CONSTANTS.put(4, (Object)"remoteInterfaceRef");
        ROLES_2_EJBJARMODELMETAINFO_CONSTANTS.put(8, (Object)"localHomeInterfaceRef");
        ROLES_2_EJBJARMODELMETAINFO_CONSTANTS.put(16, (Object)"localInterfaceRef");
        ROLES_2_EJBJARMODELMETAINFO_CONSTANTS.put(32, (Object)"primaryKeyClassRef");
    }
}

