/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbMetaInfo;
import com.tssap.j2ee.core.ejb.IBusinessMethod;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.utils.signature.MethodSignature;
import com.tssap.j2ee.internal.core.ejb.AccessibleBean;
import com.tssap.j2ee.internal.core.ejb.BodyAndComment;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.EnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.EntityBean;
import com.tssap.j2ee.internal.core.ejb.FullNameUtil;
import com.tssap.j2ee.internal.core.ejb.MethodSig;
import com.tssap.j2ee.internal.core.ejb.util.EjbTemplatesSupport;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class BusinessMethod
extends EJBMethod
implements IBusinessMethod {
    public BusinessMethod(AccessibleBean parent, MethodSig signature) {
        super(parent, 1, signature.getName(), signature.getName(), signature.getParameterTypeFQNs());
    }

    public IStatus validate() throws EJBModelException {
        return null;
    }

    public static String getRemoteName(IMethod beanClassMethod) {
        if (BusinessMethod.isValidBeanClassBusinessMethod(beanClassMethod)) {
            return beanClassMethod.getElementName();
        }
        return null;
    }

    public static String getBeanClassName(IMethod remoteMethod) {
        MethodSignature sig = FullNameUtil.getSignature(remoteMethod);
        if (sig == null) {
            return null;
        }
        if (EjbMetaInfo.isVetoedBusinessMethodSignature((String)sig.toUnqualifiedFullName())) {
            return null;
        }
        return remoteMethod.getElementName();
    }

    public static boolean isValidBeanClassBusinessMethod(IMethod beanClassMethod) {
        try {
            int flags = beanClassMethod.getFlags();
            if (!Flags.isPublic((int)flags)) {
                return false;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
        String name = beanClassMethod.getElementName();
        if (!EjbMetaInfo.isBusinessMethodImplName((String)name)) {
            return false;
        }
        MethodSignature sig = FullNameUtil.getSignature(beanClassMethod);
        if (sig == null) {
            return false;
        }
        return !EjbMetaInfo.isVetoedBusinessMethodSignature((String)sig.toUnqualifiedFullName());
    }

    public IMethod getRemoteDeclaration() {
        return this.getMethod(4);
    }

    public IMethod getLocalDeclaration() {
        return this.getMethod(16);
    }

    public IMethod getImplementation() {
        return this.getMethod(1);
    }

    protected IMethod getDefiningMethod() throws EJBModelException {
        IMethod method = this.getImplementation();
        if (method != null && method.exists()) {
            return method;
        }
        method = this.getRemoteDeclaration();
        if (method != null && method.exists()) {
            return method;
        }
        method = this.getLocalDeclaration();
        if (method != null && method.exists()) {
            return method;
        }
        return null;
    }

    public String getRenamedNameForDD(String beanClassName) {
        return beanClassName;
    }

    public Map getRenameScheme(String beanClassName) throws EJBModelException {
        if (!EjbMetaInfo.isBusinessMethodImplName((String)beanClassName)) {
            String msg = "Invalid method name [" + beanClassName + "]";
            throw new EJBModelException((IStatus)new Status(4, EJBImplPlugin.getPluginId(), 0, msg, null));
        }
        HashMap<IMethod, String> scheme = new HashMap<IMethod, String>(3);
        IMethod method = this.getImplementation();
        if (method != null && method.exists()) {
            scheme.put(method, beanClassName);
        }
        if ((method = this.getRemoteDeclaration()) != null && method.exists()) {
            scheme.put(method, beanClassName);
        }
        if ((method = this.getLocalDeclaration()) != null && method.exists()) {
            scheme.put(method, beanClassName);
        }
        return scheme;
    }

    public Map getReturnTypeScheme(String beanClassReturnType) throws EJBModelException {
        HashMap<IMethod, String> scheme = new HashMap<IMethod, String>(3);
        IMethod method = this.getImplementation();
        if (method != null && method.exists()) {
            scheme.put(method, beanClassReturnType);
        }
        if ((method = this.getRemoteDeclaration()) != null && method.exists()) {
            scheme.put(method, beanClassReturnType);
        }
        if ((method = this.getLocalDeclaration()) != null && method.exists()) {
            scheme.put(method, beanClassReturnType);
        }
        return scheme;
    }

    protected int getAllowedMethodParticipants() {
        return 21;
    }

    public boolean canPromote(int role) {
        if (!super.canPromote(role)) {
            return false;
        }
        if (!this.isCMPAccessor()) {
            return true;
        }
        try {
            IPersistentField pf = ((EntityBean)this.getParentBean()).getField(JDTUtils.getFieldNameByAccessor((IMethod)this.getDefiningMethod()));
            if (!pf.isRelationship()) {
                return true;
            }
            return role != 4;
        }
        catch (EJBModelException e) {
            return false;
        }
    }

    protected void promote(int role, IType type, String userName, List paramList, String returnType, List exceptionType, IProgressMonitor monitor) throws EJBModelException {
        try {
            switch (role) {
                case 1: {
                    EjbTemplatesSupport.createBusinessMethodImpl(type, userName, paramList, returnType, exceptionType, monitor);
                    break;
                }
                case 16: {
                    EjbTemplatesSupport.createBusinessLocalMethod(type, userName, paramList, returnType, exceptionType, monitor);
                    break;
                }
                case 4: {
                    EjbTemplatesSupport.createBusinessMethod(type, userName, paramList, returnType, exceptionType, monitor);
                }
            }
        }
        catch (CoreException e) {
            throw new EJBModelException("Exception occurred while promoting the method", (Throwable)e);
        }
    }

    protected void pasteMethodCopy(EnterpriseBean target, int role, String beanClassMethodName, String[] paramTypeFQNs, String[] paramNames, String[] exceptionTypes, String returnType, BodyAndComment bodyAndComment) throws CoreException {
        AccessibleBean bean = (AccessibleBean)target;
        IType type = bean.getParticipant(role);
        String userName = beanClassMethodName;
        List paramList = EnterpriseBean.asList(paramTypeFQNs, paramNames);
        List exceptionType = EnterpriseBean.asList(exceptionTypes);
        switch (role) {
            case 1: {
                EjbTemplatesSupport.createBusinessMethodImpl(type, userName, paramList, returnType, exceptionType, null);
                break;
            }
            case 16: {
                EjbTemplatesSupport.createBusinessLocalMethod(type, userName, paramList, returnType, exceptionType, null);
                break;
            }
            case 4: {
                EjbTemplatesSupport.createBusinessMethod(type, userName, paramList, returnType, exceptionType, null);
            }
        }
        this.pasteMethodBody(type, beanClassMethodName, paramTypeFQNs, bodyAndComment);
    }

    public boolean canSetReturnType(String type) {
        return true;
    }

    protected boolean isValidName(String name) {
        return EjbMetaInfo.isBusinessMethodImplName((String)name);
    }

    protected String getDdpKey() {
        return "BusinessMethod";
    }

    public boolean canCopy() {
        if (this.isCMPAccessor()) {
            return false;
        }
        return super.canCopy();
    }

    protected void transferDdpsFrom(IMethod m) throws EJBModelException {
        if (m.equals(this.getImplementation())) {
            if (!this.transferDdps(m, this.getRemoteDeclaration())) {
                this.transferDdps(m, this.getLocalDeclaration());
            }
        } else if (m.equals(this.getRemoteDeclaration()) && this.getImplementation() == null) {
            this.transferDdps(m, this.getLocalDeclaration());
        }
    }
}

