/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.internal.core.ejb.AbstractEjbMethodCollector;
import com.tssap.j2ee.internal.core.ejb.AccessibleBean;
import com.tssap.j2ee.internal.core.ejb.BusinessMethod;
import com.tssap.j2ee.internal.core.ejb.CreateMethod;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.MethodSig;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public abstract class AccessibleBeanMethodCollector
extends AbstractEjbMethodCollector {
    private SpecificMethodCollector myBeanClassBusinessMethodsCollector = new BusinessMethodCollector(){

        public String getBeanClassMethodName(IMethod beanClassMethod) {
            if (BusinessMethod.isValidBeanClassBusinessMethod(beanClassMethod)) {
                return beanClassMethod.getElementName();
            }
            return null;
        }
    };
    private SpecificMethodCollector myInterfaceBusinessMethodsCollector = new BusinessMethodCollector(){

        public String getBeanClassMethodName(IMethod interfaceMethod) {
            return BusinessMethod.getBeanClassName(interfaceMethod);
        }
    };
    private SpecificMethodCollector myInterfaceCreateMethodsCollector = new CreateMethodCollector(){

        public String getBeanClassMethodName(IMethod interfaceMethod) {
            return CreateMethod.getBeanClassName(interfaceMethod);
        }
    };
    private static final IMethod[] NO_METHODS = new IMethod[0];

    public AccessibleBeanMethodCollector(AccessibleBean bean) {
        super(bean);
    }

    protected final void collectMethods(HashMap receiver) {
        IMethod[] beanClassMethods = this.getDeclaredMethods(1);
        IMethod[] homeMethods = this.getDeclaredMethods(2);
        IMethod[] remoteMethods = this.getDeclaredMethods(4);
        IMethod[] localhomeMethods = this.getDeclaredMethods(8);
        IMethod[] localMethods = this.getDeclaredMethods(16);
        this.collectMethods(receiver, beanClassMethods, homeMethods, remoteMethods, localhomeMethods, localMethods);
    }

    protected void collectMethods(HashMap receiver, IMethod[] beanClassMethods, IMethod[] homeMethods, IMethod[] remoteMethods, IMethod[] localhomeMethods, IMethod[] localMethods) {
        this.collectBusinessMethods(receiver, beanClassMethods, remoteMethods, localMethods);
        this.collectCreateMethods(receiver, beanClassMethods, homeMethods, localhomeMethods);
    }

    private void collectBusinessMethods(HashMap receiver, IMethod[] beanClassMethods, IMethod[] remoteMethods, IMethod[] localMethods) {
        HashSet failedSignatures = new HashSet();
        this.collectMethods(receiver, failedSignatures, beanClassMethods, this.myBeanClassBusinessMethodsCollector, 1);
        this.collectMethods(receiver, failedSignatures, remoteMethods, this.myInterfaceBusinessMethodsCollector, 4);
        this.collectMethods(receiver, failedSignatures, localMethods, this.myInterfaceBusinessMethodsCollector, 16);
    }

    private void collectCreateMethods(HashMap receiver, IMethod[] beanClassMethods, IMethod[] homeMethods, IMethod[] localhomeMethods) {
        HashSet failedSignatures = new HashSet();
        this.collectMethods(receiver, failedSignatures, beanClassMethods, this.getBeanClassCreateMethodsCollector(), 1);
        this.collectMethods(receiver, failedSignatures, homeMethods, this.myInterfaceCreateMethodsCollector, 2);
        this.collectMethods(receiver, failedSignatures, localhomeMethods, this.myInterfaceCreateMethodsCollector, 8);
    }

    protected final void collectMethods(HashMap receiver, HashSet failedSignatures, IMethod[] methods, SpecificMethodCollector collector, int participantRole) {
        int i = 0;
        while (i < methods.length) {
            MethodSig signature;
            IMethod next = methods[i];
            String beanClassRepresentation = collector.getBeanClassMethodName(next);
            if (beanClassRepresentation != null && !failedSignatures.contains(signature = AbstractEjbMethodCollector.createSignature(beanClassRepresentation, this.getParameterTypeFQNs(next)))) {
                if (receiver.containsKey(signature)) {
                    EJBMethod existingMethod = (EJBMethod)((Object)receiver.get(signature));
                    collector.addMethodOccurrence(existingMethod, next, participantRole);
                } else {
                    try {
                        EJBMethod createdMethod = collector.createMethod(signature);
                        collector.addMethodOccurrence(createdMethod, next, participantRole);
                        createdMethod.validate();
                        receiver.put(signature, createdMethod);
                    }
                    catch (EJBModelException e) {
                        failedSignatures.add(signature);
                    }
                }
            }
            ++i;
        }
    }

    private IMethod[] getDeclaredMethods(int role) {
        try {
            IType participant = this.getAccessibleBean().getParticipant(role);
            if (participant != null && participant.exists()) {
                return this.getDeclaredMethods(participant);
            }
        }
        catch (EJBModelException e) {
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return NO_METHODS;
    }

    protected AccessibleBean getAccessibleBean() {
        return (AccessibleBean)this.getBean();
    }

    protected abstract SpecificMethodCollector getBeanClassCreateMethodsCollector();

    protected abstract class CreateMethodCollector
    extends MethodSettingMethodCollector {
        protected CreateMethodCollector() {
        }

        public EJBMethod createMethod(MethodSig signature) {
            return new CreateMethod(AccessibleBeanMethodCollector.this.getAccessibleBean(), signature);
        }
    }

    private abstract class BusinessMethodCollector
    extends MethodSettingMethodCollector {
        private BusinessMethodCollector() {
        }

        public EJBMethod createMethod(MethodSig signature) {
            return new BusinessMethod(AccessibleBeanMethodCollector.this.getAccessibleBean(), signature);
        }
    }

    protected abstract class MethodSettingMethodCollector
    implements SpecificMethodCollector {
        protected MethodSettingMethodCollector() {
        }

        public void addMethodOccurrence(EJBMethod ejbMethod, IMethod jdtMethod, int participantRole) {
            ejbMethod.setMethod(participantRole, jdtMethod);
        }

        public abstract EJBMethod createMethod(MethodSig var1) throws EJBModelException;

        public abstract String getBeanClassMethodName(IMethod var1);
    }

    protected static interface SpecificMethodCollector {
        public String getBeanClassMethodName(IMethod var1);

        public EJBMethod createMethod(MethodSig var1) throws EJBModelException;

        public void addMethodOccurrence(EJBMethod var1, IMethod var2, int var3);
    }
}

