/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbMetaInfo;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.IBusinessMethod;
import com.tssap.j2ee.core.ejb.ICopiedEnterpriseBean;
import com.tssap.j2ee.core.ejb.ICreateMethod;
import com.tssap.j2ee.core.ejb.IEJBSynchronizeListener;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.inheritance.InhType;
import com.tssap.j2ee.core.utils.ReadOnlinessValidator;
import com.tssap.j2ee.internal.core.ejb.CopiedAccessibleBean;
import com.tssap.j2ee.internal.core.ejb.EJBDelta;
import com.tssap.j2ee.internal.core.ejb.EJBImplPlugin;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.EjbProjectImpl;
import com.tssap.j2ee.internal.core.ejb.EnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.NamingConvention;
import com.tssap.j2ee.internal.core.ejb.refactor.ParticipantRefactorer;
import com.tssap.j2ee.internal.core.ejb.util.EjbBuilder;
import com.tssap.j2ee.internal.core.ejb.util.EjbTemplatesSupport;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ITag;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public abstract class AccessibleBean
extends EnterpriseBean
implements IAccessibleBean {
    private IntHashMap myRoles2Types;
    private IntHashMap myRoles2WCTypes;
    private boolean myRefreshParticipantsPending;
    private int myParticipantRenamePending = 0;
    private static final int MAX_ROLE = 32;
    private static final String NO_PARTICIPANT = "none";
    private static final IntHashMap TAGS_FOR_ROLE = new IntHashMap();
    private static final IntHashMap MY_MANDATORY_SUPERINTERFACES;
    private ParticipantRefactorer myCachedParticipantRefactorer;
    private boolean myDeferredParticipantChangeDetectedInWCM;
    static /* synthetic */ Class class$java$util$Collection;

    public AccessibleBean(EjbProjectImpl parent, int kind, IType beanClass) {
        super(parent, kind, beanClass);
    }

    protected void removed() {
        super.removed();
        this.removedMethods();
    }

    protected void afterRemoved() {
        super.afterRemoved();
        if (this.myRoles2Types == null) {
            return;
        }
        Iterator it = this.myRoles2Types.values().iterator();
        while (it.hasNext()) {
            this.removeDispatchedDeltaListener((IType)it.next());
        }
    }

    private void removedMethods() {
        this.getMethodCollector().removedMethods();
    }

    public void delete(IProgressMonitor monitor) throws EJBModelException {
        this.assertExists();
        this.deleteRequirements();
        final ArrayList participants = new ArrayList(this.myRoles2Types.values());
        final MultiStatus status = new MultiStatus("com.tssap.j2ee.internal.core.ejb", 0, "Deleting EJB", null);
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    EnterpriseBean.deleteDeployedBeans(AssembledInfoFinder.findAssembledBeans((IEnterpriseBean)AccessibleBean.this));
                    Iterator it = participants.iterator();
                    while (it.hasNext()) {
                        try {
                            JDTUtils.deleteType((IType)((IType)it.next()));
                        }
                        catch (CoreException e) {
                            status.add(e.getStatus());
                        }
                    }
                }
            }, monitor);
        }
        catch (CoreException e) {
            IStatus s = e.getStatus();
            if (s instanceof MultiStatus) {
                status.addAll(s);
            }
            status.add(e.getStatus());
        }
        if (!status.isOK()) {
            throw new EJBModelException((IStatus)status);
        }
    }

    protected void deleteRequirements() throws EJBModelException {
        super.deleteRequirements();
        Iterator it = this.myRoles2Types.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            if (!this.shouldRenameParticipant((Integer)next.getKey()) || !((IType)next.getValue()).isBinary()) continue;
            throw this.cannotModify();
        }
    }

    protected void cutRequirements(boolean forPackageCut) throws EJBModelException {
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        int i = 1;
        int existingRoles = this.getExistingRoles();
        while (i < existingRoles) {
            if ((i & existingRoles) != 0) {
                IType participant = this.getParticipant(i);
                if (this.shouldRenameParticipant(i) && (!forPackageCut || participant.getPackageFragment().equals(this.getBeanClass().getPackageFragment()))) {
                    validator.addJavaElement((IMember)participant);
                }
            }
            i <<= 1;
        }
        com.tssap.j2ee.core.descriptor.EnterpriseBean[] assembledBeans = AssembledInfoFinder.findAssembledBeans((IEnterpriseBean)this);
        if (assembledBeans != null) {
            int i2 = 0;
            while (i2 < assembledBeans.length) {
                validator.addResource(assembledBeans[i2].getDocument().getFile());
                ++i2;
            }
        }
        if (!validator.canModify()) {
            throw this.cannotModify();
        }
    }

    protected abstract int getSupportedRoles();

    public int getExistingRoles() {
        if (!this.exists()) {
            return 0;
        }
        int result = 0;
        int supportedRoles = this.getSupportedRoles();
        int i = 1;
        while (i <= 32) {
            if ((supportedRoles & i) > 0) {
                try {
                    if (this.getParticipant(i) != null) {
                        result |= i;
                    }
                }
                catch (EJBModelException cannotHappen) {
                    // empty catch block
                }
            }
            i <<= 1;
        }
        return result;
    }

    public IType getParticipant(int role) throws EJBModelException {
        IType participant;
        this.assertExists();
        if (role == 1) {
            return this.getBeanClass();
        }
        int supportedRoles = this.getSupportedRoles();
        if ((supportedRoles & role) == 0) {
            return null;
        }
        this.addParticipants();
        if (this.isWorkingCopyMode()) {
            participant = (IType)this.myRoles2WCTypes.get(role);
            if (!(participant != null || (participant = (IType)this.myRoles2Types.get(role)) != null && participant.isBinary())) {
                return null;
            }
        } else {
            participant = (IType)this.myRoles2Types.get(role);
            if (participant == null && (participant = this.findParticipant(role)) != null) {
                final IType finalParticipant = participant;
                final int finalRole = role;
                this.internalGetEJBProject().runCommand((Runnable)new UndoTransparableCommand(){

                    public void run() {
                        AccessibleBean.this.registerParticipant(finalParticipant, finalRole);
                        AccessibleBean.this.internalGetEJBProject().getDelta().totallyChanged(AccessibleBean.this);
                    }
                });
            }
        }
        if (participant == null || !participant.exists()) {
            return null;
        }
        return participant;
    }

    public boolean canAddParticipant(int role, String participantFQN) {
        IType type = JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)participantFQN);
        if (type == null) {
            return true;
        }
        return this.validateParticipant(role, type);
    }

    public void addParticipant(int role, String participantFQN, boolean acceptExisting, IType[] supertypes, IProgressMonitor monitor) throws EJBModelException {
        this.addParticipant(role, participantFQN, acceptExisting, false, supertypes, monitor);
    }

    public final void addParticipant(int role, String participantFQN, boolean acceptExisting, boolean deleteOldParticipant, IType[] supertypes, IProgressMonitor monitor) throws EJBModelException {
        if (participantFQN == null) {
            throw new EJBModelException("The given participant is null", (Throwable)new NullPointerException());
        }
        IType actualParticipant = this.getParticipant(role);
        if (actualParticipant == null || !participantFQN.equals(actualParticipant.getFullyQualifiedName())) {
            this.internalGetEJBProject().getDelta().totallyChanged(this);
        }
        this.primAddParticipant(role, participantFQN, acceptExisting, deleteOldParticipant, actualParticipant, supertypes, monitor);
        this.addParticipantTag(participantFQN, role);
        if (actualParticipant != null) {
            this.unregisterParticipant(actualParticipant, role);
        }
        IType newParticipant = JDTUtils.findType((IJavaProject)this.getJavaProject(), (String)participantFQN);
        this.registerParticipant(newParticipant, role);
        this.participantChanged(actualParticipant, newParticipant, role);
        this.participantChangeDetected();
    }

    protected void primAddParticipant(int role, String participantFQN, boolean acceptExisting, boolean deleteOldParticipant, IType actualParticipant, IType[] supertypes, IProgressMonitor monitor) throws EJBModelException {
        if (role == 2) {
            this.addHomeInterface(participantFQN, acceptExisting, deleteOldParticipant, actualParticipant, supertypes, monitor);
        } else if (role == 4) {
            this.addRemoteInterface(participantFQN, acceptExisting, deleteOldParticipant, actualParticipant, supertypes, monitor);
        } else if (role == 8) {
            this.addLocalHomeInterface(participantFQN, acceptExisting, deleteOldParticipant, actualParticipant, supertypes, monitor);
        } else if (role == 16) {
            this.addLocalInterface(participantFQN, acceptExisting, deleteOldParticipant, actualParticipant, supertypes, monitor);
        } else {
            throw new RuntimeException("Unknown role [" + role + "]");
        }
    }

    protected void addHomeInterface(String homeFQN, boolean acceptExisting, boolean deleteOldParticipant, IType actualParticipant, IType[] supertypes, IProgressMonitor monitor) throws EJBModelException {
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        validator.addJavaElement((IMember)this.getBeanClass());
        if (!validator.canModify()) {
            throw this.cannotModify();
        }
        IType type = JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)homeFQN);
        if (type != null) {
            if (acceptExisting) {
                return;
            }
            throw new EJBModelException(this.newStatus(4, "[" + homeFQN + "] already exists"));
        }
        IPackageFragment homePackage = ((EjbProjectImpl)this.getEJBProject()).getSuitablePackage(homeFQN);
        String homeInterface = EjbProjectImpl.getTypeName(homeFQN);
        try {
            if (actualParticipant != null) {
                if (!homeFQN.equals(actualParticipant.getFullyQualifiedName())) {
                    this.copyParticipant(actualParticipant, homePackage, homeInterface, deleteOldParticipant, monitor);
                }
            } else {
                EjbTemplatesSupport.createHomeInterface(homePackage, homeInterface, supertypes, monitor);
            }
        }
        catch (CoreException ce) {
            EJBModelException me = new EJBModelException(ce.getStatus());
            throw me;
        }
    }

    protected void addRemoteInterface(String remoteFQN, boolean acceptExisting, boolean deleteOldParticipant, IType actualParticipant, IType[] supertypes, IProgressMonitor monitor) throws EJBModelException {
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        validator.addJavaElement((IMember)this.getBeanClass());
        IType home = this.getParticipant(2);
        if (home == null || home.isBinary()) {
            throw new EJBModelException("Cannot change remote interface: home interface is read-only");
        }
        validator.addJavaElement((IMember)home);
        if (!validator.canModify()) {
            throw this.cannotModify();
        }
        IType type = JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)remoteFQN);
        if (type != null) {
            if (acceptExisting) {
                this.fixupReferences(home, actualParticipant == null ? null : actualParticipant.getFullyQualifiedName(), remoteFQN);
                return;
            }
            throw new EJBModelException(this.newStatus(4, "[" + remoteFQN + "] already exists"));
        }
        IPackageFragment remotePackage = ((EjbProjectImpl)this.getEJBProject()).getSuitablePackage(remoteFQN);
        String remoteInterface = EjbProjectImpl.getTypeName(remoteFQN);
        try {
            if (actualParticipant != null) {
                if (!remoteFQN.equals(actualParticipant.getFullyQualifiedName())) {
                    this.copyParticipant(actualParticipant, remotePackage, remoteInterface, deleteOldParticipant, monitor);
                }
                this.fixupReferences(home, actualParticipant.getFullyQualifiedName(), remoteFQN);
            } else {
                EjbTemplatesSupport.createRemoteInterface(remotePackage, remoteInterface, supertypes, monitor);
                this.fixupReferences(home, null, remoteFQN);
            }
        }
        catch (CoreException ce) {
            EJBModelException me = new EJBModelException(ce.getStatus());
            throw me;
        }
    }

    protected void addLocalHomeInterface(String localHomeFQN, boolean acceptExisting, boolean deleteOldParticipant, IType actualParticipant, IType[] supertypes, IProgressMonitor monitor) throws EJBModelException {
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        validator.addJavaElement((IMember)this.getBeanClass());
        if (!validator.canModify()) {
            throw this.cannotModify();
        }
        IType type = JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)localHomeFQN);
        if (type != null) {
            if (acceptExisting) {
                return;
            }
            throw new EJBModelException(this.newStatus(4, "[" + localHomeFQN + "] already exists"));
        }
        IPackageFragment localHomePackage = ((EjbProjectImpl)this.getEJBProject()).getSuitablePackage(localHomeFQN);
        String localHomeInterface = EjbProjectImpl.getTypeName(localHomeFQN);
        try {
            if (actualParticipant != null) {
                if (!localHomeFQN.equals(actualParticipant.getFullyQualifiedName())) {
                    this.copyParticipant(actualParticipant, localHomePackage, localHomeInterface, deleteOldParticipant, monitor);
                }
            } else {
                EjbTemplatesSupport.createLocalHomeInterface(localHomePackage, localHomeInterface, supertypes, monitor);
            }
        }
        catch (CoreException ce) {
            EJBModelException me = new EJBModelException(ce.getStatus());
            throw me;
        }
    }

    protected void addLocalInterface(String localFQN, boolean acceptExisting, boolean deleteOldParticipant, IType actualParticipant, IType[] supertypes, IProgressMonitor monitor) throws EJBModelException {
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        validator.addJavaElement((IMember)this.getBeanClass());
        IType localhome = this.getParticipant(8);
        if (localhome == null || localhome.isBinary()) {
            throw new EJBModelException("Cannot change local interface: local home interface is read-only");
        }
        validator.addJavaElement((IMember)localhome);
        if (!validator.canModify()) {
            throw this.cannotModify();
        }
        IType type = JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)localFQN);
        if (type != null) {
            if (acceptExisting) {
                this.fixupReferences(localhome, actualParticipant == null ? null : actualParticipant.getFullyQualifiedName(), localFQN);
                return;
            }
            throw new EJBModelException(this.newStatus(4, "[" + localFQN + "] already exists"));
        }
        IPackageFragment localPackage = ((EjbProjectImpl)this.getEJBProject()).getSuitablePackage(localFQN);
        String localInterface = EjbProjectImpl.getTypeName(localFQN);
        try {
            if (actualParticipant != null) {
                if (!localFQN.equals(actualParticipant.getFullyQualifiedName())) {
                    this.copyParticipant(actualParticipant, localPackage, localInterface, deleteOldParticipant, monitor);
                }
                this.fixupReferences(localhome, actualParticipant.getFullyQualifiedName(), localFQN);
            } else {
                EjbTemplatesSupport.createLocalInterface(localPackage, localInterface, supertypes, monitor);
                this.fixupReferences(localhome, null, localFQN);
            }
        }
        catch (CoreException ce) {
            EJBModelException me = new EJBModelException(ce.getStatus());
            throw me;
        }
    }

    protected void copyParticipant(IType actualParticipant, IPackageFragment aPackage, String newName, boolean deleteOldParticipant, IProgressMonitor monitor) throws EJBModelException {
        if (deleteOldParticipant) {
            this.renameClass(actualParticipant, aPackage, newName, monitor);
            return;
        }
        try {
            ICompilationUnit oldCU = actualParticipant.getCompilationUnit();
            if (oldCU == null) {
                throw new EJBModelException("Type is binary");
            }
            oldCU.copy((IJavaElement)aPackage, null, newName + ".java", false, monitor);
        }
        catch (CoreException e) {
            if (e instanceof EJBModelException) {
                throw (EJBModelException)((Object)e);
            }
            throw new EJBModelException("Exception occurred while copying participant", (Throwable)e);
        }
    }

    private void addParticipantTag(String participantFQN, int role) {
        boolean changed = false;
        IJavaComment comment = this.getJavaComment();
        String tagName = this.getTagByRole(role);
        String tagValue = "<{" + participantFQN + "}>";
        Enumeration tags = comment.getTags(tagName);
        if (tags.hasMoreElements()) {
            ITag tag = (ITag)tags.nextElement();
            if (!tagValue.equals(tag.getValue())) {
                tag.setValue(tagValue);
                changed = true;
            }
        } else {
            comment.addTag(tagName, tagValue);
            changed = true;
        }
        if (changed) {
            comment.synchronize(true);
        }
    }

    public void removeParticipant(int role, boolean deleteType, IProgressMonitor monitor) throws EJBModelException {
        this.internalGetEJBProject().getDelta().totallyChanged(this);
        IType participant = (IType)this.myRoles2Types.get(role);
        if (participant != null && participant.exists()) {
            this.unregisterParticipant(participant, role);
            if (deleteType) {
                try {
                    JDTUtils.deleteType((IType)participant);
                }
                catch (JavaModelException e) {
                    throw new EJBModelException("Exception occurred while deleting participant type", (Throwable)e);
                }
            }
        }
        this.addParticipantTag(NO_PARTICIPANT, role);
    }

    private void addParticipants() {
        if (this.myRoles2Types != null) {
            return;
        }
        this.myRoles2Types = new IntHashMap();
        int supportedRoles = this.getSupportedRoles();
        int role = 1;
        while (role <= 32) {
            IType participant;
            if ((supportedRoles & role) > 0 && (participant = this.findParticipant(role)) != null) {
                this.registerParticipant(participant, role);
            }
            role <<= 1;
        }
    }

    public boolean canSetName(String name) {
        if (name == null) {
            return false;
        }
        boolean isNamingConventioned = this.isNamingConventioned();
        if (isNamingConventioned) {
            name = this.internalGetEJBProject().getNamingConvention().getConventionalBeanClassName(name);
        }
        if (name.equals(this.getName())) {
            return true;
        }
        ParticipantRefactorer refactorer = this.getParticipantRefactorer(name, isNamingConventioned);
        if (!refactorer.canPerformNaive()) {
            this.myCachedParticipantRefactorer = null;
            return false;
        }
        return true;
    }

    public String setName(String name, IProgressMonitor monitor) throws EJBModelException {
        if (this.isNamingConventioned()) {
            name = this.internalGetEJBProject().getNamingConvention().getConventionalBeanClassName(name);
        }
        if (name.equals(this.getName())) {
            return name;
        }
        ParticipantRefactorer refactorer = this.getParticipantRefactorer(name, this.isNamingConventioned(), true);
        if (!refactorer.canPerform()) {
            this.myCachedParticipantRefactorer = null;
            return this.getName();
        }
        try {
            try {
                refactorer.perform(monitor);
            }
            catch (CoreException e) {
                throw new EJBModelException("Could not perform refactoring", (Throwable)e);
            }
            Object var6_4 = null;
            this.myCachedParticipantRefactorer = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.myCachedParticipantRefactorer = null;
            throw throwable;
        }
        return name;
    }

    private ParticipantRefactorer getParticipantRefactorer(String name, boolean isNamingConventioned) {
        return this.getParticipantRefactorer(name, isNamingConventioned, false);
    }

    private ParticipantRefactorer getParticipantRefactorer(String name, boolean isNamingConventioned, boolean assertName) {
        if (this.myCachedParticipantRefactorer == null || assertName && !AccessibleBean.equals(name, this.myCachedParticipantRefactorer.getNewName())) {
            this.myCachedParticipantRefactorer = new ParticipantRefactorer(this, name);
            if (isNamingConventioned) {
                int role = 2;
                int roleMax = this.getSupportedRoles();
                while (role <= roleMax) {
                    IType participant = (IType)this.myRoles2Types.get(role);
                    if (participant != null && participant.exists() && this.shouldRenameParticipant(role)) {
                        this.myCachedParticipantRefactorer.addParticipant(role, this.internalGetEJBProject().getNamingConvention().getConventionalParticipantName(name, role));
                    }
                    role <<= 1;
                }
            }
        }
        return this.myCachedParticipantRefactorer;
    }

    private ParticipantRefactorer getParticipantRefactorerForRenameParticipant(int role, String newFQN, boolean assertName) {
        if (this.myCachedParticipantRefactorer == null || assertName && this.myCachedParticipantRefactorer.getNewName() != null) {
            this.myCachedParticipantRefactorer = new ParticipantRefactorer(this);
            IType participant = (IType)this.myRoles2Types.get(role);
            if (participant != null && participant.exists()) {
                this.myCachedParticipantRefactorer.addParticipant(role, newFQN);
            }
        }
        return this.myCachedParticipantRefactorer;
    }

    private static boolean equals(String one, String another) {
        if (one == null) {
            return another == null;
        }
        return one.equals(another);
    }

    private boolean isNamingConventioned() {
        this.addParticipants();
        NamingConvention conv = this.internalGetEJBProject().getNamingConvention();
        int i = 1;
        int iMax = this.getSupportedRoles();
        while (i <= iMax) {
            IType participant = (IType)this.myRoles2Types.get(i);
            if (participant != null && participant.exists() && this.shouldRenameParticipant(i) && !participant.equals(conv.findParticipant(this, i))) {
                return false;
            }
            i <<= 1;
        }
        return true;
    }

    protected boolean shouldRenameParticipant(int role) {
        return true;
    }

    private void registerParticipant(IType participant, int role) {
        if (participant == null) {
            EJBImplPlugin.logError("Trying to register participant null for role " + role + " in bean " + this.getBeanClassName());
            return;
        }
        if (!participant.isBinary() && participant.getCompilationUnit().isWorkingCopy()) {
            throw new IllegalArgumentException("Trying to register nonpersistent (working copy) participant");
        }
        this.addDispatchedDeltaListener(participant);
        this.myRoles2Types.put(role, (Object)participant);
        if (this.isWorkingCopyMode()) {
            this.myRoles2WCTypes.put(role, (Object)this.createWorkingCopyType(participant));
        }
    }

    private void unregisterParticipant(IType participant, int role) {
        IType wcParticipant;
        if (!participant.isBinary() && participant.getCompilationUnit().isWorkingCopy()) {
            throw new IllegalArgumentException("Trying to unregister nonpersistent (working copy) participant");
        }
        this.removeDispatchedDeltaListener(participant);
        this.myRoles2Types.remove(role);
        if (this.isWorkingCopyMode() && (wcParticipant = (IType)this.myRoles2WCTypes.remove(role)) != null) {
            this.commitWorkingCopyType(wcParticipant);
        }
    }

    protected IType findParticipant(int role) {
        return this.findParticipant(role, true);
    }

    protected IType findParticipant(int role, boolean validate) {
        IType type;
        if (role == 1) {
            return this.getBeanClass();
        }
        EJBImplPlugin.revisit("More options");
        try {
            type = this.findParticipantInJavaComments(role);
        }
        catch (EJBModelException e) {
            return null;
        }
        if (type != null && type.exists()) {
            if (!validate || this.validateParticipant(role, type)) {
                return type;
            }
            return null;
        }
        type = this.internalGetEJBProject().getNamingConvention().findParticipant(this, role);
        if (type != null && type.exists() && (!validate || this.validateParticipant(role, type))) {
            return type;
        }
        return null;
    }

    private IType findParticipantInJavaComments(int role) throws EJBModelException {
        IJavaComment comment = this.getJavaComment();
        if (comment == null) {
            return null;
        }
        String tagName = this.getTagByRole(role);
        if (tagName == null) {
            return null;
        }
        Enumeration enumeration = comment.getTags(tagName);
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        ITag tag = (ITag)enumeration.nextElement();
        String participantTypeName = tag.getValue();
        if (participantTypeName == null) {
            return null;
        }
        if ((participantTypeName = participantTypeName.trim()).startsWith("<{")) {
            participantTypeName = participantTypeName.substring(2);
        }
        if (participantTypeName.endsWith("}>")) {
            participantTypeName = participantTypeName.substring(0, participantTypeName.length() - 2);
        }
        if ((participantTypeName = participantTypeName.trim()).equals(NO_PARTICIPANT)) {
            throw new EJBModelException("");
        }
        if (participantTypeName.length() == 0) {
            return null;
        }
        IType result = JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)participantTypeName.trim());
        if (result != null) {
            return result;
        }
        if (participantTypeName.indexOf(46) == -1) {
            String packageName = this.getBeanClass().getPackageFragment().getElementName();
            if (packageName.length() == 0) {
                return null;
            }
            participantTypeName = packageName + '.' + participantTypeName;
            result = JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)participantTypeName);
            if (result == null) {
                return null;
            }
            return result;
        }
        return null;
    }

    protected boolean validateParticipant(int role, IType type) {
        if (role == 1) {
            return this.getBeanClass().equals(type);
        }
        InhType inhType = this.internalGetEJBProject().getInhModel().findType(type.getFullyQualifiedName('.'));
        if (inhType == null) {
            return false;
        }
        return inhType.derivedFrom(this.internalGetEJBProject().getHierarchyHolder().getBaseName(role));
    }

    public IBusinessMethod createBusinessMethod(String userMethodName, String[] parameterTypes, String[] parameterNames, String returnType, String[] exceptionTypes, IProgressMonitor monitor) throws EJBModelException {
        IType remote = this.getParticipant(4);
        IType local = this.getParticipant(16);
        ReadOnlinessValidator validator = new ReadOnlinessValidator();
        if (remote != null) {
            validator.addJavaElement((IMember)remote);
        }
        if (local != null) {
            validator.addJavaElement((IMember)local);
        }
        validator.addJavaElement((IMember)this.getBeanClass());
        if (!validator.canModify()) {
            throw this.cannotModify();
        }
        parameterTypes = this.qualify(parameterTypes);
        exceptionTypes = this.qualify(exceptionTypes);
        this.enterWorkingCopyMode();
        try {
            try {
                EjbBuilder.createBusinessMethod(this, userMethodName, EnterpriseBean.asList(parameterTypes, parameterNames), returnType, Arrays.asList(exceptionTypes), monitor);
            }
            catch (CoreException ce) {
                EJBModelException me = new EJBModelException(ce.getStatus());
                throw me;
            }
            Object var13_10 = null;
            this.exitWorkingCopyMode();
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            this.exitWorkingCopyMode();
            throw throwable;
        }
        return (IBusinessMethod)this.getEJBMethodByJavaTypes(userMethodName, parameterTypes);
    }

    protected void participantRenamed(String oldFQN, String newFQN) {
        int role = this.findRole(oldFQN);
        if (role == 0) {
            return;
        }
        IType type = JDTUtils.findType((IJavaProject)this.getJavaProject(), (String)newFQN);
        if (type == null || !type.exists()) {
            return;
        }
        this.changeParticipant((IType)this.myRoles2Types.get(role), type, role);
    }

    private void changeParticipant(final IType oldParticipant, final IType newParticipant, final int role) {
        this.myParticipantRenamePending |= role;
        ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                AccessibleBean.this.participantChanged(oldParticipant, newParticipant, role);
            }
        });
    }

    private int findRole(String fqn) {
        int i = 1;
        int existingRoles = this.getSupportedRoles();
        while (i < existingRoles) {
            IType participant;
            if ((i & existingRoles) != 0 && (participant = (IType)this.myRoles2Types.get(i)) != null && participant.getFullyQualifiedName('.').equals(fqn)) {
                return i;
            }
            i <<= 1;
        }
        return 0;
    }

    protected void refresh(EJBDelta ejbDelta) {
        this.flushComment();
        this.refreshParticipants();
        super.refresh(ejbDelta);
    }

    private void refreshParticipants() {
        if (this.myRoles2Types == null) {
            return;
        }
        AccessibleBean accessibleBean = this;
        synchronized (accessibleBean) {
            if (this.myRefreshParticipantsPending) {
                return;
            }
            this.myRefreshParticipantsPending = true;
        }
        this.internalGetEJBProject().runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                if (!AccessibleBean.this.exists()) {
                    return;
                }
                boolean changed = false;
                int supportedRoles = AccessibleBean.this.getSupportedRoles();
                int role = 1;
                while (role <= 32) {
                    if ((supportedRoles & role) > 0) {
                        if ((AccessibleBean.this.myParticipantRenamePending & role) > 0) {
                            AccessibleBean.this.myParticipantRenamePending -= role;
                            changed = true;
                        } else {
                            IType participant;
                            IType oldParticipant = (IType)AccessibleBean.this.myRoles2Types.get(role);
                            if (!AccessibleBean.equalParticipants((IJavaElement)oldParticipant, (IJavaElement)(participant = AccessibleBean.this.findParticipant(role)))) {
                                AccessibleBean.this.participantChanged(oldParticipant, participant, role);
                                changed = true;
                            }
                        }
                    }
                    role <<= 1;
                }
                if (changed) {
                    EJBDelta ejbDelta = AccessibleBean.this.internalGetEJBProject().getDelta();
                    ejbDelta.totallyChanged(AccessibleBean.this);
                    AccessibleBean.this.participantChangeDetected();
                }
                AccessibleBean accessibleBean = AccessibleBean.this;
                synchronized (accessibleBean) {
                    AccessibleBean.this.myRefreshParticipantsPending = false;
                }
            }
        });
    }

    private void participantChangeDetected() {
        if (this.isWorkingCopyMode()) {
            this.myDeferredParticipantChangeDetectedInWCM = true;
        } else {
            this.participantChangeDetectedAfterExitFromWCM();
        }
    }

    protected void participantChangeDetectedAfterExitFromWCM() {
        this.resetMethodCollector();
        try {
            this.getEJBMethods();
        }
        catch (EJBModelException eJBModelException) {
            // empty catch block
        }
    }

    protected void participantChanged(IType oldParticipant, IType newParticipant, int role) {
        boolean haveNew;
        boolean haveOld = oldParticipant != null;
        boolean bl = haveNew = newParticipant != null;
        if (haveOld) {
            this.unregisterParticipant(oldParticipant, role);
        }
        if (haveNew) {
            this.registerParticipant(newParticipant, role);
        }
        if (haveOld) {
            if (haveNew) {
                this.participantRenamed(oldParticipant, role);
            } else {
                this.participantRemoved(oldParticipant, role);
            }
        }
    }

    private void participantRenamed(IType oldValue, int role) {
        IEJBSynchronizeListener synchronizer = this.internalGetEJBProject().getSynchronizeTarget();
        switch (role) {
            case 1: {
                break;
            }
            case 2: {
                synchronizer.homeInterfaceRenamed((IEnterpriseBean)this, oldValue);
                break;
            }
            case 8: {
                synchronizer.localhomeInterfaceRenamed((IEnterpriseBean)this, oldValue);
                break;
            }
            case 4: {
                synchronizer.remoteInterfaceRenamed((IEnterpriseBean)this, oldValue);
                break;
            }
            case 16: {
                synchronizer.localInterfaceRenamed((IEnterpriseBean)this, oldValue);
                break;
            }
            case 32: {
                synchronizer.primKeyClassRenamed((IEnterpriseBean)this, oldValue);
            }
        }
    }

    private void participantRemoved(IType oldValue, int role) {
        IEJBSynchronizeListener synchronizer = this.internalGetEJBProject().getSynchronizeTarget();
        switch (role) {
            case 1: {
                break;
            }
            case 2: {
                synchronizer.homeInterfaceRemoved((IEnterpriseBean)this, oldValue);
                break;
            }
            case 8: {
                synchronizer.localhomeInterfaceRemoved((IEnterpriseBean)this, oldValue);
                break;
            }
            case 4: {
                synchronizer.remoteInterfaceRemoved((IEnterpriseBean)this, oldValue);
                break;
            }
            case 16: {
                synchronizer.localInterfaceRemoved((IEnterpriseBean)this, oldValue);
                break;
            }
            case 32: {
                synchronizer.primKeyClassRemoved((IEnterpriseBean)this, oldValue);
            }
        }
    }

    private static boolean equalParticipants(IJavaElement one, IJavaElement two) {
        if (one == null) {
            return two == null;
        }
        return one.equals(two);
    }

    private String getTagByRole(int role) {
        return (String)TAGS_FOR_ROLE.get(role);
    }

    protected void workingCopyModeEntered() {
        super.workingCopyModeEntered();
        this.myRoles2WCTypes = new IntHashMap();
        int existingRoles = this.getExistingRoles();
        int i = 1;
        while (i <= existingRoles) {
            if ((existingRoles & i) > 0 && i != 1) {
                this.myRoles2WCTypes.put(i, (Object)this.createWorkingCopyType((IType)this.myRoles2Types.get(i)));
            }
            i <<= 1;
        }
    }

    protected void workingCopyModeExited() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    AccessibleBean.super.workingCopyModeExited();
                    if (AccessibleBean.this.myRoles2WCTypes == null) {
                        return;
                    }
                    Iterator it = AccessibleBean.this.myRoles2WCTypes.values().iterator();
                    while (it.hasNext()) {
                        IType next = (IType)it.next();
                        if (next == null) continue;
                        AccessibleBean.this.commitWorkingCopyType(next);
                    }
                    AccessibleBean.this.myRoles2WCTypes = null;
                }
            }, null);
        }
        catch (CoreException e) {
            EJBImplPlugin.logWarning("Could not commit the working copy upon exiting working copy mode", e);
        }
        if (this.myDeferredParticipantChangeDetectedInWCM) {
            this.myDeferredParticipantChangeDetectedInWCM = false;
            this.participantChangeDetectedAfterExitFromWCM();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected ICompilationUnit findWorkingCopy(IMember member) {
        cu = member.getCompilationUnit();
        try {
            return super.findWorkingCopy(member);
        }
        catch (IllegalArgumentException e) {
            existingRoles = this.getExistingRoles();
            i = 2;
            ** while (i <= existingRoles)
        }
lbl-1000:
        // 1 sources

        {
            if ((existingRoles & i) > 0 && cu.equals(((IType)this.myRoles2Types.get(i)).getCompilationUnit())) {
                return ((IType)this.myRoles2WCTypes.get(i)).getCompilationUnit();
            }
            i <<= 1;
            continue;
        }
lbl12:
        // 1 sources

        return null;
    }

    void fixupReferences(IType where, String oldFQN, String newFQN) throws EJBModelException {
        try {
            ICompilationUnit cu = where.getCompilationUnit();
            ICompilationUnit wc = (ICompilationUnit)cu.getWorkingCopy();
            try {
                IImportDeclaration importDecl;
                IImportDeclaration iImportDeclaration = importDecl = oldFQN == null ? null : wc.getImport(oldFQN);
                if (importDecl != null && importDecl.exists()) {
                    importDecl.delete(false, null);
                }
                IType wcType = (IType)wc.findElements((IJavaElement)where)[0];
                IMethod[] methods = wcType.getMethods();
                int i = 0;
                while (i < methods.length) {
                    IMethod next = methods[i];
                    if (this.shouldFixupReference(next)) {
                        EJBMethod.setReturnType(next, newFQN, (IProgressMonitor)new NullProgressMonitor());
                    }
                    ++i;
                }
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                wc.save(null, false);
                wc.makeConsistent(null);
                wc.commit(false, null);
                wc.destroy();
                throw throwable;
            }
            wc.save(null, false);
            wc.makeConsistent(null);
            wc.commit(false, null);
            wc.destroy();
            {
            }
        }
        catch (JavaModelException e) {
            throw new EJBModelException("Could not fixup references", (Throwable)e);
        }
    }

    private boolean shouldFixupReference(IMethod method) throws JavaModelException {
        if (EjbMetaInfo.isCreateMethodName((String)method.getElementName())) {
            return true;
        }
        if (EjbMetaInfo.isFindMethodName((String)method.getElementName())) {
            String returnType = Signature.toString((String)method.getReturnType());
            return !Signature.getSimpleName((String)(class$java$util$Collection == null ? (class$java$util$Collection = AccessibleBean.class$("java.util.Collection")) : class$java$util$Collection).getName()).equals(Signature.getSimpleName((String)returnType));
        }
        return false;
    }

    public boolean canCut(boolean forPackageCut) {
        if (!super.canCut(forPackageCut)) {
            return false;
        }
        return this.haveNoBinaryParticipantsForCopyCutOperations(true);
    }

    public boolean canCopy(boolean forPackageCopy) {
        if (!super.canCopy(forPackageCopy)) {
            return false;
        }
        return this.haveNoBinaryParticipantsForCopyCutOperations(forPackageCopy);
    }

    private boolean haveNoBinaryParticipantsForCopyCutOperations(boolean excludeNonPackageParticipants) {
        int i = 2;
        int existingRoles = this.getExistingRoles();
        while (i < existingRoles) {
            if ((i & existingRoles) != 0) {
                try {
                    IType participant = this.getParticipant(i);
                    if (participant == null) {
                        return false;
                    }
                    if (this.shouldRenameParticipant(i) && (!excludeNonPackageParticipants || participant.getPackageFragment().equals(this.getBeanClass().getPackageFragment())) && participant.isBinary()) {
                        return false;
                    }
                }
                catch (EJBModelException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            i <<= 1;
        }
        return true;
    }

    public ICopiedEnterpriseBean copy(boolean forPackageCopy) throws EJBModelException {
        try {
            this.deleteRequirements();
        }
        catch (EJBModelException eme) {
            return null;
        }
        return new CopiedAccessibleBean(this, false, forPackageCopy);
    }

    public ICopiedEnterpriseBean cut(boolean forPackageCut) throws EJBModelException {
        try {
            this.cutRequirements(forPackageCut);
        }
        catch (EJBModelException eme) {
            eme.printStackTrace();
            return null;
        }
        try {
            return new CopiedAccessibleBean(this, true, forPackageCut);
        }
        catch (EJBModelException eme) {
            eme.printStackTrace();
            return null;
        }
    }

    public IType[] getParticipantSuperinterfaces(int role) {
        try {
            IType participant = this.getParticipant(role);
            if (participant == null) {
                return null;
            }
            return EnterpriseBean.getSuperinterfaces(this.internalGetEJBProject(), participant);
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    public boolean canSetParticipantSuperinterfaces(int role, IType[] types) {
        try {
            if (!this.exists()) {
                return false;
            }
            IType participant = this.getParticipant(role);
            if (participant == null || !participant.exists()) {
                return false;
            }
            try {
                types = this.addMandatoryTypeToArray(types, this.getMandatorySuperinterface(role));
            }
            catch (JavaModelException e) {
                return false;
            }
            return EnterpriseBean.canSetSuperinterfaces(participant, types, EnterpriseBean.getSuperinterfaces(this.internalGetEJBProject(), participant));
        }
        catch (EJBModelException e) {
            return false;
        }
    }

    private String[] getMandatorySuperinterface(int role) {
        return (String[])MY_MANDATORY_SUPERINTERFACES.get(role);
    }

    public void setParticipantSuperinterfaces(int role, IType[] types) throws EJBModelException {
        if (!this.canSetParticipantSuperinterfaces(role, types)) {
            throw new EJBModelException("Cannot set property value");
        }
        try {
            types = this.addMandatoryTypeToArray(types, this.getMandatorySuperinterface(role));
        }
        catch (JavaModelException e) {
            throw new EJBModelException("Cannot set property value", (Throwable)e);
        }
        this.setSuperinterfaces(this.getParticipant(role), types);
    }

    public final void rewriteWithEjbJarContents(final Object assembledBean, final IProgressMonitor monitor) {
        this.internalGetEJBProject().runCommand(new Runnable(){

            public void run() {
                AccessibleBean.this.primRewriteWithEjbJarContents(assembledBean, monitor);
            }
        });
    }

    protected void primRewriteWithEjbJarContents(Object assembledBean, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Rewriting participants with the ejb-jar contents", 4);
        try {
            com.tssap.j2ee.core.descriptor.AccessibleBean asmBean = (com.tssap.j2ee.core.descriptor.AccessibleBean)assembledBean;
            this.rewriteParticipant(2, asmBean.getHomeInterface(), monitor);
            this.rewriteParticipant(8, asmBean.getLocalHomeInterface(), monitor);
            this.rewriteParticipant(4, asmBean.getRemoteInterface(), monitor);
            this.rewriteParticipant(16, asmBean.getLocalInterface(), monitor);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void rewriteParticipant(int role, String participantFQN, IProgressMonitor m) {
        IType newParticipant;
        if (participantFQN == null) {
            m.worked(1);
            return;
        }
        try {
            newParticipant = this.getJavaProject().findType(participantFQN);
        }
        catch (JavaModelException e) {
            newParticipant = null;
        }
        if (newParticipant == null) {
            EJBImplPlugin.logError("Could not find participant " + participantFQN + " for bean " + this.getBeanClassName());
            m.worked(1);
            return;
        }
        try {
            block9: {
                try {
                    IType recognizedParticipant = this.getParticipant(role);
                    if (recognizedParticipant != null && participantFQN.equals(recognizedParticipant.getFullyQualifiedName())) break block9;
                    this.addParticipantTag(participantFQN, role);
                    if (recognizedParticipant != null) {
                        this.unregisterParticipant(recognizedParticipant, role);
                    }
                    this.registerParticipant(recognizedParticipant, role);
                    this.participantChanged(recognizedParticipant, newParticipant, role);
                    this.participantChangeDetected();
                }
                catch (EJBModelException e1) {
                    EJBImplPlugin.logWarning("Unable to set participant " + participantFQN + " for bean " + this.getBeanClassName());
                    Object var7_9 = null;
                    m.worked(1);
                    return;
                }
            }
            Object var7_8 = null;
            m.worked(1);
            return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            m.worked(1);
            throw throwable;
        }
    }

    public abstract ICreateMethod createCreateMethod(String var1, String[] var2, String[] var3, String[] var4, IProgressMonitor var5) throws EJBModelException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TAGS_FOR_ROLE.put(2, (Object)"@ejbHome");
        TAGS_FOR_ROLE.put(4, (Object)"@ejbRemote");
        TAGS_FOR_ROLE.put(8, (Object)"@ejbLocalHome");
        TAGS_FOR_ROLE.put(16, (Object)"@ejbLocal");
        TAGS_FOR_ROLE.put(32, (Object)"@ejbPrimaryKey");
        MY_MANDATORY_SUPERINTERFACES = new IntHashMap();
        MY_MANDATORY_SUPERINTERFACES.put(2, (Object)new String[]{"javax.ejb.EJBHome"});
        MY_MANDATORY_SUPERINTERFACES.put(4, (Object)new String[]{"javax.ejb.EJBObject"});
        MY_MANDATORY_SUPERINTERFACES.put(8, (Object)new String[]{"javax.ejb.EJBLocalHome"});
        MY_MANDATORY_SUPERINTERFACES.put(16, (Object)new String[]{"javax.ejb.EJBLocalObject"});
    }
}

