/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.inheritance.InhDirection;
import com.tssap.j2ee.core.inheritance.InhElement;
import com.tssap.j2ee.core.inheritance.InhMember;
import com.tssap.j2ee.core.inheritance.InhModelAccess;
import com.tssap.j2ee.core.inheritance.InhType;
import com.tssap.j2ee.internal.core.ejb.EJBDelta;
import com.tssap.j2ee.internal.core.ejb.EJBMethod;
import com.tssap.j2ee.internal.core.ejb.EnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.MethodSig;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public abstract class AbstractEjbMethodCollector {
    private EnterpriseBean myBean;
    private HashMap myMethods;

    public AbstractEjbMethodCollector(EnterpriseBean bean) {
        this.myBean = bean;
    }

    public final Collection getMethods() {
        if (this.myMethods == null) {
            this.myMethods = new HashMap();
            this.collectMethods(this.myMethods);
            Iterator it = this.myMethods.values().iterator();
            while (it.hasNext()) {
                EJBMethod next = (EJBMethod)((Object)it.next());
                if (next == null) continue;
                next.getExistingMethods();
            }
        }
        return this.myMethods.values();
    }

    protected abstract void collectMethods(HashMap var1);

    public EJBMethod getMethod(String name, String[] parameterTypeFQNs) {
        this.getMethods();
        return (EJBMethod)((Object)this.myMethods.get(AbstractEjbMethodCollector.createSignature(name, parameterTypeFQNs)));
    }

    protected static MethodSig createSignature(String name, String[] parameterTypeFQNs) {
        return new MethodSig(name, parameterTypeFQNs, null, parameterTypeFQNs, null);
    }

    protected String[] getParameterTypeFQNs(IMethod method) {
        return EnterpriseBean.qualify(JDTUtils.jdt2java((String[])method.getParameterTypes()), method.getDeclaringType());
    }

    protected EnterpriseBean getBean() {
        return this.myBean;
    }

    public void refresh(EJBDelta delta) {
        if (this.myMethods == null) {
            return;
        }
        HashMap newMethods = new HashMap();
        this.collectMethods(newMethods);
        Iterator it = this.myMethods.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            MethodSig key = (MethodSig)next.getKey();
            EJBMethod oldMethod = (EJBMethod)((Object)next.getValue());
            EJBMethod newMethod = (EJBMethod)((Object)newMethods.get(key));
            if (newMethod == null) {
                delta.removed(oldMethod);
                oldMethod.removed();
                it.remove();
                continue;
            }
            if (!oldMethod.merge(newMethod)) continue;
            delta.changed(newMethod);
        }
        Iterator it2 = newMethods.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry next = it2.next();
            MethodSig key = (MethodSig)next.getKey();
            if (this.myMethods.containsKey(key)) continue;
            EJBMethod addedMethod = (EJBMethod)((Object)next.getValue());
            delta.added(addedMethod);
            this.myMethods.put(key, addedMethod);
        }
    }

    public void removedMethods() {
        if (this.myMethods == null) {
            return;
        }
        Iterator it = this.myMethods.values().iterator();
        while (it.hasNext()) {
            ((EJBMethod)((Object)it.next())).removed();
        }
    }

    protected final void addedMethod(EJBMethod addedMethod) {
        this.myMethods.put(AbstractEjbMethodCollector.createSignature(addedMethod.getName(), addedMethod.getParameterTypesForDD()), addedMethod);
    }

    protected final void removedMethod(EJBMethod removedMethod) {
        this.myMethods.remove(AbstractEjbMethodCollector.createSignature(removedMethod.getName(), removedMethod.getParameterTypesForDD()));
    }

    protected IMethod[] getDeclaredMethods(IType participant) throws JavaModelException {
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        InhType inhType = InhModelAccess.getModel((String)this.getBean().getEJBProject().getProject().getName()).findType(participant.getFullyQualifiedName('.'));
        if (inhType != null) {
            InhMember[] members = inhType.children("method");
            result.ensureCapacity(members.length);
            int i = 0;
            while (i < members.length) {
                IMethod next = this.getIMethodFromInhMember(members[i]);
                if (next != null) {
                    result.add(next);
                }
                ++i;
            }
        }
        return result.toArray(new IMethod[result.size()]);
    }

    protected IField[] getDeclaredFields(IType participant) throws JavaModelException {
        InhType inhType = InhModelAccess.getModel((String)this.getBean().getEJBProject().getProject().getName()).findType(participant.getFullyQualifiedName('.'));
        InhMember[] members = inhType.children("attribute");
        ArrayList<IField> result = new ArrayList<IField>(members.length);
        int i = 0;
        while (i < members.length) {
            IField next = this.getIFieldFromInhMember(members[i]);
            if (next != null) {
                result.add(next);
            }
            ++i;
        }
        return result.toArray(new IField[result.size()]);
    }

    private IMethod getIMethodFromInhMember(InhMember member) {
        try {
            if (member.hasSource()) {
                return this.getIMethodFromFullName(member.getParentType().getFullName(), member.getName(), member.getParameterTypesAsArray());
            }
            InhElement[] existing = member.existingHierarchyElements(InhDirection.BASE);
            if (existing != null && existing.length > 0) {
                return this.getIMethodFromFullName(((InhMember)existing[0]).getParentType().getFullName(), existing[0].getName(), existing[0].getParameterTypesAsArray());
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    private IMethod getIMethodFromFullName(String typeFQN, String methodName, String[] parameters) throws JavaModelException {
        IType type = this.getBean().getJavaProject().findType(typeFQN);
        if (type == null) {
            return null;
        }
        IMethod method = type.getMethod(methodName, JDTUtils.java2jdt((String[])parameters, (boolean)true));
        IMethod[] possibilities = type.findMethods(method);
        if (possibilities == null || possibilities.length == 0) {
            return null;
        }
        IMethod result = possibilities[0];
        int flags = result.getFlags();
        if (Flags.isStatic((int)flags) || Flags.isNative((int)flags) || Flags.isSynthetic((int)flags)) {
            return null;
        }
        return result;
    }

    private IField getIFieldFromInhMember(InhMember member) {
        try {
            if (member.hasSource()) {
                return this.getIFieldFromFullName(member.getParentType().getFullName(), member.getName());
            }
            InhElement[] existing = member.existingHierarchyElements(InhDirection.BASE);
            if (existing != null && existing.length > 0) {
                return this.getIFieldFromFullName(((InhMember)existing[0]).getParentType().getFullName(), existing[0].getName());
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    private IField getIFieldFromFullName(String typeFQN, String methodName) throws JavaModelException {
        IType type = this.getBean().getJavaProject().findType(typeFQN);
        if (type == null) {
            return null;
        }
        IField field = type.getField(methodName);
        int flags = field.getFlags();
        if (Flags.isStatic((int)flags) || Flags.isSynthetic((int)flags)) {
            return null;
        }
        return field;
    }
}

