/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.base;

import com.sap.engine.lib.util.base.BaseQueue;
import com.sap.engine.lib.util.base.NextItem;

public class BaseWaitQueue
extends BaseQueue {
    private transient int waitPop = 0;
    private transient int waitPush = 0;

    public BaseWaitQueue() {
        this(0);
    }

    public BaseWaitQueue(int limit) {
        super(limit);
    }

    public synchronized NextItem head() {
        NextItem result;
        while ((result = this.getFirstItem()) == null) {
            Object var4_2;
            ++this.waitPush;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var4_2 = null;
                    --this.waitPush;
                    break;
                }
                var4_2 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitPush;
                throw throwable;
            }
        }
        return result;
    }

    public synchronized NextItem head(long timeout) throws InterruptedException {
        NextItem result = this.getFirstItem();
        if (result == null) {
            ++this.waitPush;
            try {
                this.wait(timeout);
                Object var5_3 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                --this.waitPush;
                throw throwable;
            }
            return this.getFirstItem();
        }
        return result;
    }

    public synchronized NextItem dequeue() {
        NextItem result;
        while ((result = this.removeFirstItem()) == null) {
            Object var4_2;
            ++this.waitPush;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var4_2 = null;
                    --this.waitPush;
                    break;
                }
                var4_2 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitPush;
                throw throwable;
            }
        }
        if (this.waitPop > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized NextItem dequeue(long timeout) throws InterruptedException {
        NextItem result = this.removeFirstItem();
        if (result == null) {
            ++this.waitPush;
            try {
                this.wait(timeout);
                Object var5_3 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                --this.waitPush;
                throw throwable;
            }
            result = this.removeFirstItem();
        }
        if (this.waitPop > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized boolean enqueue(NextItem item) {
        boolean result;
        while (!(result = this.addLastItem(item))) {
            Object var5_3;
            ++this.waitPop;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var5_3 = null;
                    --this.waitPop;
                    break;
                }
                var5_3 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                var5_3 = null;
                --this.waitPop;
                throw throwable;
            }
        }
        if (this.waitPush > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized boolean enqueue(NextItem item, long timeout) throws InterruptedException {
        boolean result = this.addLastItem(item);
        if (!result) {
            ++this.waitPop;
            try {
                this.wait(timeout);
                Object var6_4 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                --this.waitPop;
                throw throwable;
            }
            result = this.addLastItem(item);
        }
        if (this.waitPush > 0) {
            this.notifyAll();
        }
        return result;
    }
}

