/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.RandomGenerator;
import java.util.Random;

public class MersenneTwister {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] mt;
    private int mti;
    private int[] mag01;
    private static final long GOOD_SEED = 4357L;

    public MersenneTwister() {
        this.setSeed(4357L);
    }

    public MersenneTwister(long seed) {
        this.setSeed(seed);
    }

    public final void setSeed(long seed) {
        int _seed = (int)seed;
        this.mt = new int[624];
        int i = 0;
        while (i < 624) {
            this.mt[i] = _seed & 0xFFFF0000;
            _seed = 69069 * _seed + 1;
            int n = i++;
            this.mt[n] = this.mt[n] | (_seed & 0xFFFF0000) >>> 16;
            _seed = 69069 * _seed + 1;
        }
        this.mti = 624;
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
    }

    public final int nextInt() {
        int y;
        if (this.mti >= 624) {
            int kk = 0;
            while (kk < 227) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }

    public final long nextLong() {
        int z;
        int y;
        int kk;
        if (this.mti >= 624) {
            kk = 0;
            while (kk < 227) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        if (this.mti >= 624) {
            kk = 0;
            while (kk < 227) {
                z = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ z >>> 1 ^ this.mag01[z & 1];
                ++kk;
            }
            while (kk < 623) {
                z = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ z >>> 1 ^ this.mag01[z & 1];
                ++kk;
            }
            z = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ z >>> 1 ^ this.mag01[z & 1];
            this.mti = 0;
        }
        z = this.mt[this.mti++];
        z ^= z >>> 11;
        z ^= z << 7 & 0x9D2C5680;
        z ^= z << 15 & 0xEFC60000;
        z ^= z >>> 18;
        return ((long)y << 32) + (long)z;
    }

    public final int nextInt(int n) {
        int val;
        int y;
        int bits;
        if (n <= 0) {
            return -1;
        }
        if ((n & -n) == n) {
            int y2;
            if (this.mti >= 624) {
                int kk = 0;
                while (kk < 227) {
                    y2 = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + 397] ^ y2 >>> 1 ^ this.mag01[y2 & 1];
                    ++kk;
                }
                while (kk < 623) {
                    y2 = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + -227] ^ y2 >>> 1 ^ this.mag01[y2 & 1];
                    ++kk;
                }
                y2 = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ y2 >>> 1 ^ this.mag01[y2 & 1];
                this.mti = 0;
            }
            y2 = this.mt[this.mti++];
            y2 ^= y2 >>> 11;
            y2 ^= y2 << 7 & 0x9D2C5680;
            y2 ^= y2 << 15 & 0xEFC60000;
            y2 ^= y2 >>> 18;
            return (int)((long)n * (long)(y2 >>> 1) >> 31);
        }
        do {
            if (this.mti >= 624) {
                int kk = 0;
                while (kk < 227) {
                    y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
                    ++kk;
                }
                while (kk < 623) {
                    y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                    ++kk;
                }
                y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
                this.mti = 0;
            }
            y = this.mt[this.mti++];
            y ^= y >>> 11;
            y ^= y << 7 & 0x9D2C5680;
            y ^= y << 15 & 0xEFC60000;
        } while ((bits = (y ^= y >>> 18) >>> 1) - (val = bits % n) + (n - 1) < 0);
        return val;
    }

    public static void main(String[] args) {
        MersenneTwister r = new MersenneTwister();
        System.out.println("\nTime to test grabbing 10000000 ints");
        long ms = System.currentTimeMillis();
        int j = 0;
        while (j < 10000000) {
            r.nextInt();
            ++j;
        }
        System.out.println("Mersenne Twister: " + (System.currentTimeMillis() - ms) + " ms");
        Random rr = new Random(1L);
        ms = System.currentTimeMillis();
        j = 0;
        while (j < 10000000) {
            rr.nextInt();
            ++j;
        }
        System.out.println("java.util.Random: " + (System.currentTimeMillis() - ms) + " ms");
        RandomGenerator rg = new RandomGenerator();
        ms = System.currentTimeMillis();
        j = 0;
        while (j < 10000000) {
            rg.nextInt();
            ++j;
        }
        System.out.println("iqlib.RandomGenerator: " + (System.currentTimeMillis() - ms) + " ms");
    }
}

