/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.devel.wizards;

import com.sap.tc.jtools.jtci.TestMessageDescription;
import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TestMessageDialog
extends Dialog {
    private Button fOkButton;
    private Text fMsgKeyText;
    private Text fDisplayNameText;
    private Combo fPriorityCombo;
    private Label fMsgKeyLabel;
    private Label fDisplayNameLabel;
    private Label fPriorityLabel;
    private Label fMessageLabel;
    private ITestMessageDescription fResult;
    private boolean editMode;

    public TestMessageDialog(Shell pParentShell, ITestMessageDescription initialValues) {
        super(pParentShell);
        this.editMode = true;
        this.fResult = initialValues;
    }

    public TestMessageDialog(Shell pParentShell) {
        super(pParentShell);
        this.editMode = false;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String prioString = this.fPriorityCombo.getItems()[this.fPriorityCombo.getSelectionIndex()];
            int prio = "DYNAMIC".equalsIgnoreCase(prioString) ? -1 : Integer.parseInt(prioString);
            String key = this.fMsgKeyText.getText().trim();
            String displayName = this.fDisplayNameText.getText().trim();
            this.fResult = new TestMessageDescription(key, displayName, prio);
        } else {
            this.fResult = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Enter Message Data");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.fOkButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.fMsgKeyText.setFocus();
        this.validateInput();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.fMsgKeyLabel = new Label(composite, 0);
        this.fMsgKeyLabel.setLayoutData((Object)new GridData(768));
        this.fMsgKeyLabel.setText("Msg Key");
        this.fMsgKeyText = new Text(composite, 2052);
        this.fMsgKeyText.setLayoutData((Object)new GridData(768));
        this.fMsgKeyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestMessageDialog.this.validateInput();
            }
        });
        this.fDisplayNameLabel = new Label(composite, 0);
        this.fDisplayNameLabel.setLayoutData((Object)new GridData(768));
        this.fDisplayNameLabel.setText("Display Name");
        this.fDisplayNameText = new Text(composite, 2052);
        this.fDisplayNameText.setLayoutData((Object)new GridData(768));
        this.fDisplayNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestMessageDialog.this.validateInput();
            }
        });
        this.fPriorityLabel = new Label(composite, 0);
        this.fPriorityLabel.setLayoutData((Object)new GridData(768));
        this.fPriorityLabel.setText("Priority");
        this.fPriorityCombo = new Combo(composite, 12);
        this.fPriorityCombo.setItems(new String[]{"1", "2", "3", "DYNAMIC"});
        this.fPriorityCombo.setLayoutData((Object)new GridData(768));
        this.fPriorityCombo.select(0);
        if (this.fResult != null) {
            this.fMsgKeyText.setText(this.fResult.getKey());
            this.fDisplayNameText.setText(this.fResult.getDisplayName());
            int prio = this.fResult.getPriority();
            String prioString = String.valueOf(prio);
            if (-1 == prio) {
                this.fPriorityCombo.select(3);
            } else {
                String[] items = this.fPriorityCombo.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(prioString)) {
                        this.fPriorityCombo.select(i);
                    }
                    ++i;
                }
            }
        }
        this.fMessageLabel = new Label(composite, 0);
        this.fMessageLabel.setText("Message Key and Display Name must not be empty");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fMessageLabel.setLayoutData((Object)gd);
        this.validateInput();
        return composite;
    }

    protected ITestMessageDescription getResult() {
        return this.fResult;
    }

    protected void validateInput() {
        boolean okay;
        String msgKey = this.fMsgKeyText.getText().trim();
        String displayName = this.fDisplayNameText.getText().trim();
        boolean bl = okay = msgKey.length() > 0 && displayName.length() > 0;
        if (this.fOkButton != null && this.fMessageLabel != null) {
            this.fOkButton.setEnabled(okay);
            this.fMessageLabel.setVisible(!okay);
        }
    }
}

