/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.devel.wizards;

import com.sap.tc.jtools.jlint.eclipse.devel.DevelPlugin;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;

public class TestClassMemberCreator {
    private static final String NAME_JAVADOC = "\n/* keep in sync with tests.xml! */\n\n";
    private static final String GET_TEST_NAME_CONTENT = "\npublic String getTestName() {\n return NAME;\n}\n\n";
    private static final String STRUC_TREE_QUAL_NAME = (class$com$sap$tc$jtools$util$structures$StructureTree == null ? (class$com$sap$tc$jtools$util$structures$StructureTree = TestClassMemberCreator.class$("com.sap.tc.jtools.util.structures.StructureTree")) : class$com$sap$tc$jtools$util$structures$StructureTree).getName();
    private IType fTestClassType;
    private String fTestName;
    private ParameterInterface[] fTestParams;
    static /* synthetic */ Class class$com$sap$tc$jtools$util$structures$StructureTree;

    public TestClassMemberCreator(IType type, String testDisplayName, ParameterInterface[] testParams) {
        this.fTestClassType = type;
        this.fTestName = testDisplayName;
        this.fTestParams = testParams;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createMembers(IProgressMonitor monitor) {
        ArrayList<String> newMethods = new ArrayList<String>();
        ITypeHierarchy hierarchy = null;
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        try {
            try {
                String[] unimplemented;
                String[] constructors;
                hierarchy = this.fTestClassType.newSupertypeHierarchy(monitor);
                IType superclass = hierarchy.getSuperclass(this.fTestClassType);
                if (superclass != null && (constructors = StubUtility.evalConstructors((IType)this.fTestClassType, (IType)superclass, (CodeGenerationSettings)settings, null)) != null) {
                    newMethods.addAll(Arrays.asList(constructors));
                }
                this.fTestClassType.createField("\n/* keep in sync with tests.xml! */\n\nprivate static final String NAME = \"" + this.fTestName + "\";\n\n", null, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fTestClassType.createMethod(GET_TEST_NAME_CONTENT, null, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.createParamGetterMethods(monitor);
                if (hierarchy != null && (unimplemented = StubUtility.evalUnimplementedMethods((IType)this.fTestClassType, (ITypeHierarchy)hierarchy, (boolean)false, (CodeGenerationSettings)settings, null, null)) != null) {
                    newMethods.addAll(Arrays.asList(unimplemented));
                }
                IMethod[] createdMethods = new IMethod[newMethods.size()];
                int i = 0;
                while (i < newMethods.size()) {
                    String content = (String)newMethods.get(i) + '\n';
                    createdMethods[i] = this.fTestClassType.createMethod(content, null, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ++i;
                }
            }
            catch (JavaModelException e) {
                DevelPlugin.log(e);
                Object var10_12 = null;
                if (monitor == null) return;
                monitor.done();
                return;
            }
            catch (CoreException e) {
                DevelPlugin.log(e);
                Object var10_13 = null;
                if (monitor == null) return;
                monitor.done();
                return;
            }
            Object var10_11 = null;
            if (monitor == null) return;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (monitor == null) throw throwable;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private void createParamGetterMethods(IProgressMonitor monitor) {
        int i = 0;
        while (i < this.fTestParams.length) {
            try {
                this.fTestClassType.createMethod(this.getContents(this.fTestParams[i]), null, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (this.fTestParams[i].getType().equals("DEEP STRUCTURE")) {
                    this.fTestClassType.getCompilationUnit().createImport(STRUC_TREE_QUAL_NAME, null, null);
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            ++i;
        }
    }

    private String getContents(ParameterInterface param) {
        StringBuffer content = new StringBuffer();
        String type = param.getType();
        String typeName = null;
        if (ParameterTool.isArrayType((String)type)) {
            typeName = "String[]";
        } else if (ParameterTool.isSimpleType((String)type)) {
            if ("FILE".equals(param.getType()) || "DIRECTORY".equals(param.getType()) || "STRING".equals(param.getType())) {
                typeName = "String";
            } else if ("BOOLEAN".equals(param.getType())) {
                typeName = "Boolean";
            } else if ("INT".equals(param.getType())) {
                typeName = "Integer";
            } else if ("FLOAT".equals(param.getType())) {
                typeName = "Float";
            }
        } else {
            typeName = "StructureTree";
        }
        content.append("\nprivate " + typeName + " get" + this.capitalizeFirstLetter(param.getName()) + "Param() {\n");
        content.append(" return (" + typeName + ") getInputParameter(\"" + param.getName() + "\");\n");
        content.append("}\n\n");
        return content.toString();
    }

    private String capitalizeFirstLetter(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

