/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.devel.wizards;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.devel.extension.ExtensionManager;
import com.sap.tc.jtools.jlint.eclipse.devel.wizards.InputParameterDialog;
import com.sap.tc.jtools.jlint.eclipse.devel.wizards.NewTestWizard;
import com.sap.tc.jtools.jlint.eclipse.devel.wizards.TestMessageDialog;
import com.sap.tc.jtools.jlint.eclipse.devel.wizards.TextKeyDevelWizards;
import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ParametersPage
extends WizardPage {
    private Table fInputParamTable;
    private Table fTestMessageTable;

    public ParametersPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.setDescription("Enter Runtime Test Parameters and Test Messages");
        this.createTestParametersControls(composite, nColumns);
        this.createTestMessagesControls(composite, nColumns);
        this.setControl((Control)composite);
    }

    private void createTestParametersControls(Composite composite, int nColumns) {
        Label paramsLabel = new Label(composite, 0);
        paramsLabel.setText(TextKeyDevelWizards.PARAMS_LABEL.getText());
        paramsLabel.setLayoutData((Object)ParametersPage.gridDataForLabel(1));
        this.fInputParamTable = new Table(composite, 67588);
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        this.fInputParamTable.setLayout((Layout)tl);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.fInputParamTable.setLayoutData((Object)gd);
        this.fInputParamTable.setHeaderVisible(true);
        this.fInputParamTable.setLinesVisible(true);
        new TableColumn(this.fInputParamTable, 0).setText(TextKeyDevelWizards.PARAM_NAME_LABEL.getText());
        new TableColumn(this.fInputParamTable, 0).setText(TextKeyDevelWizards.PARAM_TYPE_LABEL.getText());
        Composite compButton = new Composite(composite, 0);
        compButton.setLayout((Layout)new GridLayout());
        Button addButton = new Button(compButton, 8);
        addButton.setText(TextKeyDevelWizards.ADD_LABEL.getText());
        addButton.setLayoutData((Object)ParametersPage.gridDataForButton(addButton, 1));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                InputParameterDialog dlg = new InputParameterDialog(JlinPlugin.getActiveWorkbenchShell(), ParametersPage.this.getTestParameters());
                if (0 == dlg.open() && null != dlg.getResult()) {
                    ParameterInterface result = dlg.getResult();
                    TableItem newItem = new TableItem(ParametersPage.this.fInputParamTable, 0);
                    newItem.setText(new String[]{result.getName(), result.getType()});
                    newItem.setData((Object)result);
                }
            }
        });
        Button editButton = new Button(compButton, 8);
        editButton.setText(TextKeyDevelWizards.EDIT_LABEL.getText());
        editButton.setLayoutData((Object)ParametersPage.gridDataForButton(editButton, 1));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int selIdx = ParametersPage.this.fInputParamTable.getSelectionIndex();
                if (selIdx < 0) {
                    return;
                }
                TableItem selItem = ParametersPage.this.fInputParamTable.getItem(selIdx);
                ParameterInterface selParam = (ParameterInterface)selItem.getData();
                InputParameterDialog dlg = new InputParameterDialog(JlinPlugin.getActiveWorkbenchShell(), selParam, ParametersPage.this.getTestParameters());
                if (0 == dlg.open() && null != dlg.getResult()) {
                    ParameterInterface result = dlg.getResult();
                    selItem.setText(new String[]{result.getName(), result.getType()});
                    selItem.setData((Object)result);
                }
            }
        });
        Button deleteButton = new Button(compButton, 8);
        deleteButton.setText(TextKeyDevelWizards.REMOVE_LABEL.getText());
        deleteButton.setLayoutData((Object)ParametersPage.gridDataForButton(deleteButton, 1));
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int delNdx = ParametersPage.this.fInputParamTable.getSelectionIndex();
                if (0 <= delNdx) {
                    ParametersPage.this.fInputParamTable.remove(delNdx);
                    if (delNdx < ParametersPage.this.fInputParamTable.getItemCount()) {
                        ParametersPage.this.fInputParamTable.setSelection(delNdx);
                    } else if (0 != ParametersPage.this.fInputParamTable.getItemCount()) {
                        ParametersPage.this.fInputParamTable.setSelection(0);
                    }
                }
            }
        });
    }

    private void createTestMessagesControls(Composite composite, int nColumns) {
        Label msgsLabel = new Label(composite, 0);
        msgsLabel.setText("Messages");
        msgsLabel.setLayoutData((Object)ParametersPage.gridDataForLabel(1));
        this.fTestMessageTable = new Table(composite, 67588);
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        this.fTestMessageTable.setLayout((Layout)tl);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.fTestMessageTable.setLayoutData((Object)gd);
        this.fTestMessageTable.setHeaderVisible(true);
        this.fTestMessageTable.setLinesVisible(true);
        new TableColumn(this.fTestMessageTable, 0).setText("Msg Key");
        new TableColumn(this.fTestMessageTable, 0).setText("Display Name");
        new TableColumn(this.fTestMessageTable, 0).setText("Priority");
        Composite compButton = new Composite(composite, 0);
        compButton.setLayout((Layout)new GridLayout());
        Button addButton = new Button(compButton, 8);
        addButton.setText(TextKeyDevelWizards.ADD_LABEL.getText());
        addButton.setLayoutData((Object)ParametersPage.gridDataForButton(addButton, 1));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TestMessageDialog dlg = new TestMessageDialog(JlinPlugin.getActiveWorkbenchShell());
                if (0 == dlg.open() && null != dlg.getResult()) {
                    ITestMessageDescription result = dlg.getResult();
                    TableItem newItem = new TableItem(ParametersPage.this.fTestMessageTable, 0);
                    String prio = result.getPriority() == -1 ? "DYNAMIC" : String.valueOf(result.getPriority());
                    newItem.setText(new String[]{result.getKey(), result.getDisplayName(), prio});
                    newItem.setData((Object)result);
                }
            }
        });
        Button editButton = new Button(compButton, 8);
        editButton.setText(TextKeyDevelWizards.EDIT_LABEL.getText());
        editButton.setLayoutData((Object)ParametersPage.gridDataForButton(editButton, 1));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int selIdx = ParametersPage.this.fTestMessageTable.getSelectionIndex();
                if (selIdx < 0) {
                    return;
                }
                TableItem selItem = ParametersPage.this.fTestMessageTable.getItem(selIdx);
                ITestMessageDescription selMsg = (ITestMessageDescription)selItem.getData();
                TestMessageDialog dlg = new TestMessageDialog(JlinPlugin.getActiveWorkbenchShell(), selMsg);
                if (0 == dlg.open() && null != dlg.getResult()) {
                    ITestMessageDescription result = dlg.getResult();
                    String prio = result.getPriority() == -1 ? "DYNAMIC" : String.valueOf(result.getPriority());
                    selItem.setText(new String[]{result.getKey(), result.getDisplayName(), prio});
                    selItem.setData((Object)result);
                }
            }
        });
        Button deleteButton = new Button(compButton, 8);
        deleteButton.setText(TextKeyDevelWizards.REMOVE_LABEL.getText());
        deleteButton.setLayoutData((Object)ParametersPage.gridDataForButton(deleteButton, 1));
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int delNdx = ParametersPage.this.fTestMessageTable.getSelectionIndex();
                if (0 <= delNdx) {
                    ParametersPage.this.fTestMessageTable.remove(delNdx);
                    if (delNdx < ParametersPage.this.fTestMessageTable.getItemCount()) {
                        ParametersPage.this.fTestMessageTable.setSelection(delNdx);
                    } else if (0 != ParametersPage.this.fTestMessageTable.getItemCount()) {
                        ParametersPage.this.fTestMessageTable.setSelection(0);
                    }
                }
            }
        });
    }

    private void setButtonGridData(Button button) {
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
        SWTUtil.setButtonDimensionHint((Button)button);
    }

    public ParameterInterface[] getTestParameters() {
        if (this.fInputParamTable == null) {
            return new ParameterInterface[0];
        }
        TableItem[] items = this.fInputParamTable.getItems();
        Vector<ParameterInterface> params = new Vector<ParameterInterface>();
        int i = 0;
        while (i < items.length) {
            params.add((ParameterInterface)items[i].getData());
            ++i;
        }
        return params.toArray(new ParameterInterface[params.size()]);
    }

    public ITestMessageDescription[] getMessages() {
        if (this.fTestMessageTable == null) {
            return new ITestMessageDescription[0];
        }
        TableItem[] items = this.fTestMessageTable.getItems();
        ArrayList<ITestMessageDescription> params = new ArrayList<ITestMessageDescription>();
        int i = 0;
        while (i < items.length) {
            params.add((ITestMessageDescription)items[i].getData());
            ++i;
        }
        return params.toArray(new ITestMessageDescription[params.size()]);
    }

    public IWizardPage getNextPage() {
        String generatorName = ((NewTestWizard)this.getWizard()).getMainPage().getTestType();
        IWizardPage[] addPages = ExtensionManager.getExtensionManager().getAdditionalPages(generatorName);
        if (addPages == null || addPages.length == 0) {
            return null;
        }
        return addPages[0];
    }

    protected static GridData gridDataForLabel(int span) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        return gd;
    }

    protected static GridData gridDataForButton(Button button, int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.heightHint = SWTUtil.getButtonHeigthHint((Button)button);
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)button);
        return gd;
    }
}

