/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.devel.wizards;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.eclipse.devel.extension.ExtensionManager;
import com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator;
import com.sap.tc.jtools.jlint.eclipse.devel.generation.TestDescriptorTool;
import com.sap.tc.jtools.jlint.eclipse.devel.wizards.MainPage;
import com.sap.tc.jtools.jlint.eclipse.devel.wizards.ParametersPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.wizard.IWizardPage;

public class NewTestWizard
extends NewElementWizard {
    private MainPage fMainPage;
    private ParametersPage fParamPage;

    public NewTestWizard() {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle("New JLin Test Class");
    }

    public void addPages() {
        this.fMainPage = new MainPage();
        this.fMainPage.init(this.getSelection());
        this.addPage((IWizardPage)this.fMainPage);
        this.fParamPage = new ParametersPage("Enter Test Parameters and Messages");
        this.addPage((IWizardPage)this.fParamPage);
        ExtensionManager man = ExtensionManager.getExtensionManager();
        String[] generators = man.getTestGeneratorNames();
        int i = 0;
        while (i < generators.length) {
            IWizardPage[] pages = man.getAdditionalPages(generators[i]);
            if (pages != null && pages.length != 0) {
                int j = 0;
                while (j < pages.length) {
                    this.addPage(pages[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.fMainPage.createType(monitor);
        ITestGenerator testGenerator = this.getTestGenerator();
        TestDescriptionSet testDescriptionSet = TestDescriptorTool.getTestDescriptionSet(this.fMainPage.getTestDescriptor());
        TestDescriptionSet newTestDescrSet = TestDescriptorTool.addTestDefinitionToDescrSet(testGenerator.getTestDefinition(), testDescriptionSet, this.fMainPage.getTestGroup());
        TestDescriptorTool.saveTestDescriptionSet(newTestDescrSet, this.fMainPage.getTestDescriptor());
        IFile descrIFile = this.fMainPage.getTestDescrIFile();
        descrIFile.refreshLocal(0, null);
        IJavaElement origEl = this.fMainPage.getCreatedType().getCompilationUnit().getOriginalElement();
        this.selectAndReveal(origEl.getCorrespondingResource());
        JavaUI.openInEditor((IJavaElement)origEl);
    }

    private ITestGenerator getTestGenerator() {
        ITestGenerator gen = ExtensionManager.getExtensionManager().getTestGenerator(this.fMainPage.getTestType());
        gen.init(this.fMainPage.getPackageText().trim(), this.fMainPage.getTypeName().trim(), this.fMainPage.getTestName(), this.fMainPage.getTestGroup(), this.fMainPage.getTestDescription(), this.fMainPage.getTestResponsible(), this.fParamPage.getTestParameters(), this.fParamPage.getMessages());
        return gen;
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        return currentPage.isPageComplete() && currentPage.getNextPage() == null;
    }

    public MainPage getMainPage() {
        return this.fMainPage;
    }

    public ParametersPage getParametersPage() {
        return this.fParamPage;
    }
}

