/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.devel.wizards;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.devel.extension.ExtensionManager;
import com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator;
import com.sap.tc.jtools.jlint.eclipse.devel.wizards.NewTestWizard;
import com.sap.tc.jtools.jlint.eclipse.devel.wizards.TestClassMemberCreator;
import com.sap.tc.jtools.jlint.eclipse.devel.wizards.TextKeyDevelWizards;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.wizards.NewContainerWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.dialogs.FileFolderSelectionDialog;

public class MainPage
extends NewTypeWizardPage {
    private static final String DESCRIPTION = "field.description";
    private static final String DESCRIPTOR_FILE = "field.descriptorfile";
    private static final String DISPLAY_NAME = "field.displayname";
    private static ExtensionManager extensionManager = ExtensionManager.getExtensionManager();
    private static final String PAGE_NAME = "JlinNewClassWizardPage";
    private static final String RESPONSIBLE = "field.responsible";
    private static final String[] TEST_TYPES = extensionManager.getTestGeneratorNames();
    private IStatus fDescriptionStatus = new StatusInfo();
    private StringButtonDialogField fDescriptorFileDialogField;
    private IStatus fDescriptorFileStatus = new StatusInfo();
    private StringDialogField fResponsibleDialogField;
    private IStatus fResponsibleStatus = new StatusInfo();
    private StringDialogField fTestDescriptionDialogField;
    private StringDialogField fTestGroupDialogField;
    private StringDialogField fTestNameDialogField;
    private IStatus fTestNameStatus = new StatusInfo();
    private ComboDialogField fTestTypeDialogField;
    private IStatus fProjectStatus = new StatusInfo();
    private IProject selectedProject;

    public MainPage() {
        super(true, PAGE_NAME);
        this.setTitle(TextKeyDevelWizards.NEW_WIZ_PAGETITLE.getText());
        this.setDescription(TextKeyDevelWizards.NEW_WIZ_PAGEDESCR.getText());
        this.fTestNameDialogField = new StringDialogField();
        this.fTestNameDialogField.setLabelText(TextKeyDevelWizards.DISP_NAME_LABEL.getText());
        this.fTestNameDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                MainPage.this.handleFieldChanged(MainPage.DISPLAY_NAME);
            }
        });
        this.updateDisplayNameStatus();
        this.fTestTypeDialogField = new ComboDialogField(8);
        this.fTestTypeDialogField.setLabelText(TextKeyDevelWizards.TYPE_LABEL.getText());
        this.fTestTypeDialogField.setItems(TEST_TYPES);
        this.fTestTypeDialogField.selectItem(0);
        this.fResponsibleDialogField = new StringDialogField();
        this.fResponsibleDialogField.setLabelText(TextKeyDevelWizards.RESP_LABEL.getText());
        this.fResponsibleDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                MainPage.this.handleFieldChanged(MainPage.RESPONSIBLE);
            }
        });
        this.updateResponsibleStatus();
        this.fTestDescriptionDialogField = new StringDialogField();
        this.fTestDescriptionDialogField.setLabelText(TextKeyDevelWizards.DESCR_LABEL.getText());
        this.fTestDescriptionDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                MainPage.this.handleFieldChanged(MainPage.DESCRIPTION);
            }
        });
        this.updateDescrStatus();
        this.fTestGroupDialogField = new StringDialogField();
        this.fTestGroupDialogField.setLabelText(TextKeyDevelWizards.GROUP_LABEL.getText());
        this.fDescriptorFileDialogField = new StringButtonDialogField((IStringButtonAdapter)new DescriptorButtonAdapter());
        this.fDescriptorFileDialogField.setLabelText(TextKeyDevelWizards.DESCR_FILE_LABEL.getText());
        this.fDescriptorFileDialogField.setButtonLabel(TextKeyDevelWizards.BROWSE_LABEL.getText());
        this.fDescriptorFileDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                MainPage.this.handleFieldChanged(MainPage.DESCRIPTOR_FILE);
            }
        });
        this.updateDescrFileStatus();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTestNameControls(composite, nColumns);
        this.createTestTypeControls(composite, nColumns);
        this.createResponsibleControls(composite, nColumns);
        this.createTestGroupControls(composite, nColumns);
        this.createTestDescriptionControls(composite, nColumns);
        this.createDescriptorFileControls(composite, nColumns);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.new_class_wizard_page_context");
        this.doStatusUpdate();
        this.setControl((Control)composite);
    }

    private void createDescriptorFileControls(Composite composite, int nColumns) {
        this.fDescriptorFileDialogField.doFillIntoGrid(composite, nColumns);
        LayoutUtil.setWidthHint((Control)this.fDescriptorFileDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
    }

    private void createResponsibleControls(Composite composite, int nColumns) {
        this.fResponsibleDialogField.doFillIntoGrid(composite, nColumns - 1);
        this.fResponsibleDialogField.setText(System.getProperty("user.name", ""));
        DialogField.createEmptySpace((Composite)composite);
        LayoutUtil.setWidthHint((Control)this.fResponsibleDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
    }

    private void createTestDescriptionControls(Composite composite, int nColumns) {
        this.fTestDescriptionDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace((Composite)composite);
        LayoutUtil.setWidthHint((Control)this.fTestDescriptionDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
    }

    private void createTestGroupControls(Composite composite, int nColumns) {
        this.fTestGroupDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace((Composite)composite);
        LayoutUtil.setWidthHint((Control)this.fTestGroupDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
    }

    private void createTestNameControls(Composite composite, int nColumns) {
        this.fTestNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace((Composite)composite);
        LayoutUtil.setWidthHint((Control)this.fTestNameDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
    }

    private void createTestTypeControls(Composite composite, int nColumns) {
        this.fTestTypeDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace((Composite)composite);
        LayoutUtil.setWidthHint((Control)this.fTestTypeDialogField.getComboControl(null), (int)this.getMaxFieldWidth());
        this.fTestTypeDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                IWizardContainer container = MainPage.this.getWizard().getContainer();
                MainPage.super.superClassChanged();
                container.updateButtons();
                MainPage.this.doStatusUpdate();
            }
        });
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.getTestGenerator().createTypeMembers(type, imports);
        ParameterInterface[] params = ((NewTestWizard)this.getWizard()).getParametersPage().getTestParameters();
        new TestClassMemberCreator(type, this.getTestName(), params).createMembers(monitor);
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{((NewContainerWizardPage)this).fContainerStatus, this.fProjectStatus, this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.superClassChanged(), this.fSuperInterfacesStatus, this.fTestNameStatus, this.fResponsibleStatus, this.fDescriptionStatus, this.fDescriptorFileStatus};
        this.updateStatus(status);
    }

    public IType getEnclosingType() {
        return null;
    }

    public int getModifiers() {
        return this.F_PUBLIC;
    }

    public IProject getProject() {
        return this.selectedProject;
    }

    public String getSuperClass() {
        return this.getTestGenerator().getSuperClass();
    }

    private ITestGenerator getTestGenerator() {
        return ExtensionManager.getExtensionManager().getTestGenerator(this.getTestType());
    }

    public List getSuperInterfaces() {
        return Collections.EMPTY_LIST;
    }

    public String getTestDescription() {
        return this.fTestDescriptionDialogField.getText();
    }

    public File getTestDescriptor() {
        return new File(this.selectedProject.getLocation().toFile(), this.fDescriptorFileDialogField.getText().trim());
    }

    public IFile getTestDescrIFile() {
        return this.selectedProject.getFile(this.fDescriptorFileDialogField.getText().trim());
    }

    public String getTestGroup() {
        return this.fTestGroupDialogField.getText().trim();
    }

    public String getTestName() {
        return this.fTestNameDialogField.getText().trim();
    }

    public String getTestResponsible() {
        return this.fResponsibleDialogField.getText().trim();
    }

    private void handleDescrButtonPressed() {
        Object result;
        FileFolderSelectionDialog dlg = new FileFolderSelectionDialog(this.getControl().getShell(), false, 1);
        dlg.setInput((Object)this.selectedProject.getLocation().toFile());
        dlg.addFilter((ViewerFilter)new XMLFileFilter());
        dlg.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                File descrFile;
                if (selection.length > 0 && selection[0] instanceof File && (descrFile = (File)selection[0]).getAbsolutePath().toLowerCase().endsWith(".xml")) {
                    try {
                        new TestDescriptionSet(XMLTool.parseReader((Reader)new FileReader(descrFile)));
                    }
                    catch (Exception e) {
                        return new StatusInfo(4, TextKeyDevelWizards.INVALID_DESCRIPTOR.getText());
                    }
                    return new StatusInfo();
                }
                return new StatusInfo(4, TextKeyDevelWizards.SELECT_XML_FILE.getText());
            }
        });
        if (0 == dlg.open() && (result = dlg.getFirstResult()) instanceof File) {
            File descrFile = (File)result;
            this.fDescriptorFileDialogField.setText(new Path(descrFile.getAbsolutePath()).removeFirstSegments(this.selectedProject.getLocation().segmentCount()).setDevice(null).toString());
        }
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (DISPLAY_NAME.equals(fieldName)) {
            this.updateDisplayNameStatus();
        } else if (RESPONSIBLE.equals(fieldName)) {
            this.updateResponsibleStatus();
        } else if (DESCRIPTION.equals(fieldName)) {
            this.updateDescrStatus();
        } else if (DESCRIPTOR_FILE.equals(fieldName)) {
            this.updateDescrFileStatus();
        } else if ("NewContainerWizardPage.container".equals(fieldName)) {
            this.updateProjectStatus();
        }
        this.doStatusUpdate();
    }

    private void updateProjectStatus() {
        try {
            String str = this.getPackageFragmentRootText();
            if (str.length() == 0) {
                return;
            }
            Path path = new Path(str);
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (res == null) {
                return;
            }
            this.selectedProject = res.getProject();
            if (this.selectedProject == null || !this.selectedProject.hasNature("org.eclipse.pde.PluginNature")) {
                this.fProjectStatus = new StatusInfo(4, "selected project must be a plugin project");
            } else {
                List missingReuiredPluginsIds = this.getMissingImports();
                if (missingReuiredPluginsIds.size() == 0) {
                    this.fProjectStatus = new StatusInfo();
                } else {
                    StringBuffer buf = new StringBuffer();
                    Iterator iter = missingReuiredPluginsIds.iterator();
                    while (iter.hasNext()) {
                        buf.append((String)iter.next());
                        if (!iter.hasNext()) continue;
                        buf.append(", ");
                    }
                    this.fProjectStatus = new StatusInfo(2, "missing required plugin dependencies: " + buf.toString());
                }
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (CoreException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        try {
            if (jelem != null) {
                this.selectedProject = (IProject)jelem.getJavaProject().getCorrespondingResource();
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
    }

    private void setButtonGridData(Button button) {
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
        SWTUtil.setButtonDimensionHint((Button)button);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setFocus();
        }
        super.setVisible(visible);
    }

    private void updateDescrFileStatus() {
        String fileName = this.fDescriptorFileDialogField.getText().trim();
        this.fDescriptorFileStatus = !fileName.endsWith(".xml") ? new StatusInfo(4, TextKeyDevelWizards.ENTER_XML_FILE.getText()) : new StatusInfo();
    }

    private void updateDescrStatus() {
        this.fDescriptionStatus = this.fTestDescriptionDialogField.getText().trim().equals("") ? new StatusInfo(2, TextKeyDevelWizards.DESCR_EMPTY_MSG.getText()) : new StatusInfo();
    }

    private void updateDisplayNameStatus() {
        this.fTestNameStatus = this.fTestNameDialogField.getText().trim().equals("") ? new StatusInfo(4, TextKeyDevelWizards.NAME_EMPTY_MSG.getText()) : new StatusInfo();
    }

    private List getMissingImports() {
        ModelEntry entry = PDECore.getDefault().getModelManager().findEntry(this.selectedProject);
        IPluginImport[] imports = entry.getActiveModel().getPluginBase().getImports();
        HashSet<String> importSet = new HashSet<String>();
        int i = 0;
        while (i < imports.length) {
            importSet.add(imports[i].getId());
            ++i;
        }
        ArrayList<String> requiredImportsList = new ArrayList<String>();
        requiredImportsList.add(JlinPlugin.getPluginId());
        String[] reqPluginIds = this.getTestGenerator().getRequiredPluginIds();
        int i2 = 0;
        while (i2 < reqPluginIds.length) {
            requiredImportsList.add(reqPluginIds[i2]);
            ++i2;
        }
        requiredImportsList.removeAll(importSet);
        return requiredImportsList;
    }

    private void updateResponsibleStatus() {
        this.fResponsibleStatus = this.fResponsibleDialogField.getText().trim().equals("") ? new StatusInfo(2, TextKeyDevelWizards.RESP_EMPTY_MSG.getText()) : new StatusInfo();
    }

    public String getTestType() {
        return this.fTestTypeDialogField != null ? this.fTestTypeDialogField.getText() : TEST_TYPES[0];
    }

    private class XMLFileFilter
    extends ViewerFilter {
        private XMLFileFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            File file;
            return element instanceof File && ((file = (File)element).getAbsolutePath().toLowerCase().endsWith(".xml") || file.isDirectory());
        }
    }

    private class DescriptorButtonAdapter
    implements IStringButtonAdapter {
        private DescriptorButtonAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            MainPage.this.handleDescrButtonPressed();
        }
    }
}

