/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.devel.wizards;

import com.sap.tc.jtools.jlint.eclipse.devel.wizards.TextKeyDevelWizards;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.ascii.StringBuf;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputParameterDialog
extends Dialog {
    private Button fOkButton;
    private Text fNameText;
    private Combo fTypeCombo;
    private Label fMessageLabel;
    private ParameterInterface fResult;
    private ParameterInterface[] fExistingParams;
    private boolean editMode;

    public InputParameterDialog(Shell pParentShell, ParameterInterface initialValues, ParameterInterface[] existingParameters) {
        super(pParentShell);
        this.editMode = true;
        this.fResult = initialValues;
        this.fExistingParams = existingParameters;
    }

    public InputParameterDialog(Shell pParentShell, ParameterInterface[] existingParameters) {
        super(pParentShell);
        this.editMode = false;
        this.fExistingParams = existingParameters;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String type = this.fTypeCombo.getItems()[this.fTypeCombo.getSelectionIndex()];
            String name = this.fNameText.getText().trim();
            this.fResult = ParameterTool.createParameter((String)name, (String)type, null);
        } else {
            this.fResult = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(TextKeyDevelWizards.PARAM_DLG_TITLE.getText());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.fOkButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.fNameText.setFocus();
        this.validateInput();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fNameText = new Text(composite, 2052);
        this.fNameText.setLayoutData((Object)new GridData(768));
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputParameterDialog.this.validateInput();
            }
        });
        this.fTypeCombo = new Combo(composite, 4);
        this.fTypeCombo.setItems(ParameterTool.getParameterTypes());
        this.fTypeCombo.setLayoutData((Object)new GridData(768));
        this.fTypeCombo.select(0);
        if (this.fResult != null) {
            String type = this.fResult.getType();
            String[] items = this.fTypeCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(type)) {
                    this.fTypeCombo.select(i);
                }
                ++i;
            }
            this.fNameText.setText(this.fResult.getName());
        }
        this.fMessageLabel = new Label(composite, 0);
        this.fMessageLabel.setLayoutData((Object)new GridData(768));
        this.fMessageLabel.setFont(parent.getFont());
        this.validateInput();
        return composite;
    }

    protected ParameterInterface getResult() {
        return this.fResult;
    }

    protected void validateInput() {
        boolean okay;
        boolean empty;
        boolean nameOk;
        String paramName = this.fNameText.getText().trim();
        boolean exists = this.parameterNameExists(paramName);
        if (exists) {
            this.fMessageLabel.setText(TextKeyDevelWizards.PARAM_EXISTS_MSG.getText());
        }
        if (!(nameOk = this.parameterNameOk(paramName))) {
            this.fMessageLabel.setText(TextKeyDevelWizards.PARAM_NAME_NOT_OK_MSG.getText());
        }
        boolean bl = empty = paramName.length() < 1;
        if (empty) {
            this.fMessageLabel.setText(TextKeyDevelWizards.PARAM_EMPTY_MSG.getText());
        }
        boolean bl2 = okay = !empty && !exists && nameOk;
        if (this.fOkButton != null && this.fMessageLabel != null) {
            this.fOkButton.setEnabled(okay);
            this.fMessageLabel.setVisible(!okay);
        }
    }

    private boolean parameterNameOk(String paramName) {
        char[] name = paramName.toLowerCase().toCharArray();
        StringBuf buf = new StringBuf("abcdefghijklmnopqrstuvwxyz0123456789");
        int i = 0;
        while (i < name.length) {
            if (buf.indexOf(name[i]) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean parameterNameExists(String paramName) {
        if (this.editMode && paramName.equals(this.fResult.getName())) {
            return false;
        }
        int i = 0;
        while (i < this.fExistingParams.length) {
            if (this.fExistingParams[i].getName().equals(paramName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

